/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils.renderables.primitives;

import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.render.ShaderRenderUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0016\b\u0016\u0018\u0000 (2\u00020\u0001:\u0001(BK\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u0002\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001aR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001bR\u0014\u0010\n\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0016R\u001a\u0010\u001c\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0017\u001a\u0004\b\u001d\u0010\u0019R\u001a\u0010\u001e\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0017\u001a\u0004\b\u001f\u0010\u0019R\u001a\u0010 \u001a\u00020\u000b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\r8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'\u00a8\u0006)"}, d2={"Lat/hannibal2/skyhanni/utils/renderables/primitives/CircularRenderable;", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "backgroundColor", "", "radius", "", "smoothness", "", "filledPercentage", "unfilledColor", "Lat/hannibal2/skyhanni/utils/RenderUtils$HorizontalAlignment;", "horizontalAlignment", "Lat/hannibal2/skyhanni/utils/RenderUtils$VerticalAlignment;", "verticalAlignment", "<init>", "(Lio/github/notenoughupdates/moulconfig/ChromaColour;IFDLio/github/notenoughupdates/moulconfig/ChromaColour;Lat/hannibal2/skyhanni/utils/RenderUtils$HorizontalAlignment;Lat/hannibal2/skyhanni/utils/RenderUtils$VerticalAlignment;)V", "mouseOffsetX", "mouseOffsetY", "", "render", "(II)V", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "I", "getRadius", "()I", "F", "D", "width", "getWidth", "height", "getHeight", "horizontalAlign", "Lat/hannibal2/skyhanni/utils/RenderUtils$HorizontalAlignment;", "getHorizontalAlign", "()Lat/hannibal2/skyhanni/utils/RenderUtils$HorizontalAlignment;", "verticalAlign", "Lat/hannibal2/skyhanni/utils/RenderUtils$VerticalAlignment;", "getVerticalAlign", "()Lat/hannibal2/skyhanni/utils/RenderUtils$VerticalAlignment;", "Companion", "1.21.7"})
public class CircularRenderable
implements Renderable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChromaColour backgroundColor;
    private final int radius;
    private final float smoothness;
    private final double filledPercentage;
    @NotNull
    private final ChromaColour unfilledColor;
    private final int width;
    private final int height;
    @NotNull
    private final RenderUtils.HorizontalAlignment horizontalAlign;
    @NotNull
    private final RenderUtils.VerticalAlignment verticalAlign;

    protected CircularRenderable(@NotNull ChromaColour backgroundColor, int radius, float smoothness, double filledPercentage, @NotNull ChromaColour unfilledColor, @NotNull RenderUtils.HorizontalAlignment horizontalAlignment, @NotNull RenderUtils.VerticalAlignment verticalAlignment) {
        Intrinsics.checkNotNullParameter((Object)backgroundColor, (String)"backgroundColor");
        Intrinsics.checkNotNullParameter((Object)unfilledColor, (String)"unfilledColor");
        Intrinsics.checkNotNullParameter((Object)((Object)horizontalAlignment), (String)"horizontalAlignment");
        Intrinsics.checkNotNullParameter((Object)((Object)verticalAlignment), (String)"verticalAlignment");
        this.backgroundColor = backgroundColor;
        this.radius = radius;
        this.smoothness = smoothness;
        this.filledPercentage = filledPercentage;
        this.unfilledColor = unfilledColor;
        this.width = this.radius * 2;
        this.height = this.radius * 2;
        this.horizontalAlign = horizontalAlignment;
        this.verticalAlign = verticalAlignment;
    }

    public /* synthetic */ CircularRenderable(ChromaColour chromaColour, int n, float f, double d, ChromaColour chromaColour2, RenderUtils.HorizontalAlignment horizontalAlignment, RenderUtils.VerticalAlignment verticalAlignment, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            f = 1.0f;
        }
        if ((n2 & 8) != 0) {
            d = 100.0;
        }
        if ((n2 & 0x10) != 0) {
            Color color = Color.LIGHT_GRAY;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"LIGHT_GRAY");
            chromaColour2 = ColorUtils.toChromaColor$default(color, 255, 0, 2, null);
        }
        if ((n2 & 0x20) != 0) {
            horizontalAlignment = RenderUtils.HorizontalAlignment.CENTER;
        }
        if ((n2 & 0x40) != 0) {
            verticalAlignment = RenderUtils.VerticalAlignment.CENTER;
        }
        this(chromaColour, n, f, d, chromaColour2, horizontalAlignment, verticalAlignment);
    }

    public final int getRadius() {
        return this.radius;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @NotNull
    public RenderUtils.HorizontalAlignment getHorizontalAlign() {
        return this.horizontalAlign;
    }

    @Override
    @NotNull
    public RenderUtils.VerticalAlignment getVerticalAlign() {
        return this.verticalAlign;
    }

    @Override
    public void render(int mouseOffsetX, int mouseOffsetY) {
        if (this.filledPercentage < 100.0) {
            float baseAngle = 4.712389f;
            float f = baseAngle + (float)((100.0 - this.filledPercentage) / 50.0 * Math.PI);
            float f2 = (float)Math.PI * 2;
            float f3 = f % f2;
            float endAngle = !(f3 == 0.0f) && !(Math.signum(f3) == Math.signum(f2)) ? f3 + f2 : f3;
            ShaderRenderUtils.INSTANCE.drawFilledCircle(0, 0, ColorUtils.INSTANCE.toColor(this.backgroundColor), this.radius, this.smoothness, baseAngle, endAngle);
            ShaderRenderUtils.INSTANCE.drawFilledCircle(0, 0, ColorUtils.INSTANCE.toColor(this.unfilledColor), this.radius, this.smoothness, endAngle, baseAngle);
        } else {
            ShaderRenderUtils.drawFilledCircle$default(ShaderRenderUtils.INSTANCE, 0, 0, ColorUtils.INSTANCE.toColor(this.backgroundColor), this.radius, this.smoothness, 0.0f, 0.0f, 96, null);
        }
    }

    @Override
    public boolean isHovered(int mouseOffsetX, int mouseOffsetY) {
        return Renderable.DefaultImpls.isHovered(this, mouseOffsetX, mouseOffsetY);
    }

    @Override
    public boolean isBoxHovered(int mouseOffsetX, int width, int mouseOffsetY, int height) {
        return Renderable.DefaultImpls.isBoxHovered(this, mouseOffsetX, width, mouseOffsetY, height);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JS\u0010\u0013\u001a\u00020\u0012*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lat/hannibal2/skyhanni/utils/renderables/primitives/CircularRenderable$Companion;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/utils/renderables/Renderable$Companion;", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "backgroundColor", "", "radius", "", "smoothness", "", "filledPercentage", "unfilledColor", "Lat/hannibal2/skyhanni/utils/RenderUtils$HorizontalAlignment;", "horizontalAlignment", "Lat/hannibal2/skyhanni/utils/RenderUtils$VerticalAlignment;", "verticalAlignment", "Lat/hannibal2/skyhanni/utils/renderables/primitives/CircularRenderable;", "circular", "(Lat/hannibal2/skyhanni/utils/renderables/Renderable$Companion;Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;IFDLat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;Lat/hannibal2/skyhanni/utils/RenderUtils$HorizontalAlignment;Lat/hannibal2/skyhanni/utils/RenderUtils$VerticalAlignment;)Lat/hannibal2/skyhanni/utils/renderables/primitives/CircularRenderable;", "1.21.7"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CircularRenderable circular(@NotNull Renderable.Companion $this$circular, @NotNull ChromaColour backgroundColor, int radius, float smoothness, double filledPercentage, @NotNull ChromaColour unfilledColor, @NotNull RenderUtils.HorizontalAlignment horizontalAlignment, @NotNull RenderUtils.VerticalAlignment verticalAlignment) {
            Intrinsics.checkNotNullParameter((Object)$this$circular, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)backgroundColor, (String)"backgroundColor");
            Intrinsics.checkNotNullParameter((Object)unfilledColor, (String)"unfilledColor");
            Intrinsics.checkNotNullParameter((Object)((Object)horizontalAlignment), (String)"horizontalAlignment");
            Intrinsics.checkNotNullParameter((Object)((Object)verticalAlignment), (String)"verticalAlignment");
            return new CircularRenderable(backgroundColor, radius, smoothness, filledPercentage, unfilledColor, horizontalAlignment, verticalAlignment);
        }

        public static /* synthetic */ CircularRenderable circular$default(Companion companion, Renderable.Companion companion2, ChromaColour chromaColour, int n, float f, double d, ChromaColour chromaColour2, RenderUtils.HorizontalAlignment horizontalAlignment, RenderUtils.VerticalAlignment verticalAlignment, int n2, Object object) {
            if ((n2 & 4) != 0) {
                f = 1.0f;
            }
            if ((n2 & 8) != 0) {
                d = 100.0;
            }
            if ((n2 & 0x10) != 0) {
                Color color = Color.LIGHT_GRAY;
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"LIGHT_GRAY");
                chromaColour2 = ColorUtils.toChromaColor$default(color, 255, 0, 2, null);
            }
            if ((n2 & 0x20) != 0) {
                horizontalAlignment = RenderUtils.HorizontalAlignment.CENTER;
            }
            if ((n2 & 0x40) != 0) {
                verticalAlignment = RenderUtils.VerticalAlignment.CENTER;
            }
            return companion.circular(companion2, chromaColour, n, f, d, chromaColour2, horizontalAlignment, verticalAlignment);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

