/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils.system;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.ArgContext;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.MarkdownBuilder;
import at.hannibal2.skyhanni.utils.OSUtils;
import at.hannibal2.skyhanni.utils.VersionConstants;
import at.hannibal2.skyhanni.utils.system.ModInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_155;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\"\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0012\u001a\u00020\u00062\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0015\u001a\u0004\u0018\u00010\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\r*\u0006\u0012\u0002\b\u00030\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010\u001e\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b \u0010\u0003R\u0017\u0010!\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010%\u001a\u00020\u001b8\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010\u001fR\u001b\u0010*\u001a\u00020\u001b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010\u001fR\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0016\u0010.\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010&\u00a8\u0006/"}, d2={"Lat/hannibal2/skyhanni/utils/system/PlatformUtils;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "event", "", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebug", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "", "Lat/hannibal2/skyhanni/utils/system/ModInstance;", "getLoadedMods", "()Ljava/util/List;", "", "reason", "shutdownMinecraft", "(Ljava/lang/String;)V", "packageName", "getModFromPackage", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/utils/system/ModInstance;", "Ljava/lang/Class;", "getModInstance", "(Ljava/lang/Class;)Lat/hannibal2/skyhanni/utils/system/ModInstance;", "modId", "", "isModInstalled", "(Ljava/lang/String;)Z", "isNeuLoaded", "()Z", "checkIfNeuIsLoaded", "MC_VERSION", "Ljava/lang/String;", "getMC_VERSION", "()Ljava/lang/String;", "IS_LEGACY", "Z", "getIS_LEGACY", "isDevEnvironment$delegate", "Lkotlin/Lazy;", "isDevEnvironment", "", "allowedFabricReports", "Ljava/util/Set;", "validNeuInstalled", "1.21.7"})
@SourceDebugExtension(value={"SMAP\nPlatformUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformUtils.kt\nat/hannibal2/skyhanni/utils/system/PlatformUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1869#2,2:178\n774#2:181\n865#2,2:182\n1869#2,2:184\n1869#2,2:186\n1#3:180\n*S KotlinDebug\n*F\n+ 1 PlatformUtils.kt\nat/hannibal2/skyhanni/utils/system/PlatformUtils\n*L\n93#1:178,2\n64#1:181\n64#1:182,2\n68#1:184,2\n81#1:186,2\n*E\n"})
public final class PlatformUtils {
    @NotNull
    public static final PlatformUtils INSTANCE = new PlatformUtils();
    @NotNull
    private static final String MC_VERSION;
    private static final boolean IS_LEGACY;
    @NotNull
    private static final Lazy isDevEnvironment$delegate;
    @NotNull
    private static final Set<String> allowedFabricReports;
    private static boolean validNeuInstalled;

    private PlatformUtils() {
    }

    @NotNull
    public final String getMC_VERSION() {
        return MC_VERSION;
    }

    public final boolean getIS_LEGACY() {
        return IS_LEGACY;
    }

    public final boolean isDevEnvironment() {
        Lazy lazy = isDevEnvironment$delegate;
        return (Boolean)lazy.getValue();
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (validNeuInstalled) {
            return;
        }
        event.registerBrigadier("shmodlist", (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)PlatformUtils::onCommandRegistration$lambda$4));
    }

    @HandleEvent
    public final void onDebug(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.title("Loaded Mods");
        event.addIrrelevant((Function1<? super List<String>, Unit>)((Function1)PlatformUtils::onDebug$lambda$6));
    }

    private final List<ModInstance> getLoadedMods() {
        List list;
        List $this$getLoadedMods_u24lambda_u248 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Collection collection = FabricLoader.getInstance().getAllMods();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllMods(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModContainer it = (ModContainer)element$iv;
            boolean bl2 = false;
            if (StringsKt.contains$default((CharSequence)it.getOrigin().toString(), (CharSequence)":META-INF", (boolean)false, (int)2, null)) continue;
            String origin = StringsKt.substringAfterLast$default((String)it.getOrigin().toString(), (char)'\\', null, (int)2, null);
            String string = it.getMetadata().getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            String string2 = it.getMetadata().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            $this$getLoadedMods_u24lambda_u248.add(new ModInstance(string, string2, it.getMetadata().getVersion().toString(), origin));
        }
        return CollectionsKt.build((List)list);
    }

    public final void shutdownMinecraft(@Nullable String reason) {
        Object object;
        Object object2;
        String string = reason;
        if (string != null) {
            String it = string;
            boolean bl = false;
            object2 = " Reason: " + it;
        } else {
            object2 = object = null;
        }
        if (object2 == null) {
            object = "";
        }
        String reasonLine = object;
        System.err.println("SkyHanni-4.21.0 forced the game to shutdown." + reasonLine);
        System.exit(-1);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    public static /* synthetic */ void shutdownMinecraft$default(PlatformUtils platformUtils, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        platformUtils.shutdownMinecraft(string);
    }

    private final ModInstance getModFromPackage(String packageName) {
        if (packageName == null) {
            return null;
        }
        if (StringsKt.startsWith$default((String)packageName, (String)"at.hannibal2.skyhanni", (boolean)false, (int)2, null)) {
            return new ModInstance("skyhanni", "SkyHanni", "4.21.0", "");
        }
        return null;
    }

    @Nullable
    public final ModInstance getModInstance(@NotNull Class<?> $this$getModInstance) {
        Intrinsics.checkNotNullParameter($this$getModInstance, (String)"<this>");
        String string = $this$getModInstance.getCanonicalName();
        return this.getModFromPackage(string != null ? StringsKt.substringBeforeLast$default((String)string, (char)'.', null, (int)2, null) : null);
    }

    public final boolean isModInstalled(@NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    public final boolean isNeuLoaded() {
        return validNeuInstalled;
    }

    @JvmStatic
    public static final void checkIfNeuIsLoaded() {
    }

    private static final boolean isDevEnvironment_delegate$lambda$0() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCommandRegistration$lambda$4$lambda$3(ArgContext $this$callback) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$callback, (String)"$this$callback");
        Iterable $this$filter$iv = INSTANCE.getLoadedMods();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModInstance it = (ModInstance)element$iv$iv;
            boolean bl = false;
            if (!(allowedFabricReports.contains(it.getId()) || !StringsKt.startsWith$default((String)it.getId(), (String)"fabric-", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List loadedMods = (List)destination$iv$iv;
        MarkdownBuilder loadedModsMd = new MarkdownBuilder().category("Mods Loaded");
        Iterable $this$forEach$iv = loadedMods;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModInstance modInstance = (ModInstance)element$iv;
            boolean bl = false;
            String name2 = modInstance.component2();
            String version = modInstance.component3();
            String origin = modInstance.component4();
            loadedModsMd.append(name2, origin + " (" + version + ")");
        }
        OSUtils.INSTANCE.copyToClipboard(loadedModsMd.toString());
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Copied " + loadedMods.size() + " mods to clipboard!", false, null, false, false, null, 62, null);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$4(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Get a Discord-formatted list of all loaded mods");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_ACTIVE);
        $this$registerBrigadier.callback((Function1<ArgContext, Unit>)((Function1)PlatformUtils::onCommandRegistration$lambda$4$lambda$3));
        return Unit.INSTANCE;
    }

    private static final Unit onDebug$lambda$6(List $this$addIrrelevant) {
        Intrinsics.checkNotNullParameter((Object)$this$addIrrelevant, (String)"$this$addIrrelevant");
        Iterable $this$forEach$iv = INSTANCE.getLoadedMods();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModInstance modInstance = (ModInstance)element$iv;
            boolean bl = false;
            String name2 = modInstance.component2();
            String version = modInstance.component3();
            String origin = modInstance.component4();
            $this$addIrrelevant.add(name2 + ": \t" + origin + " (" + version + ")");
        }
        return Unit.INSTANCE;
    }

    static {
        String string = class_155.method_16673().comp_4025();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        MC_VERSION = string;
        IS_LEGACY = Intrinsics.areEqual((Object)VersionConstants.INSTANCE.getMC_VERSION(), (Object)"1.8.9");
        isDevEnvironment$delegate = LazyKt.lazy(PlatformUtils::isDevEnvironment_delegate$lambda$0);
        Object[] objectArray = new String[]{"fabricloader", "fabric-api"};
        allowedFabricReports = SetsKt.setOf((Object[])objectArray);
    }
}

