/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net.tftp;

import at.hannibal2.skyhanni.deps.commons.net.tftp.TFTPPacket;
import at.hannibal2.skyhanni.deps.commons.net.tftp.TFTPPacketException;
import java.net.DatagramPacket;
import java.net.InetAddress;

public final class TFTPDataPacket
extends TFTPPacket {
    public static final int MAX_DATA_LENGTH = 512;
    public static final int MIN_DATA_LENGTH = 0;
    int blockNumber;
    private int length;
    private int offset;
    private byte[] data;

    TFTPDataPacket(DatagramPacket datagram) throws TFTPPacketException {
        super(3, datagram.getAddress(), datagram.getPort());
        this.data = datagram.getData();
        this.offset = 4;
        if (this.getType() != this.data[1]) {
            throw new TFTPPacketException("TFTP operator code does not match type.");
        }
        this.blockNumber = (this.data[2] & 0xFF) << 8 | this.data[3] & 0xFF;
        this.length = datagram.getLength() - 4;
        if (this.length > 512) {
            this.length = 512;
        }
    }

    public TFTPDataPacket(InetAddress destination, int port, int blockNumber, byte[] data) {
        this(destination, port, blockNumber, data, 0, data.length);
    }

    public TFTPDataPacket(InetAddress destination, int port, int blockNumber, byte[] data, int offset, int length) {
        super(3, destination, port);
        this.blockNumber = blockNumber;
        this.data = data;
        this.offset = offset;
        this.length = Math.min(length, 512);
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getDataLength() {
        return this.length;
    }

    public int getDataOffset() {
        return this.offset;
    }

    @Override
    public DatagramPacket newDatagram() {
        byte[] data = new byte[this.length + 4];
        data[0] = 0;
        data[1] = (byte)this.type;
        data[2] = (byte)((this.blockNumber & 0xFFFF) >> 8);
        data[3] = (byte)(this.blockNumber & 0xFF);
        System.arraycopy(this.data, this.offset, data, 4, this.length);
        return new DatagramPacket(data, this.length + 4, this.address, this.port);
    }

    @Override
    DatagramPacket newDatagram(DatagramPacket datagram, byte[] data) {
        data[0] = 0;
        data[1] = (byte)this.type;
        data[2] = (byte)((this.blockNumber & 0xFFFF) >> 8);
        data[3] = (byte)(this.blockNumber & 0xFF);
        if (data != this.data) {
            System.arraycopy(this.data, this.offset, data, 4, this.length);
        }
        datagram.setAddress(this.address);
        datagram.setPort(this.port);
        datagram.setData(data);
        datagram.setLength(this.length + 4);
        return datagram;
    }

    public void setBlockNumber(int blockNumber) {
        this.blockNumber = blockNumber;
    }

    public void setData(byte[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
        this.length = Math.min(length, 512);
    }

    @Override
    public String toString() {
        return super.toString() + " DATA " + this.blockNumber + " " + this.length;
    }
}

