/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui.component;

import at.hannibal2.skyhanni.deps.moulconfig.common.IFontRenderer;
import at.hannibal2.skyhanni.deps.moulconfig.common.IMinecraft;
import at.hannibal2.skyhanni.deps.moulconfig.common.text.StructuredText;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiComponent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiImmediateContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class TextComponent
extends GuiComponent {
    final IFontRenderer fontRenderer;
    final Supplier<StructuredText> string;
    final int suggestedWidth;
    final TextAlignment alignment;
    final boolean shadow;
    final boolean split;
    private StructuredText lastString;
    private int lastWidth = -1;
    private List<StructuredText> lastSplit;
    private static final Pattern colorPattern = Pattern.compile("\u00a7[a-f0-9r]");

    public TextComponent(StructuredText string, int width, TextAlignment alignment) {
        this(IMinecraft.INSTANCE.getDefaultFontRenderer(), () -> string, width, alignment, false, false);
    }

    public TextComponent(StructuredText string, int width) {
        this(IMinecraft.INSTANCE.getDefaultFontRenderer(), () -> string, width, TextAlignment.LEFT, false, false);
    }

    public TextComponent(StructuredText string) {
        this(string, IMinecraft.INSTANCE.getDefaultFontRenderer().getStringWidth(string));
    }

    public TextComponent(String string) {
        this(StructuredText.of(string));
    }

    @Override
    public int getWidth() {
        return this.suggestedWidth + 4;
    }

    @Override
    public int getHeight() {
        return 2 + (this.fontRenderer.getHeight() + 2) * this.split(this.string.get(), this.getWidth()).size();
    }

    public List<StructuredText> split(StructuredText text, int width) {
        if (!this.split) {
            return Collections.singletonList(text);
        }
        if (Objects.equals(text, this.lastString) && width == this.lastWidth) {
            return this.lastSplit;
        }
        this.lastString = text;
        this.lastWidth = width;
        this.lastSplit = this.fontRenderer.splitText(text, width);
        return this.lastSplit;
    }

    @Override
    public void render(GuiImmediateContext context2) {
        context2.getRenderContext().pushMatrix();
        List<StructuredText> lines = this.split(this.string.get(), context2.getWidth());
        for (StructuredText line : lines) {
            int length = this.fontRenderer.getStringWidth(line);
            if (length > context2.getWidth()) {
                context2.getRenderContext().drawStringScaledMaxWidth(line, this.fontRenderer, 2, 2, this.shadow, context2.getWidth(), -1);
            } else {
                switch (this.alignment) {
                    case LEFT: {
                        context2.getRenderContext().drawString(this.fontRenderer, line, 2, 2, -1, this.shadow);
                        break;
                    }
                    case CENTER: {
                        context2.getRenderContext().drawString(this.fontRenderer, line, context2.getWidth() / 2 - length / 2 + 2, 2, -1, this.shadow);
                        break;
                    }
                    case RIGHT: {
                        context2.getRenderContext().drawString(this.fontRenderer, line, context2.getWidth() - length + 2, 2, -1, this.shadow);
                    }
                }
            }
            context2.getRenderContext().translate(0.0f, this.fontRenderer.getHeight() + 2);
        }
        context2.getRenderContext().popMatrix();
    }

    public TextComponent(IFontRenderer fontRenderer, Supplier<StructuredText> string, int suggestedWidth, TextAlignment alignment, boolean shadow, boolean split) {
        this.fontRenderer = fontRenderer;
        this.string = string;
        this.suggestedWidth = suggestedWidth;
        this.alignment = alignment;
        this.shadow = shadow;
        this.split = split;
    }

    public static enum TextAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

