/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.commands;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.config.features.commands.BetterWikiCommandConfig;
import at.hannibal2.skyhanni.events.GuiKeyPressEvent;
import at.hannibal2.skyhanni.events.MessageSendToServerEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.NeuItems;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.compat.InventoryCompatKt;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import java.net.URLEncoder;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ)\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J-\u0010\u001a\u001a\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0013\u001a\u00020\u00112\b\b\u0002\u0010\u0019\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001a\u0010\u001bJ5\u0010\u001e\u001a\u00020\u00062\b\b\u0002\u0010\u001c\u001a\u00020\u00172\b\b\u0002\u0010\u001d\u001a\u00020\u00172\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u0011\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020 H\u0007\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u00178\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00178\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b'\u0010&R\u0014\u0010(\u001a\u00020\u00178\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b(\u0010&R\u0014\u0010)\u001a\u00020\u00178\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b)\u0010&R\u0014\u0010-\u001a\u00020*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006."}, d2={"Lat/hannibal2/skyhanni/features/commands/WikiManager;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "event", "", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/events/MessageSendToServerEvent;", "onMessageSendToServer", "(Lat/hannibal2/skyhanni/events/MessageSendToServerEvent;)V", "Lat/hannibal2/skyhanni/events/GuiKeyPressEvent;", "onKeybind", "(Lat/hannibal2/skyhanni/events/GuiKeyPressEvent;)V", "Lnet/minecraft/class_1799;", "item", "", "autoOpen", "useFandom", "wikiTheItem", "(Lnet/minecraft/class_1799;ZZ)V", "", "", "args", "wikithis", "otherWikiCommands", "([Ljava/lang/String;ZZ)V", "search", "displaySearch", "sendWikiMessage", "(Ljava/lang/String;Ljava/lang/String;ZZ)V", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "isEnabled", "()Z", "OFFICIAL_URL_PREFIX", "Ljava/lang/String;", "OFFICIAL_SEARCH_PREFIX", "FANDOM_URL_PREFIX", "FANDOM_SEARCH_PREFIX", "Lat/hannibal2/skyhanni/config/features/commands/BetterWikiCommandConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/commands/BetterWikiCommandConfig;", "config", "1.21.5"})
public final class WikiManager {
    @NotNull
    public static final WikiManager INSTANCE = new WikiManager();
    @NotNull
    private static final String OFFICIAL_URL_PREFIX = "https://wiki.hypixel.net/";
    @NotNull
    private static final String OFFICIAL_SEARCH_PREFIX = "index.php?search=";
    @NotNull
    private static final String FANDOM_URL_PREFIX = "https://hypixel-skyblock.fandom.com/wiki/";
    @NotNull
    private static final String FANDOM_SEARCH_PREFIX = "Special:Search?query=";

    private WikiManager() {
    }

    private final BetterWikiCommandConfig getConfig() {
        return SkyHanniMod.feature.misc.getCommands().getBetterWiki();
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 6, "commands.useFandomWiki", "commands.fandomWiki.enabled", null, 8, null);
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onMessageSendToServer(@NotNull MessageSendToServerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        String string = event.getMessage().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String message = string;
        if (!StringsKt.startsWith$default((String)message, (String)"/wiki", (boolean)false, (int)2, null)) {
            return;
        }
        event.cancel();
        if (Intrinsics.areEqual((Object)message, (Object)"/wiki")) {
            WikiManager.sendWikiMessage$default(this, null, null, false, false, 15, null);
            return;
        }
        if (StringsKt.startsWith$default((String)message, (String)"/wiki ", (boolean)false, (int)2, null)) {
            String search = StringsKt.drop((String)event.getMessage(), (int)6);
            WikiManager.sendWikiMessage$default(this, search, null, false, false, 14, null);
            return;
        }
        if (Intrinsics.areEqual((Object)message, (Object)"/wikithis")) {
            class_1799 class_17992 = InventoryUtils.INSTANCE.getItemInHand();
            if (class_17992 == null) {
                WikiManager $this$onMessageSendToServer_u24lambda_u240 = this;
                boolean bl = false;
                ChatUtils.userError$default(ChatUtils.INSTANCE, "You must be holding an item to use this command!", false, 2, null);
                return;
            }
            class_1799 itemInHand = class_17992;
            WikiManager.wikiTheItem$default(this, itemInHand, this.getConfig().getAutoOpenWiki(), false, 4, null);
            return;
        }
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onKeybind(@NotNull GuiKeyPressEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (NeuItems.INSTANCE.neuHasFocus()) {
            return;
        }
        class_1799 class_17992 = InventoryCompatKt.stackUnderCursor();
        if (class_17992 == null) {
            return;
        }
        class_1799 stack = class_17992;
        if (!KeyboardManager.INSTANCE.isKeyHeld(this.getConfig().getWikiKeybind())) {
            return;
        }
        WikiManager.wikiTheItem$default(this, stack, this.getConfig().getMenuOpenWiki(), false, 4, null);
    }

    private final void wikiTheItem(class_1799 item2, boolean autoOpen, boolean useFandom) {
        String itemDisplayName = StringsKt.replace$default((String)StringsKt.replace$default((String)TextCompatKt.formattedTextCompatLeadingWhiteLessResets(item2.method_7964()), (String)"\u00a7a\u2714 ", (String)"", (boolean)false, (int)4, null), (String)"\u00a7c\u2716 ", (String)"", (boolean)false, (int)4, null);
        String internalName2 = ItemUtils.INSTANCE.getInternalName(item2).asString();
        String wikiUrlSearch = !Intrinsics.areEqual((Object)internalName2, (Object)"NONE") ? internalName2 : StringUtils.removeColor$default(StringUtils.INSTANCE, itemDisplayName, false, 1, null);
        this.sendWikiMessage(wikiUrlSearch, StringUtils.removeColor$default(StringUtils.INSTANCE, itemDisplayName, false, 1, null), autoOpen, useFandom);
    }

    static /* synthetic */ void wikiTheItem$default(WikiManager wikiManager, class_1799 class_17992, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = wikiManager.getConfig().getUseFandom();
        }
        wikiManager.wikiTheItem(class_17992, bl, bl2);
    }

    public final void otherWikiCommands(@NotNull String[] args, boolean useFandom, boolean wikithis) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (wikithis && !SkyBlockUtils.INSTANCE.getInSkyBlock()) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "You must be in SkyBlock to do this!", false, 2, null);
            return;
        }
        Object search = "";
        for (String arg2 : args) {
            search = (String)search + arg2;
        }
        if (wikithis) {
            class_1799 class_17992 = InventoryUtils.INSTANCE.getItemInHand();
            if (class_17992 == null) {
                WikiManager $this$otherWikiCommands_u24lambda_u241 = this;
                boolean bl = false;
                ChatUtils.userError$default(ChatUtils.INSTANCE, "You must be holding an item to use this command!", false, 2, null);
                return;
            }
            class_1799 itemInHand = class_17992;
            this.wikiTheItem(itemInHand, false, useFandom);
            return;
        }
        if (Intrinsics.areEqual((Object)search, (Object)"")) {
            WikiManager.sendWikiMessage$default(this, null, null, false, useFandom, 7, null);
            return;
        }
        WikiManager.sendWikiMessage$default(this, (String)search, null, false, useFandom, 6, null);
    }

    public static /* synthetic */ void otherWikiCommands$default(WikiManager wikiManager, String[] stringArray, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        wikiManager.otherWikiCommands(stringArray, bl, bl2);
    }

    public final void sendWikiMessage(@NotNull String search, @NotNull String displaySearch, boolean autoOpen, boolean useFandom) {
        String urlPrefix;
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        Intrinsics.checkNotNullParameter((Object)displaySearch, (String)"displaySearch");
        String wiki = useFandom ? "SkyBlock Fandom Wiki" : "Official SkyBlock Wiki";
        String string = urlPrefix = useFandom ? FANDOM_URL_PREFIX : OFFICIAL_URL_PREFIX;
        if (Intrinsics.areEqual((Object)search, (Object)"")) {
            ChatUtils.clickableLinkChat$default(ChatUtils.INSTANCE, "\u00a77Click \u00a7e\u00a7lHERE \u00a77to visit the \u00a76" + wiki + "\u00a77!", urlPrefix, "\u00a77The " + wiki + "!", false, false, null, false, 120, null);
            return;
        }
        String urlSearchPrefix = useFandom ? urlPrefix + FANDOM_SEARCH_PREFIX : urlPrefix + OFFICIAL_SEARCH_PREFIX;
        String searchUrl = urlSearchPrefix + URLEncoder.encode(search, "UTF-8") + "&scope=internal";
        ChatUtils.clickableLinkChat$default(ChatUtils.INSTANCE, "\u00a77Click \u00a7e\u00a7lHERE \u00a77to find \u00a7a" + displaySearch + " \u00a77on the \u00a76" + wiki + "\u00a77!", searchUrl, "\u00a77View \u00a7a" + displaySearch + " \u00a77on the \u00a76" + wiki + "\u00a77!", autoOpen, false, null, false, 112, null);
    }

    public static /* synthetic */ void sendWikiMessage$default(WikiManager wikiManager, String string, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = string;
        }
        if ((n & 4) != 0) {
            bl = wikiManager.getConfig().getAutoOpenWiki();
        }
        if ((n & 8) != 0) {
            bl2 = wikiManager.getConfig().getUseFandom();
        }
        wikiManager.sendWikiMessage(string, string2, bl, bl2);
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.registerBrigadier("shfandomwiki", (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)WikiManager::onCommandRegistration$lambda$3));
        event.registerBrigadier("shfandomwikithis", (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)WikiManager::onCommandRegistration$lambda$5));
        event.registerBrigadier("shofficialwiki", (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)WikiManager::onCommandRegistration$lambda$7));
        event.registerBrigadier("shofficialwikithis", (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)WikiManager::onCommandRegistration$lambda$9));
    }

    private final boolean isEnabled() {
        return this.getConfig().getEnabled();
    }

    private static final Unit onCommandRegistration$lambda$3$lambda$2(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        WikiManager.otherWikiCommands$default(INSTANCE, it, true, false, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$3(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Searches the fandom wiki with SkyHanni's own method.");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_ACTIVE);
        $this$registerBrigadier.legacyCallbackArgs((Function1<String[], Unit>)((Function1)WikiManager::onCommandRegistration$lambda$3$lambda$2));
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$5$lambda$4(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.otherWikiCommands(it, true, true);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$5(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Searches the fandom wiki with SkyHanni's own method.");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_ACTIVE);
        $this$registerBrigadier.legacyCallbackArgs((Function1<String[], Unit>)((Function1)WikiManager::onCommandRegistration$lambda$5$lambda$4));
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$7$lambda$6(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        WikiManager.otherWikiCommands$default(INSTANCE, it, false, false, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$7(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Searches the official wiki with SkyHanni's own method.");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_ACTIVE);
        $this$registerBrigadier.legacyCallbackArgs((Function1<String[], Unit>)((Function1)WikiManager::onCommandRegistration$lambda$7$lambda$6));
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$9$lambda$8(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.otherWikiCommands(it, false, true);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$9(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Searches the official wiki with SkyHanni's own method.");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_ACTIVE);
        $this$registerBrigadier.legacyCallbackArgs((Function1<String[], Unit>)((Function1)WikiManager::onCommandRegistration$lambda$9$lambda$8));
        return Unit.INSTANCE;
    }
}

