/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.dungeon;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.dungeon.ObjectHighlighterConfig;
import at.hannibal2.skyhanni.data.EntityMovementData;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.data.mob.MobData;
import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.MobEvent;
import at.hannibal2.skyhanni.events.entity.EntityMoveEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.MobUtils;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000f\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0003J\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0003J\u000f\u0010\u001e\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ!\u0010!\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010 \u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b#\u0010\u001cJ\u0017\u0010$\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b$\u0010\u001cJ\u0017\u0010&\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020%H\u0007\u00a2\u0006\u0004\b&\u0010'R\u0014\u0010+\u001a\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010/\u001a\u00020,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u00103\u001a\u0002008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020\u0019048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u001d\u00107\u001a\b\u0012\u0004\u0012\u00020\u0019048\u0006\u00a2\u0006\f\n\u0004\b7\u00106\u001a\u0004\b8\u00109R\u001a\u0010:\u001a\b\u0012\u0004\u0012\u00020\u0019048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u00106R\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00020\u0019048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b;\u00106\u00a8\u0006<"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonMobManager;", "", "<init>", "()V", "", "onConfigLoad", "Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;", "event", "onMobSpawn", "(Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;", "onMobDespawn", "(Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/entity/EntityMoveEvent;", "Lnet/minecraft/class_1309;", "onEntityMove", "(Lat/hannibal2/skyhanni/events/entity/EntityMoveEvent;)V", "onTick", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "kotlin.jvm.PlatformType", "getFelColor", "()Lio/github/notenoughupdates/moulconfig/ChromaColour;", "Lat/hannibal2/skyhanni/data/mob/Mob;", "mob", "handleStar", "(Lat/hannibal2/skyhanni/data/mob/Mob;)V", "handleInvisibleStar", "getStarColor", "()Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "colour", "handleStar0", "(Lat/hannibal2/skyhanni/data/mob/Mob;Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;)V", "handleFel", "handleFelDespawn", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/dungeon/ObjectHighlighterConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dungeon/ObjectHighlighterConfig;", "config", "Lat/hannibal2/skyhanni/config/features/dungeon/ObjectHighlighterConfig$StarredConfig;", "getStarredConfig", "()Lat/hannibal2/skyhanni/config/features/dungeon/ObjectHighlighterConfig$StarredConfig;", "starredConfig", "Lat/hannibal2/skyhanni/config/features/dungeon/ObjectHighlighterConfig$FelConfig;", "getFel", "()Lat/hannibal2/skyhanni/config/features/dungeon/ObjectHighlighterConfig$FelConfig;", "fel", "", "staredInvisible", "Ljava/util/Set;", "starredVisibleMobs", "getStarredVisibleMobs", "()Ljava/util/Set;", "felOnTheGround", "felMoving", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nDungeonMobManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonMobManager.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonMobManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n774#2:182\n865#2,2:183\n1869#2,2:185\n1869#2,2:187\n774#2:189\n865#2,2:190\n1869#2,2:192\n*S KotlinDebug\n*F\n+ 1 DungeonMobManager.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonMobManager\n*L\n88#1:182\n88#1:183,2\n88#1:185,2\n104#1:187,2\n42#1:189\n42#1:190,2\n42#1:192,2\n*E\n"})
public final class DungeonMobManager {
    @NotNull
    public static final DungeonMobManager INSTANCE = new DungeonMobManager();
    @NotNull
    private static final Set<Mob> staredInvisible = new LinkedHashSet();
    @NotNull
    private static final Set<Mob> starredVisibleMobs = new LinkedHashSet();
    @NotNull
    private static final Set<Mob> felOnTheGround = new LinkedHashSet();
    @NotNull
    private static final Set<Mob> felMoving = new LinkedHashSet();

    private DungeonMobManager() {
    }

    private final ObjectHighlighterConfig getConfig() {
        return SkyHanniMod.feature.getDungeon().getObjectHighlighter();
    }

    private final ObjectHighlighterConfig.StarredConfig getStarredConfig() {
        return this.getConfig().getStarred();
    }

    private final ObjectHighlighterConfig.FelConfig getFel() {
        return this.getConfig().getFel();
    }

    @NotNull
    public final Set<Mob> getStarredVisibleMobs() {
        return starredVisibleMobs;
    }

    @HandleEvent
    public final void onConfigLoad() {
        Property[] propertyArray = new Property[]{this.getStarredConfig().getHighlight(), this.getStarredConfig().getColor()};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, DungeonMobManager::onConfigLoad$lambda$2);
    }

    @HandleEvent
    public final void onMobSpawn(@NotNull MobEvent.Spawn.SkyblockMob event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getMob().getMobType() != Mob.Type.DUNGEON) {
            return;
        }
        this.handleStar(event.getMob());
        this.handleFel(event.getMob());
    }

    @HandleEvent
    public final void onMobDespawn(@NotNull MobEvent.DeSpawn.SkyblockMob event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getMob().getMobType() != Mob.Type.DUNGEON) {
            return;
        }
        if (((Boolean)this.getStarredConfig().getHighlight().get()).booleanValue()) {
            staredInvisible.remove(event.getMob());
        }
        this.handleFelDespawn(event.getMob());
        starredVisibleMobs.remove(event.getMob());
    }

    @HandleEvent(onlyOnIsland=IslandType.CATACOMBS)
    public final void onEntityMove(@NotNull EntityMoveEvent<class_1309> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Mob mob = MobUtils.INSTANCE.getMob(event.getEntity());
        if (mob == null) {
            return;
        }
        Mob mob2 = mob;
        if (felOnTheGround.remove(mob2)) {
            felMoving.add(mob2);
            if (mob2.getHasStar() && ((Boolean)this.getStarredConfig().getHighlight().get()).booleanValue()) {
                mob2.highlight(this.getStarColor());
            }
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.CATACOMBS)
    public final void onTick() {
        this.handleInvisibleStar();
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(onlyOnIsland=IslandType.CATACOMBS)
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        ChromaColour chromaColour;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        ChromaColour color;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.getFel().getLine()) {
            void $this$filterTo$iv$iv;
            color = this.getFelColor();
            Iterable $this$filter$iv = felOnTheGround;
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Mob it = (Mob)element$iv$iv;
                boolean bl = false;
                if (!it.canBeSeen(30)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$forEach$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Mob it = (Mob)element$iv;
                boolean bl = false;
                LorenzVec lorenzVec = LorenzVec.add$default(LorenzVecKt.getLorenzVec((class_1297)it.getBaseEntity()), 0.0, 0.15, 0.0, 5, null);
                Intrinsics.checkNotNull((Object)color);
                WorldRenderUtils.INSTANCE.drawLineToEye(event, lorenzVec, color, 3, true);
            }
        }
        if (((Boolean)this.getFel().getHighlight().get()).booleanValue()) {
            chromaColour = this.getFelColor();
        } else if (((Boolean)this.getStarredConfig().getHighlight().get()).booleanValue()) {
            chromaColour = this.getStarColor();
        } else {
            return;
        }
        color = chromaColour;
        $this$forEach$iv = felOnTheGround;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Mob mob = (Mob)element$iv;
            boolean bl = false;
            LorenzVec lorenzVec = LorenzVecKt.getLorenzVec((class_1297)mob.getBaseEntity()).add(-0.5, -0.23, -0.5);
            Intrinsics.checkNotNull((Object)color);
            WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event, lorenzVec, ColorUtils.INSTANCE.toColor(color), false, false, -0.2, 0.0, 0.0, 0.8f, true, 96, null);
        }
    }

    private final ChromaColour getFelColor() {
        return (ChromaColour)this.getFel().getColor().get();
    }

    private final void handleStar(Mob mob) {
        if (!((Boolean)this.getStarredConfig().getHighlight().get()).booleanValue()) {
            return;
        }
        if (!mob.getHasStar()) {
            return;
        }
        this.handleStar0(mob, this.getStarColor());
    }

    private final void handleInvisibleStar() {
        if (!((Boolean)this.getStarredConfig().getHighlight().get()).booleanValue()) {
            return;
        }
        staredInvisible.removeIf(arg_0 -> DungeonMobManager.handleInvisibleStar$lambda$7(DungeonMobManager::handleInvisibleStar$lambda$6, arg_0));
    }

    private final ChromaColour getStarColor() {
        Object t = this.getStarredConfig().getColor().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        return (ChromaColour)t;
    }

    private final void handleStar0(Mob mob, ChromaColour colour) {
        if (Intrinsics.areEqual((Object)mob.getName(), (Object)"Fels")) {
            if (felMoving.contains(mob)) {
                ChromaColour chromaColour = colour;
                if (chromaColour != null) {
                    ChromaColour it = chromaColour;
                    boolean bl = false;
                    mob.highlight(it);
                } else {
                    DungeonMobManager $this$handleStar0_u24lambda_u249 = this;
                    boolean bl = false;
                    mob.removeHighlight();
                }
            }
            return;
        }
        if (mob.isInvisible()) {
            staredInvisible.add(mob);
            return;
        }
        ChromaColour chromaColour = colour;
        if (chromaColour != null) {
            ChromaColour it = chromaColour;
            boolean bl = false;
            mob.highlight(it);
        } else {
            DungeonMobManager $this$handleStar0_u24lambda_u2411 = this;
            boolean bl = false;
            mob.removeHighlight();
        }
        starredVisibleMobs.add(mob);
    }

    private final void handleFel(Mob mob) {
        if (!Intrinsics.areEqual((Object)mob.getName(), (Object)"Fels")) {
            return;
        }
        if (felMoving.contains(mob)) {
            return;
        }
        felOnTheGround.add(mob);
        EntityMovementData.INSTANCE.addToTrack(mob);
    }

    private final void handleFelDespawn(Mob mob) {
        felOnTheGround.remove(mob);
        felMoving.remove(mob);
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String base = "dungeon.objectHighlighter";
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 101, base + ".starred.colour", base + ".starred.color", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 101, base + ".fel.colour", base + ".fel.color", null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final void onConfigLoad$lambda$2() {
        void $this$filterTo$iv$iv;
        ChromaColour color = (Boolean)INSTANCE.getStarredConfig().getHighlight().get() != false ? INSTANCE.getStarColor() : null;
        Iterable $this$filter$iv = MobData.INSTANCE.getSkyblockMobs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Mob it = (Mob)element$iv$iv;
            boolean bl = false;
            if (!it.getHasStar()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Mob it = (Mob)element$iv;
            boolean bl = false;
            INSTANCE.handleStar0(it, color);
        }
        if (!((Boolean)INSTANCE.getStarredConfig().getHighlight().get()).booleanValue()) {
            staredInvisible.clear();
        }
    }

    private static final boolean handleInvisibleStar$lambda$6(Mob it) {
        boolean visible;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean bl = visible = !it.isInvisible();
        if (visible) {
            it.highlight(INSTANCE.getStarColor());
        }
        return visible;
    }

    private static final boolean handleInvisibleStar$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

