/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.mining.crystalhollows;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.mining.MiningConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.events.skyblock.GraphAreaChangeEvent;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\n\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\n\u0010\u0003J\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lat/hannibal2/skyhanni/features/mining/crystalhollows/CrystalHollowsNamesInCore;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/skyblock/GraphAreaChangeEvent;", "event", "", "onAreaChange", "(Lat/hannibal2/skyhanni/events/skyblock/GraphAreaChangeEvent;)V", "update", "onSecondPassed", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/mining/MiningConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/mining/MiningConfig;", "config", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "", "coreLocations", "Ljava/util/Map;", "showWaypoints", "Z", "inNucleus", "1.21.5"})
public final class CrystalHollowsNamesInCore {
    @NotNull
    public static final CrystalHollowsNamesInCore INSTANCE = new CrystalHollowsNamesInCore();
    @NotNull
    private static final Map<LorenzVec, String> coreLocations;
    private static boolean showWaypoints;
    private static boolean inNucleus;

    private CrystalHollowsNamesInCore() {
    }

    private final MiningConfig getConfig() {
        return SkyHanniMod.feature.getMining();
    }

    @HandleEvent
    public final void onAreaChange(@NotNull GraphAreaChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        inNucleus = Intrinsics.areEqual((Object)event.getArea(), (Object)"Crystal Nucleus");
        this.update();
    }

    private final void update() {
        showWaypoints = inNucleus && LocationUtils.INSTANCE.playerLocation().getY() > 65.0;
    }

    @HandleEvent(eventType=SecondPassedEvent.class, onlyOnSkyblock=true)
    public final void onSecondPassed() {
        if (this.isEnabled()) {
            this.update();
        }
    }

    @HandleEvent
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled() || !showWaypoints) {
            return;
        }
        for (Map.Entry<LorenzVec, String> entry : coreLocations.entrySet()) {
            LorenzVec location = entry.getKey();
            String name2 = entry.getValue();
            if (!(LocationUtils.INSTANCE.distanceSqToPlayer(location) > 50.0)) continue;
            WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event, location, name2, 2.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        }
    }

    public final boolean isEnabled() {
        return IslandType.CRYSTAL_HOLLOWS.isCurrent() && this.getConfig().getCrystalHollowsNamesInCore();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)new LorenzVec(550, 116, 550), (Object)"\u00a78Precursor Remnants"), TuplesKt.to((Object)new LorenzVec(552, 116, 474), (Object)"\u00a7bMithril Deposits"), TuplesKt.to((Object)new LorenzVec(477, 116, 476), (Object)"\u00a7aJungle"), TuplesKt.to((Object)new LorenzVec(474, 116, 554), (Object)"\u00a76Goblin Holdout")};
        coreLocations = MapsKt.mapOf((Pair[])pairArray);
    }
}

