/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.test;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.enoughupdates.EnoughUpdatesRepoManager;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.ArgContext;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierArgument;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierArguments;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierBuilder;
import at.hannibal2.skyhanni.config.features.dev.NeuRepositoryConfig;
import at.hannibal2.skyhanni.config.features.dev.RepositoryConfig;
import at.hannibal2.skyhanni.data.HypixelData;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.repo.SkyHanniRepoManager;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.features.misc.CurrentPing;
import at.hannibal2.skyhanni.features.misc.TpsCounter;
import at.hannibal2.skyhanni.features.misc.limbo.LimboTimeTracker;
import at.hannibal2.skyhanni.test.SkyBlockIslandTest;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.NeuItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.OSUtils;
import at.hannibal2.skyhanni.utils.PlayerUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import at.hannibal2.skyhanni.utils.system.PlatformUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_2338;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\r\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0010\u0010\fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0011\u0010\fJ\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0013\u0010\u0016\u001a\u00020\u0004*\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lat/hannibal2/skyhanni/test/DebugCommand;", "", "<init>", "()V", "", "search", "", "command", "(Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "event", "profileType", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "profileName", "skyblockStatus", "repoData", "player", "networkInfo", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "", "formatTime", "(J)Ljava/lang/String;", "", "TPS_LIMIT", "D", "Lkotlin/time/Duration;", "pingLimit", "J", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nDebugCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugCommand.kt\nat/hannibal2/skyhanni/test/DebugCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 BrigadierBuilder.kt\nat/hannibal2/skyhanni/config/commands/brigadier/BrigadierBuilder\n*L\n1#1,274:1\n1761#2,3:275\n1563#2:278\n1634#2,3:279\n265#3,6:282\n168#3,9:288\n265#3,6:297\n168#3,9:303\n*S KotlinDebug\n*F\n+ 1 DebugCommand.kt\nat/hannibal2/skyhanni/test/DebugCommand\n*L\n230#1:275,3\n234#1:278\n234#1:279,3\n256#1:282,6\n256#1:288,9\n263#1:297,6\n263#1:303,9\n*E\n"})
public final class DebugCommand {
    @NotNull
    public static final DebugCommand INSTANCE = new DebugCommand();
    private static final double TPS_LIMIT = 15.0;
    private static final long pingLimit = DurationKt.toDuration((double)1.5, (DurationUnit)DurationUnit.SECONDS);

    private DebugCommand() {
    }

    public final void command(@NotNull String search) {
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        List list = new ArrayList();
        list.add("```");
        list.add("= Debug Information for SkyHanni 5.0.1 " + PlatformUtils.INSTANCE.getMC_VERSION() + " =");
        list.add("");
        list.add(((CharSequence)search).length() > 0 ? (StringUtils.INSTANCE.equalsIgnoreColor(search, "all") ? "search for everything:" : "search '" + search + "':") : "no search specified, only showing interesting stuff:");
        DebugDataCollectEvent event = new DebugDataCollectEvent(list, search);
        this.player(event);
        this.repoData(event);
        this.skyblockStatus(event);
        this.networkInfo(event);
        this.profileName(event);
        this.profileType(event);
        event.post();
        if (event.getEmpty()) {
            list.add("");
            list.add("Nothing interesting to show right now!");
            list.add("Looking for something specific? /shdebug <search>");
            list.add("Wanna see everything? /shdebug all");
        }
        list.add("```");
        OSUtils.INSTANCE.copyToClipboard(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7eCopied SkyHanni debug data in the clipboard.", false, null, false, false, null, 62, null);
    }

    private final void profileType(DebugDataCollectEvent event) {
        boolean classic;
        event.title("Profile Type");
        if (!SkyBlockUtils.INSTANCE.getInSkyBlock()) {
            event.addIrrelevant("Not on SkyBlock");
            return;
        }
        if (ProfileStorageData.INSTANCE.getPlayerSpecific() == null) {
            event.addData("playerSpecific is null!");
            return;
        }
        boolean bl = classic = !SkyBlockUtils.INSTANCE.getNoTradeMode();
        if (classic) {
            event.addIrrelevant("on classic");
        } else {
            if (HypixelData.INSTANCE.getIronman()) {
                event.addData("on ironman");
            }
            if (HypixelData.INSTANCE.getStranded()) {
                event.addData("on stranded");
            }
            if (HypixelData.INSTANCE.getBingo()) {
                event.addData("on bingo");
            }
        }
    }

    private final void profileName(DebugDataCollectEvent event) {
        event.title("Profile Name");
        if (!SkyBlockUtils.INSTANCE.getInSkyBlock()) {
            event.addIrrelevant("Not on SkyBlock");
            return;
        }
        if (!Intrinsics.areEqual((Object)HypixelData.INSTANCE.getProfileName(), (Object)"")) {
            event.addIrrelevant("profileName: '" + HypixelData.INSTANCE.getProfileName() + "'");
        } else {
            event.addData("profile name is empty!");
        }
    }

    private final void skyblockStatus(DebugDataCollectEvent event) {
        event.title("SkyBlock Status");
        if (!SkyBlockUtils.INSTANCE.getOnHypixel()) {
            event.addData("not on Hypixel");
            return;
        }
        if (!SkyBlockUtils.INSTANCE.getInSkyBlock()) {
            event.addData("not on SkyBlock, but on Hypixel");
            return;
        }
        if (SkyBlockUtils.INSTANCE.getCurrentIsland() == IslandType.UNKNOWN) {
            event.addData("Unknown SkyBlock island!");
            return;
        }
        if (SkyBlockUtils.INSTANCE.getCurrentIsland() == IslandType.NONE) {
            event.addData("No SkyBlock island found!");
            return;
        }
        if (SkyBlockUtils.INSTANCE.getCurrentIsland() != HypixelData.INSTANCE.getSkyBlockIsland()) {
            event.addData((Function1<? super List<String>, Unit>)((Function1)DebugCommand::skyblockStatus$lambda$0));
            return;
        }
        event.addIrrelevant((Function1<? super List<String>, Unit>)((Function1)DebugCommand::skyblockStatus$lambda$2));
    }

    private final void repoData(DebugDataCollectEvent event) {
        boolean isRelevant;
        List list;
        event.title("Repo Information");
        RepositoryConfig config = SkyHanniMod.feature.getDev().getRepo();
        boolean hasDefaultSettings = config.getLocation().hasDefaultSettings();
        List<String> unsuccessfulConstants = SkyHanniRepoManager.INSTANCE.getFailedConstants();
        List $this$repoData_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$repoData_u24lambda_u243.add(" repoAutoUpdate: " + config.getRepoAutoUpdate());
        $this$repoData_u24lambda_u243.add(" usingBackupRepo: " + SkyHanniRepoManager.INSTANCE.isUsingBackup());
        boolean bl2 = hasDefaultSettings ? $this$repoData_u24lambda_u243.add(" repo location: default") : $this$repoData_u24lambda_u243.add(" non-default repo location: '" + SkyHanniRepoManager.INSTANCE.getGitHubRepoPath() + "'");
        if (!((Collection)unsuccessfulConstants).isEmpty()) {
            $this$repoData_u24lambda_u243.add(" unsuccessful constants:");
            for (String constant : unsuccessfulConstants) {
                $this$repoData_u24lambda_u243.add("  - " + constant);
            }
        }
        NeuRepositoryConfig neuRepoConfig = SkyHanniMod.feature.getDev().getNeuRepo();
        $this$repoData_u24lambda_u243.add(" neuRepoAutoUpdate: " + neuRepoConfig.getRepoAutoUpdate());
        boolean bl3 = !neuRepoConfig.getLocation().hasDefaultSettings() ? $this$repoData_u24lambda_u243.add(" neu repo location: '" + EnoughUpdatesRepoManager.INSTANCE.getGitHubRepoPath() + "'") : $this$repoData_u24lambda_u243.add(" neu repo location: default");
        $this$repoData_u24lambda_u243.add(" loaded neu items: " + NeuItems.INSTANCE.allNeuRepoItems().size());
        List list2 = CollectionsKt.build((List)list);
        boolean bl4 = SkyHanniRepoManager.INSTANCE.isUsingBackup() || !((Collection)unsuccessfulConstants).isEmpty() || !hasDefaultSettings ? true : (isRelevant = false);
        if (isRelevant) {
            event.addData(list2);
        } else {
            event.addIrrelevant(list2);
        }
    }

    private final void player(DebugDataCollectEvent event) {
        event.title("Player");
        event.addIrrelevant((Function1<? super List<String>, Unit>)((Function1)DebugCommand::player$lambda$4));
    }

    /*
     * WARNING - void declaration
     */
    private final void networkInfo(DebugDataCollectEvent event) {
        boolean bl;
        Iterable $this$any$iv;
        boolean showPreviousPings;
        List $this$networkInfo_u24lambda_u247;
        List list;
        boolean pingEnabled;
        double tps;
        block11: {
            event.title("Network Information");
            Double d = TpsCounter.INSTANCE.getTps();
            tps = d != null ? d : 0.0;
            pingEnabled = SkyHanniMod.feature.getDev().getPingApi();
            $this$networkInfo_u24lambda_u247 = list = CollectionsKt.createListBuilder();
            boolean bl2 = false;
            $this$networkInfo_u24lambda_u247.add("tps: " + tps);
            $this$networkInfo_u24lambda_u247.add("ping: " + INSTANCE.formatTime(Duration.getInWholeMilliseconds-impl((long)CurrentPing.INSTANCE.getAveragePing-UwyO8pc())));
            long lastWorldSwitch = SimpleTimeMark.passedSince-UwyO8pc(SkyBlockUtils.INSTANCE.getLastWorldSwitch-uFjCsEo());
            boolean bl3 = showPreviousPings = Duration.compareTo-LRDsOJo((long)CurrentPing.INSTANCE.getAveragePing-UwyO8pc(), (long)pingLimit) > 0;
            if (!pingEnabled) {
                $this$networkInfo_u24lambda_u247.add("Hypixel Ping Packet disabled in settings!");
                showPreviousPings = true;
            }
            if (Duration.compareTo-LRDsOJo((long)lastWorldSwitch, (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES)) < 0) {
                $this$networkInfo_u24lambda_u247.add("last world switch: " + TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, lastWorldSwitch, null, false, false, 0, false, false, 63, null) + " ago");
                showPreviousPings = true;
            }
            $this$any$iv = CurrentPing.INSTANCE.getPreviousPings();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    long it = ((Number)element$iv).longValue();
                    boolean bl4 = false;
                    if (!(it > 5000L)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            showPreviousPings = true;
        }
        if (showPreviousPings) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$any$iv = CurrentPing.INSTANCE.getPreviousPings();
            List list2 = $this$networkInfo_u24lambda_u247;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                long l = ((Number)item$iv$iv).longValue();
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(INSTANCE.formatTime((long)it));
            }
            list2.add("previousPings: " + (List)destination$iv$iv);
        }
        if (LimboTimeTracker.INSTANCE.getInLimbo()) {
            $this$networkInfo_u24lambda_u247.add("currently in limbo!");
        }
        List list3 = CollectionsKt.build((List)list);
        if (tps < 15.0 || Duration.compareTo-LRDsOJo((long)CurrentPing.INSTANCE.getAveragePing-UwyO8pc(), (long)pingLimit) > 0 || !pingEnabled) {
            event.addData(list3);
        } else {
            event.addIrrelevant(list3);
        }
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.registerBrigadier("shdebug", (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)DebugCommand::onCommandRegistration$lambda$12));
    }

    private final String formatTime(long $this$formatTime) {
        return $this$formatTime > 999L ? TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, DurationKt.toDuration((long)$this$formatTime, (DurationUnit)DurationUnit.MILLISECONDS), null, true, false, 0, false, false, 61, null) : NumberUtil.INSTANCE.addSeparators($this$formatTime) + "ms";
    }

    private static final Unit skyblockStatus$lambda$0(List $this$addData) {
        Intrinsics.checkNotNullParameter((Object)$this$addData, (String)"$this$addData");
        $this$addData.add("using a test island!");
        $this$addData.add("test island: " + SkyBlockIslandTest.INSTANCE.getTestIsland());
        $this$addData.add("real island: " + HypixelData.INSTANCE.getSkyBlockIsland());
        return Unit.INSTANCE;
    }

    private static final Unit skyblockStatus$lambda$2(List $this$addIrrelevant) {
        Intrinsics.checkNotNullParameter((Object)$this$addIrrelevant, (String)"$this$addIrrelevant");
        $this$addIrrelevant.add("on Hypixel SkyBlock");
        $this$addIrrelevant.add("skyBlockIsland: " + SkyBlockUtils.INSTANCE.getCurrentIsland());
        $this$addIrrelevant.add("skyBlockArea:");
        $this$addIrrelevant.add("  scoreboard: '" + SkyBlockUtils.INSTANCE.getScoreboardArea() + "'");
        $this$addIrrelevant.add("  graph network: '" + SkyBlockUtils.INSTANCE.getGraphArea() + "'");
        class_2338 class_23382 = MinecraftCompat.INSTANCE.getLocalPlayer().method_24515();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"getBlockPos(...)");
        LorenzVec $this$skyblockStatus_u24lambda_u242_u24lambda_u241 = LorenzVecKt.toLorenzVec(class_23382).roundTo(1);
        boolean bl = false;
        $this$addIrrelevant.add(" /shtestwaypoint " + $this$skyblockStatus_u24lambda_u242_u24lambda_u241.getX() + " " + $this$skyblockStatus_u24lambda_u242_u24lambda_u241.getY() + " " + $this$skyblockStatus_u24lambda_u242_u24lambda_u241.getZ() + " pathfind");
        $this$addIrrelevant.add("isOnAlphaServer: '" + SkyBlockUtils.INSTANCE.isOnAlphaServer() + "'");
        return Unit.INSTANCE;
    }

    private static final Unit player$lambda$4(List $this$addIrrelevant) {
        Intrinsics.checkNotNullParameter((Object)$this$addIrrelevant, (String)"$this$addIrrelevant");
        $this$addIrrelevant.add("name: '" + PlayerUtils.INSTANCE.getName() + "'");
        $this$addIrrelevant.add("uuid: '" + PlayerUtils.INSTANCE.getUuid() + "'");
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$12$lambda$9(ArgContext $this$literalCallback) {
        Intrinsics.checkNotNullParameter((Object)$this$literalCallback, (String)"$this$literalCallback");
        INSTANCE.command("all");
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$12$lambda$11() {
        INSTANCE.command("");
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$12(BaseBrigadierBuilder $this$registerBrigadier) {
        String[] stringArray;
        String argName$iv$iv;
        String literalNames$iv$iv;
        Pair<String, String> pair;
        Object name$iv;
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Copies SkyHanni debug data in the clipboard.");
        $this$registerBrigadier.setCategory(CommandCategory.DEVELOPER_DEBUG);
        String string = "profilename profile";
        ArgumentType argument$iv = (ArgumentType)BrigadierArguments.INSTANCE.string();
        SuggestionProvider suggestions$iv = null;
        boolean $i$f$argCallback = false;
        BrigadierBuilder this_$iv$iv = $this$registerBrigadier;
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            this_$iv$iv.internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                    void it;
                    Intrinsics.checkNotNullParameter($this$internalArg, (String)"$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$argCallback_u24lambda_u2412 = $this$internalArg;
                    boolean bl = false;
                    $this$argCallback_u24lambda_u2412.callback((Function1<ArgContext, Unit>)((Function1)new Function1<ArgContext, Unit>((BrigadierArgument)it){
                        final /* synthetic */ BrigadierArgument $it;
                        {
                            this.$it = $it;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter((Object)$this$callback, (String)"$this$callback");
                            String profile = (String)$this$callback.getArg(this.$it);
                            ArgContext $this$onCommandRegistration_u24lambda_u2412_u24lambda_u248 = $this$callback;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)profile);
                            String string = profile.toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                            HypixelData.INSTANCE.setProfileName(string);
                            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7eManually set profileName to '" + HypixelData.INSTANCE.getProfileName() + "'", false, null, false, false, null, 62, null);
                        }
                    }));
                }
            });
        } else {
            pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            literalNames$iv$iv = (String)pair.component1();
            argName$iv$iv = (String)pair.component2();
            stringArray = new String[]{literalNames$iv$iv};
            this_$iv$iv.literal(stringArray, (Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)((Function1)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv$iv, argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, (String)"$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, (SuggestionProvider<Object>)this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                            void it;
                            Intrinsics.checkNotNullParameter($this$internalArg, (String)"$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$argCallback_u24lambda_u2412 = $this$internalArg;
                            boolean bl = false;
                            $this$argCallback_u24lambda_u2412.callback((Function1<ArgContext, Unit>)((Function1)new Function1<ArgContext, Unit>((BrigadierArgument)it){
                                final /* synthetic */ BrigadierArgument $it;
                                {
                                    this.$it = $it;
                                }

                                public final void invoke(ArgContext $this$callback) {
                                    Intrinsics.checkNotNullParameter((Object)$this$callback, (String)"$this$callback");
                                    String profile = (String)$this$callback.getArg(this.$it);
                                    ArgContext $this$onCommandRegistration_u24lambda_u2412_u24lambda_u248 = $this$callback;
                                    boolean bl = false;
                                    Intrinsics.checkNotNull((Object)profile);
                                    String string = profile.toLowerCase(Locale.ROOT);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                                    HypixelData.INSTANCE.setProfileName(string);
                                    ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7eManually set profileName to '" + HypixelData.INSTANCE.getProfileName() + "'", false, null, false, false, null, 62, null);
                                }
                            }));
                        }
                    });
                }
            }));
        }
        name$iv = new String[]{"all"};
        $this$registerBrigadier.literalCallback((String[])name$iv, (Function1<? super ArgContext, Unit>)((Function1<ArgContext, Unit>)((Function1)DebugCommand::onCommandRegistration$lambda$12$lambda$9)));
        name$iv = "search";
        argument$iv = (ArgumentType)BrigadierArguments.INSTANCE.greedyString();
        suggestions$iv = null;
        $i$f$argCallback = false;
        this_$iv$iv = $this$registerBrigadier;
        $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            this_$iv$iv.internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                    void it;
                    Intrinsics.checkNotNullParameter($this$internalArg, (String)"$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$argCallback_u24lambda_u2412 = $this$internalArg;
                    boolean bl = false;
                    $this$argCallback_u24lambda_u2412.callback((Function1<ArgContext, Unit>)((Function1)new Function1<ArgContext, Unit>((BrigadierArgument)it){
                        final /* synthetic */ BrigadierArgument $it;
                        {
                            this.$it = $it;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter((Object)$this$callback, (String)"$this$callback");
                            String search = (String)$this$callback.getArg(this.$it);
                            ArgContext $this$onCommandRegistration_u24lambda_u2412_u24lambda_u2410 = $this$callback;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)search);
                            DebugCommand.INSTANCE.command(search);
                        }
                    }));
                }
            });
        } else {
            pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            literalNames$iv$iv = (String)pair.component1();
            argName$iv$iv = (String)pair.component2();
            stringArray = new String[]{literalNames$iv$iv};
            this_$iv$iv.literal(stringArray, (Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)((Function1)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv$iv, argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, (String)"$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, (SuggestionProvider<Object>)this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                            void it;
                            Intrinsics.checkNotNullParameter($this$internalArg, (String)"$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$argCallback_u24lambda_u2412 = $this$internalArg;
                            boolean bl = false;
                            $this$argCallback_u24lambda_u2412.callback((Function1<ArgContext, Unit>)((Function1)new Function1<ArgContext, Unit>((BrigadierArgument)it){
                                final /* synthetic */ BrigadierArgument $it;
                                {
                                    this.$it = $it;
                                }

                                public final void invoke(ArgContext $this$callback) {
                                    Intrinsics.checkNotNullParameter((Object)$this$callback, (String)"$this$callback");
                                    String search = (String)$this$callback.getArg(this.$it);
                                    ArgContext $this$onCommandRegistration_u24lambda_u2412_u24lambda_u2410 = $this$callback;
                                    boolean bl = false;
                                    Intrinsics.checkNotNull((Object)search);
                                    DebugCommand.INSTANCE.command(search);
                                }
                            }));
                        }
                    });
                }
            }));
        }
        $this$registerBrigadier.simpleCallback((Function0<Unit>)((Function0)DebugCommand::onCommandRegistration$lambda$12$lambda$11));
        return Unit.INSTANCE;
    }
}

