/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandBuilder;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.OSUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.system.PlatformUtils;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ%\u0010\u000e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0011\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\bJ\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0013\u0010\bJ\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\bJ\u0013\u0010\u0016\u001a\u00020\n*\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0018\u0010\bJ\u000f\u0010\u001c\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001d\u0010\bJ\u0017\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001eH\u0007\u00a2\u0006\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lat/hannibal2/skyhanni/utils/ComputerEnvDebug;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "event", "", "onDebug", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "launcher", "", "firstStack", "Lkotlin/Pair;", "", "findLauncher", "(Ljava/lang/String;)Lkotlin/Pair;", "getFirstStack", "()Ljava/lang/String;", "java", "os", "ram", "", "formatGB", "(D)Ljava/lang/String;", "uptime", "Lkotlin/time/Duration;", "getUptime-UwyO8pc", "()J", "getUptime", "performanceMods", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nComputerEnvDebug.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComputerEnvDebug.kt\nat/hannibal2/skyhanni/utils/ComputerEnvDebug\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,278:1\n8#2:279\n1#3:280\n*S KotlinDebug\n*F\n+ 1 ComputerEnvDebug.kt\nat/hannibal2/skyhanni/utils/ComputerEnvDebug\n*L\n100#1:279\n100#1:280\n*E\n"})
public final class ComputerEnvDebug {
    @NotNull
    public static final ComputerEnvDebug INSTANCE = new ComputerEnvDebug();

    private ComputerEnvDebug() {
    }

    @HandleEvent
    public final void onDebug(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.os(event);
        this.java(event);
        this.launcher(event);
        this.ram(event);
        this.uptime(event);
        this.performanceMods(event);
    }

    private final void launcher(DebugDataCollectEvent event) {
        event.title("Computer Minecraft Launcher");
        String string = this.getFirstStack();
        if (string == null) {
            ComputerEnvDebug $this$launcher_u24lambda_u240 = this;
            boolean bl = false;
            event.addData("Could not load data!");
            return;
        }
        String firstStack = string;
        Pair<String, Boolean> pair = this.findLauncher(firstStack);
        String launcher = (String)pair.component1();
        boolean relevant = (Boolean)pair.component2();
        if (launcher != null) {
            String it = launcher;
            boolean bl = false;
            if (relevant) {
                event.addData(it);
            } else {
                event.addIrrelevant(it);
            }
            return;
        }
        event.addData((Function1<? super List<String>, Unit>)((Function1)arg_0 -> ComputerEnvDebug.launcher$lambda$2(firstStack, arg_0)));
    }

    private final Pair<String, Boolean> findLauncher(String firstStack) {
        if (StringsKt.contains$default((CharSequence)firstStack, (CharSequence)"net.fabricmc.devlaunchinjector.Main.main", (boolean)false, (int)2, null)) {
            return new Pair((Object)"Dev Env", (Object)false);
        }
        if (StringsKt.contains$default((CharSequence)firstStack, (CharSequence)"net.minecraft.launchwrapper.Launch.main", (boolean)false, (int)2, null)) {
            return new Pair((Object)"Vanilla Launcher", (Object)false);
        }
        if (StringsKt.contains$default((CharSequence)firstStack, (CharSequence)"org.prismlauncher.EntryPoint.main", (boolean)false, (int)2, null)) {
            return new Pair((Object)"Prism", (Object)false);
        }
        if (StringsKt.contains$default((CharSequence)firstStack, (CharSequence)"org.multimc.EntryPoint.main", (boolean)false, (int)2, null)) {
            return new Pair((Object)"MultiMC", (Object)false);
        }
        if (StringsKt.contains$default((CharSequence)firstStack, (CharSequence)"net.digitalingot.vendor.", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)firstStack, (CharSequence)"net.digitalingot.rustextension.", (boolean)false, (int)2, null)) {
            return new Pair((Object)"Feather Client", (Object)true);
        }
        return new Pair(null, (Object)true);
    }

    private final String getFirstStack() {
        String string;
        try {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            string = ((StackTraceElement)ArraysKt.last((Object[])stackTraceElementArray)).toString();
        }
        catch (Exception e) {
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Failed loading current thread stack trace info", new Pair[0], false, false, false, 56, null);
            string = null;
        }
        String firstStack = string;
        return firstStack;
    }

    /*
     * WARNING - void declaration
     */
    private final void java(DebugDataCollectEvent event) {
        void $this$matchMatcher$iv;
        if (!PlatformUtils.INSTANCE.getIS_LEGACY()) {
            return;
        }
        event.title("Computer Java Version");
        String version = System.getProperty("java.version");
        Object object = "1\\.8\\.0_(?<update>.*)";
        int n = 0;
        Pattern pattern = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Pattern pattern2 = pattern;
        object = RegexUtils.INSTANCE;
        Pattern pattern3 = pattern2;
        Intrinsics.checkNotNull((Object)version);
        String text$iv = version;
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$java_u24lambda_u245 = it$iv;
            boolean bl2 = false;
            String string = $this$java_u24lambda_u245.group("update");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            Integer n2 = StringsKt.toIntOrNull((String)string);
            if (n2 != null) {
                int it = ((Number)n2).intValue();
                boolean bl3 = false;
                boolean devEnvironment = PlatformUtils.INSTANCE.isDevEnvironment();
                if (it < 300 && !devEnvironment) {
                    event.addData((Function1<? super List<String>, Unit>)((Function1)arg_0 -> ComputerEnvDebug.java$lambda$5$lambda$4$lambda$3(it, arg_0)));
                } else if (devEnvironment) {
                    event.addIrrelevant("Update version: " + it + " (dev env)");
                } else {
                    event.addIrrelevant("New update: " + it);
                }
                return;
            }
        }
        event.addData("Unknown java version: '" + version + "'");
    }

    private final void os(DebugDataCollectEvent event) {
        event.title("Computer Operating System");
        OSUtils.OperatingSystem osType = OSUtils.INSTANCE.getOperatingSystem();
        String exactName = OSUtils.INSTANCE.getOperatingSystemRaw();
        if (osType != OSUtils.OperatingSystem.UNKNOWN) {
            event.addIrrelevant((Function1<? super List<String>, Unit>)((Function1)arg_0 -> ComputerEnvDebug.os$lambda$6(osType, exactName, arg_0)));
        } else {
            event.addData("Unknown OS: '" + exactName + "'");
        }
    }

    private final void ram(DebugDataCollectEvent event) {
        event.title("Computer RAM");
        Runtime runtime = Runtime.getRuntime();
        List text = new ArrayList();
        long totalMemory = runtime.totalMemory();
        long maxMemory = runtime.maxMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        int allocatedPercentage = (int)((double)totalMemory / (double)maxMemory * (double)100);
        int usedPercentage = (int)((double)usedMemory / (double)maxMemory * (double)100);
        double totalMemoryGB = (double)totalMemory / (double)0x40000000;
        double maxMemoryGB = (double)maxMemory / (double)0x40000000;
        double usedMemoryGB = (double)usedMemory / (double)0x40000000;
        text.add("Minecraft Memory: " + usedPercentage + "% " + this.formatGB(usedMemoryGB) + "/" + this.formatGB(maxMemoryGB) + " GB");
        text.add("Minecraft Allocated: " + allocatedPercentage + "% " + this.formatGB(totalMemoryGB) + " GB");
        java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        Intrinsics.checkNotNull((Object)osBean, (String)"null cannot be cast to non-null type com.sun.management.OperatingSystemMXBean");
        long totalPhysicalMemory = ((OperatingSystemMXBean)osBean).getTotalPhysicalMemorySize();
        long freePhysicalMemory = ((OperatingSystemMXBean)osBean).getFreePhysicalMemorySize();
        long usedPhysicalMemory = totalPhysicalMemory - freePhysicalMemory;
        double totalPhysicalGB = (double)totalPhysicalMemory / (double)0x40000000;
        double usedPhysicalGB = (double)usedPhysicalMemory / (double)0x40000000;
        int usedPhysicalPercentage = MathKt.roundToInt((double)((double)usedPhysicalMemory / (double)totalPhysicalMemory * (double)100));
        text.add("System Memory: " + usedPhysicalPercentage + "% " + this.formatGB(usedPhysicalGB) + "/" + this.formatGB(totalPhysicalGB) + " GB");
        boolean important = false;
        if (maxMemoryGB < 3.5) {
            text.add("");
            text.add("Minecraft has less than 3.5 GB of RAM! Change this to 4-6 GB! (Currently at " + this.formatGB(maxMemoryGB) + " GB RAM)");
            important = true;
        } else if (maxMemoryGB > 6.0) {
            text.add("");
            text.add("Minecraft has more than 6 GB of RAM! Change this to 4-6 GB! (Currently at " + this.formatGB(maxMemoryGB) + " GB RAM)");
            important = true;
        }
        if (usedPhysicalPercentage > 90) {
            text.add("");
            text.add("The computer uses more than 90% of system memory. Maybe close background apps! (" + usedPhysicalPercentage + "% used)");
            important = true;
        }
        if (important) {
            event.addData(text);
        } else {
            event.addIrrelevant(text);
        }
    }

    private final String formatGB(double $this$formatGB) {
        return NumberUtil.INSTANCE.addSeparators(NumberUtil.INSTANCE.roundTo($this$formatGB, 1));
    }

    private final void uptime(DebugDataCollectEvent event) {
        event.title("Minecraft Uptime");
        long uptime = this.getUptime-UwyO8pc();
        String info = "The game is running for " + TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, uptime, null, false, false, 0, false, false, 63, null);
        if (Duration.compareTo-LRDsOJo((long)uptime, (long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.HOURS)) > 0) {
            event.addData((Function1<? super List<String>, Unit>)((Function1)arg_0 -> ComputerEnvDebug.uptime$lambda$7(info, arg_0)));
        } else {
            event.addIrrelevant(info);
        }
    }

    private final long getUptime-UwyO8pc() {
        return DurationKt.toDuration((long)ManagementFactory.getRuntimeMXBean().getUptime(), (DurationUnit)DurationUnit.MILLISECONDS);
    }

    private final void performanceMods(DebugDataCollectEvent event) {
        if (PlatformUtils.INSTANCE.isDevEnvironment()) {
            return;
        }
        event.title("Performance Mods");
        boolean hasSodium = FabricLoader.getInstance().isModLoaded("sodium");
        if (!hasSodium) {
            event.addData((Function1<? super List<String>, Unit>)((Function1)ComputerEnvDebug::performanceMods$lambda$8));
        } else {
            event.addIrrelevant((Function1<? super List<String>, Unit>)((Function1)ComputerEnvDebug::performanceMods$lambda$9));
        }
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.register("shuptime", (Function1<? super CommandBuilder, Unit>)((Function1)ComputerEnvDebug::onCommandRegistration$lambda$11));
    }

    private static final Unit launcher$lambda$2(String $firstStack, List $this$addData) {
        Intrinsics.checkNotNullParameter((Object)$firstStack, (String)"$firstStack");
        Intrinsics.checkNotNullParameter((Object)$this$addData, (String)"$this$addData");
        $this$addData.add("Unknown launcher!");
        String launcherBrand = System.getProperty("minecraft.launcher.brand");
        $this$addData.add("System property of 'minecraft.launcher.brand': '" + launcherBrand + "'");
        $this$addData.add("firstStack: '" + $firstStack + "'");
        return Unit.INSTANCE;
    }

    private static final Unit java$lambda$5$lambda$4$lambda$3(int $it, List $this$addData) {
        Intrinsics.checkNotNullParameter((Object)$this$addData, (String)"$this$addData");
        $this$addData.add("Old java version: " + $it);
        $this$addData.add("Update to a newer version if you have performance issues.");
        $this$addData.add("For more infos: https://github.com/hannibal002/SkyHanni/blob/beta/docs/update_java.md");
        return Unit.INSTANCE;
    }

    private static final Unit os$lambda$6(OSUtils.OperatingSystem $osType, String $exactName, List $this$addIrrelevant) {
        Intrinsics.checkNotNullParameter((Object)((Object)$osType), (String)"$osType");
        Intrinsics.checkNotNullParameter((Object)$exactName, (String)"$exactName");
        Intrinsics.checkNotNullParameter((Object)$this$addIrrelevant, (String)"$this$addIrrelevant");
        $this$addIrrelevant.add("OS type: " + $osType);
        $this$addIrrelevant.add("Exact name: " + $exactName);
        return Unit.INSTANCE;
    }

    private static final Unit uptime$lambda$7(String $info, List $this$addData) {
        Intrinsics.checkNotNullParameter((Object)$info, (String)"$info");
        Intrinsics.checkNotNullParameter((Object)$this$addData, (String)"$this$addData");
        $this$addData.add("The game runs for more than 5 hours, memory leaks may accumulate to dangerous levels.");
        $this$addData.add($info);
        return Unit.INSTANCE;
    }

    private static final Unit performanceMods$lambda$8(List $this$addData) {
        Intrinsics.checkNotNullParameter((Object)$this$addData, (String)"$this$addData");
        $this$addData.add("Sodium is not installed");
        $this$addData.add("This mod greatly improve performance");
        $this$addData.add("https://modrinth.com/mod/sodium");
        return Unit.INSTANCE;
    }

    private static final Unit performanceMods$lambda$9(List $this$addIrrelevant) {
        Intrinsics.checkNotNullParameter((Object)$this$addIrrelevant, (String)"$this$addIrrelevant");
        $this$addIrrelevant.add("Sodium is installed");
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$11$lambda$10(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        long uptime = INSTANCE.getUptime-UwyO8pc();
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Minecraft is running for \u00a7b" + TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, uptime, null, false, false, 0, false, false, 63, null) + "\u00a7e.", false, null, false, false, null, 62, null);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$11(CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        $this$register.setDescription("Shows the time since the start of minecraft");
        $this$register.setCategory(CommandCategory.USERS_RESET);
        $this$register.callback((Function1<? super String[], Unit>)((Function1)ComputerEnvDebug::onCommandRegistration$lambda$11$lambda$10));
        return Unit.INSTANCE;
    }
}

