/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0004\n\u0002\b\u001f\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\b\u0018\u0000 \u008b\u00012\u00020\u0001:\u0002\u008b\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u000b\u0012\u0006\u0010\u0005\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0015J%\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0019\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0015J\u0015\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001a\u0010\u0015J\u0018\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0018\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001cJ\u0018\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0018\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\tH\u0086\u0002\u00a2\u0006\u0004\b\u001e\u0010 J\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b!\u0010\u001cJ\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0004\b!\u0010\u001fJ+\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\"\u0010#J+\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\t2\b\b\u0002\u0010\u0004\u001a\u00020\t2\b\b\u0002\u0010\u0005\u001a\u00020\t\u00a2\u0006\u0004\b\"\u0010$J\u0015\u0010%\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b%\u0010\u0015J\u0015\u0010&\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b&\u0010\u0015J\u0015\u0010'\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b'\u0010\u0015J\u0015\u0010(\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b(\u0010\u0015J\u0015\u0010)\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b)\u0010\u001cJ\u0015\u0010*\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b*\u0010\u001cJ\r\u0010+\u001a\u00020\u0000\u00a2\u0006\u0004\b+\u0010,J\r\u0010-\u001a\u00020\u0000\u00a2\u0006\u0004\b-\u0010,J\r\u0010.\u001a\u00020\u0002\u00a2\u0006\u0004\b.\u0010/J\r\u00100\u001a\u00020\u0002\u00a2\u0006\u0004\b0\u0010/J\u0015\u00101\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b1\u0010\u001cJ\u0015\u00102\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b2\u0010\u001cJ\u001f\u00106\u001a\u0002042\u0006\u00103\u001a\u00020\t2\b\b\u0002\u00105\u001a\u000204\u00a2\u0006\u0004\b6\u00107J\u0017\u00109\u001a\u0002042\b\b\u0002\u00108\u001a\u000204\u00a2\u0006\u0004\b9\u0010:J\r\u0010;\u001a\u000204\u00a2\u0006\u0004\b;\u0010<J\r\u0010=\u001a\u00020\u0002\u00a2\u0006\u0004\b=\u0010/J\r\u0010>\u001a\u00020\u0002\u00a2\u0006\u0004\b>\u0010/J\u0017\u0010A\u001a\u00020@2\b\b\u0002\u0010?\u001a\u00020\u0002\u00a2\u0006\u0004\bA\u0010BJ\r\u0010C\u001a\u00020@\u00a2\u0006\u0004\bC\u0010DJ\r\u0010E\u001a\u00020\u0000\u00a2\u0006\u0004\bE\u0010,J\u0013\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00020F\u00a2\u0006\u0004\bG\u0010HJ\u0013\u0010I\u001a\b\u0012\u0004\u0012\u00020\u000b0F\u00a2\u0006\u0004\bI\u0010JJ\u0015\u0010K\u001a\u00020@2\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\bK\u0010LJ\u0015\u0010N\u001a\u00020\u00002\u0006\u0010M\u001a\u00020\t\u00a2\u0006\u0004\bN\u0010 J\r\u0010O\u001a\u00020\u0000\u00a2\u0006\u0004\bO\u0010,J\r\u0010P\u001a\u00020\u0000\u00a2\u0006\u0004\bP\u0010,J\u001d\u0010R\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u0002\u00a2\u0006\u0004\bR\u0010SJ\r\u0010T\u001a\u00020\u0000\u00a2\u0006\u0004\bT\u0010,J\r\u0010U\u001a\u00020\u0000\u00a2\u0006\u0004\bU\u0010,J\r\u0010V\u001a\u00020\u0000\u00a2\u0006\u0004\bV\u0010,J%\u0010[\u001a\u00020Z2\u0006\u0010W\u001a\u00020\u00022\u0006\u0010X\u001a\u00020\u00022\u0006\u0010Y\u001a\u00020\u0002\u00a2\u0006\u0004\b[\u0010\\J\u0015\u0010^\u001a\u00020\u00002\u0006\u0010]\u001a\u00020\u0002\u00a2\u0006\u0004\b^\u0010\u001fJ\u0015\u0010_\u001a\u00020Z2\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\b_\u0010`J\u0017\u0010c\u001a\u00020\u00002\b\b\u0002\u0010b\u001a\u00020a\u00a2\u0006\u0004\bc\u0010dJ\u0017\u0010e\u001a\u00020\u00002\b\b\u0002\u0010b\u001a\u00020a\u00a2\u0006\u0004\be\u0010dJ\u001d\u0010f\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00002\u0006\u0010Q\u001a\u00020\u0002\u00a2\u0006\u0004\bf\u0010SJ\r\u0010g\u001a\u00020\u0000\u00a2\u0006\u0004\bg\u0010,J\u0015\u0010i\u001a\u00020\u00002\u0006\u0010h\u001a\u00020\u0002\u00a2\u0006\u0004\bi\u0010\u001fJ\u0015\u0010j\u001a\u00020\u00002\u0006\u0010h\u001a\u00020\u0002\u00a2\u0006\u0004\bj\u0010\u001fJ\u0015\u0010k\u001a\u00020\u00002\u0006\u0010h\u001a\u00020\u0002\u00a2\u0006\u0004\bk\u0010\u001fJ\u001d\u0010n\u001a\u00020\u00002\u0006\u0010l\u001a\u00020\u00002\u0006\u0010m\u001a\u00020\u0000\u00a2\u0006\u0004\bn\u0010oJ\u001d\u0010p\u001a\u00020\u00022\u0006\u0010l\u001a\u00020\u00002\u0006\u0010m\u001a\u00020\u0000\u00a2\u0006\u0004\bp\u0010qJ\u0015\u0010r\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000\u00a2\u0006\u0004\br\u0010\u001cJ\u0018\u0010!\u001a\u00020\u00002\u0006\u0010s\u001a\u00020aH\u0082\u0002\u00a2\u0006\u0004\b!\u0010dJ\u001a\u0010t\u001a\u00020@2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\bt\u0010uJ\u000f\u0010v\u001a\u00020\tH\u0016\u00a2\u0006\u0004\bv\u0010wJ\u0010\u0010x\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\bx\u0010/J\u0010\u0010y\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\by\u0010/J\u0010\u0010z\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\bz\u0010/J.\u0010{\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b{\u0010#J\u0010\u0010|\u001a\u000204H\u00d6\u0001\u00a2\u0006\u0004\b|\u0010<R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010}\u001a\u0004\b~\u0010/R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010}\u001a\u0004\b\u007f\u0010/R\u0018\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\r\n\u0004\b\u0005\u0010}\u001a\u0005\b\u0080\u0001\u0010/R4\u0010\u0087\u0001\u001a\u0016\u0012\u0011\u0012\u000f\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u0082\u00010\u0081\u00018FX\u0086\u0084\u0002\u00a2\u0006\u0010\n\u0006\b\u0083\u0001\u0010\u0084\u0001\u001a\u0006\b\u0085\u0001\u0010\u0086\u0001R\u0016\u0010\u0088\u0001\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u0088\u0001\u0010}R\u0016\u0010\u0089\u0001\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u0089\u0001\u0010}R\u0016\u0010\u008a\u0001\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0007\n\u0005\b\u008a\u0001\u0010}\u00a8\u0006\u008c\u0001"}, d2={"Lat/hannibal2/skyhanni/utils/LorenzVec;", "", "", "x", "y", "z", "<init>", "(DDD)V", "()V", "", "(III)V", "", "(FFF)V", "Lnet/minecraft/class_2338;", "toBlockPos", "()Lnet/minecraft/class_2338;", "Lnet/minecraft/class_243;", "toVec3", "()Lnet/minecraft/class_243;", "other", "distanceIgnoreY", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)D", "distance", "distanceSq", "(DDD)D", "distanceChebyshevIgnoreY", "distanceSqIgnoreY", "plus", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "minus", "times", "(D)Lat/hannibal2/skyhanni/utils/LorenzVec;", "(I)Lat/hannibal2/skyhanni/utils/LorenzVec;", "div", "add", "(DDD)Lat/hannibal2/skyhanni/utils/LorenzVec;", "(III)Lat/hannibal2/skyhanni/utils/LorenzVec;", "dotProduct", "angleAsCos", "angleInRad", "angleInDeg", "crossProduct", "scaledTo", "normalize", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "inverse", "min", "()D", "max", "minOfEachElement", "maxOfEachElement", "accuracy", "", "splitChar", "printWithAccuracy", "(ILjava/lang/String;)Ljava/lang/String;", "separator", "toCleanString", "(Ljava/lang/String;)Ljava/lang/String;", "asStoredString", "()Ljava/lang/String;", "lengthSquared", "length", "tolerance", "", "isNormalized", "(D)Z", "isZero", "()Z", "clone", "", "toDoubleArray", "()[Ljava/lang/Double;", "toFloatArray", "()[Ljava/lang/Float;", "equalsIgnoreY", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Z", "precision", "roundTo", "roundToBlock", "blockCenter", "factor", "slope", "(Lat/hannibal2/skyhanni/utils/LorenzVec;D)Lat/hannibal2/skyhanni/utils/LorenzVec;", "roundLocation", "floor", "ceil", "offX", "offY", "offZ", "Lnet/minecraft/class_238;", "boundingToOffset", "(DDD)Lnet/minecraft/class_238;", "scalar", "scale", "axisAlignedTo", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Lnet/minecraft/class_238;", "", "offset", "up", "(Ljava/lang/Number;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "down", "interpolate", "negated", "theta", "rotateXY", "rotateXZ", "rotateYZ", "startPos", "endPos", "nearestPointOnLine", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "distanceToLine", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;)D", "middle", "i", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "component1", "component2", "component3", "copy", "toString", "D", "getX", "getY", "getZ", "", "Lkotlin/Pair;", "edges$delegate", "Lkotlin/Lazy;", "getEdges", "()Ljava/util/Set;", "edges", "normX", "normY", "normZ", "Companion", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nLorenzVec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LorenzVec.kt\nat/hannibal2/skyhanni/utils/LorenzVec\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,313:1\n1#2:314\n*E\n"})
public final class LorenzVec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    private final double z;
    @NotNull
    private final Lazy edges$delegate;
    private final double normX;
    private final double normY;
    private final double normZ;
    @NotNull
    private static final Set<LorenzVec> directions;
    @NotNull
    private static final LorenzVec expandVector;

    public LorenzVec(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.edges$delegate = LazyKt.lazy(() -> LorenzVec.edges_delegate$lambda$0(this));
        this.normX = this.x == 0.0 ? 0.0 : this.x;
        this.normY = this.y == 0.0 ? 0.0 : this.y;
        this.normZ = this.z == 0.0 ? 0.0 : this.z;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    @NotNull
    public final Set<Pair<LorenzVec, LorenzVec>> getEdges() {
        Lazy lazy = this.edges$delegate;
        return (Set)lazy.getValue();
    }

    public LorenzVec() {
        this(0.0, 0.0, 0.0);
    }

    public LorenzVec(int x, int y, int z) {
        this((double)x, (double)y, (double)z);
    }

    public LorenzVec(float x, float y, float z) {
        this((double)x, (double)y, (double)z);
    }

    @NotNull
    public final class_2338 toBlockPos() {
        return new class_2338((int)Math.floor(this.x), (int)Math.floor(this.y), (int)Math.floor(this.z));
    }

    @NotNull
    public final class_243 toVec3() {
        return new class_243(this.x, this.y, this.z);
    }

    public final double distanceIgnoreY(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Math.pow(this.distanceSqIgnoreY(other), 0.5);
    }

    public final double distance(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Math.pow(this.distanceSq(other), 0.5);
    }

    public final double distanceSq(double x, double y, double z) {
        return this.distanceSq(new LorenzVec(x, y, z));
    }

    public final double distance(double x, double y, double z) {
        return this.distance(new LorenzVec(x, y, z));
    }

    public final double distanceChebyshevIgnoreY(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Math.max(Math.abs(this.x - other.x), Math.abs(this.z - other.z));
    }

    public final double distanceSq(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        double dx = other.x - this.x;
        double dy = other.y - this.y;
        double dz = other.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public final double distanceSqIgnoreY(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        double dx = other.x - this.x;
        double dz = other.z - this.z;
        return dx * dx + dz * dz;
    }

    @NotNull
    public final LorenzVec plus(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new LorenzVec(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    @NotNull
    public final LorenzVec minus(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new LorenzVec(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    @NotNull
    public final LorenzVec times(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new LorenzVec(this.x * other.x, this.y * other.y, this.z * other.z);
    }

    @NotNull
    public final LorenzVec times(double other) {
        return new LorenzVec(this.x * other, this.y * other, this.z * other);
    }

    @NotNull
    public final LorenzVec times(int other) {
        return new LorenzVec(this.x * (double)other, this.y * (double)other, this.z * (double)other);
    }

    @NotNull
    public final LorenzVec div(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new LorenzVec(this.x / other.x, this.y / other.y, this.z / other.z);
    }

    @NotNull
    public final LorenzVec div(double other) {
        return new LorenzVec(this.x / other, this.y / other, this.z / other);
    }

    @NotNull
    public final LorenzVec add(double x, double y, double z) {
        return new LorenzVec(this.x + x, this.y + y, this.z + z);
    }

    public static /* synthetic */ LorenzVec add$default(LorenzVec lorenzVec, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.0;
        }
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        return lorenzVec.add(d, d2, d3);
    }

    @NotNull
    public final LorenzVec add(int x, int y, int z) {
        return new LorenzVec(this.x + (double)x, this.y + (double)y, this.z + (double)z);
    }

    public static /* synthetic */ LorenzVec add$default(LorenzVec lorenzVec, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        return lorenzVec.add(n, n2, n3);
    }

    public final double dotProduct(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public final double angleAsCos(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.normalize().dotProduct(other.normalize());
    }

    public final double angleInRad(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Math.acos(this.angleAsCos(other));
    }

    public final double angleInDeg(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Math.toDegrees(this.angleInRad(other));
    }

    @NotNull
    public final LorenzVec crossProduct(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new LorenzVec(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    @NotNull
    public final LorenzVec scaledTo(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.normalize().times(other.length());
    }

    @NotNull
    public final LorenzVec normalize() {
        double it = this.length();
        boolean bl = false;
        return new LorenzVec(this.x / it, this.y / it, this.z / it);
    }

    @NotNull
    public final LorenzVec inverse() {
        return new LorenzVec(1.0 / this.x, 1.0 / this.y, 1.0 / this.z);
    }

    public final double min() {
        return Math.min(this.x, Math.min(this.y, this.z));
    }

    public final double max() {
        return Math.max(this.x, Math.max(this.y, this.z));
    }

    @NotNull
    public final LorenzVec minOfEachElement(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new LorenzVec(Math.min(this.x, other.x), Math.min(this.y, other.y), Math.min(this.z, other.z));
    }

    @NotNull
    public final LorenzVec maxOfEachElement(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new LorenzVec(Math.max(this.x, other.x), Math.max(this.y, other.y), Math.max(this.z, other.z));
    }

    @NotNull
    public final String printWithAccuracy(int accuracy, @NotNull String splitChar) {
        String string;
        Intrinsics.checkNotNullParameter((Object)splitChar, (String)"splitChar");
        if (accuracy == 0) {
            int x = (int)Math.rint(this.x);
            int y = (int)Math.rint(this.y);
            int z = (int)Math.rint(this.z);
            string = x + splitChar + y + splitChar + z;
        } else {
            double x = Math.rint(this.x * (double)accuracy) / (double)accuracy;
            double y = Math.rint(this.y * (double)accuracy) / (double)accuracy;
            double z = Math.rint(this.z * (double)accuracy) / (double)accuracy;
            string = x + splitChar + y + splitChar + z;
        }
        return string;
    }

    public static /* synthetic */ String printWithAccuracy$default(LorenzVec lorenzVec, int n, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = " ";
        }
        return lorenzVec.printWithAccuracy(n, string);
    }

    @NotNull
    public final String toCleanString(@NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Object[] objectArray = new Double[]{this.x, this.y, this.z};
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)separator, null, null, (int)0, null, null, (int)62, null);
    }

    public static /* synthetic */ String toCleanString$default(LorenzVec lorenzVec, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = ", ";
        }
        return lorenzVec.toCleanString(string);
    }

    @NotNull
    public final String asStoredString() {
        return this.x + ":" + this.y + ":" + this.z;
    }

    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public final boolean isNormalized(double tolerance) {
        return Math.abs(this.lengthSquared() - 1.0) < tolerance;
    }

    public static /* synthetic */ boolean isNormalized$default(LorenzVec lorenzVec, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.01;
        }
        return lorenzVec.isNormalized(d);
    }

    public final boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    @NotNull
    public final LorenzVec clone() {
        return new LorenzVec(this.x, this.y, this.z);
    }

    @NotNull
    public final Double[] toDoubleArray() {
        Double[] doubleArray = new Double[]{this.x, this.y, this.z};
        return doubleArray;
    }

    @NotNull
    public final Float[] toFloatArray() {
        Float[] floatArray = new Float[]{Float.valueOf((float)this.x), Float.valueOf((float)this.y), Float.valueOf((float)this.z)};
        return floatArray;
    }

    public final boolean equalsIgnoreY(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.x == other.x && this.z == other.z;
    }

    @NotNull
    public final LorenzVec roundTo(int precision) {
        return new LorenzVec(NumberUtil.INSTANCE.roundTo(this.x, precision), NumberUtil.INSTANCE.roundTo(this.y, precision), NumberUtil.INSTANCE.roundTo(this.z, precision));
    }

    @NotNull
    public final LorenzVec roundToBlock() {
        return new LorenzVec(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    @NotNull
    public final LorenzVec blockCenter() {
        return this.roundToBlock().add(0.5, 0.5, 0.5);
    }

    @NotNull
    public final LorenzVec slope(@NotNull LorenzVec other, double factor) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.plus(other.minus(this).scale(factor));
    }

    @NotNull
    public final LorenzVec roundLocation() {
        int x = this.x < 0.0 ? (int)this.x - 1 : (int)this.x;
        int y = (int)this.y - 1;
        int z = this.z < 0.0 ? (int)this.z - 1 : (int)this.z;
        return new LorenzVec(x, y, z);
    }

    @NotNull
    public final LorenzVec floor() {
        int x = (int)Math.floor(this.x);
        int y = (int)Math.floor(this.y);
        int z = (int)Math.floor(this.z);
        return new LorenzVec(x, y, z);
    }

    @NotNull
    public final LorenzVec ceil() {
        int x = (int)Math.ceil(this.x);
        int y = (int)Math.ceil(this.y);
        int z = (int)Math.ceil(this.z);
        return new LorenzVec(x, y, z);
    }

    @NotNull
    public final class_238 boundingToOffset(double offX, double offY, double offZ) {
        return new class_238(this.x, this.y, this.z, this.x + offX, this.y + offY, this.z + offZ);
    }

    @NotNull
    public final LorenzVec scale(double scalar) {
        return new LorenzVec(scalar * this.x, scalar * this.y, scalar * this.z);
    }

    @NotNull
    public final class_238 axisAlignedTo(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new class_238(this.x, this.y, this.z, other.x, other.y, other.z);
    }

    @NotNull
    public final LorenzVec up(@NotNull Number offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return LorenzVec.copy$default(this, 0.0, this.y + offset.doubleValue(), 0.0, 5, null);
    }

    public static /* synthetic */ LorenzVec up$default(LorenzVec lorenzVec, Number number, int n, Object object) {
        if ((n & 1) != 0) {
            number = 1;
        }
        return lorenzVec.up(number);
    }

    @NotNull
    public final LorenzVec down(@NotNull Number offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return LorenzVec.copy$default(this, 0.0, this.y - offset.doubleValue(), 0.0, 5, null);
    }

    public static /* synthetic */ LorenzVec down$default(LorenzVec lorenzVec, Number number, int n, Object object) {
        if ((n & 1) != 0) {
            number = 1;
        }
        return lorenzVec.down(number);
    }

    @NotNull
    public final LorenzVec interpolate(@NotNull LorenzVec other, double factor) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(0.0 <= factor ? factor <= 1.0 : false)) {
            boolean bl = false;
            String string = "Percentage must be between 0 and 1: " + factor;
            throw new IllegalArgumentException(string.toString());
        }
        double x = (1.0 - factor) * this.x + factor * other.x;
        double y = (1.0 - factor) * this.y + factor * other.y;
        double z = (1.0 - factor) * this.z + factor * other.z;
        return new LorenzVec(x, y, z);
    }

    @NotNull
    public final LorenzVec negated() {
        return new LorenzVec(-this.x, -this.y, -this.z);
    }

    @NotNull
    public final LorenzVec rotateXY(double theta) {
        return new LorenzVec(this.x * Math.cos(theta) - this.y * Math.sin(theta), this.x * Math.sin(theta) + this.y * Math.cos(theta), this.z);
    }

    @NotNull
    public final LorenzVec rotateXZ(double theta) {
        return new LorenzVec(this.x * Math.cos(theta) + this.z * Math.sin(theta), this.y, -this.x * Math.sin(theta) + this.z * Math.cos(theta));
    }

    @NotNull
    public final LorenzVec rotateYZ(double theta) {
        return new LorenzVec(this.x, this.y * Math.cos(theta) - this.z * Math.sin(theta), this.y * Math.sin(theta) + this.z * Math.cos(theta));
    }

    @NotNull
    public final LorenzVec nearestPointOnLine(@NotNull LorenzVec startPos, @NotNull LorenzVec endPos) {
        Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
        Intrinsics.checkNotNullParameter((Object)endPos, (String)"endPos");
        LorenzVec d = endPos.minus(startPos);
        LorenzVec w = this.minus(startPos);
        double dp = d.lengthSquared();
        double dt = 0.0;
        if (!(dp == dt)) {
            dt = RangesKt.coerceIn((double)(w.dotProduct(d) / dp), (double)0.0, (double)1.0);
        }
        d = d.times(dt);
        d = d.plus(startPos);
        return d;
    }

    public final double distanceToLine(@NotNull LorenzVec startPos, @NotNull LorenzVec endPos) {
        Intrinsics.checkNotNullParameter((Object)startPos, (String)"startPos");
        Intrinsics.checkNotNullParameter((Object)endPos, (String)"endPos");
        return this.nearestPointOnLine(startPos, endPos).minus(this).lengthSquared();
    }

    @NotNull
    public final LorenzVec middle(@NotNull LorenzVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.plus(other.minus(this).div((Number)2));
    }

    private final LorenzVec div(Number i2) {
        return new LorenzVec(this.x / i2.doubleValue(), this.y / i2.doubleValue(), this.z / i2.doubleValue());
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof LorenzVec) {
            LorenzVec v2 = (LorenzVec)other;
            if (this.x == v2.x && this.y == v2.y && this.z == v2.z) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 31 * (31 * Double.hashCode(this.normX) + Double.hashCode(this.normY)) + Double.hashCode(this.normZ);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    @NotNull
    public final LorenzVec copy(double x, double y, double z) {
        return new LorenzVec(x, y, z);
    }

    public static /* synthetic */ LorenzVec copy$default(LorenzVec lorenzVec, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = lorenzVec.x;
        }
        if ((n & 2) != 0) {
            d2 = lorenzVec.y;
        }
        if ((n & 4) != 0) {
            d3 = lorenzVec.z;
        }
        return lorenzVec.copy(d, d2, d3);
    }

    @NotNull
    public String toString() {
        return "LorenzVec(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    private static final Set edges_delegate$lambda$0(LorenzVec this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        class_238 class_2383 = this$0.boundingToOffset(1.0, 1.0, 1.0).method_1009(1.0E-4, 1.0E-4, 1.0E-4);
        Intrinsics.checkNotNullExpressionValue((Object)class_2383, (String)"expand(...)");
        return LocationUtils.INSTANCE.calculateEdges(class_2383);
    }

    static {
        Object[] objectArray = new LorenzVec[]{new LorenzVec(1, 0, 0), new LorenzVec(-1, 0, 0), new LorenzVec(0, 1, 0), new LorenzVec(0, -1, 0), new LorenzVec(0, 0, 1), new LorenzVec(0, 0, -1)};
        directions = SetsKt.setOf((Object[])objectArray);
        expandVector = new LorenzVec((double)0.002f, (double)0.002f, (double)0.002f);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00040\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lat/hannibal2/skyhanni/utils/LorenzVec$Companion;", "", "<init>", "()V", "", "yawDegrees", "pitchDegrees", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getFromYawPitch", "(DD)Lat/hannibal2/skyhanni/utils/LorenzVec;", "", "string", "decodeFromString", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "", "toLorenzVec", "(Ljava/util/List;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "", "directions", "Ljava/util/Set;", "getDirections", "()Ljava/util/Set;", "expandVector", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getExpandVector", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "1.21.5"})
    @SourceDebugExtension(value={"SMAP\nLorenzVec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LorenzVec.kt\nat/hannibal2/skyhanni/utils/LorenzVec$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,313:1\n1563#2:314\n1634#2,3:315\n*S KotlinDebug\n*F\n+ 1 LorenzVec.kt\nat/hannibal2/skyhanni/utils/LorenzVec$Companion\n*L\n258#1:314\n258#1:315,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<LorenzVec> getDirections() {
            return directions;
        }

        @NotNull
        public final LorenzVec getFromYawPitch(double yawDegrees, double pitchDegrees) {
            double yawRad = (yawDegrees + (double)90) * Math.PI / (double)180;
            double pitchRad = (pitchDegrees + (double)90) * Math.PI / (double)180;
            double x = Math.sin(pitchRad) * Math.cos(yawRad);
            double y = Math.sin(pitchRad) * Math.sin(yawRad);
            double z = Math.cos(pitchRad);
            return new LorenzVec(x, z, y);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final LorenzVec decodeFromString(@NotNull String string) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            String[] stringArray = new String[]{":"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Double.parseDouble((String)it));
            }
            List list = (List)destination$iv$iv;
            double x = ((Number)list.get(0)).doubleValue();
            double y = ((Number)list.get(1)).doubleValue();
            double z = ((Number)list.get(2)).doubleValue();
            return new LorenzVec(x, y, z);
        }

        @NotNull
        public final LorenzVec toLorenzVec(@NotNull List<Double> $this$toLorenzVec) {
            Intrinsics.checkNotNullParameter($this$toLorenzVec, (String)"<this>");
            if ($this$toLorenzVec.size() != 3) {
                throw new IllegalStateException(("Can not transform a list of size " + $this$toLorenzVec.size() + " to LorenzVec").toString());
            }
            return new LorenzVec(((Number)$this$toLorenzVec.get(0)).doubleValue(), ((Number)$this$toLorenzVec.get(1)).doubleValue(), ((Number)$this$toLorenzVec.get(2)).doubleValue());
        }

        @NotNull
        public final LorenzVec getExpandVector() {
            return expandVector;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

