/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.events.ItemInHandChangeEvent;
import at.hannibal2.skyhanni.events.PlaySoundEvent;
import at.hannibal2.skyhanni.events.ReceiveParticleEvent;
import at.hannibal2.skyhanni.events.minecraft.ServerTickEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketReceivedEvent;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S29PacketSoundEffect;
import net.minecraft.network.play.server.S2APacketParticles;
import net.minecraft.network.play.server.S32PacketConfirmTransaction;
import net.minecraft.util.EnumParticleTypes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\n\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\n\u0010\u0003R$\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lat/hannibal2/skyhanni/data/MinecraftData;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;", "event", "", "onPacket", "(Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;)V", "onTick", "onWorldChange", "", "value", "totalServerTicks", "J", "getTotalServerTicks", "()J", "1.8.9"})
public final class MinecraftData {
    @NotNull
    public static final MinecraftData INSTANCE = new MinecraftData();
    private static long totalServerTicks;

    private MinecraftData() {
    }

    @HandleEvent(receiveCancelled=true)
    public final void onPacket(@NotNull PacketReceivedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Packet<?> packet = event.getPacket();
        if (packet instanceof S29PacketSoundEffect) {
            String string = ((S29PacketSoundEffect)packet).func_149212_c();
            Intrinsics.checkNotNullExpressionValue(string, "getSoundName(...)");
            if (new PlaySoundEvent(string, new LorenzVec(((S29PacketSoundEffect)packet).func_149207_d(), ((S29PacketSoundEffect)packet).func_149211_e(), ((S29PacketSoundEffect)packet).func_149210_f()), ((S29PacketSoundEffect)packet).func_149209_h(), ((S29PacketSoundEffect)packet).func_149208_g()).post()) {
                event.cancel();
            }
        } else if (packet instanceof S2APacketParticles) {
            EnumParticleTypes enumParticleTypes = ((S2APacketParticles)packet).func_179749_a();
            Intrinsics.checkNotNullExpressionValue(enumParticleTypes, "getParticleType(...)");
            if (new ReceiveParticleEvent(enumParticleTypes, new LorenzVec(((S2APacketParticles)packet).func_149220_d(), ((S2APacketParticles)packet).func_149226_e(), ((S2APacketParticles)packet).func_149225_f()), ((S2APacketParticles)packet).func_149222_k(), ((S2APacketParticles)packet).func_149227_j(), new LorenzVec(((S2APacketParticles)packet).func_149221_g(), ((S2APacketParticles)packet).func_149224_h(), ((S2APacketParticles)packet).func_149223_i()), ((S2APacketParticles)packet).func_179750_b(), ((S2APacketParticles)packet).func_179748_k()).post()) {
                event.cancel();
            }
        } else if (packet instanceof S32PacketConfirmTransaction) {
            if (((S32PacketConfirmTransaction)packet).func_148890_d() > 0) {
                return;
            }
            long l = totalServerTicks;
            totalServerTicks = l + 1L;
            ServerTickEvent.INSTANCE.post();
        }
    }

    public final long getTotalServerTicks() {
        return totalServerTicks;
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onTick() {
        NeuInternalName oldItem;
        Object newItem;
        ItemStack hand = InventoryUtils.INSTANCE.getItemInHand();
        Object object = hand;
        if (object == null || (object = ItemUtils.INSTANCE.getInternalName((ItemStack)object)) == null) {
            object = NeuInternalName.Companion.getNONE();
        }
        if (!Intrinsics.areEqual(newItem = object, oldItem = InventoryUtils.INSTANCE.getItemInHandId())) {
            if (!Intrinsics.areEqual(newItem, NeuInternalName.Companion.getNONE())) {
                InventoryUtils.INSTANCE.getRecentItemsInHand().add((NeuInternalName)newItem);
            }
            InventoryUtils.INSTANCE.setItemInHandId((NeuInternalName)newItem);
            InventoryUtils.INSTANCE.setLatestItemInHand(hand);
            new ItemInHandChangeEvent((NeuInternalName)newItem, oldItem).post();
        }
    }

    @HandleEvent
    public final void onWorldChange() {
        InventoryUtils.INSTANCE.setItemInHandId(NeuInternalName.Companion.getNONE());
        InventoryUtils.INSTANCE.getRecentItemsInHand().clear();
    }
}

