/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.events.ActionBarUpdateEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.ProfileJoinEvent;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u001b\u0010%\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u001b\u0010(\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\"\u001a\u0004\b'\u0010$R \u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000f0)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lat/hannibal2/skyhanni/data/SkillExperience;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ProfileJoinEvent;", "event", "", "onProfileJoin", "(Lat/hannibal2/skyhanni/events/ProfileJoinEvent;)V", "Lat/hannibal2/skyhanni/events/ActionBarUpdateEvent;", "onActionBarUpdate", "(Lat/hannibal2/skyhanni/events/ActionBarUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "onInventoryFullyOpened", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "", "experience", "", "getLevelForExpExactly", "(J)I", "requestedLevel", "getExpForNextLevel", "(I)I", "getExpForLevel", "(I)J", "", "skillName", "getExpForSkill", "(Ljava/lang/String;)J", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "actionBarPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getActionBarPattern", "()Ljava/util/regex/Pattern;", "actionBarPattern", "inventoryPattern$delegate", "getInventoryPattern", "inventoryPattern", "", "skillExp", "Ljava/util/Map;", "", "levelingExp", "Ljava/util/List;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nSkillExperience.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkillExperience.kt\nat/hannibal2/skyhanni/data/SkillExperience\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n8#2:177\n8#2:179\n1#3:178\n1#3:180\n*S KotlinDebug\n*F\n+ 1 SkillExperience.kt\nat/hannibal2/skyhanni/data/SkillExperience\n*L\n35#1:177\n67#1:179\n35#1:178\n67#1:180\n*E\n"})
public final class SkillExperience {
    @NotNull
    public static final SkillExperience INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern actionBarPattern$delegate;
    @NotNull
    private static final RepoPattern inventoryPattern$delegate;
    @NotNull
    private static final Map<String, Long> skillExp;
    @NotNull
    private static final List<Integer> levelingExp;

    private SkillExperience() {
    }

    private final Pattern getActionBarPattern() {
        return (Pattern)actionBarPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getInventoryPattern() {
        return (Pattern)inventoryPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    @HandleEvent
    public final void onProfileJoin(@NotNull ProfileJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        skillExp.clear();
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(onlyOnSkyblock=true)
    public final void onActionBarUpdate(@NotNull ActionBarUpdateEvent event) {
        void $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter(event, "event");
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getActionBarPattern();
        String text$iv = event.getActionBar();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onActionBarUpdate_u24lambda_u240 = it$iv;
            boolean bl2 = false;
            String string = $this$onActionBarUpdate_u24lambda_u240.group("skill");
            Intrinsics.checkNotNullExpressionValue(string, "group(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            String skill = string2;
            String string3 = $this$onActionBarUpdate_u24lambda_u240.group("overflow");
            Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
            long overflow = NumberUtil.INSTANCE.formatLong(string3);
            String string4 = $this$onActionBarUpdate_u24lambda_u240.group("needed");
            Intrinsics.checkNotNullExpressionValue(string4, "group(...)");
            long neededForNextLevel = NumberUtil.INSTANCE.formatLong(string4);
            int nextLevel = INSTANCE.getLevelForExpExactly(neededForNextLevel);
            long baseExp = INSTANCE.getExpForLevel(nextLevel - 1);
            long totalExp = baseExp + overflow;
            Long l = totalExp;
            skillExp.put(skill, l);
        }
    }

    @HandleEvent
    public final void onInventoryFullyOpened(@NotNull InventoryFullyOpenedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!Intrinsics.areEqual(event.getInventoryName(), "Your Skills")) {
            return;
        }
        Iterator<Map.Entry<Integer, ItemStack>> iterator2 = event.getInventoryItems().entrySet().iterator();
        while (iterator2.hasNext()) {
            ItemStack stack = iterator2.next().getValue();
            String string = stack.func_82833_r();
            Intrinsics.checkNotNullExpressionValue(string, "getDisplayName(...)");
            String name2 = StringUtils.removeColor$default(StringUtils.INSTANCE, string, false, 1, null);
            if (!StringsKt.contains$default((CharSequence)name2, " ", false, 2, null)) continue;
            List<String> lore = ItemUtils.INSTANCE.getLore(stack);
            boolean next = false;
            for (String line : lore) {
                if (StringsKt.contains$default((CharSequence)line, "Progress to Level", false, 2, null)) {
                    next = true;
                    continue;
                }
                if (!next) continue;
                String[] stringArray = new String[]{" "};
                List split = StringsKt.split$default((CharSequence)name2, stringArray, false, 0, 6, null);
                Intrinsics.checkNotNullExpressionValue(((String)split.get(0)).toLowerCase(Locale.ROOT), "toLowerCase(...)");
                int level = NumberUtil.INSTANCE.romanToDecimal((String)split.get(1));
                long baseExp = this.getExpForLevel(level);
                RegexUtils regexUtils = RegexUtils.INSTANCE;
                Pattern $this$matchMatcher$iv = this.getInventoryPattern();
                boolean $i$f$matchMatcher = false;
                Matcher it$iv = $this$matchMatcher$iv.matcher(line);
                boolean bl = false;
                if (it$iv.matches()) {
                    String skillName;
                    Intrinsics.checkNotNull(it$iv);
                    Matcher $this$onInventoryFullyOpened_u24lambda_u241 = it$iv;
                    boolean bl2 = false;
                    String string2 = $this$onInventoryFullyOpened_u24lambda_u241.group("number");
                    Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
                    long overflow = NumberUtil.INSTANCE.formatLong(string2);
                    long experience = baseExp + overflow;
                    Long l = experience;
                    skillExp.put(skillName, l);
                }
                next = false;
            }
        }
        if (!skillExp.isEmpty()) {
            return;
        }
    }

    private final int getLevelForExpExactly(long experience) {
        int level = 1;
        Iterator<Integer> iterator2 = levelingExp.iterator();
        while (iterator2.hasNext()) {
            int levelXP = ((Number)iterator2.next()).intValue();
            if ((long)levelXP == experience) {
                return level;
            }
            ++level;
        }
        return 0;
    }

    public final int getExpForNextLevel(int requestedLevel) {
        return ((Number)levelingExp.get(requestedLevel)).intValue();
    }

    public final long getExpForLevel(int requestedLevel) {
        long total = 0L;
        int level = 0;
        Iterator<Integer> iterator2 = levelingExp.iterator();
        while (iterator2.hasNext()) {
            int levelXP = ((Number)iterator2.next()).intValue();
            total += (long)levelXP;
            if (++level != requestedLevel) continue;
            return total;
        }
        return 0L;
    }

    public final long getExpForSkill(@NotNull String skillName) {
        Intrinsics.checkNotNullParameter(skillName, "skillName");
        String string = skillName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        Long l = skillExp.get(string);
        return l != null ? l : 0L;
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(SkillExperience.class, "actionBarPattern", "getActionBarPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(SkillExperience.class, "inventoryPattern", "getInventoryPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = objectArray;
        INSTANCE = new SkillExperience();
        patternGroup = RepoPattern.Companion.group("data.skill");
        actionBarPattern$delegate = patternGroup.pattern("actionbar", ".*\u00a73\\+.* (?<skill>.*) \\((?<overflow>.*)/(?<needed>.*)\\).*");
        inventoryPattern$delegate = patternGroup.pattern("inventory", ".* \u00a7e(?<number>.*)\u00a76/.*");
        skillExp = new LinkedHashMap();
        objectArray = new Integer[]{50, 125, 200, 300, 500, 750, 1000, 1500, 2000, 3500, 5000, 7500, 10000, 15000, 20000, 30000, 50000, 75000, 100000, 200000, 300000, 400000, 500000, 600000, 700000, 800000, 900000, 1000000, 1100000, 1200000, 1300000, 1400000, 1500000, 1600000, 1700000, 1800000, 1900000, 2000000, 0x200B20, 2200000, 2300000, 2400000, 2500000, 2600000, 2750000, 2900000, 3100000, 3400000, 3700000, 4000000, 4300000, 4600000, 4900000, 5200000, 5500000, 5800000, 6100000, 6400000, 6700000, 7000000};
        levelingExp = CollectionsKt.listOf(objectArray);
    }
}

