/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net.tftp;

import at.hannibal2.skyhanni.deps.commons.net.tftp.TFTPPacket;
import at.hannibal2.skyhanni.deps.commons.net.tftp.TFTPPacketException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.Locale;

public abstract class TFTPRequestPacket
extends TFTPPacket {
    static final String[] modeStrings = new String[]{"netascii", "octet"};
    private static final byte[][] modeBytes = new byte[][]{{110, 101, 116, 97, 115, 99, 105, 105, 0}, {111, 99, 116, 101, 116, 0}};
    private final int mode;
    private final String fileName;

    TFTPRequestPacket(InetAddress destination, int port, int type2, String fileName, int mode) {
        super(type2, destination, port);
        this.fileName = fileName;
        this.mode = mode;
    }

    TFTPRequestPacket(int type2, DatagramPacket datagram) throws TFTPPacketException {
        super(type2, datagram.getAddress(), datagram.getPort());
        int index;
        byte[] data2 = datagram.getData();
        if (this.getType() != data2[1]) {
            throw new TFTPPacketException("TFTP operator code does not match type.");
        }
        StringBuilder buffer = new StringBuilder();
        int length = datagram.getLength();
        for (index = 2; index < length && data2[index] != 0; ++index) {
            buffer.append((char)data2[index]);
        }
        this.fileName = buffer.toString();
        if (index >= length) {
            throw new TFTPPacketException("Bad file name and mode format.");
        }
        buffer.setLength(0);
        ++index;
        while (index < length && data2[index] != 0) {
            buffer.append((char)data2[index]);
            ++index;
        }
        String modeString = buffer.toString().toLowerCase(Locale.ENGLISH);
        length = modeStrings.length;
        int mode = 0;
        for (index = 0; index < length; ++index) {
            if (!modeString.equals(modeStrings[index])) continue;
            mode = index;
            break;
        }
        this.mode = mode;
        if (index >= length) {
            throw new TFTPPacketException("Unrecognized TFTP transfer mode: " + modeString);
        }
    }

    public final String getFilename() {
        return this.fileName;
    }

    public final int getMode() {
        return this.mode;
    }

    @Override
    public final DatagramPacket newDatagram() {
        int fileLength = this.fileName.length();
        int modeLength = modeBytes[this.mode].length;
        byte[] data2 = new byte[fileLength + modeLength + 4];
        data2[0] = 0;
        data2[1] = (byte)this.type;
        System.arraycopy(this.fileName.getBytes(Charset.defaultCharset()), 0, data2, 2, fileLength);
        data2[fileLength + 2] = 0;
        System.arraycopy(modeBytes[this.mode], 0, data2, fileLength + 3, modeLength);
        return new DatagramPacket(data2, data2.length, this.address, this.port);
    }

    @Override
    final DatagramPacket newDatagram(DatagramPacket datagram, byte[] data2) {
        int fileLength = this.fileName.length();
        int modeLength = modeBytes[this.mode].length;
        data2[0] = 0;
        data2[1] = (byte)this.type;
        System.arraycopy(this.fileName.getBytes(Charset.defaultCharset()), 0, data2, 2, fileLength);
        data2[fileLength + 2] = 0;
        System.arraycopy(modeBytes[this.mode], 0, data2, fileLength + 3, modeLength);
        datagram.setAddress(this.address);
        datagram.setPort(this.port);
        datagram.setData(data2);
        datagram.setLength(fileLength + modeLength + 3);
        return datagram;
    }
}

