/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui.editors;

import at.hannibal2.skyhanni.deps.moulconfig.common.RenderContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiOptionEditor;
import at.hannibal2.skyhanni.deps.moulconfig.gui.MouseEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.elements.GuiElementTextField;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedOption;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiOptionEditorTextL
extends GuiOptionEditor {
    private final GuiElementTextField textField;

    public GuiOptionEditorTextL(ProcessedOption option) {
        super(option);
        this.textField = new GuiElementTextField((String)option.get(), 0);
    }

    @Override
    public void render(RenderContext renderContext, int x, int y, int width) {
        super.render(renderContext, x, y, width);
        int height = this.getHeight();
        int fullWidth = Math.min(width / 3 - 10, 80);
        int textFieldX = x + width / 6 - fullWidth / 2;
        if (this.textField.getFocus()) {
            fullWidth = Math.max(fullWidth, Minecraft.func_71410_x().field_71466_p.func_78256_a(this.textField.getText()) + 10);
        }
        this.textField.setSize(fullWidth, 16);
        this.textField.setText((String)this.option.get());
        this.textField.render(textFieldX, y + height - 7 - 14);
    }

    @Override
    public boolean mouseInput(int x, int y, int width, int mouseX, int mouseY, MouseEvent mouseEvent) {
        if (mouseEvent instanceof MouseEvent.Move) {
            this.textField.mouseMoved(mouseX, mouseY);
            return false;
        }
        return super.mouseInput(x, y, width, mouseX, mouseY, mouseEvent);
    }

    @Override
    public boolean mouseInput(int x, int y, int width, int mouseX, int mouseY) {
        int height = this.getHeight();
        int fullWidth = Math.min(width / 3 - 10, 80);
        int textFieldX = x + width / 6 - fullWidth / 2;
        if (this.textField.getFocus()) {
            fullWidth = Math.max(fullWidth, Minecraft.func_71410_x().field_71466_p.func_78256_a(this.textField.getText()) + 10);
        }
        int textFieldY = y + height - 7 - 14;
        this.textField.setSize(fullWidth, 16);
        if (Mouse.getEventButton() == 0 || Mouse.getEventButton() == 1) {
            if (mouseX > textFieldX && mouseX < textFieldX + fullWidth && mouseY > textFieldY && mouseY < textFieldY + 16) {
                if (Mouse.getEventButtonState()) {
                    this.textField.mouseClicked(mouseX, mouseY, Mouse.getEventButton());
                } else {
                    this.textField.mouseUnclicked(mouseX, mouseY, Mouse.getEventButton());
                }
                return true;
            }
            this.textField.unfocus();
        }
        return false;
    }

    @Override
    public boolean keyboardInput() {
        if (!Keyboard.getEventKeyState()) {
            return false;
        }
        if (Keyboard.getEventKey() == 1 && this.textField.getFocus()) {
            this.textField.unfocus();
            return true;
        }
        if (this.textField.getFocus()) {
            this.textField.keyTyped(Keyboard.getEventCharacter(), Keyboard.getEventKey());
            try {
                this.textField.setCustomBorderColour(-1);
                this.option.set(this.textField.getText());
            }
            catch (Exception e) {
                this.textField.setCustomBorderColour(-65536);
            }
            return true;
        }
        return false;
    }
}

