/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.observer;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;

public class ObservableList<T>
implements List<T> {
    final List<T> delegate;
    Runnable observer;

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    @NotNull
    public <T1> T1[] toArray(@NotNull T1[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(T t) {
        boolean a = this.delegate.add(t);
        if (a) {
            this.update();
        }
        return a;
    }

    public void update() {
        if (this.observer != null) {
            this.observer.run();
        }
    }

    @Override
    public boolean remove(Object o) {
        boolean a = this.delegate.remove(o);
        if (a) {
            this.update();
        }
        return a;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        boolean a = this.delegate.addAll(c);
        if (a) {
            this.update();
        }
        return a;
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends T> c) {
        boolean b = this.delegate.addAll(index, c);
        if (b) {
            this.update();
        }
        return b;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        boolean b = this.delegate.removeAll(c);
        if (b) {
            this.update();
        }
        return b;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        boolean b = this.delegate.retainAll(c);
        if (b) {
            this.update();
        }
        return b;
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.update();
    }

    @Override
    public T get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public T set(int index, T element) {
        T set = this.delegate.set(index, element);
        this.update();
        return set;
    }

    @Override
    public void add(int index, T element) {
        this.delegate.add(index, element);
        this.update();
    }

    @Override
    public T remove(int index) {
        T remove = this.delegate.remove(index);
        this.update();
        return remove;
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    public ObservableList(List<T> delegate2) {
        this.delegate = delegate2;
    }

    public List<T> getDelegate() {
        return this.delegate;
    }

    public Runnable getObserver() {
        return this.observer;
    }

    public void setObserver(Runnable observer) {
        this.observer = observer;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObservableList)) {
            return false;
        }
        ObservableList other = (ObservableList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<T> this$delegate = this.getDelegate();
        List<T> other$delegate = other.getDelegate();
        if (this$delegate == null ? other$delegate != null : !((Object)this$delegate).equals(other$delegate)) {
            return false;
        }
        Runnable this$observer = this.getObserver();
        Runnable other$observer = other.getObserver();
        return !(this$observer == null ? other$observer != null : !this$observer.equals(other$observer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ObservableList;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        List<T> $delegate = this.getDelegate();
        result2 = result2 * 59 + ($delegate == null ? 43 : ((Object)$delegate).hashCode());
        Runnable $observer = this.getObserver();
        result2 = result2 * 59 + ($observer == null ? 43 : $observer.hashCode());
        return result2;
    }

    public String toString() {
        return "ObservableList(delegate=" + this.getDelegate() + ", observer=" + this.getObserver() + ")";
    }
}

