/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.dungeon;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.chat.ChatConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonApi;
import at.hannibal2.skyhanni.utils.RegexUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u0011\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0017R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonBossMessages;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "", "message", "", "isBoss", "(Ljava/lang/String;)Z", "Lat/hannibal2/skyhanni/config/features/chat/ChatConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/chat/ChatConfig;", "config", "Ljava/util/regex/Pattern;", "bossPattern", "Ljava/util/regex/Pattern;", "", "excludedMessages", "Ljava/util/List;", "messageList", "messageContainsList", "messageEndsWithList", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nDungeonBossMessages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonBossMessages.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonBossMessages\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n8#2:83\n1#3:84\n1755#4,3:85\n*S KotlinDebug\n*F\n+ 1 DungeonBossMessages.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonBossMessages\n*L\n76#1:83\n76#1:84\n77#1:85,3\n*E\n"})
public final class DungeonBossMessages {
    @NotNull
    public static final DungeonBossMessages INSTANCE = new DungeonBossMessages();
    @NotNull
    private static final Pattern bossPattern;
    @NotNull
    private static final List<String> excludedMessages;
    @NotNull
    private static final List<String> messageList;
    @NotNull
    private static final List<String> messageContainsList;
    @NotNull
    private static final List<String> messageEndsWithList;

    private DungeonBossMessages() {
    }

    private final ChatConfig getConfig() {
        return SkyHanniMod.feature.getChat();
    }

    @HandleEvent(onlyOnIsland=IslandType.CATACOMBS)
    public final void onChat(@NotNull SkyHanniChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isBoss(event.getMessage())) {
            return;
        }
        DungeonApi.INSTANCE.handleBossMessage(event.getMessage());
        if (this.getConfig().getDungeonBossMessages()) {
            event.setBlockedReason("dungeon_boss");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBoss(String message) {
        String it;
        boolean bl;
        if (excludedMessages.contains(message)) {
            return false;
        }
        if (messageList.contains(message)) {
            return true;
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv = bossPattern;
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(message);
        boolean bl2 = false;
        if (!it$iv.matches()) return false;
        Intrinsics.checkNotNull(it$iv);
        Matcher $this$isBoss_u24lambda_u242 = it$iv;
        boolean bl3 = false;
        Iterable $this$any$iv = messageContainsList;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                it = (String)element$iv;
                boolean bl4 = false;
                if (!StringsKt.contains$default((CharSequence)message, it, false, 2, null)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        $this$any$iv = messageEndsWithList;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            it = (String)element$iv;
            boolean bl5 = false;
        } while (!StringsKt.endsWith$default(message, it, false, 2, null));
        return true;
    }

    static {
        String[] stringArray = "\u00a7([cd4])\\[BOSS] (.*)";
        int n = 0;
        Pattern pattern = Pattern.compile((String)stringArray, n);
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        bossPattern = pattern;
        excludedMessages = CollectionsKt.listOf("\u00a7c[BOSS] The Watcher\u00a7r\u00a7f: You have proven yourself. You may pass.");
        stringArray = new String[]{"\u00a7cThe Crystal withers your soul as you hold it in your hands!", "\u00a7cIt doesn't seem like that is supposed to go there."};
        messageList = CollectionsKt.listOf(stringArray);
        stringArray = new String[]{" The Watcher\u00a7r\u00a7f: ", " Bonzo\u00a7r\u00a7f: ", " Scarf\u00a7r\u00a7f:", "Professor\u00a7r\u00a7f", " Livid\u00a7r\u00a7f: ", " Enderman\u00a7r\u00a7f: ", " Thorn\u00a7r\u00a7f: ", " Sadan\u00a7r\u00a7f: ", " Maxor\u00a7r\u00a7c: ", " Storm\u00a7r\u00a7c: ", " Goldor\u00a7r\u00a7c: ", " Necron\u00a7r\u00a7c: ", " \u00a7r\u00a74\u00a7kWither King\u00a7r\u00a7c:"};
        messageContainsList = CollectionsKt.listOf(stringArray);
        stringArray = new String[]{" Necron\u00a7r\u00a7c: That is enough, fool!", " Necron\u00a7r\u00a7c: Adventurers! Be careful of who you are messing with..", " Necron\u00a7r\u00a7c: Before I have to deal with you myself."};
        messageEndsWithList = CollectionsKt.listOf(stringArray);
    }
}

