/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing.tracker;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandBuilder;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.fishing.SeaCreatureTrackerConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.config.storage.Resettable;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.jsonobjects.repo.ExcludedSeaCreatureAreasJson;
import at.hannibal2.skyhanni.data.repo.AbstractRepoManager;
import at.hannibal2.skyhanni.data.repo.AbstractRepoReloadEvent;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.fishing.FishingBobberCastEvent;
import at.hannibal2.skyhanni.events.fishing.SeaCreatureFishEvent;
import at.hannibal2.skyhanni.features.fishing.FishingApi;
import at.hannibal2.skyhanni.features.fishing.SeaCreature;
import at.hannibal2.skyhanni.features.fishing.SeaCreatureManager;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.collection.RenderableCollectionUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.RenderableUtils;
import at.hannibal2.skyhanni.utils.renderables.ScrollValue;
import at.hannibal2.skyhanni.utils.renderables.Searchable;
import at.hannibal2.skyhanni.utils.renderables.SearchableKt;
import at.hannibal2.skyhanni.utils.renderables.container.HorizontalContainerRenderable;
import at.hannibal2.skyhanni.utils.tracker.SkyHanniTracker;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.Expose;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001?B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000f\u001a\u0012\u0012\b\u0012\u00060\fj\u0002`\r\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0003J\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J#\u0010\u0017\u001a\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J-\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001b0\u001a*\b\u0012\u0004\u0012\u00020\u00130\u00192\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001b\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b \u0010\u0003J\u0017\u0010\"\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020!H\u0007\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010'\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020&H\u0007\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010)\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b)\u0010%J\u0017\u0010+\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020*H\u0007\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010-\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b-\u0010%R\u0016\u0010.\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0014\u00103\u001a\u0002008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020\t048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0018\u00107\u001a\u00060\fj\u0002`\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b7\u00108R\u001a\u00109\u001a\u00060\fj\u0002`\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u00108R\u001c\u0010<\u001a\b\u0012\u0004\u0012\u00020;0:8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u001c\u0010>\u001a\b\u0012\u0004\u0012\u00020\f0:8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010=\u00a8\u0006@"}, d2={"Lat/hannibal2/skyhanni/features/fishing/tracker/SeaCreatureTracker;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/fishing/SeaCreatureFishEvent;", "event", "", "onSeaCreatureFish", "(Lat/hannibal2/skyhanni/events/fishing/SeaCreatureFishEvent;)V", "Lat/hannibal2/skyhanni/features/fishing/tracker/SeaCreatureTracker$Data;", "data", "", "", "Lat/hannibal2/skyhanni/features/fishing/tracker/CategoryName;", "", "getCurrentCategories", "(Lat/hannibal2/skyhanni/features/fishing/tracker/SeaCreatureTracker$Data;)Ljava/util/Map;", "onProfileJoin", "", "Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "drawDisplay", "(Lat/hannibal2/skyhanni/features/fishing/tracker/SeaCreatureTracker$Data;)Ljava/util/List;", "", "tryToMigrate", "(Ljava/util/Map;)V", "", "Lkotlin/Function1;", "", "addCategories", "(Ljava/util/List;Lat/hannibal2/skyhanni/features/fishing/tracker/SeaCreatureTracker$Data;)Lkotlin/jvm/functions/Function1;", "filterCurrentCategory", "()Lkotlin/jvm/functions/Function1;", "onConfigLoad", "Lat/hannibal2/skyhanni/events/fishing/FishingBobberCastEvent;", "onBobberThrow", "(Lat/hannibal2/skyhanni/events/fishing/FishingBobberCastEvent;)V", "shouldShowDisplay", "()Z", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "inDisabledArea", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "isEnabled", "needMigration", "Z", "Lat/hannibal2/skyhanni/config/features/fishing/SeaCreatureTrackerConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/fishing/SeaCreatureTrackerConfig;", "config", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniTracker;", "tracker", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniTracker;", "NAME_ALL", "Ljava/lang/String;", "currentCategory", "", "Lat/hannibal2/skyhanni/data/IslandType;", "excludedIslands", "Ljava/util/Set;", "excludedGraphAreas", "Data", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nSeaCreatureTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeaCreatureTracker.kt\nat/hannibal2/skyhanni/features/fishing/tracker/SeaCreatureTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 RenderableUtils.kt\nat/hannibal2/skyhanni/utils/renderables/RenderableUtils\n+ 5 AbstractRepoReloadEvent.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoReloadEvent\n+ 6 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n+ 7 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n*L\n1#1,225:1\n1782#2,4:226\n1062#2:237\n535#3:230\n520#3,6:231\n241#4,10:238\n344#4,10:248\n253#4:258\n354#4,20:259\n386#4,2:279\n385#4,14:281\n259#4:295\n13#5,7:296\n21#5,6:313\n167#6,5:303\n172#6,4:309\n24#7:308\n*S KotlinDebug\n*F\n+ 1 SeaCreatureTracker.kt\nat/hannibal2/skyhanni/features/fishing/tracker/SeaCreatureTracker\n*L\n66#1:226,4\n89#1:237\n86#1:230\n86#1:231,6\n141#1:238,10\n141#1:248,10\n141#1:258\n141#1:259,20\n141#1:279,2\n141#1:281,14\n141#1:295\n201#1:296,7\n201#1:313,6\n201#1:303,5\n201#1:309,4\n201#1:308\n*E\n"})
public final class SeaCreatureTracker {
    @NotNull
    public static final SeaCreatureTracker INSTANCE = new SeaCreatureTracker();
    private static boolean needMigration = true;
    @NotNull
    private static final SkyHanniTracker<Data> tracker = new SkyHanniTracker("Sea Creature Tracker", SeaCreatureTracker::tracker$lambda$0, SeaCreatureTracker::tracker$lambda$1, null, SeaCreatureTracker::tracker$lambda$2, 8, null);
    @NotNull
    private static final String NAME_ALL = "All";
    @NotNull
    private static String currentCategory = "All";
    @NotNull
    private static Set<? extends IslandType> excludedIslands;
    @NotNull
    private static Set<String> excludedGraphAreas;

    private SeaCreatureTracker() {
    }

    private final SeaCreatureTrackerConfig getConfig() {
        return SkyHanniMod.feature.getFishing().getSeaCreatureTracker();
    }

    @HandleEvent
    public final void onSeaCreatureFish(@NotNull SeaCreatureFishEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        tracker.modify(arg_0 -> SeaCreatureTracker.onSeaCreatureFish$lambda$3(event, arg_0));
        if (this.getConfig().getHideChat()) {
            event.getChatEvent().setBlockedReason("sea_creature_tracker");
        }
    }

    private final Map<String, Integer> getCurrentCategories(Data data2) {
        Map map2 = new LinkedHashMap();
        map2.put(NAME_ALL, data2.getAmount().size());
        for (Map.Entry<String, List<String>> entry : SeaCreatureManager.INSTANCE.getAllVariants().entrySet()) {
            int amount;
            int n;
            String category = entry.getKey();
            List<String> names = entry.getValue();
            Iterable $this$count$iv = names;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!data2.getAmount().containsKey(it) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if ((amount = n) <= 0) continue;
            Integer n2 = amount;
            map2.put(category, n2);
        }
        return map2;
    }

    @HandleEvent
    public final void onProfileJoin() {
        needMigration = true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Searchable> drawDisplay(Data data2) {
        void $this$filterTo$iv$iv;
        List<Searchable> list;
        List<Searchable> $this$drawDisplay_u24lambda_u248 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        INSTANCE.tryToMigrate(data2.getAmount());
        RenderableCollectionUtils.addSearchString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u248, "\u00a77Sea Creature Tracker:", null, null, null, 14, null);
        Function1<String, Boolean> filter2 = INSTANCE.addCategories($this$drawDisplay_u24lambda_u248, data2);
        Map<String, Integer> $this$filter$iv = data2.getAmount();
        boolean $i$f$filter = false;
        Map<String, Integer> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            if (!filter2.invoke((String)it.getKey()).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map realAmount = destination$iv$iv;
        double total = CollectionUtils.INSTANCE.sumAllValues(realAmount);
        Iterable $this$sortedByDescending$iv = realAmount.entrySet();
        boolean $i$f$sortedByDescending = false;
        for (Map.Entry entry : CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getValue()));
            }
        })) {
            String string;
            String name2 = (String)entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            Object object = SeaCreatureManager.INSTANCE.getAllFishingMobs().get(name2);
            if (object == null || (object = ((SeaCreature)object).getDisplayName()) == null) {
                List<Searchable> $this$drawDisplay_u24lambda_u248_u24lambda_u247 = $this$drawDisplay_u24lambda_u248;
                boolean bl3 = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to("SeaCreatureManager.allFishingMobs.keys", SeaCreatureManager.INSTANCE.getAllFishingMobs().keySet()), TuplesKt.to("name", name2)};
                ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "Sea Creature Tracker can not display a name correctly", "Could not find sea creature by name", pairArray, false, false, false, null, 120, null);
                object = name2;
            }
            Object displayName = object;
            if (((Boolean)INSTANCE.getConfig().getShowPercentage().get()).booleanValue()) {
                String percentage = NumberUtil.INSTANCE.formatPercentage((double)amount / total);
                string = " \u00a77" + percentage;
            } else {
                string = "";
            }
            String percentageSuffix = string;
            RenderableCollectionUtils.addSearchString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u248, " \u00a77- \u00a7e" + NumberUtil.INSTANCE.addSeparators(amount) + ' ' + (String)displayName + percentageSuffix, (String)displayName, null, null, 12, null);
        }
        RenderableCollectionUtils.addSearchString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u248, " \u00a77- \u00a7e" + NumberUtil.INSTANCE.addSeparators(total) + " \u00a77Total Sea Creatures", null, null, null, 14, null);
        return CollectionsKt.build(list);
    }

    private final void tryToMigrate(Map<String, Integer> data2) {
        if (!needMigration) {
            return;
        }
        needMigration = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to("Phlhlegblast", "Plhlegblast"), TuplesKt.to("Sea Emperor", "The Sea Emperor"), TuplesKt.to("The Sea Emperor", "The Loch Emperor")};
        Map map2 = MapsKt.mutableMapOf(pairArray);
        for (Map.Entry entry : map2.entrySet()) {
            String oldName = (String)entry.getKey();
            String newName = (String)entry.getValue();
            if (!SeaCreatureManager.INSTANCE.getAllFishingMobs().containsKey(newName)) continue;
            Integer n = data2.get(oldName);
            if (n == null) continue;
            int it = ((Number)n).intValue();
            boolean bl = false;
            ChatUtils.debug$default(ChatUtils.INSTANCE, "Sea Creature Tracker migrated " + it + ' ' + oldName + " to " + newName, false, 2, null);
            Map<String, Integer> map3 = data2;
            Integer n2 = data2.get(newName);
            Integer n3 = it + (n2 != null ? n2 : 0);
            map3.put(newName, n3);
            data2.remove(oldName);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Function1<String, Boolean> addCategories(List<Searchable> $this$addCategories, Data data2) {
        Map<String, Integer> amounts = this.getCurrentCategories(data2);
        List list = CollectionsKt.toList((Iterable)amounts.keySet());
        if (!list.contains(currentCategory)) {
            currentCategory = NAME_ALL;
        }
        if (tracker.isInventoryOpen()) {
            void label$iv;
            List<String> list2;
            void current$iv;
            RenderableUtils renderableUtils = RenderableUtils.INSTANCE;
            String string = "Category";
            String string2 = currentCategory;
            boolean enableUniverseScroll$iv = true;
            boolean $i$f$addButton = false;
            List<Searchable> list3 = $this$addCategories;
            ScrollValue scrollValue$iv$iv = new ScrollValue();
            boolean $i$f$createButtonNew = false;
            Object it$iv = current$iv;
            boolean bl = false;
            void v0 = it$iv;
            if (v0 == null) {
                throw new IllegalStateException("it is null in non-nullable getName()".toString());
            }
            String it = v0;
            boolean bl2 = false;
            String currentName$iv$iv = StringUtils.INSTANCE.allLettersFirstUppercase(it) + " \u00a77(" + amounts.get(it) + ')';
            List<String> $this$createButtonNew_u24lambda_u2430$iv$iv = list2 = CollectionsKt.createListBuilder();
            boolean bl3 = false;
            $this$createButtonNew_u24lambda_u2430$iv$iv.add("\u00a7a" + (String)label$iv);
            $this$createButtonNew_u24lambda_u2430$iv$iv.add(" ");
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Object entry$iv$iv;
                it$iv = entry$iv$iv = iterator2.next();
                bl = false;
                Object t = it$iv;
                if (t == null) {
                    throw new IllegalStateException("it is null in non-nullable getName()".toString());
                }
                it = (String)t;
                bl2 = false;
                String name$iv$iv = StringUtils.INSTANCE.allLettersFirstUppercase(it) + " \u00a77(" + amounts.get(it) + ')';
                boolean bl4 = Intrinsics.areEqual(entry$iv$iv, current$iv) ? $this$createButtonNew_u24lambda_u2430$iv$iv.add("\u00a7e\u25b6 " + name$iv$iv) : $this$createButtonNew_u24lambda_u2430$iv$iv.add("\u00a77  " + name$iv$iv);
            }
            $this$createButtonNew_u24lambda_u2430$iv$iv.add(" ");
            $this$createButtonNew_u24lambda_u2430$iv$iv.add("\u00a7bRight-click to go backwards!");
            $this$createButtonNew_u24lambda_u2430$iv$iv.add("\u00a7eClick to switch " + (String)label$iv + '!');
            $this$createButtonNew_u24lambda_u2430$iv$iv.add("\u00a78You can also mouse scroll!");
            List<String> tips$iv$iv = CollectionsKt.build(list2);
            Function1 onClick$iv$iv = new Function1<Integer, Unit>(list, (Object)current$iv){
                final /* synthetic */ List $universe;
                final /* synthetic */ Object $current;
                {
                    this.$universe = $universe;
                    this.$current = $current;
                }

                public final void invoke(int keyCode) {
                    Object next;
                    Object object;
                    if (System.currentTimeMillis() - ChatUtils.INSTANCE.getLastButtonClicked() < 150L) {
                        return;
                    }
                    switch (keyCode) {
                        case -100: {
                            object = RenderableUtils.INSTANCE.circle(this.$universe, this.$current);
                            break;
                        }
                        case -99: {
                            object = RenderableUtils.INSTANCE.circleBackwards(this.$universe, this.$current);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    Object it = next = object;
                    boolean bl = false;
                    Object object2 = it;
                    if (object2 == null) {
                        throw new IllegalStateException("it is null in non-nullable onChange()".toString());
                    }
                    String it2 = (String)object2;
                    boolean bl2 = false;
                    SeaCreatureTracker.access$setCurrentCategory$p(it2);
                    SeaCreatureTracker.access$getTracker$p().update();
                    SoundUtils.INSTANCE.playClickSound();
                    ChatUtils.INSTANCE.setLastButtonClicked(System.currentTimeMillis());
                }
            };
            Pair[] pairArray = new Pair[]{TuplesKt.to(-100, new Function0<Unit>((Function1<? super Integer, Unit>)onClick$iv$iv){
                final /* synthetic */ Function1<Integer, Unit> $onClick;
                {
                    this.$onClick = $onClick;
                }

                public final void invoke() {
                    this.$onClick.invoke(-100);
                }
            }), TuplesKt.to(-99, new Function0<Unit>((Function1<? super Integer, Unit>)onClick$iv$iv){
                final /* synthetic */ Function1<Integer, Unit> $onClick;
                {
                    this.$onClick = $onClick;
                }

                public final void invoke() {
                    this.$onClick.invoke(-99);
                }
            })};
            Map clickMap$iv$iv = MapsKt.mapOf(pairArray);
            list3.add(SearchableKt.toSearchable$default(HorizontalContainerRenderable.Companion.horizontal$default(HorizontalContainerRenderable.Companion, Renderable.Companion, 0, null, null, new Function1<List<Renderable>, Unit>((String)label$iv, currentName$iv$iv, tips$iv$iv, enableUniverseScroll$iv, clickMap$iv$iv, scrollValue$iv$iv){
                final /* synthetic */ String $label;
                final /* synthetic */ String $currentName;
                final /* synthetic */ List<String> $tips;
                final /* synthetic */ boolean $enableUniverseScroll;
                final /* synthetic */ Map<Integer, Function0<Unit>> $clickMap;
                final /* synthetic */ ScrollValue $scrollValue;
                {
                    this.$label = $label;
                    this.$currentName = $currentName;
                    this.$tips = $tips;
                    this.$enableUniverseScroll = $enableUniverseScroll;
                    this.$clickMap = $clickMap;
                    this.$scrollValue = $scrollValue;
                }

                public final void invoke(List<Renderable> $this$horizontal) {
                    Renderable renderable2;
                    Intrinsics.checkNotNullParameter($this$horizontal, "$this$horizontal");
                    RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$horizontal, "\u00a77" + this.$label + " \u00a7a[", 0.0, null, null, 14, null);
                    Renderable displayFormat2 = Renderable.Companion.hoverTips$default(Renderable.Companion, "\u00a7e" + this.$currentName, this.$tips, null, null, null, false, false, false, null, RenderableUtils.createButtonNew.displayFormat.1.INSTANCE, 444, null);
                    boolean bl = this.$enableUniverseScroll;
                    if (bl) {
                        renderable2 = Renderable.Companion.clickableAndScrollable$default(Renderable.Companion, displayFormat2, this.$clickMap, false, null, this.$scrollValue, 8, null);
                    } else if (!bl) {
                        renderable2 = Renderable.Companion.clickable$default(Renderable.Companion, displayFormat2, this.$clickMap, false, null, null, null, 56, null);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    Renderable it = renderable2;
                    boolean bl2 = false;
                    $this$horizontal.add(it);
                    RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$horizontal, "\u00a7a]", 0.0, null, null, 14, null);
                }
            }, 7, null), null, 1, null));
        }
        return Intrinsics.areEqual(currentCategory, NAME_ALL) ? SeaCreatureTracker::addCategories$lambda$12 : this.filterCurrentCategory();
    }

    private final Function1<String, Boolean> filterCurrentCategory() {
        List<String> list = SeaCreatureManager.INSTANCE.getAllVariants().get(currentCategory);
        if (list == null) {
            SeaCreatureTracker $this$filterCurrentCategory_u24lambda_u2414 = this;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to("SeaCreatureManager.allVariants.keys", SeaCreatureManager.INSTANCE.getAllVariants().keySet()), TuplesKt.to("currentCategory", currentCategory)};
            ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "Sea Creature Tracker can not find all sea creature variants", "Sea creature variant is not found", pairArray, false, false, false, null, 120, null);
            return SeaCreatureTracker::filterCurrentCategory$lambda$14$lambda$13;
        }
        List<String> items = list;
        return arg_0 -> SeaCreatureTracker.filterCurrentCategory$lambda$15(items, arg_0);
    }

    @HandleEvent
    public final void onConfigLoad() {
        Property[] propertyArray = new Property[]{this.getConfig().getShowPercentage()};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, SeaCreatureTracker::onConfigLoad$lambda$16);
    }

    @HandleEvent
    public final void onBobberThrow(@NotNull FishingBobberCastEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        tracker.firstUpdate();
    }

    private final boolean shouldShowDisplay() {
        if (!this.getConfig().getEnabled()) {
            return false;
        }
        if (!this.isEnabled()) {
            return false;
        }
        if (this.inDisabledArea()) {
            return false;
        }
        return FishingApi.INSTANCE.isFishing(false);
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        Object object;
        Intrinsics.checkNotNullParameter(event, "event");
        String constant$iv = "fishing/ExcludedSeaCreatureAreas";
        Object type$iv = null;
        Gson gson$iv = ((AbstractRepoReloadEvent)event).getGson();
        boolean $i$f$getConstant = false;
        Object object2 = event;
        try {
            Object $this$getRepoData_u24lambda_u2414$iv$iv;
            void this_$iv$iv;
            AbstractRepoReloadEvent $this$getConstant_u24lambda_u242$iv = object2;
            boolean bl = false;
            AbstractRepoManager<?> abstractRepoManager = $this$getConstant_u24lambda_u242$iv.getManager();
            String directory$iv$iv = "constants";
            boolean $i$f$getRepoData = false;
            Object object3 = this_$iv$iv;
            try {
                $this$getRepoData_u24lambda_u2414$iv$iv = object3;
                boolean bl2 = false;
                String path$iv$iv = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).resolvePath(directory$iv$iv, constant$iv);
                JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).readJsonElement(path$iv$iv);
                if (jsonElement == null) {
                    ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).getLogger().throwError("Repo file '" + constant$iv + "' not found.");
                    throw new KotlinNothingValueException();
                }
                JsonElement json$iv$iv = jsonElement;
                Gson $this$fromJson$iv$iv$iv = gson$iv;
                boolean $i$f$fromJson = false;
                Object object4 = $this$fromJson$iv$iv$iv.fromJson(json$iv$iv, ReflectJvmMapping.getJavaType(Reflection.typeOf(ExcludedSeaCreatureAreasJson.class)));
                Intrinsics.checkNotNullExpressionValue(object4, "fromJson(...)");
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl(object4);
            }
            catch (Throwable bl2) {
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl(ResultKt.createFailure(bl2));
            }
            object3 = $this$getRepoData_u24lambda_u2414$iv$iv;
            Throwable throwable = Result.exceptionOrNull-impl(object3);
            if (throwable != null) {
                Throwable e$iv$iv = throwable;
                boolean bl3 = false;
                this_$iv$iv.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv$iv);
                throw new KotlinNothingValueException();
            }
            Object constantData$iv = object3;
            $this$getConstant_u24lambda_u242$iv.getManager().addSuccessfulConstant(constant$iv);
            object = constantData$iv;
        }
        catch (Throwable bl) {
            object2 = Result.constructor-impl(ResultKt.createFailure(bl));
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable != null) {
                Throwable it$iv = throwable;
                boolean bl4 = false;
                ((AbstractRepoReloadEvent)event).getManager().addUnsuccessfulConstant(constant$iv);
                ((AbstractRepoReloadEvent)event).getManager().getLogger().throwErrorWithCause("Could not load constant '" + constant$iv + '\'', it$iv);
                throw new KotlinNothingValueException();
            }
            throw new KotlinNothingValueException();
        }
        ExcludedSeaCreatureAreasJson data2 = (ExcludedSeaCreatureAreasJson)object;
        Set<IslandType> set = data2.getExcludedIslands();
        Set<Object> set2 = set != null ? CollectionsKt.toSet((Iterable)set) : null;
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        excludedIslands = set2;
        Set<String> set3 = data2.getExcludedGraphAreas();
        Set<Object> set4 = set3 != null ? CollectionsKt.toSet((Iterable)set3) : null;
        if (set4 == null) {
            set4 = SetsKt.emptySet();
        }
        excludedGraphAreas = set4;
    }

    private final boolean inDisabledArea() {
        return excludedIslands.contains((Object)SkyBlockUtils.INSTANCE.getCurrentIsland()) ? true : CollectionsKt.contains((Iterable)excludedGraphAreas, SkyBlockUtils.INSTANCE.getGraphArea());
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        event.register("shresetseacreaturetracker", SeaCreatureTracker::onCommandRegistration$lambda$20);
    }

    private final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && !FishingApi.INSTANCE.getHasTreasureHook() && !FishingApi.INSTANCE.getWearingTrophyArmor();
    }

    private static final Data tracker$lambda$0() {
        return new Data(null, 1, null);
    }

    private static final Data tracker$lambda$1(ProfileSpecificStorage it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getFishing().getSeaCreatureTracker();
    }

    private static final List tracker$lambda$2(Data it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return INSTANCE.drawDisplay(it);
    }

    private static final Unit onSeaCreatureFish$lambda$3(SeaCreatureFishEvent $event, Data it) {
        Intrinsics.checkNotNullParameter($event, "$event");
        Intrinsics.checkNotNullParameter(it, "it");
        int amount = $event.getDoubleHook() && INSTANCE.getConfig().getCountDouble() ? 2 : 1;
        CollectionUtils.INSTANCE.addOrPut(it.getAmount(), $event.getSeaCreature().getName(), amount);
        return Unit.INSTANCE;
    }

    private static final boolean addCategories$lambda$12(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return true;
    }

    private static final boolean filterCurrentCategory$lambda$14$lambda$13(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return true;
    }

    private static final boolean filterCurrentCategory$lambda$15(List $items, String it) {
        Intrinsics.checkNotNullParameter($items, "$items");
        Intrinsics.checkNotNullParameter(it, "it");
        return $items.contains(it);
    }

    private static final void onConfigLoad$lambda$16() {
        tracker.update();
    }

    private static final Position _init_$lambda$17() {
        return INSTANCE.getConfig().getPosition();
    }

    private static final boolean _init_$lambda$18() {
        return INSTANCE.shouldShowDisplay();
    }

    private static final Unit onCommandRegistration$lambda$20$lambda$19(String[] it) {
        Intrinsics.checkNotNullParameter(it, "it");
        tracker.resetCommand();
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$20(CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter($this$register, "$this$register");
        $this$register.setDescription("Resets the Sea Creature Tracker");
        $this$register.setCategory(CommandCategory.USERS_RESET);
        $this$register.callback(SeaCreatureTracker::onCommandRegistration$lambda$20$lambda$19);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$setCurrentCategory$p(String string) {
        currentCategory = string;
    }

    public static final /* synthetic */ SkyHanniTracker access$getTracker$p() {
        return tracker;
    }

    static {
        SkyHanniTracker.initRenderer$default(tracker, SeaCreatureTracker::_init_$lambda$17, null, null, SeaCreatureTracker::_init_$lambda$18, 6, null);
        excludedIslands = SetsKt.emptySet();
        excludedGraphAreas = SetsKt.emptySet();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u00d6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R.\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0015\u001a\u0004\b\u0016\u0010\t\"\u0004\b\u0017\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lat/hannibal2/skyhanni/features/fishing/tracker/SeaCreatureTracker$Data;", "Lat/hannibal2/skyhanni/config/storage/Resettable;", "", "", "", "amount", "<init>", "(Ljava/util/Map;)V", "component1", "()Ljava/util/Map;", "copy", "(Ljava/util/Map;)Lat/hannibal2/skyhanni/features/fishing/tracker/SeaCreatureTracker$Data;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Ljava/util/Map;", "getAmount", "setAmount", "1.8.9"})
    public static final class Data
    implements Resettable {
        @Expose
        @NotNull
        private Map<String, Integer> amount;

        public Data(@NotNull Map<String, Integer> amount) {
            Intrinsics.checkNotNullParameter(amount, "amount");
            this.amount = amount;
        }

        public /* synthetic */ Data(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map2 = new LinkedHashMap();
            }
            this(map2);
        }

        @NotNull
        public final Map<String, Integer> getAmount() {
            return this.amount;
        }

        public final void setAmount(@NotNull Map<String, Integer> map2) {
            Intrinsics.checkNotNullParameter(map2, "<set-?>");
            this.amount = map2;
        }

        @NotNull
        public final Map<String, Integer> component1() {
            return this.amount;
        }

        @NotNull
        public final Data copy(@NotNull Map<String, Integer> amount) {
            Intrinsics.checkNotNullParameter(amount, "amount");
            return new Data(amount);
        }

        public static /* synthetic */ Data copy$default(Data data2, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = data2.amount;
            }
            return data2.copy(map2);
        }

        @NotNull
        public String toString() {
            return "Data(amount=" + this.amount + ')';
        }

        public int hashCode() {
            return ((Object)this.amount).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            return Intrinsics.areEqual(this.amount, data2.amount);
        }

        @Override
        public void reset() {
            Resettable.DefaultImpls.reset(this);
        }

        public Data() {
            this(null, 1, null);
        }
    }
}

