/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.slayer.enderman;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.slayer.endermen.EndermanBeaconConfig;
import at.hannibal2.skyhanni.config.features.slayer.endermen.EndermanConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.SlayerApi;
import at.hannibal2.skyhanni.data.title.TitleManager;
import at.hannibal2.skyhanni.events.CheckRenderEntityEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.ServerBlockChangeEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.mixins.hooks.RenderLivingEntityHelper;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzLogger;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkullTextureHolder;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.compat.EntityCompatKt;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0013J\u0017\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\u001d\u0010\u0003J\u0017\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u001eH\u0007\u00a2\u0006\u0004\b\u001f\u0010 R\u0014\u0010$\u001a\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010(\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020-0,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020-0,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u0010/R\"\u00104\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u000203018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0014\u00107\u001a\u0002068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R\u001b\u0010>\u001a\u0002098BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\u00a8\u0006?"}, d2={"Lat/hannibal2/skyhanni/features/slayer/enderman/EndermanSlayerFeatures;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/CheckRenderEntityEvent;", "Lnet/minecraft/entity/Entity;", "event", "", "onCheckRender", "(Lat/hannibal2/skyhanni/events/CheckRenderEntityEvent;)V", "Lnet/minecraft/entity/monster/EntityEnderman;", "enderman", "", "hasBeaconInHand", "(Lnet/minecraft/entity/monster/EntityEnderman;)Z", "showBeacon", "()Z", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "drawNukekubiSkulls", "drawFlyingBeacon", "drawSittingBeacon", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "Lat/hannibal2/skyhanni/events/ServerBlockChangeEvent;", "onBlockChange", "(Lat/hannibal2/skyhanni/events/ServerBlockChangeEvent;)V", "onWorldChange", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/slayer/endermen/EndermanConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/slayer/endermen/EndermanConfig;", "config", "Lat/hannibal2/skyhanni/config/features/slayer/endermen/EndermanBeaconConfig;", "getBeaconConfig", "()Lat/hannibal2/skyhanni/config/features/slayer/endermen/EndermanBeaconConfig;", "beaconConfig", "", "endermenWithBeacons", "Ljava/util/List;", "", "Lnet/minecraft/entity/item/EntityArmorStand;", "flyingBeacons", "Ljava/util/Set;", "nukekubiSkulls", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "sittingBeacon", "Ljava/util/Map;", "Lat/hannibal2/skyhanni/utils/LorenzLogger;", "logger", "Lat/hannibal2/skyhanni/utils/LorenzLogger;", "", "NUKEKUBI_SKULL_TEXTURE$delegate", "Lkotlin/Lazy;", "getNUKEKUBI_SKULL_TEXTURE", "()Ljava/lang/String;", "NUKEKUBI_SKULL_TEXTURE", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nEndermanSlayerFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndermanSlayerFeatures.kt\nat/hannibal2/skyhanni/features/slayer/enderman/EndermanSlayerFeatures\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,255:1\n1557#2:256\n1628#2,3:257\n1863#2,2:268\n535#3:260\n520#3,6:261\n1#4:267\n*S KotlinDebug\n*F\n+ 1 EndermanSlayerFeatures.kt\nat/hannibal2/skyhanni/features/slayer/enderman/EndermanSlayerFeatures\n*L\n106#1:256\n106#1:257,3\n204#1:268,2\n201#1:260\n201#1:261,6\n*E\n"})
public final class EndermanSlayerFeatures {
    @NotNull
    public static final EndermanSlayerFeatures INSTANCE = new EndermanSlayerFeatures();
    @NotNull
    private static final List<EntityEnderman> endermenWithBeacons = new ArrayList();
    @NotNull
    private static final Set<EntityArmorStand> flyingBeacons = new LinkedHashSet();
    @NotNull
    private static final Set<EntityArmorStand> nukekubiSkulls = new LinkedHashSet();
    @NotNull
    private static Map<LorenzVec, SimpleTimeMark> sittingBeacon = MapsKt.emptyMap();
    @NotNull
    private static final LorenzLogger logger = new LorenzLogger("slayer/enderman");
    @NotNull
    private static final Lazy NUKEKUBI_SKULL_TEXTURE$delegate = LazyKt.lazy(EndermanSlayerFeatures::NUKEKUBI_SKULL_TEXTURE_delegate$lambda$0);

    private EndermanSlayerFeatures() {
    }

    private final EndermanConfig getConfig() {
        return SlayerApi.INSTANCE.getConfig().getEndermen();
    }

    private final EndermanBeaconConfig getBeaconConfig() {
        return this.getConfig().getBeacon();
    }

    private final String getNUKEKUBI_SKULL_TEXTURE() {
        Lazy lazy = NUKEKUBI_SKULL_TEXTURE$delegate;
        return (String)lazy.getValue();
    }

    @HandleEvent(onlyOnIsland=IslandType.THE_END)
    public final void onCheckRender(@NotNull CheckRenderEntityEvent<Entity> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Entity entity = event.getEntity();
        if (CollectionsKt.contains((Iterable)endermenWithBeacons, entity) || CollectionsKt.contains((Iterable)flyingBeacons, entity)) {
            return;
        }
        if (entity instanceof EntityEnderman && this.showBeacon() && this.hasBeaconInHand((EntityEnderman)entity) && EntityUtils.canBeSeen$default(EntityUtils.INSTANCE, entity, 15.0, 0.0, true, 2, null)) {
            endermenWithBeacons.add((EntityEnderman)entity);
            logger.log("Added enderman with beacon at " + LorenzVecKt.getLorenzVec(entity));
        }
        if (entity instanceof EntityArmorStand) {
            if (this.showBeacon()) {
                ItemStack itemStack = EntityCompatKt.getStandHelmet((EntityArmorStand)entity);
                if (itemStack == null) {
                    return;
                }
                ItemStack stack = itemStack;
                if (Intrinsics.areEqual(stack.func_82833_r(), "Beacon") && EntityUtils.canBeSeen$default(EntityUtils.INSTANCE, entity, 15.0, 0.0, true, 2, null)) {
                    flyingBeacons.add((EntityArmorStand)entity);
                    RenderLivingEntityHelper.INSTANCE.setEntityColor((EntityLivingBase)entity, ColorUtils.INSTANCE.addAlpha(ColorUtils.INSTANCE.toColor(this.getBeaconConfig().getBeaconColor()), 1), EndermanSlayerFeatures::onCheckRender$lambda$1);
                    if (this.getBeaconConfig().getShowWarning()) {
                        TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, "\u00a74Beacon", null, DurationKt.toDuration(2, DurationUnit.SECONDS), null, null, null, 0.0, false, false, null, 0L, null, null, 0L, 16378, null);
                    }
                    logger.log("Added flying beacons at " + LorenzVecKt.getLorenzVec(entity));
                }
            }
            if (this.getConfig().getHighlightNukekebi() && EntityUtils.INSTANCE.hasSkullTexture((EntityArmorStand)entity, this.getNUKEKUBI_SKULL_TEXTURE()) && !nukekubiSkulls.contains(entity)) {
                nukekubiSkulls.add((EntityArmorStand)entity);
                RenderLivingEntityHelper.INSTANCE.setEntityColor((EntityLivingBase)entity, ColorUtils.INSTANCE.addAlpha(LorenzColor.GOLD.toColor(), 1), EndermanSlayerFeatures::onCheckRender$lambda$2);
                logger.log("Added Nukekubi skulls at " + LorenzVecKt.getLorenzVec(entity));
            }
        }
    }

    private final boolean hasBeaconInHand(EntityEnderman enderman) {
        IBlockState iBlockState = EntityUtils.INSTANCE.getBlockInHand(enderman);
        return Intrinsics.areEqual(iBlockState != null ? iBlockState.func_177230_c() : null, Blocks.field_150461_bJ);
    }

    private final boolean showBeacon() {
        return this.getBeaconConfig().getHighlightBeacon() || this.getBeaconConfig().getShowWarning() || this.getBeaconConfig().getShowLine();
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(onlyOnIsland=IslandType.THE_END)
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (this.getBeaconConfig().getHighlightBeacon()) {
            void $this$mapTo$iv$iv;
            endermenWithBeacons.removeIf(arg_0 -> EndermanSlayerFeatures.onRenderWorld$lambda$4(EndermanSlayerFeatures::onRenderWorld$lambda$3, arg_0));
            Iterable $this$map$iv = endermenWithBeacons;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                EntityEnderman entityEnderman = (EntityEnderman)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(LorenzVecKt.getLorenzVec((Entity)it).add(-0.5, 0.2, -0.5));
            }
            for (LorenzVec location : (List)destination$iv$iv) {
                WorldRenderUtils.drawColor$default(WorldRenderUtils.INSTANCE, event, location, this.getBeaconConfig().getBeaconColor(), false, 0.5f, false, 20, null);
            }
        }
        this.drawSittingBeacon(event);
        this.drawFlyingBeacon(event);
        this.drawNukekubiSkulls(event);
    }

    private final void drawNukekubiSkulls(SkyHanniRenderWorldEvent event) {
        for (EntityArmorStand skull : nukekubiSkulls) {
            if (skull.field_70128_L) continue;
            if (this.getConfig().getHighlightNukekebi()) {
                WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event, LorenzVecKt.getLorenzVec((Entity)skull).add(-0.5, 1.5, -0.5), "\u00a76Nukekubi Skull", 1.6, 0.0f, 0.0, 0.0, false, false, 20, 184, null);
            }
            if (!this.getConfig().getDrawLineToNukekebi()) continue;
            LorenzVec skullLocation = WorldRenderUtils.INSTANCE.exactLocation(event, (Entity)skull);
            if (!EntityUtils.canBeSeen$default(EntityUtils.INSTANCE, (Entity)skull, 20, 0.0, false, 6, null)) continue;
            WorldRenderUtils.INSTANCE.drawLineToEye(event, LorenzVec.up$default(skullLocation, null, 1, null), LorenzColor.toChromaColor$default(LorenzColor.GOLD, 0, 0, 3, null), 3, true);
        }
    }

    private final void drawFlyingBeacon(SkyHanniRenderWorldEvent event) {
        for (EntityArmorStand beacon : flyingBeacons) {
            LorenzVec beaconLocation;
            if (!EntityUtils.canBeSeen$default(EntityUtils.INSTANCE, (Entity)beacon, null, 0.0, true, 3, null)) continue;
            if (this.getBeaconConfig().getHighlightBeacon()) {
                beaconLocation = WorldRenderUtils.INSTANCE.exactLocation(event, (Entity)beacon);
                WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event, LorenzVec.add$default(beaconLocation, 0, 1, 0, 5, null), "\u00a74Beacon", 1.8, 0.0f, 0.0, 0.0, false, false, null, 504, null);
            }
            if (!this.getBeaconConfig().getShowLine()) continue;
            beaconLocation = WorldRenderUtils.INSTANCE.exactLocation(event, (Entity)beacon);
            WorldRenderUtils.INSTANCE.drawLineToEye(event, beaconLocation.add(0.5, 1.0, 0.5), this.getBeaconConfig().getLineColor(), this.getBeaconConfig().getLineWidth(), true);
        }
    }

    private final void drawSittingBeacon(SkyHanniRenderWorldEvent event) {
        for (Map.Entry<LorenzVec, SimpleTimeMark> entry : sittingBeacon.entrySet()) {
            LorenzVec location = entry.getKey();
            long time = entry.getValue().unbox-impl();
            if (LocationUtils.INSTANCE.distanceToPlayer(location) > 20.0) continue;
            if (this.getBeaconConfig().getShowLine()) {
                WorldRenderUtils.INSTANCE.drawLineToEye(event, location.add(0.5, 1.0, 0.5), this.getBeaconConfig().getLineColor(), this.getBeaconConfig().getLineWidth(), true);
            }
            if (!this.getBeaconConfig().getHighlightBeacon()) continue;
            long duration = Duration.minus-LRDsOJo(DurationKt.toDuration(5, DurationUnit.SECONDS), SimpleTimeMark.passedSince-UwyO8pc(time));
            String durationFormat = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, duration, null, true, false, 0, false, false, 61, null);
            WorldRenderUtils.drawColor$default(WorldRenderUtils.INSTANCE, event, location, this.getBeaconConfig().getBeaconColor(), false, 1.0f, false, 20, null);
            WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event, location, ColorUtils.INSTANCE.toColor(this.getBeaconConfig().getBeaconColor()), true, true, 0.0, 0.0, 0.0, 0.0f, false, 496, null);
            WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event, LorenzVec.add$default(location, 0, 1, 0, 5, null), "\u00a74Beacon \u00a7b" + durationFormat, 1.8, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(onlyOnIsland=IslandType.THE_END)
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(event, "event");
        CollectionsKt.removeAll((Iterable)nukekubiSkulls, EndermanSlayerFeatures::onSecondPassed$lambda$6);
        CollectionsKt.removeAll((Iterable)flyingBeacons, EndermanSlayerFeatures::onSecondPassed$lambda$7);
        Map<LorenzVec, SimpleTimeMark> $this$filter$iv = sittingBeacon;
        boolean $i$f$filter = false;
        Map<LorenzVec, SimpleTimeMark> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(((SimpleTimeMark)it.getValue()).unbox-impl()), DurationKt.toDuration(7, DurationUnit.SECONDS)) > 0)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map toRemove = destination$iv$iv;
        if (!toRemove.isEmpty()) {
            sittingBeacon = CollectionUtils.INSTANCE.editCopy(sittingBeacon, arg_0 -> EndermanSlayerFeatures.onSecondPassed$lambda$10(toRemove, arg_0));
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.THE_END)
    public final void onBlockChange(@NotNull ServerBlockChangeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.showBeacon()) {
            return;
        }
        LorenzVec location = event.getLocation();
        if (Intrinsics.areEqual(event.getNew(), "beacon")) {
            Object v0;
            block6: {
                Iterable iterable = flyingBeacons;
                for (Object t : iterable) {
                    EntityArmorStand it = (EntityArmorStand)t;
                    boolean bl = false;
                    if (!(location.distance(LorenzVecKt.getLorenzVec((Entity)it)) < 3.0)) continue;
                    v0 = t;
                    break block6;
                }
                v0 = null;
            }
            EntityArmorStand armorStand = v0;
            if (armorStand != null) {
                flyingBeacons.remove(armorStand);
                RenderLivingEntityHelper.INSTANCE.removeEntityColor((EntityLivingBase)armorStand);
                sittingBeacon = CollectionUtils.INSTANCE.editCopy(sittingBeacon, arg_0 -> EndermanSlayerFeatures.onBlockChange$lambda$12(location, arg_0));
                logger.log("Replaced flying beacon with sitting beacon at " + location);
            }
        } else if (sittingBeacon.containsKey(location)) {
            logger.log("Removed sitting beacon " + location);
            sittingBeacon = CollectionUtils.INSTANCE.editCopy(sittingBeacon, arg_0 -> EndermanSlayerFeatures.onBlockChange$lambda$13(location, arg_0));
        }
    }

    @HandleEvent
    public final void onWorldChange() {
        endermenWithBeacons.clear();
        flyingBeacons.clear();
        nukekubiSkulls.clear();
        sittingBeacon = MapsKt.emptyMap();
        logger.log("Reset everything (world change)");
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "slayer.endermanBeaconConfig.highlightBeacon", "slayer.endermen.endermanBeaconConfig.highlightBeacon", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "slayer.endermanBeaconConfig.beaconColor", "slayer.endermen.endermanBeaconConfig.beaconColor", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "slayer.endermanBeaconConfig.showWarning", "slayer.endermen.endermanBeaconConfig.showWarning", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "slayer.endermanBeaconConfig.showLine", "slayer.endermen.endermanBeaconConfig.showLine", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "slayer.endermanBeaconConfig.lneColor", "slayer.endermen.endermanBeaconConfig.lineColor", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "slayer.endermanBeaconConfig.lineWidth", "slayer.endermen.endermanBeaconConfig.lineWidth", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 3, "slayer.endermanHighlightNukekebi", "slayer.endermen.highlightNukekebi", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 9, "slayer.enderman.endermanBeaconConfig", "slayer.endermen.beacon", null, 8, null);
    }

    private static final String NUKEKUBI_SKULL_TEXTURE_delegate$lambda$0() {
        return SkullTextureHolder.INSTANCE.getTexture("MOB_NUKEKUBI");
    }

    private static final boolean onCheckRender$lambda$1() {
        return INSTANCE.getBeaconConfig().getHighlightBeacon();
    }

    private static final boolean onCheckRender$lambda$2() {
        return INSTANCE.getConfig().getHighlightNukekebi();
    }

    private static final boolean onRenderWorld$lambda$3(EntityEnderman it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.field_70128_L || !INSTANCE.hasBeaconInHand(it);
    }

    private static final boolean onRenderWorld$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean onSecondPassed$lambda$6(EntityArmorStand it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.field_70128_L) {
            RenderLivingEntityHelper.INSTANCE.removeEntityColor((EntityLivingBase)it);
        }
        return it.field_70128_L;
    }

    private static final boolean onSecondPassed$lambda$7(EntityArmorStand it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.field_70128_L) {
            RenderLivingEntityHelper.INSTANCE.removeEntityColor((EntityLivingBase)it);
        }
        return it.field_70128_L;
    }

    private static final Unit onSecondPassed$lambda$10(Map $toRemove, Map $this$editCopy) {
        Intrinsics.checkNotNullParameter($toRemove, "$toRemove");
        Intrinsics.checkNotNullParameter($this$editCopy, "$this$editCopy");
        Iterable $this$forEach$iv = $toRemove.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LorenzVec it = (LorenzVec)element$iv;
            boolean bl = false;
            $this$editCopy.remove(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onBlockChange$lambda$12(LorenzVec $location, Map $this$editCopy) {
        Intrinsics.checkNotNullParameter($location, "$location");
        Intrinsics.checkNotNullParameter($this$editCopy, "$this$editCopy");
        $this$editCopy.put($location, SimpleTimeMark.box-impl(SimpleTimeMark.Companion.now-uFjCsEo()));
        return Unit.INSTANCE;
    }

    private static final Unit onBlockChange$lambda$13(LorenzVec $location, Map $this$editCopy) {
        Intrinsics.checkNotNullParameter($location, "$location");
        Intrinsics.checkNotNullParameter($this$editCopy, "$this$editCopy");
        $this$editCopy.remove($location);
        return Unit.INSTANCE;
    }
}

