/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.brigadier.tree;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

public class ArgumentCommandNode<S, T>
extends CommandNode<S> {
    private static final String USAGE_ARGUMENT_OPEN = "<";
    private static final String USAGE_ARGUMENT_CLOSE = ">";
    private final String name;
    private final ArgumentType<T> type;
    private final SuggestionProvider<S> customSuggestions;

    public ArgumentCommandNode(String name2, ArgumentType<T> type2, Command<S> command2, Predicate<S> requirement, CommandNode<S> redirect, RedirectModifier<S> modifier, boolean forks, SuggestionProvider<S> customSuggestions) {
        super(command2, requirement, redirect, modifier, forks);
        this.name = name2;
        this.type = type2;
        this.customSuggestions = customSuggestions;
    }

    public ArgumentType<T> getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUsageText() {
        return USAGE_ARGUMENT_OPEN + this.name + USAGE_ARGUMENT_CLOSE;
    }

    public SuggestionProvider<S> getCustomSuggestions() {
        return this.customSuggestions;
    }

    @Override
    public void parse(StringReader reader, CommandContextBuilder<S> contextBuilder) throws CommandSyntaxException {
        int start2 = reader.getCursor();
        T result2 = this.type.parse(reader);
        ParsedArgument parsed = new ParsedArgument(start2, reader.getCursor(), result2);
        contextBuilder.withArgument(this.name, parsed);
        contextBuilder.withNode(this, parsed.getRange());
    }

    @Override
    public CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context2, SuggestionsBuilder builder) throws CommandSyntaxException {
        if (this.customSuggestions == null) {
            return this.type.listSuggestions(context2, builder);
        }
        return this.customSuggestions.getSuggestions(context2, builder);
    }

    @Override
    public RequiredArgumentBuilder<S, T> createBuilder() {
        RequiredArgumentBuilder builder = RequiredArgumentBuilder.argument(this.name, this.type);
        builder.requires(this.getRequirement());
        builder.forward(this.getRedirect(), this.getRedirectModifier(), this.isFork());
        builder.suggests(this.customSuggestions);
        if (this.getCommand() != null) {
            builder.executes(this.getCommand());
        }
        return builder;
    }

    @Override
    public boolean isValidInput(String input2) {
        try {
            StringReader reader = new StringReader(input2);
            this.type.parse(reader);
            return !reader.canRead() || reader.peek() == ' ';
        }
        catch (CommandSyntaxException ignored) {
            return false;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArgumentCommandNode)) {
            return false;
        }
        ArgumentCommandNode that = (ArgumentCommandNode)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = 31 * result2 + this.type.hashCode();
        return result2;
    }

    @Override
    protected String getSortedKey() {
        return this.name;
    }

    @Override
    public Collection<String> getExamples() {
        return this.type.getExamples();
    }

    public String toString() {
        return "<argument " + this.name + ":" + this.type + USAGE_ARGUMENT_CLOSE;
    }
}

