/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.debug.internal;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.AbstractMutableMap;
import kotlin.collections.AbstractMutableSet;
import kotlin.jvm.Volatile;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.debug.internal.ConcurrentWeakMap;
import kotlinx.coroutines.debug.internal.ConcurrentWeakMapKt;
import kotlinx.coroutines.debug.internal.HashedWeakRef;
import kotlinx.coroutines.debug.internal.Marked;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\b\b\u0001\u0010\u0003*\u00020\u00012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004:\u0003,-.B\u0011\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\f\u001a\u00020\u000b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u001a\u0010\u0012\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0011\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J!\u0010\u0015\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u0017\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0011\u001a\u00028\u00002\b\u0010\u0014\u001a\u0004\u0018\u00018\u0001H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u0019\u0010\u0018\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0013J\r\u0010\u0019\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0019\u0010\u000fR\u000b\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004R!\u0010\u001e\u001a\u0018\u0012\u0014\u0012\u00120\u001dR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00000\u001c8\u0002X\u0082\u0004R&\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010 0\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"R\u0014\u0010)\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u001c\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010+\u00a8\u0006/"}, d2={"Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap;", "", "K", "V", "Lkotlin/collections/AbstractMutableMap;", "", "weakRefQueue", "<init>", "(Z)V", "Lkotlinx/coroutines/debug/internal/HashedWeakRef;", "w", "", "cleanWeakRef", "(Lkotlinx/coroutines/debug/internal/HashedWeakRef;)V", "clear", "()V", "decrementSize", "key", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "value", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "putSynchronized", "remove", "runWeakRefQueueCleaningLoopUntilInterrupted", "Lkotlinx/atomicfu/AtomicInt;", "_size", "Lkotlinx/atomicfu/AtomicRef;", "Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$Core;", "core", "", "", "getEntries", "()Ljava/util/Set;", "entries", "getKeys", "keys", "", "getSize", "()I", "size", "Ljava/lang/ref/ReferenceQueue;", "Ljava/lang/ref/ReferenceQueue;", "Core", "Entry", "KeyValueSet", "kotlinx-coroutines-core"})
@SourceDebugExtension(value={"SMAP\nConcurrentWeakMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcurrentWeakMap.kt\nkotlinx/coroutines/debug/internal/ConcurrentWeakMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,284:1\n1#2:285\n*E\n"})
public final class ConcurrentWeakMap<K, V>
extends AbstractMutableMap<K, V> {
    @Volatile
    private volatile int _size;
    @Volatile
    @Nullable
    private volatile Object core;
    @Nullable
    private final ReferenceQueue<K> weakRefQueue;
    @NotNull
    private static final AtomicIntegerFieldUpdater _size$FU = AtomicIntegerFieldUpdater.newUpdater(ConcurrentWeakMap.class, "_size");
    @NotNull
    private static final AtomicReferenceFieldUpdater core$FU = AtomicReferenceFieldUpdater.newUpdater(ConcurrentWeakMap.class, Object.class, "core");

    public ConcurrentWeakMap(boolean weakRefQueue) {
        this.core = new Core(16);
        this.weakRefQueue = weakRefQueue ? new ReferenceQueue() : null;
    }

    public /* synthetic */ ConcurrentWeakMap(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @Override
    public int getSize() {
        return _size$FU.get(this);
    }

    private final void decrementSize() {
        _size$FU.decrementAndGet(this);
    }

    @Override
    @Nullable
    public V get(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        return ((Core)core$FU.get(this)).getImpl(key);
    }

    @Override
    @Nullable
    public V put(@NotNull K key, @NotNull V value) {
        Object oldValue = Core.putImpl$default((Core)core$FU.get(this), key, value, null, 4, null);
        if (oldValue == ConcurrentWeakMapKt.access$getREHASH$p()) {
            oldValue = this.putSynchronized(key, value);
        }
        if (oldValue == null) {
            _size$FU.incrementAndGet(this);
        }
        return (V)oldValue;
    }

    @Override
    @Nullable
    public V remove(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        Object oldValue = Core.putImpl$default((Core)core$FU.get(this), key, null, null, 4, null);
        if (oldValue == ConcurrentWeakMapKt.access$getREHASH$p()) {
            oldValue = this.putSynchronized(key, null);
        }
        if (oldValue != null) {
            _size$FU.decrementAndGet(this);
        }
        return (V)oldValue;
    }

    private final synchronized V putSynchronized(K key, V value) {
        Core curCore = (Core)core$FU.get(this);
        Object oldValue;
        while ((oldValue = Core.putImpl$default(curCore, key, value, null, 4, null)) == ConcurrentWeakMapKt.access$getREHASH$p()) {
            curCore = curCore.rehash();
            core$FU.set(this, curCore);
        }
        return (V)oldValue;
    }

    @Override
    @NotNull
    public Set<K> getKeys() {
        return new KeyValueSet(keys.1.INSTANCE);
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        return new KeyValueSet(entries.1.INSTANCE);
    }

    @Override
    public void clear() {
        for (Object k : this.keySet()) {
            this.remove(k);
        }
    }

    public final void runWeakRefQueueCleaningLoopUntilInterrupted() {
        if (!(this.weakRefQueue != null)) {
            boolean bl = false;
            String string = "Must be created with weakRefQueue = true";
            throw new IllegalStateException(string.toString());
        }
        try {
            while (true) {
                Reference<K> reference = this.weakRefQueue.remove();
                Intrinsics.checkNotNull(reference, "null cannot be cast to non-null type kotlinx.coroutines.debug.internal.HashedWeakRef<*>");
                this.cleanWeakRef((HashedWeakRef)reference);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private final void cleanWeakRef(HashedWeakRef<?> w) {
        ((Core)core$FU.get(this)).cleanWeakRef(w);
    }

    public ConcurrentWeakMap() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\t\u001a\u00020\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000b\u001a\u00028\u0000\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J3\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00020\u0014\"\u0004\b\u0002\u0010\u00112\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J3\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00028\u00002\b\u0010\u0017\u001a\u0004\u0018\u00018\u00012\u0010\b\u0002\u0010\u0018\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001c\u001a\u00120\u0000R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010 R\u0019\u0010\"\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00060!8\u0002X\u0082\u0004R\u000b\u0010$\u001a\u00020#8\u0002X\u0082\u0004R\u0014\u0010%\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010 R\u0014\u0010&\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010 R\u0013\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010!8\u0002X\u0082\u0004\u00a8\u0006)"}, d2={"Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$Core;", "", "", "allocated", "<init>", "(Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap;I)V", "Lkotlinx/coroutines/debug/internal/HashedWeakRef;", "weakRef", "", "cleanWeakRef", "(Lkotlinx/coroutines/debug/internal/HashedWeakRef;)V", "key", "getImpl", "(Ljava/lang/Object;)Ljava/lang/Object;", "hash", "index", "(I)I", "E", "Lkotlin/Function2;", "factory", "", "keyValueIterator", "(Lkotlin/jvm/functions/Function2;)Ljava/util/Iterator;", "value", "weakKey0", "putImpl", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlinx/coroutines/debug/internal/HashedWeakRef;)Ljava/lang/Object;", "Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap;", "rehash", "()Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$Core;", "removeCleanedAt", "(I)V", "I", "Lkotlinx/atomicfu/AtomicArray;", "keys", "Lkotlinx/atomicfu/AtomicInt;", "load", "shift", "threshold", "values", "KeyValueIterator", "kotlinx-coroutines-core"})
    private final class Core {
        private final int allocated;
        private final int shift;
        private final int threshold;
        @Volatile
        private volatile int load;
        @NotNull
        private final AtomicReferenceArray keys;
        @NotNull
        private final AtomicReferenceArray values;
        @NotNull
        private static final AtomicIntegerFieldUpdater load$FU = AtomicIntegerFieldUpdater.newUpdater(Core.class, "load");

        public Core(int allocated) {
            this.allocated = allocated;
            this.shift = Integer.numberOfLeadingZeros(this.allocated) + 1;
            this.threshold = 2 * this.allocated / 3;
            this.keys = new AtomicReferenceArray(this.allocated);
            this.values = new AtomicReferenceArray(this.allocated);
        }

        private final int index(int hash) {
            return hash * -1640531527 >>> this.shift;
        }

        @Nullable
        public final V getImpl(@NotNull K key) {
            int index = this.index(key.hashCode());
            while ((HashedWeakRef)this.keys.get(index) != null) {
                HashedWeakRef w;
                Object k = w.get();
                if (Intrinsics.areEqual(key, k)) {
                    Object value = this.values.get(index);
                    return value instanceof Marked ? ((Marked)value).ref : value;
                }
                if (k == null) {
                    this.removeCleanedAt(index);
                }
                if (index == 0) {
                    index = this.allocated;
                }
                --index;
            }
            return null;
        }

        private final void removeCleanedAt(int index) {
            Object oldValue;
            do {
                if (this.values.get(index) == null) {
                    return;
                }
                if (!(oldValue instanceof Marked)) continue;
                return;
            } while (!this.values.compareAndSet(index, oldValue, null));
            ConcurrentWeakMap.this.decrementSize();
        }

        @Nullable
        public final Object putImpl(@NotNull K key, @Nullable V value, @Nullable HashedWeakRef<K> weakKey0) {
            int index = this.index(key.hashCode());
            boolean loadIncremented = false;
            HashedWeakRef weakKey = weakKey0;
            while (true) {
                HashedWeakRef w;
                if ((w = (HashedWeakRef)this.keys.get(index)) == null) {
                    if (value == null) {
                        return null;
                    }
                    if (!loadIncremented) {
                        int n;
                        int n2;
                        int n3;
                        Core core = this;
                        AtomicIntegerFieldUpdater atomicfu$handler$iv = load$FU;
                        boolean $i$f$update$atomicfu = false;
                        do {
                            n = n3 = atomicfu$handler$iv.get(this);
                            boolean bl = false;
                            if (n < this.threshold) continue;
                            return ConcurrentWeakMapKt.access$getREHASH$p();
                        } while (!atomicfu$handler$iv.compareAndSet(this, n3, n2 = n + 1));
                        loadIncremented = true;
                    }
                    if (weakKey == null) {
                        weakKey = new HashedWeakRef(key, ConcurrentWeakMap.this.weakRefQueue);
                    }
                    if (this.keys.compareAndSet(index, null, weakKey)) break;
                    continue;
                }
                Object k = w.get();
                if (Intrinsics.areEqual(key, k)) {
                    if (!loadIncremented) break;
                    load$FU.decrementAndGet(this);
                    break;
                }
                if (k == null) {
                    this.removeCleanedAt(index);
                }
                if (index == 0) {
                    index = this.allocated;
                }
                --index;
            }
            Object oldValue = null;
            do {
                if (!((oldValue = (Object)this.values.get(index)) instanceof Marked)) continue;
                return ConcurrentWeakMapKt.access$getREHASH$p();
            } while (!this.values.compareAndSet(index, oldValue, value));
            return oldValue;
        }

        public static /* synthetic */ Object putImpl$default(Core core, Object object, Object object2, HashedWeakRef hashedWeakRef, int n, Object object3) {
            if ((n & 4) != 0) {
                hashedWeakRef = null;
            }
            return core.putImpl(object, object2, hashedWeakRef);
        }

        @NotNull
        public final Core rehash() {
            Core newCore;
            block0: while (true) {
                int newCapacity = Integer.highestOneBit(RangesKt.coerceAtLeast(ConcurrentWeakMap.this.size(), 4)) * 4;
                newCore = new Core(newCapacity);
                int n = this.allocated;
                for (int index = 0; index < n; ++index) {
                    boolean bl;
                    Object k;
                    HashedWeakRef w;
                    HashedWeakRef hashedWeakRef = w = (HashedWeakRef)this.keys.get(index);
                    Object object = k = hashedWeakRef != null ? hashedWeakRef.get() : null;
                    if (w != null && k == null) {
                        this.removeCleanedAt(index);
                    }
                    Object value = null;
                    do {
                        if (!((value = (Object)this.values.get(index)) instanceof Marked)) continue;
                        value = ((Marked)value).ref;
                        break;
                    } while (!this.values.compareAndSet(index, value, ConcurrentWeakMapKt.access$mark(value)));
                    if (k == null || value == null) continue;
                    Object oldValue = newCore.putImpl(k, value, w);
                    if (oldValue == ConcurrentWeakMapKt.access$getREHASH$p()) continue block0;
                    boolean bl2 = bl = oldValue == null;
                    if (!_Assertions.ENABLED || bl) continue;
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                break;
            }
            return newCore;
        }

        public final void cleanWeakRef(@NotNull HashedWeakRef<?> weakRef) {
            int index = this.index(weakRef.hash);
            while ((HashedWeakRef)this.keys.get(index) != null) {
                HashedWeakRef w;
                if (w == weakRef) {
                    this.removeCleanedAt(index);
                    return;
                }
                if (index == 0) {
                    index = this.allocated;
                }
                --index;
            }
            return;
        }

        @NotNull
        public final <E> Iterator<E> keyValueIterator(@NotNull Function2<? super K, ? super V, ? extends E> factory) {
            return new KeyValueIterator<E>(factory);
        }

        private final void update$atomicfu(AtomicIntegerFieldUpdater atomicfu$handler, Function1<? super Integer, Integer> atomicfu$action, Object atomicfu$dispatchReceiver) {
            Integer n;
            int n2;
            boolean $i$f$update$atomicfu = false;
            while (!atomicfu$handler.compareAndSet(atomicfu$dispatchReceiver, n2 = atomicfu$handler.get(atomicfu$dispatchReceiver), ((Number)(n = atomicfu$action.invoke((Integer)n2))).intValue())) {
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0082\u0004\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u00028\u00020\u0002B!\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000b\u001a\u00020\nH\u0096\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R&\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0012R\u0016\u0010\u0014\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u00028\u00008\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00028\u00018\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$Core$KeyValueIterator;", "E", "", "Lkotlin/Function2;", "factory", "<init>", "(Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$Core;Lkotlin/jvm/functions/Function2;)V", "", "findNext", "()V", "", "hasNext", "()Z", "next", "()Ljava/lang/Object;", "", "remove", "()Ljava/lang/Void;", "Lkotlin/jvm/functions/Function2;", "", "index", "I", "key", "Ljava/lang/Object;", "value", "kotlinx-coroutines-core"})
        @SourceDebugExtension(value={"SMAP\nConcurrentWeakMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcurrentWeakMap.kt\nkotlinx/coroutines/debug/internal/ConcurrentWeakMap$Core$KeyValueIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,284:1\n1#2:285\n*E\n"})
        private final class KeyValueIterator<E>
        implements Iterator<E>,
        KMutableIterator {
            @NotNull
            private final Function2<K, V, E> factory;
            private int index;
            private K key;
            private V value;

            public KeyValueIterator(Function2<? super K, ? super V, ? extends E> factory) {
                this.factory = factory;
                this.index = -1;
                this.findNext();
            }

            private final void findNext() {
                block2: {
                    Object value;
                    while (true) {
                        ++this.index;
                        if (this.index >= Core.this.allocated) break block2;
                        HashedWeakRef hashedWeakRef = (HashedWeakRef)Core.this.keys.get(this.index);
                        if (hashedWeakRef == null || (hashedWeakRef = hashedWeakRef.get()) == null) continue;
                        this.key = hashedWeakRef;
                        value = Core.this.values.get(this.index);
                        if (value instanceof Marked) {
                            value = ((Marked)value).ref;
                        }
                        if (value != null) break;
                    }
                    this.value = value;
                    return;
                }
            }

            @Override
            public boolean hasNext() {
                return this.index < Core.this.allocated;
            }

            @Override
            public E next() {
                E e;
                Object object;
                if (this.index >= Core.this.allocated) {
                    throw new NoSuchElementException();
                }
                Object object2 = this.key;
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("key");
                    object2 = Unit.INSTANCE;
                }
                if ((object = this.value) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("value");
                    object = Unit.INSTANCE;
                }
                E it = e = this.factory.invoke(object2, object);
                boolean bl = false;
                this.findNext();
                return e;
            }

            @NotNull
            public Void remove() {
                ConcurrentWeakMapKt.access$noImpl();
                throw new KotlinNothingValueException();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010'\n\u0002\b\f\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u0012\u0006\u0010\u0005\u001a\u00028\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\t\u001a\u00028\u00032\u0006\u0010\b\u001a\u00028\u0003H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00028\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u00028\u00038\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u000f"}, d2={"Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$Entry;", "K", "V", "", "key", "value", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;)V", "newValue", "setValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "Ljava/lang/Object;", "getKey", "()Ljava/lang/Object;", "getValue", "kotlinx-coroutines-core"})
    private static final class Entry<K, V>
    implements Map.Entry<K, V>,
    KMutableMap.Entry {
        private final K key;
        private final V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            ConcurrentWeakMapKt.access$noImpl();
            throw new KotlinNothingValueException();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010)\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u00028\u00020\u0002B!\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00028\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00020\u000bH\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rR&\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap$KeyValueSet;", "E", "Lkotlin/collections/AbstractMutableSet;", "Lkotlin/Function2;", "factory", "<init>", "(Lkotlinx/coroutines/debug/internal/ConcurrentWeakMap;Lkotlin/jvm/functions/Function2;)V", "element", "", "add", "(Ljava/lang/Object;)Z", "", "iterator", "()Ljava/util/Iterator;", "Lkotlin/jvm/functions/Function2;", "", "getSize", "()I", "size", "kotlinx-coroutines-core"})
    private final class KeyValueSet<E>
    extends AbstractMutableSet<E> {
        @NotNull
        private final Function2<K, V, E> factory;

        public KeyValueSet(Function2<? super K, ? super V, ? extends E> factory) {
            this.factory = factory;
        }

        @Override
        public int getSize() {
            return ConcurrentWeakMap.this.size();
        }

        @Override
        public boolean add(E element) {
            ConcurrentWeakMapKt.access$noImpl();
            throw new KotlinNothingValueException();
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            return ((Core)core$FU.get(ConcurrentWeakMap.this)).keyValueIterator(this.factory);
        }
    }
}

