/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data.hotx;

import at.hannibal2.skyhanni.data.hotx.HotmData;
import at.hannibal2.skyhanni.data.hotx.HotxData;
import at.hannibal2.skyhanni.data.hotx.HotxHandler;
import at.hannibal2.skyhanni.events.minecraft.ToolTipEvent;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u0000*\u0014\b\u0000\u0010\u0002*\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00012\u00020\u0003:\u0001!B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ5\u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J#\u0010\u0016\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\t2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0018\u001a\u0004\u0018\u00010\u00052\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0014H&\u00a2\u0006\u0004\b\u0018\u0010\u0019J#\u0010\u001a\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\t2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0017J#\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000f2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0004\u001a\u00028\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001fR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010 \u00a8\u0006\""}, d2={"Lat/hannibal2/skyhanni/data/hotx/CurrencyPerHotxPerk;", "Lat/hannibal2/skyhanni/data/hotx/HotxHandler;", "HotxType", "", "hotx", "", "displayText", "<init>", "(Lat/hannibal2/skyhanni/data/hotx/HotxHandler;Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;", "event", "", "showWhispersSpent", "showCurrencyFor10Levels", "showCurrentCurrency", "Lat/hannibal2/skyhanni/data/hotx/CurrencyPerHotxPerk$CurrencySpentDesign;", "currencySpentDesign", "", "handleHotxCurrency", "(Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;ZZZLat/hannibal2/skyhanni/data/hotx/CurrencyPerHotxPerk$CurrencySpentDesign;)V", "Lat/hannibal2/skyhanni/data/hotx/HotxData;", "perk", "handleCurrentCurrency", "(Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;Lat/hannibal2/skyhanni/data/hotx/HotxData;)V", "currentCurrencyLineString", "(Lat/hannibal2/skyhanni/data/hotx/HotxData;)Ljava/lang/String;", "handleCurrencyFor10Levels", "handleCurrencySpent", "(Lat/hannibal2/skyhanni/data/hotx/CurrencyPerHotxPerk$CurrencySpentDesign;Lat/hannibal2/skyhanni/data/hotx/HotxData;)Ljava/lang/String;", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/data/hotx/HotxHandler;", "Ljava/lang/String;", "CurrencySpentDesign", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nCurrencyPerHotxPerk.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurrencyPerHotxPerk.kt\nat/hannibal2/skyhanni/data/hotx/CurrencyPerHotxPerk\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n360#2,7:88\n360#2,7:95\n*S KotlinDebug\n*F\n+ 1 CurrencyPerHotxPerk.kt\nat/hannibal2/skyhanni/data/hotx/CurrencyPerHotxPerk\n*L\n33#1:88,7\n44#1:95,7\n*E\n"})
public abstract class CurrencyPerHotxPerk<HotxType extends HotxHandler<?, ?, ?>> {
    @NotNull
    private final HotxType hotx;
    @NotNull
    private final String displayText;

    public CurrencyPerHotxPerk(@NotNull HotxType hotx, @NotNull String displayText) {
        Intrinsics.checkNotNullParameter(hotx, (String)"hotx");
        Intrinsics.checkNotNullParameter((Object)displayText, (String)"displayText");
        this.hotx = hotx;
        this.displayText = displayText;
    }

    public final void handleHotxCurrency(@NotNull ToolTipEvent event, boolean showWhispersSpent, boolean showCurrencyFor10Levels, boolean showCurrentCurrency, @NotNull CurrencySpentDesign currencySpentDesign) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)((Object)currencySpentDesign), (String)"currencySpentDesign");
        String itemName2 = TextCompatKt.formattedTextCompatLeadingWhiteLessResets(event.getItemStack().method_7964());
        Object Data2 = ((HotxHandler)this.hotx).getPerkByNameOrNull(StringUtils.removeColor$default(StringUtils.INSTANCE, itemName2, false, 1, null));
        if (Data2 == null) {
            return;
        }
        Object perk = Data2;
        if (perk.getLevelUpCost() == null) {
            return;
        }
        if (showWhispersSpent) {
            event.getToolTip().add(2, this.handleCurrencySpent(currencySpentDesign, (HotxData<?>)perk));
        }
        if (showCurrencyFor10Levels) {
            this.handleCurrencyFor10Levels(event, (HotxData<?>)perk);
        }
        if (showCurrentCurrency) {
            this.handleCurrentCurrency(event, (HotxData<?>)perk);
        }
    }

    private final void handleCurrentCurrency(ToolTipEvent event, HotxData<?> perk) {
        int n;
        block4: {
            if (!perk.isUnlocked() || perk.isMaxLevel()) {
                return;
            }
            List<String> $this$indexOfFirst$iv = event.getToolTip();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<String> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                String item$iv;
                String it = item$iv = iterator2.next();
                boolean bl = false;
                if (RegexUtils.INSTANCE.matches(HotmData.Companion.getPerkCostPattern(), it)) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = -1;
        }
        int indexOfCost = n;
        String string = this.currentCurrencyLineString(perk);
        if (string == null) {
            return;
        }
        String currentCurrencyLine = string;
        event.getToolTip().add(indexOfCost + 2, " ");
        event.getToolTip().add(indexOfCost + 3, "You have");
        event.getToolTip().add(indexOfCost + 4, currentCurrencyLine);
    }

    @Nullable
    public abstract String currentCurrencyLineString(@NotNull HotxData<?> var1);

    private final void handleCurrencyFor10Levels(ToolTipEvent event, HotxData<?> perk) {
        int indexOfCost;
        block4: {
            int n;
            if (!KeyboardManager.INSTANCE.isKeyHeld(340)) {
                return;
            }
            List<String> $this$indexOfFirst$iv = event.getToolTip();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<String> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                String item$iv;
                String it = item$iv = iterator2.next();
                boolean bl = false;
                if (RegexUtils.INSTANCE.matches(HotmData.Companion.getPerkCostPattern(), it)) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = indexOfCost = -1;
        }
        if (indexOfCost == -1) {
            return;
        }
        int currencyFor10Levels = perk.calculateTotalCost(RangesKt.coerceAtMost((int)(perk.getRawLevel() + 10), (int)perk.getMaxLevel())) - perk.calculateTotalCost(perk.getRawLevel());
        int numberOfLevels = RangesKt.coerceAtMost((int)(perk.getMaxLevel() - perk.getRawLevel()), (int)10);
        String levelsFormat = StringUtils.pluralize$default(StringUtils.INSTANCE, numberOfLevels, "level", null, false, 12, null);
        event.getToolTip().add(indexOfCost + 2, "\u00a77" + this.displayText + " for " + numberOfLevels + " " + levelsFormat + " \u00a7e" + NumberUtil.INSTANCE.addSeparators(currencyFor10Levels));
    }

    private final String handleCurrencySpent(CurrencySpentDesign currencySpentDesign, HotxData<?> perk) {
        String string;
        block11: {
            String label;
            double percentage;
            int maxCurrencyNeeded;
            int currentAmountSpent;
            block10: {
                currentAmountSpent = perk.calculateTotalCost(perk.getRawLevel());
                maxCurrencyNeeded = perk.getTotalCostMaxLevel();
                percentage = NumberUtil.INSTANCE.roundTo((double)currentAmountSpent * 100.0 / (double)maxCurrencyNeeded, 2);
                boolean isMaxLevel = perk.getRawLevel() == perk.getMaxLevel();
                label = "\u00a77" + this.displayText + " spent:";
                if (!isMaxLevel) break block10;
                switch (WhenMappings.$EnumSwitchMapping$0[currencySpentDesign.ordinal()]) {
                    case 1: {
                        string = label + " \u00a7e" + NumberUtil.INSTANCE.addSeparators(maxCurrencyNeeded) + " \u00a77(\u00a7aMax level\u00a77)";
                        break block11;
                    }
                    case 2: {
                        string = label + " \u00a7e" + percentage + "% \u00a77(\u00a7aMax level\u00a77)";
                        break block11;
                    }
                    case 3: {
                        string = label + " \u00a7e" + NumberUtil.INSTANCE.addSeparators(maxCurrencyNeeded) + " \u00a77(\u00a7aMax level\u00a77)";
                        break block11;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$0[currencySpentDesign.ordinal()]) {
                case 1: {
                    string = label + " \u00a7e" + NumberUtil.INSTANCE.addSeparators(currentAmountSpent) + "\u00a77 / \u00a7e" + NumberUtil.INSTANCE.addSeparators(maxCurrencyNeeded);
                    break;
                }
                case 2: {
                    string = label + " \u00a7e" + percentage + "%\u00a77 of max";
                    break;
                }
                case 3: {
                    string = label + " \u00a7e" + NumberUtil.INSTANCE.addSeparators(currentAmountSpent) + "\u00a77/\u00a7e" + NumberUtil.INSTANCE.addSeparators(maxCurrencyNeeded) + "\u00a77 (\u00a7e" + percentage + "%\u00a77)";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return string;
    }

    public boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && ((HotxHandler)this.hotx).getInInventory();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\u0007j\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lat/hannibal2/skyhanni/data/hotx/CurrencyPerHotxPerk$CurrencySpentDesign;", "", "", "display", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getDisplay", "NUMBER", "PERCENTAGE", "NUMBER_AND_PERCENTAGE", "1.21.5"})
    public static final class CurrencySpentDesign
    extends Enum<CurrencySpentDesign> {
        @NotNull
        private final String display;
        public static final /* enum */ CurrencySpentDesign NUMBER = new CurrencySpentDesign("Number");
        public static final /* enum */ CurrencySpentDesign PERCENTAGE = new CurrencySpentDesign("Percentage");
        public static final /* enum */ CurrencySpentDesign NUMBER_AND_PERCENTAGE = new CurrencySpentDesign("Number and Percentage");
        private static final /* synthetic */ CurrencySpentDesign[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private CurrencySpentDesign(String display) {
            this.display = display;
        }

        @NotNull
        public final String getDisplay() {
            return this.display;
        }

        @NotNull
        public String toString() {
            return this.display;
        }

        public static CurrencySpentDesign[] values() {
            return (CurrencySpentDesign[])$VALUES.clone();
        }

        public static CurrencySpentDesign valueOf(String value) {
            return Enum.valueOf(CurrencySpentDesign.class, value);
        }

        @NotNull
        public static EnumEntries<CurrencySpentDesign> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = currencySpentDesignArray = new CurrencySpentDesign[]{CurrencySpentDesign.NUMBER, CurrencySpentDesign.PERCENTAGE, CurrencySpentDesign.NUMBER_AND_PERCENTAGE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CurrencySpentDesign.values().length];
            try {
                nArray[CurrencySpentDesign.NUMBER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CurrencySpentDesign.PERCENTAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CurrencySpentDesign.NUMBER_AND_PERCENTAGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

