/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net.nntp;

import at.hannibal2.skyhanni.deps.commons.net.io.DotTerminatedMessageReader;
import at.hannibal2.skyhanni.deps.commons.net.io.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class ReplyIterator
implements Iterator<String>,
Iterable<String> {
    private final BufferedReader reader;
    private String line;
    private Exception savedException;

    ReplyIterator(BufferedReader _reader) throws IOException {
        this(_reader, true);
    }

    ReplyIterator(BufferedReader _reader, boolean addDotReader) throws IOException {
        this.reader = addDotReader ? new DotTerminatedMessageReader(_reader) : _reader;
        this.line = this.reader.readLine();
        if (this.line == null) {
            Util.closeQuietly(this.reader);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.savedException != null) {
            throw new NoSuchElementException(this.savedException.toString());
        }
        return this.line != null;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public String next() throws NoSuchElementException {
        if (this.savedException != null) {
            throw new NoSuchElementException(this.savedException.toString());
        }
        String prev = this.line;
        if (prev == null) {
            throw new NoSuchElementException();
        }
        try {
            this.line = this.reader.readLine();
            if (this.line == null) {
                Util.closeQuietly(this.reader);
            }
        }
        catch (IOException ex) {
            this.savedException = ex;
            Util.closeQuietly(this.reader);
        }
        return prev;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

