/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.libautoupdate;

import at.hannibal2.skyhanni.deps.libautoupdate.CurrentVersion;
import at.hannibal2.skyhanni.deps.libautoupdate.PotentialUpdate;
import at.hannibal2.skyhanni.deps.libautoupdate.UpdateData;
import at.hannibal2.skyhanni.deps.libautoupdate.UpdateSource;
import at.hannibal2.skyhanni.deps.libautoupdate.UpdateTarget;
import at.hannibal2.skyhanni.deps.libautoupdate.UpdateUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public final class UpdateContext {
    @NonNull
    private final UpdateSource source;
    @NonNull
    private final UpdateTarget target;
    @NonNull
    private final CurrentVersion currentVersion;
    @NonNull
    private final String identifier;

    public void cleanup() {
        File file = new File(".autoupdates", this.identifier).getAbsoluteFile();
        try {
            UpdateUtils.deleteDirectory(file.toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CompletableFuture<PotentialUpdate> checkUpdate(String updateStream) {
        return this.source.checkUpdate(updateStream).thenApply(it -> new PotentialUpdate((UpdateData)it, this));
    }

    public UpdateContext(@NonNull UpdateSource source, @NonNull UpdateTarget target, @NonNull CurrentVersion currentVersion, @NonNull String identifier) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (currentVersion == null) {
            throw new NullPointerException("currentVersion is marked non-null but is null");
        }
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        this.source = source;
        this.target = target;
        this.currentVersion = currentVersion;
        this.identifier = identifier;
    }

    @NonNull
    public UpdateSource getSource() {
        return this.source;
    }

    @NonNull
    public UpdateTarget getTarget() {
        return this.target;
    }

    @NonNull
    public CurrentVersion getCurrentVersion() {
        return this.currentVersion;
    }

    @NonNull
    public String getIdentifier() {
        return this.identifier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateContext)) {
            return false;
        }
        UpdateContext other = (UpdateContext)o;
        UpdateSource this$source = this.getSource();
        UpdateSource other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        UpdateTarget this$target = this.getTarget();
        UpdateTarget other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        CurrentVersion this$currentVersion = this.getCurrentVersion();
        CurrentVersion other$currentVersion = other.getCurrentVersion();
        if (this$currentVersion == null ? other$currentVersion != null : !this$currentVersion.equals(other$currentVersion)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        return !(this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        UpdateSource $source = this.getSource();
        result2 = result2 * 59 + ($source == null ? 43 : $source.hashCode());
        UpdateTarget $target = this.getTarget();
        result2 = result2 * 59 + ($target == null ? 43 : $target.hashCode());
        CurrentVersion $currentVersion = this.getCurrentVersion();
        result2 = result2 * 59 + ($currentVersion == null ? 43 : $currentVersion.hashCode());
        String $identifier = this.getIdentifier();
        result2 = result2 * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        return result2;
    }

    public String toString() {
        return "UpdateContext(source=" + this.getSource() + ", target=" + this.getTarget() + ", currentVersion=" + this.getCurrentVersion() + ", identifier=" + this.getIdentifier() + ")";
    }
}

