/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui.editors;

import at.hannibal2.skyhanni.deps.moulconfig.GuiTextures;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorKeybind;
import at.hannibal2.skyhanni.deps.moulconfig.common.IMinecraft;
import at.hannibal2.skyhanni.deps.moulconfig.common.KeyboardConstants;
import at.hannibal2.skyhanni.deps.moulconfig.common.RenderContext;
import at.hannibal2.skyhanni.deps.moulconfig.common.text.StructuredText;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiComponent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiImmediateContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.KeyboardEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.MouseEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.editors.ComponentEditor;
import at.hannibal2.skyhanni.deps.moulconfig.internal.Warnings;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ProcessedOption;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class GuiOptionEditorKeybind
extends ComponentEditor {
    private boolean editingKeycode = false;
    GuiComponent component;

    public GuiOptionEditorKeybind(final ProcessedOption option, final int defaultKeyCode) {
        super(option);
        if (option.getType() != Integer.TYPE && option.getType() != Integer.class) {
            Warnings.warn(ConfigEditorKeybind.class + " can only be applied to int properties.");
        }
        this.component = this.wrapComponent(new GuiComponent(){

            @Override
            public int getWidth() {
                return 0;
            }

            @Override
            public int getHeight() {
                return 30;
            }

            @Override
            public void render(@NotNull GuiImmediateContext context2) {
                int height = this.getHeight();
                RenderContext renderContext = context2.getRenderContext();
                int width = this.getWidth();
                renderContext.drawTexturedRect(GuiTextures.BUTTON, width / 6 - 24, height - 7 - 14, 48.0f, 16.0f);
                StructuredText keyName = IMinecraft.INSTANCE.getKeyName((Integer)option.get());
                StructuredText text = GuiOptionEditorKeybind.this.editingKeycode ? StructuredText.of("> ").append(keyName).append(" <") : keyName;
                renderContext.drawStringCenteredScaledMaxWidth(text, IMinecraft.INSTANCE.getDefaultFontRenderer(), width / 6, height - 7 - 6, false, 38, -13619152);
                int resetX = width / 6 - 24 + 48 + 3;
                int resetY = height - 7 - 14 + 3;
                renderContext.drawTexturedRect(GuiTextures.RESET, resetX, resetY, 10.0f, 11.0f);
                int mouseX = context2.getMouseX();
                int mouseY = context2.getMouseY();
                if (mouseX >= resetX && mouseX < resetX + 10 && mouseY >= resetY && mouseY < resetY + 11) {
                    renderContext.scheduleDrawTooltip(context2.getMouseX(), context2.getMouseY(), Collections.singletonList(StructuredText.of("Reset to Default").red()));
                }
            }

            @Override
            public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context2) {
                if (!(mouseEvent instanceof MouseEvent.Click)) {
                    return false;
                }
                MouseEvent.Click click = (MouseEvent.Click)mouseEvent;
                if (click.getMouseState() && click.getMouseButton() != -1 && GuiOptionEditorKeybind.this.editingKeycode) {
                    GuiOptionEditorKeybind.this.editingKeycode = false;
                    int mouseButton = click.getMouseButton();
                    option.set(mouseButton);
                    return true;
                }
                if (click.getMouseState() && click.getMouseButton() == 0) {
                    int height = this.getHeight();
                    int width = this.getHeight();
                    int mouseX = context2.getMouseX();
                    int mouseY = context2.getMouseY();
                    if (mouseX > width / 6 - 24 && mouseX < width / 6 + 16 && mouseY > height - 7 - 14 && mouseY < height - 7 + 2) {
                        GuiOptionEditorKeybind.this.editingKeycode = true;
                        return true;
                    }
                    if (mouseX > width / 6 - 24 + 48 - 3 && mouseX < width / 6 - 24 + 48 + 13 - 5 && mouseY > height - 7 - 14 + 3 && mouseY < height - 7 - 14 + 3 + 11) {
                        option.set(defaultKeyCode);
                        return true;
                    }
                }
                return false;
            }

            @Override
            public boolean keyboardEvent(@NotNull KeyboardEvent keyboardEvent, @NotNull GuiImmediateContext context2) {
                if (keyboardEvent instanceof KeyboardEvent.KeyPressed) {
                    KeyboardEvent.KeyPressed keyPressed = (KeyboardEvent.KeyPressed)keyboardEvent;
                    if (GuiOptionEditorKeybind.this.editingKeycode) {
                        if (keyPressed.getPressed()) {
                            return true;
                        }
                        GuiOptionEditorKeybind.this.editingKeycode = false;
                        int keycode = keyPressed.getKeycode();
                        if (keycode == KeyboardConstants.INSTANCE.getEscape() || keycode == 0) {
                            keycode = KeyboardConstants.INSTANCE.getNone();
                        }
                        option.set(keycode);
                        return true;
                    }
                    return false;
                }
                return GuiOptionEditorKeybind.this.editingKeycode;
            }
        });
    }

    @Override
    @NotNull
    public GuiComponent getDelegate() {
        return this.component;
    }
}

