/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.platform;

import at.hannibal2.skyhanni.deps.moulconfig.common.IFontRenderer;
import at.hannibal2.skyhanni.deps.moulconfig.common.IItemStack;
import at.hannibal2.skyhanni.deps.moulconfig.common.IMinecraft;
import at.hannibal2.skyhanni.deps.moulconfig.common.Layer;
import at.hannibal2.skyhanni.deps.moulconfig.common.MyResourceLocation;
import at.hannibal2.skyhanni.deps.moulconfig.common.RenderContext;
import at.hannibal2.skyhanni.deps.moulconfig.common.TextureFilter;
import at.hannibal2.skyhanni.deps.moulconfig.common.text.StructuredText;
import at.hannibal2.skyhanni.deps.moulconfig.internal.FilterAssertionCache;
import at.hannibal2.skyhanni.deps.moulconfig.internal.Rect;
import at.hannibal2.skyhanni.deps.moulconfig.internal.Warnings;
import at.hannibal2.skyhanni.deps.moulconfig.platform.MoulConfigPlatform;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1044;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_8030;
import org.joml.Matrix4f;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class MoulConfigRenderContext
implements RenderContext {
    final class_332 drawContext;
    class_310 mc = class_310.method_1551();

    public MoulConfigRenderContext(class_332 drawContext) {
        this.drawContext = drawContext;
    }

    public class_4587 getMatrices() {
        return this.drawContext.method_51448();
    }

    @Override
    public void pushMatrix() {
        this.getMatrices().method_22903();
    }

    @Override
    public void popMatrix() {
        this.getMatrices().method_22909();
    }

    @Override
    public void translate(float x, float y) {
        this.getMatrices().method_46416(x, y, 0.0f);
    }

    @Override
    public void scale(float x, float y) {
        this.getMatrices().method_22905(x, y, 1.0f);
    }

    @Override
    public void drawOnTop(Layer layer, RenderContext.ScissorBehaviour escapeScissors, Consumer<RenderContext> later) {
        this.pushMatrix();
        if (escapeScissors == RenderContext.ScissorBehaviour.ESCAPE) {
            this.pushRawScissor(0, 0, IMinecraft.INSTANCE.getScaledWidth(), IMinecraft.INSTANCE.getScaledHeight());
        }
        this.getMatrices().method_46416(0.0f, 0.0f, (float)layer.getSortIndex());
        later.accept(this);
        if (escapeScissors == RenderContext.ScissorBehaviour.ESCAPE) {
            this.popScissor();
        }
        this.popMatrix();
    }

    @Override
    public void drawColouredQuads(int color, float ... coordinates) {
        assert (coordinates.length % 8 == 0);
        Rect rect = Rect.ofDot((int)coordinates[0], (int)coordinates[1]);
        for (int i2 = 0; i2 < coordinates.length; i2 += 2) {
            rect = rect.includePoint((int)coordinates[i2], (int)coordinates[i2 + 1]);
        }
        this.drawContext.method_64039(consumers -> {
            Matrix4f matrix = this.getMatrices().method_23760().method_23761();
            class_4588 vertices = consumers.getBuffer(class_1921.method_51784());
            for (int i2 = 0; i2 < coordinates.length; i2 += 2) {
                vertices.method_22918(matrix, coordinates[i2], coordinates[i2 + 1], 0.0f).method_39415(color);
            }
        });
    }

    @Override
    public void drawString(IFontRenderer fontRenderer, StructuredText text, int x, int y, int color, boolean shadow) {
        this.drawContext.method_51439(MoulConfigPlatform.unwrap(fontRenderer), MoulConfigPlatform.unwrap(text), x, y, color | 0xFF000000, shadow);
    }

    @Override
    public void drawColoredRect(float left, float top, float right, float bottom, int color) {
        this.drawContext.method_25294((int)left, (int)top, (int)right, (int)bottom, color);
    }

    @Override
    public void invertedRect(float left, float top, float right, float bottom, int additiveColor) {
        int leftI = (int)left;
        int topI = (int)top;
        int rightI = (int)right;
        int bottomI = (int)bottom;
        this.drawContext.method_48196(class_1921.method_51786(), leftI, topI, rightI, bottomI, 0, additiveColor);
    }

    @Override
    public void drawTexturedTintedRect(MyResourceLocation texture, float x, float y, float width, float height, float u1, float v1, float u2, float v2, int color, TextureFilter filter) {
        FilterAssertionCache.assertTextureFilter(texture, filter);
        class_2960 identifier = MoulConfigPlatform.unwrap(texture);
        class_1044 class_10442 = this.mc.method_1531().method_4619(identifier);
        class_10442.method_4527(switch (filter) {
            default -> throw new MatchException(null, null);
            case TextureFilter.LINEAR -> true;
            case TextureFilter.NEAREST -> false;
        }, false);
        this.drawContext.method_25295(class_1921::method_62277, identifier, (int)x, (int)(x + width), (int)y, (int)(y + height), u1, u2, v1, v2, color);
    }

    @Override
    public void drawDarkRect(int x, int y, int width, int height, boolean shadow) {
        int body = -14671834;
        int light = -13619146;
        int dark = -15724522;
        this.drawContext.method_25294(x, y, x + 1, y + height, light);
        this.drawContext.method_25294(x + 1, y, x + width, y + 1, light);
        this.drawContext.method_25294(x + width - 1, y + 1, x + width, y + height, dark);
        this.drawContext.method_25294(x + 1, y + height - 1, x + width - 1, y + height, dark);
        this.drawContext.method_25294(x + 1, y + 1, x + width - 1, y + height - 1, body);
        if (shadow) {
            this.drawContext.method_25294(x + width, y + 2, x + width + 2, y + height + 2, 0x70000000);
            this.drawContext.method_25294(x + 2, y + height, x + width, y + height + 2, 0x70000000);
        }
    }

    @Override
    public void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        this.drawContext.method_25296(left, top, right, bottom, startColor, endColor);
    }

    @Override
    public void pushScissor(int left, int top, int right, int bottom) {
        this.drawContext.method_44379(left, top, right, bottom);
    }

    @Override
    public void pushRawScissor(int left, int top, int right, int bottom) {
        this.drawContext.field_44659.field_43099.addLast(new class_8030(left, top, right, bottom));
    }

    @Override
    public void popScissor() {
        this.drawContext.method_44380();
    }

    @Override
    public void assertNoScissors() {
        if (!this.drawContext.field_44659.field_43099.isEmpty()) {
            Warnings.warn("Scissors found despite no scissor assertion", 4);
        }
    }

    @Override
    @Deprecated
    public void clearScissor() {
        this.drawContext.field_44659.field_43099.clear();
    }

    @Override
    public void renderItemStack(IItemStack itemStack, int x, int y, @Nullable StructuredText overlayText) {
        class_1799 item2 = MoulConfigPlatform.unwrap(itemStack);
        this.drawContext.method_51427(item2, x, y);
        if (overlayText != null) {
            this.drawContext.method_51432(this.mc.field_1772, item2, x, y, overlayText.getText());
        }
    }

    @Override
    public void drawTooltipNow(int x, int y, List<StructuredText> tooltipLines) {
        List<class_2561> lines = tooltipLines.stream().map(MoulConfigPlatform::unwrap).toList();
        this.drawContext.method_64037(this.mc.field_1772, lines, x, y, null);
    }

    @Override
    public void renderExtraLayers() {
    }

    public class_332 getDrawContext() {
        return this.drawContext;
    }
}

