/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.enums.OutsideSBFeature;
import at.hannibal2.skyhanni.config.features.garden.YawPitchDisplayConfig;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.garden.GardenToolChangeEvent;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import java.math.BigDecimal;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0015\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001a\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lat/hannibal2/skyhanni/features/garden/GardenYawAndPitch;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "event", "", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/events/garden/GardenToolChangeEvent;", "onGardenToolChange", "(Lat/hannibal2/skyhanni/events/garden/GardenToolChangeEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/garden/YawPitchDisplayConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/YawPitchDisplayConfig;", "config", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastChange", "J", "", "lastYaw", "F", "lastPitch", "1.21.5"})
public final class GardenYawAndPitch {
    @NotNull
    public static final GardenYawAndPitch INSTANCE = new GardenYawAndPitch();
    private static long lastChange = SimpleTimeMark.Companion.farPast();
    private static float lastYaw;
    private static float lastPitch;

    private GardenYawAndPitch() {
    }

    private final YawPitchDisplayConfig getConfig() {
        return GardenApi.INSTANCE.getConfig().getYawPitchDisplay();
    }

    @HandleEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!SkyBlockUtils.INSTANCE.getOnHypixel()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (GardenApi.INSTANCE.hideExtraGuis()) {
            return;
        }
        if (GardenApi.INSTANCE.getToolInHand() == null && !this.getConfig().getShowWithoutTool()) {
            return;
        }
        class_746 player = MinecraftCompat.INSTANCE.getLocalPlayer();
        float yaw = LocationUtils.INSTANCE.calculatePlayerYaw();
        float pitch = player.method_36455();
        if (!(yaw == lastYaw) || !(pitch == lastPitch)) {
            lastChange = SimpleTimeMark.Companion.now-uFjCsEo();
        }
        lastYaw = yaw;
        lastPitch = pitch;
        if (!this.getConfig().getShowAlways()) {
            if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastChange), (long)DurationKt.toDuration((int)this.getConfig().getTimeout(), (DurationUnit)DurationUnit.SECONDS)) > 0) {
                return;
            }
        }
        String yawText = new BigDecimal(String.valueOf(NumberUtil.INSTANCE.roundTo(yaw, this.getConfig().getYawPrecision()))).toPlainString();
        String pitchText = new BigDecimal(String.valueOf(NumberUtil.INSTANCE.roundTo(pitch, this.getConfig().getPitchPrecision()))).toPlainString();
        Object[] objectArray = new String[]{"\u00a7aYaw: \u00a7f" + yawText, "\u00a7aPitch: \u00a7f" + pitchText};
        List displayList = CollectionsKt.listOf((Object[])objectArray);
        if (GardenApi.INSTANCE.inGarden()) {
            RenderUtils.renderStrings$default(RenderUtils.INSTANCE, this.getConfig().getPos(), displayList, 0, "Yaw and Pitch", 2, null);
        } else {
            RenderUtils.renderStrings$default(RenderUtils.INSTANCE, this.getConfig().getPosOutside(), displayList, 0, "Yaw and Pitch", 2, null);
        }
    }

    @HandleEvent
    public final void onGardenToolChange(@NotNull GardenToolChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        lastChange = SimpleTimeMark.Companion.farPast();
    }

    private final boolean isEnabled() {
        return this.getConfig().getEnabled() && (OutsideSBFeature.YAW_AND_PITCH.isSelected() && !SkyBlockUtils.INSTANCE.getInSkyBlock() || SkyBlockUtils.INSTANCE.getInSkyBlock() && (GardenApi.INSTANCE.inGarden() || this.getConfig().getShowOutsideGarden()));
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 18, "garden.yawPitchDisplay.showEverywhere", "garden.yawPitchDisplay.showOutsideGarden", null, 8, null);
    }
}

