/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest;

import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.jsonobjects.repo.ReputationQuest;
import at.hannibal2.skyhanni.data.model.TabWidget;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.features.nether.kuudra.KuudraTier;
import at.hannibal2.skyhanni.features.nether.reputationhelper.CrimsonIsleReputationHelper;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.DailyQuestHelper;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.DojoQuest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.FetchQuest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.KuudraQuest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.MiniBossQuest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.ProgressQuest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.Quest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.QuestState;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.RescueMissionQuest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.TrophyFishQuest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.dailyquest.quest.UnknownQuest;
import at.hannibal2.skyhanni.features.nether.reputationhelper.miniboss.CrimsonMiniBoss;
import at.hannibal2.skyhanni.features.nether.reputationhelper.miniboss.DailyMiniBossHelper;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.TabListData;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\n\u001a\u00020\t2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0019\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0010\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010 \u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b \u0010!J\u001f\u0010%\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b%\u0010&J\u0015\u0010)\u001a\u00020\t2\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010,\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b,\u0010-J\u0017\u0010\u001a\u001a\u00020\t2\u0006\u0010.\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001a\u0010/R/\u00102\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000601008\u0006\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u00105\u00a8\u00066"}, d2={"Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/QuestLoader;", "", "<init>", "()V", "", "", "Lat/hannibal2/skyhanni/data/jsonobjects/repo/ReputationQuest;", "data", "questType", "", "loadQuests", "(Ljava/util/Map;Ljava/lang/String;)V", "loadFromTabList", "line", "readQuest", "(Ljava/lang/String;)V", "name", "", "green", "", "needAmount", "checkQuest", "(Ljava/lang/String;ZI)V", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/quest/QuestState;", "state", "Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/quest/Quest;", "addQuest", "(Ljava/lang/String;Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/quest/QuestState;I)Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/quest/Quest;", "getQuestByName", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/quest/Quest;", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "event", "checkInventory", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "quest", "Lnet/minecraft/class_1799;", "stack", "fixMinibossAmount", "(Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/quest/Quest;Lnet/minecraft/class_1799;)V", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CrimsonIsleStorage;", "storage", "loadConfig", "(Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CrimsonIsleStorage;)V", "text", "hasGreatSpookLine", "(Ljava/lang/String;)Z", "element", "(Lat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/quest/Quest;)V", "", "Lkotlin/Pair;", "quests", "Ljava/util/Map;", "getQuests", "()Ljava/util/Map;", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nQuestLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuestLoader.kt\nat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/QuestLoader\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n8#2:235\n8#2:243\n1#3:236\n1#3:237\n1#3:244\n295#4,2:238\n1761#4,3:240\n1761#4,3:245\n*S KotlinDebug\n*F\n+ 1 QuestLoader.kt\nat/hannibal2/skyhanni/features/nether/reputationhelper/dailyquest/QuestLoader\n*L\n55#1:235\n163#1:243\n55#1:236\n163#1:244\n130#1:238,2\n145#1:240,3\n182#1:245,3\n*E\n"})
public final class QuestLoader {
    @NotNull
    public static final QuestLoader INSTANCE = new QuestLoader();
    @NotNull
    private static final Map<String, Pair<String, ReputationQuest>> quests = new LinkedHashMap();

    private QuestLoader() {
    }

    @NotNull
    public final Map<String, Pair<String, ReputationQuest>> getQuests() {
        return quests;
    }

    public final void loadQuests(@NotNull Map<String, ReputationQuest> data, @NotNull String questType) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)questType, (String)"questType");
        for (Map.Entry<String, ReputationQuest> entry : data.entrySet()) {
            String questName = entry.getKey();
            ReputationQuest questInfo = entry.getValue();
            quests.put(questName, (Pair<String, ReputationQuest>)new Pair((Object)questType, (Object)questInfo));
        }
    }

    public final void loadFromTabList() {
        DailyQuestHelper.INSTANCE.setGreatSpook(false);
        int found = 0;
        for (String line : TabWidget.FACTION_QUESTS.getLines()) {
            this.readQuest(line);
            ++found;
            if (!DailyQuestHelper.INSTANCE.getGreatSpook()) continue;
            return;
        }
        CrimsonIsleReputationHelper.INSTANCE.setTabListQuestsMissing(found == 0);
        DailyQuestHelper.INSTANCE.update();
    }

    private final void readQuest(String line) {
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv = CrimsonIsleReputationHelper.INSTANCE.getTabListQuestPattern();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(line);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$readQuest_u24lambda_u240 = it$iv;
            boolean bl2 = false;
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)"The Great Spook", (boolean)false, (int)2, null)) {
                DailyQuestHelper.INSTANCE.setGreatSpook(true);
                DailyQuestHelper.INSTANCE.update();
                return;
            }
            String name2 = $this$readQuest_u24lambda_u240.group("name");
            String string = RegexUtils.INSTANCE.groupOrNull($this$readQuest_u24lambda_u240, "amount");
            int amount = string != null ? Integer.parseInt(string) : 1;
            boolean green = Intrinsics.areEqual((Object)$this$readQuest_u24lambda_u240.group("status"), (Object)"\u2714");
            Intrinsics.checkNotNull((Object)name2);
            INSTANCE.checkQuest(name2, green, amount);
        }
    }

    private final void checkQuest(String name2, boolean green, int needAmount) {
        Quest oldQuest = this.getQuestByName(name2);
        if (oldQuest != null) {
            if (green && oldQuest.getState() != QuestState.READY_TO_COLLECT && oldQuest.getState() != QuestState.COLLECTED) {
                oldQuest.setState(QuestState.READY_TO_COLLECT);
                DailyQuestHelper.INSTANCE.update();
                ChatUtils.debug$default(ChatUtils.INSTANCE, "Reputation Helper: Tab-List updated " + oldQuest.getInternalName() + " (This should not happen)", false, 2, null);
            }
            return;
        }
        QuestState state = green ? QuestState.READY_TO_COLLECT : QuestState.ACCEPTED;
        DailyQuestHelper.INSTANCE.update();
        this.addQuest(this.addQuest(name2, state, needAmount));
    }

    private final Quest addQuest(String name2, QuestState state, int needAmount) {
        String dojoGoal;
        String questName;
        block20: {
            for (CrimsonMiniBoss miniBoss : DailyMiniBossHelper.INSTANCE.getMiniBosses()) {
                if (!Intrinsics.areEqual((Object)name2, (Object)miniBoss.getDisplayName())) continue;
                return new MiniBossQuest(miniBoss, state, needAmount);
            }
            KuudraQuest kuudraQuest = KuudraTier.Companion.getQuestOrNull(name2, state);
            if (kuudraQuest != null) {
                KuudraQuest it = kuudraQuest;
                boolean bl = false;
                return it;
            }
            questName = name2;
            dojoGoal = "";
            if (StringsKt.contains$default((CharSequence)name2, (CharSequence)" Rank ", (boolean)false, (int)2, null)) {
                String[] bl = new String[]{" Rank "};
                List split = StringsKt.split$default((CharSequence)name2, (String[])bl, (boolean)false, (int)0, (int)6, null);
                questName = (String)split.get(0);
                dojoGoal = (String)split.get(1);
            }
            if (!quests.containsKey(questName)) break block20;
            Pair<String, ReputationQuest> pair = quests.get(questName);
            if (pair == null) {
                return new UnknownQuest(name2);
            }
            Pair<String, ReputationQuest> questInfo = pair;
            List<Double> locationInfo = ((ReputationQuest)questInfo.getSecond()).getLocation();
            LorenzVec location = CrimsonIsleReputationHelper.INSTANCE.readLocationData(locationInfo);
            NeuInternalName displayItem = ((ReputationQuest)questInfo.getSecond()).getItem();
            switch ((String)questInfo.getFirst()) {
                case "FISHING": {
                    return new TrophyFishQuest(name2, location, displayItem, state, needAmount);
                }
                case "RESCUE": {
                    return new RescueMissionQuest(displayItem, location, state);
                }
                case "FETCH": {
                    return new FetchQuest(name2, location, displayItem, state, needAmount);
                }
                case "DOJO": {
                    return new DojoQuest(questName, location, displayItem, dojoGoal, state);
                }
            }
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)name2), TuplesKt.to((Object)"questName", (Object)questName), TuplesKt.to((Object)"dojoGoal", (Object)dojoGoal), TuplesKt.to((Object)"state", (Object)((Object)state)), TuplesKt.to((Object)"needAmount", (Object)needAmount), TuplesKt.to((Object)"tablist", TabListData.INSTANCE.getTabList())};
        ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "Unknown Crimson Isle quest: '" + name2 + "'", "Unknown quest detected", pairArray, false, false, false, null, 120, null);
        return new UnknownQuest(name2);
    }

    private final Quest getQuestByName(String name2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = DailyQuestHelper.INSTANCE.getQuests();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Quest it = (Quest)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getInternalName(), (Object)name2)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void checkInventory(@NotNull InventoryFullyOpenedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean inMageRegion = Intrinsics.areEqual((Object)SkyBlockUtils.INSTANCE.getGraphArea(), (Object)"Community Center");
        boolean inBarbarianRegion = Intrinsics.areEqual((Object)SkyBlockUtils.INSTANCE.getGraphArea(), (Object)"Dragontail");
        if (!inMageRegion && !inBarbarianRegion) {
            return;
        }
        String name2 = event.getInventoryName();
        for (Quest quest : DailyQuestHelper.INSTANCE.getQuests()) {
            boolean completed;
            class_1799 stack;
            block6: {
                String categoryName = quest.getCategory().name();
                if (!StringsKt.equals((String)categoryName, (String)name2, (boolean)true) || event.getInventoryItems().get(22) == null) continue;
                Iterable $this$any$iv = ItemUtils.INSTANCE.getLore(stack);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        if (!RegexUtils.INSTANCE.matches(DailyQuestHelper.INSTANCE.getTownBoardCompletedPattern(), it)) continue;
                        v0 = true;
                        break block6;
                    }
                    v0 = completed = false;
                }
            }
            if (completed && quest.getState() != QuestState.COLLECTED) {
                quest.setState(QuestState.COLLECTED);
                DailyQuestHelper.INSTANCE.update();
            }
            if (!Intrinsics.areEqual((Object)name2, (Object)"Miniboss")) continue;
            this.fixMinibossAmount(quest, stack);
        }
    }

    private final void fixMinibossAmount(Quest quest, class_1799 stack) {
        if (!(quest instanceof MiniBossQuest)) {
            return;
        }
        int storedAmount = ((MiniBossQuest)quest).getNeedAmount();
        if (storedAmount != 1) {
            return;
        }
        for (String line : ItemUtils.INSTANCE.getLore(stack)) {
            Integer n;
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern $this$matchMatcher$iv = DailyQuestHelper.INSTANCE.getMinibossAmountPattern();
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(line);
            boolean bl = false;
            if (it$iv.matches()) {
                Intrinsics.checkNotNull((Object)it$iv);
                Matcher $this$fixMinibossAmount_u24lambda_u244 = it$iv;
                boolean bl2 = false;
                String string = $this$fixMinibossAmount_u24lambda_u244.group("amount");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                n = Integer.parseInt(string);
            } else {
                n = null;
            }
            if (n == null) {
                continue;
            }
            int realAmount = n;
            if (storedAmount == realAmount) continue;
            ChatUtils.debug$default(ChatUtils.INSTANCE, "Wrong amount detected! realAmount: " + realAmount + ", storedAmount: " + storedAmount, false, 2, null);
            MiniBossQuest newQuest = new MiniBossQuest(((MiniBossQuest)quest).getMiniBoss(), quest.getState(), realAmount);
            newQuest.setHaveAmount(((MiniBossQuest)quest).getHaveAmount());
            DelayedRun.INSTANCE.runNextTick((Function0<Unit>)((Function0)() -> QuestLoader.fixMinibossAmount$lambda$5(quest, newQuest)));
        }
    }

    public final void loadConfig(@NotNull ProfileSpecificStorage.CrimsonIsleStorage storage) {
        boolean bl;
        block10: {
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            if (DailyQuestHelper.INSTANCE.getGreatSpook()) {
                return;
            }
            Iterable $this$any$iv = CollectionsKt.toList((Iterable)storage.getQuests());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.hasGreatSpookLine(it)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            DailyQuestHelper.INSTANCE.setGreatSpook(true);
            return;
        }
        for (String text : CollectionsKt.toList((Iterable)storage.getQuests())) {
            int needAmount;
            QuestState state;
            Object element$iv;
            List split = StringsKt.split$default((CharSequence)text, element$iv = new String[]{":"}, (boolean)false, (int)0, (int)6, null);
            String name2 = (String)split.get(0);
            Quest quest = this.addQuest(name2, state = Intrinsics.areEqual(split.get(1), (Object)"NOT_ACCEPTED") ? QuestState.ACCEPTED : QuestState.valueOf((String)split.get(1)), needAmount = Integer.parseInt((String)split.get(2)));
            if (quest instanceof UnknownQuest) {
                DailyQuestHelper.INSTANCE.getQuests().clear();
                storage.getQuests().clear();
                System.out.println((Object)"Reset crimson isle quest data from the config because the config was invalid!");
                return;
            }
            if (quest instanceof ProgressQuest && split.size() == 4) {
                try {
                    int haveAmount = Integer.parseInt((String)split.get(3));
                    ((ProgressQuest)quest).setHaveAmount(haveAmount);
                }
                catch (IndexOutOfBoundsException e) {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"text", (Object)text)};
                    ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Error loading Crimson Isle Quests from config.", pairArray, false, false, false, 56, null);
                }
            }
            this.addQuest(quest);
        }
    }

    private final boolean hasGreatSpookLine(String text) {
        return StringsKt.contains$default((CharSequence)text, (CharSequence)"The Great Spook", (boolean)false, (int)2, null) ? true : (StringsKt.contains$default((CharSequence)text, (CharSequence)" Days", (boolean)false, (int)2, null) ? true : (StringsKt.contains$default((CharSequence)text, (CharSequence)"Fear: \u00a7r", (boolean)false, (int)2, null) ? true : StringsKt.contains$default((CharSequence)text, (CharSequence)"Primal Fears", (boolean)false, (int)2, null)));
    }

    private final void addQuest(Quest element) {
        DailyQuestHelper.INSTANCE.getQuests().add(element);
        if (DailyQuestHelper.INSTANCE.getQuests().size() > 5) {
            CrimsonIsleReputationHelper.INSTANCE.reset();
        }
    }

    private static final Unit fixMinibossAmount$lambda$5(Quest $quest, MiniBossQuest $newQuest) {
        Intrinsics.checkNotNullParameter((Object)$quest, (String)"$quest");
        Intrinsics.checkNotNullParameter((Object)$newQuest, (String)"$newQuest");
        DailyQuestHelper.INSTANCE.getQuests().remove($quest);
        DailyQuestHelper.INSTANCE.getQuests().add($newQuest);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Fixed wrong miniboss amount from Town Board.", false, null, false, false, null, 62, null);
        DailyQuestHelper.INSTANCE.update();
        return Unit.INSTANCE;
    }
}

