/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils.shader;

import at.hannibal2.skyhanni.utils.ChatUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLCapabilities;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\bJ\u001d\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001c\u0010\bJ\u001d\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001d\u0010\u000fJ\u001d\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001e\u0010\fJ\u0015\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001f\u0010\bJ\u001d\u0010#\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b#\u0010$J\u001d\u0010%\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004\u00a2\u0006\u0004\b%\u0010\u0013J%\u0010'\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\"\u001a\u00020!2\u0006\u0010&\u001a\u00020!\u00a2\u0006\u0004\b'\u0010(J-\u0010*\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\"\u001a\u00020!2\u0006\u0010&\u001a\u00020!2\u0006\u0010)\u001a\u00020!\u00a2\u0006\u0004\b*\u0010+J5\u0010-\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\"\u001a\u00020!2\u0006\u0010&\u001a\u00020!2\u0006\u0010)\u001a\u00020!2\u0006\u0010,\u001a\u00020!\u00a2\u0006\u0004\b-\u0010.J%\u00103\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00042\u0006\u00100\u001a\u00020/2\u0006\u00102\u001a\u000201\u00a2\u0006\u0004\b3\u00104J\u001d\u00106\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0018\u00a2\u0006\u0004\b6\u00107J\r\u00108\u001a\u00020/\u00a2\u0006\u0004\b8\u00109R\u0016\u0010:\u001a\u00020/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0016\u0010<\u001a\u00020/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u0010;R\"\u0010=\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010>\u001a\u0004\b?\u0010@\"\u0004\bA\u0010\bR\"\u0010B\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bB\u0010>\u001a\u0004\bC\u0010@\"\u0004\bD\u0010\bR\"\u0010E\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bE\u0010>\u001a\u0004\bF\u0010@\"\u0004\bG\u0010\bR\"\u0010H\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bH\u0010>\u001a\u0004\bI\u0010@\"\u0004\bJ\u0010\b\u00a8\u0006K"}, d2={"Lat/hannibal2/skyhanni/utils/shader/ShaderHelper;", "", "<init>", "()V", "", "program", "", "glLinkProgram", "(I)V", "maxLength", "", "glGetProgramInfoLog", "(II)Ljava/lang/String;", "pName", "glGetProgramInt", "(II)I", "glUseProgram", "shaderIn", "glAttachShader", "(II)V", "type", "glCreateShader", "(I)I", "shader", "", "source", "glShaderSource", "(ILjava/lang/CharSequence;)V", "glCompileShader", "glGetShaderInt", "glGetShaderInfoLog", "glDeleteShader", "location", "", "v0", "glUniform1f", "(IF)V", "glUniform1i", "v1", "glUniform2f", "(IFF)V", "v2", "glUniform3f", "(IFFF)V", "v3", "glUniform4f", "(IFFFF)V", "", "transpose", "Lorg/joml/Matrix4f;", "matrix", "glUniformMatrix4f", "(IZLorg/joml/Matrix4f;)V", "name", "glGetUniformLocation", "(ILjava/lang/CharSequence;)I", "areShadersSupported", "()Z", "SHADERS_SUPPORTED", "Z", "USING_ARB_SHADERS", "GL_LINK_STATUS", "I", "getGL_LINK_STATUS", "()I", "setGL_LINK_STATUS", "GL_COMPILE_STATUS", "getGL_COMPILE_STATUS", "setGL_COMPILE_STATUS", "GL_VERTEX_SHADER", "getGL_VERTEX_SHADER", "setGL_VERTEX_SHADER", "GL_FRAGMENT_SHADER", "getGL_FRAGMENT_SHADER", "setGL_FRAGMENT_SHADER", "1.21.5"})
public final class ShaderHelper {
    @NotNull
    public static final ShaderHelper INSTANCE = new ShaderHelper();
    private static boolean SHADERS_SUPPORTED;
    private static boolean USING_ARB_SHADERS;
    private static int GL_LINK_STATUS;
    private static int GL_COMPILE_STATUS;
    private static int GL_VERTEX_SHADER;
    private static int GL_FRAGMENT_SHADER;

    private ShaderHelper() {
    }

    public final int getGL_LINK_STATUS() {
        return GL_LINK_STATUS;
    }

    public final void setGL_LINK_STATUS(int n) {
        GL_LINK_STATUS = n;
    }

    public final int getGL_COMPILE_STATUS() {
        return GL_COMPILE_STATUS;
    }

    public final void setGL_COMPILE_STATUS(int n) {
        GL_COMPILE_STATUS = n;
    }

    public final int getGL_VERTEX_SHADER() {
        return GL_VERTEX_SHADER;
    }

    public final void setGL_VERTEX_SHADER(int n) {
        GL_VERTEX_SHADER = n;
    }

    public final int getGL_FRAGMENT_SHADER() {
        return GL_FRAGMENT_SHADER;
    }

    public final void setGL_FRAGMENT_SHADER(int n) {
        GL_FRAGMENT_SHADER = n;
    }

    public final void glLinkProgram(int program) {
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glLinkProgramARB((int)program);
        } else {
            GL20.glLinkProgram((int)program);
        }
    }

    @NotNull
    public final String glGetProgramInfoLog(int program, int maxLength) {
        String string;
        if (USING_ARB_SHADERS) {
            String string2 = ARBShaderObjects.glGetInfoLogARB((int)program, (int)maxLength);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"glGetInfoLogARB(...)");
        } else {
            String string3 = GL20.glGetProgramInfoLog((int)program, (int)maxLength);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"glGetProgramInfoLog(...)");
        }
        return string;
    }

    public final int glGetProgramInt(int program, int pName) {
        return USING_ARB_SHADERS ? ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)pName) : GL20.glGetProgrami((int)program, (int)pName);
    }

    public final void glUseProgram(int program) {
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glUseProgramObjectARB((int)program);
        } else {
            GL20.glUseProgram((int)program);
        }
    }

    public final void glAttachShader(int program, int shaderIn) {
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)shaderIn);
        } else {
            GL20.glAttachShader((int)program, (int)shaderIn);
        }
    }

    public final int glCreateShader(int type2) {
        return USING_ARB_SHADERS ? ARBShaderObjects.glCreateShaderObjectARB((int)type2) : GL20.glCreateShader((int)type2);
    }

    public final void glShaderSource(int shader, @NotNull CharSequence source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)source);
        } else {
            GL20.glShaderSource((int)shader, (CharSequence)source);
        }
    }

    public final void glCompileShader(int shader) {
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glCompileShaderARB((int)shader);
        } else {
            GL20.glCompileShader((int)shader);
        }
    }

    public final int glGetShaderInt(int shader, int pName) {
        return USING_ARB_SHADERS ? ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)pName) : GL20.glGetShaderi((int)shader, (int)pName);
    }

    @NotNull
    public final String glGetShaderInfoLog(int shader, int maxLength) {
        String string;
        if (USING_ARB_SHADERS) {
            String string2 = ARBShaderObjects.glGetInfoLogARB((int)shader, (int)maxLength);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"glGetInfoLogARB(...)");
        } else {
            String string3 = GL20.glGetShaderInfoLog((int)shader, (int)maxLength);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"glGetShaderInfoLog(...)");
        }
        return string;
    }

    public final void glDeleteShader(int shader) {
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
        } else {
            GL20.glDeleteShader((int)shader);
        }
    }

    public final void glUniform1f(int location, float v0) {
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glUniform1fARB((int)location, (float)v0);
        } else {
            GL20.glUniform1f((int)location, (float)v0);
        }
    }

    public final void glUniform1i(int location, int v0) {
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glUniform1iARB((int)location, (int)v0);
        } else {
            GL20.glUniform1i((int)location, (int)v0);
        }
    }

    public final void glUniform2f(int location, float v0, float v1) {
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glUniform2fARB((int)location, (float)v0, (float)v1);
        } else {
            GL20.glUniform2f((int)location, (float)v0, (float)v1);
        }
    }

    public final void glUniform3f(int location, float v0, float v1, float v2) {
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glUniform3fARB((int)location, (float)v0, (float)v1, (float)v2);
        } else {
            GL20.glUniform3f((int)location, (float)v0, (float)v1, (float)v2);
        }
    }

    public final void glUniform4f(int location, float v0, float v1, float v2, float v3) {
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glUniform4fARB((int)location, (float)v0, (float)v1, (float)v2, (float)v3);
        } else {
            GL20.glUniform4f((int)location, (float)v0, (float)v1, (float)v2, (float)v3);
        }
    }

    public final void glUniformMatrix4f(int location, boolean transpose, @NotNull Matrix4f matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        float[] matrixArray = new float[16];
        matrix.get(matrixArray);
        if (USING_ARB_SHADERS) {
            ARBShaderObjects.glUniformMatrix4fvARB((int)location, (boolean)transpose, (float[])matrixArray);
        } else {
            GL20.glUniformMatrix4fv((int)location, (boolean)transpose, (float[])matrixArray);
        }
    }

    public final int glGetUniformLocation(int program, @NotNull CharSequence name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return USING_ARB_SHADERS ? ARBShaderObjects.glGetUniformLocationARB((int)program, (CharSequence)name2) : GL20.glGetUniformLocation((int)program, (CharSequence)name2);
    }

    public final boolean areShadersSupported() {
        return SHADERS_SUPPORTED;
    }

    static {
        GLCapabilities gLCapabilities = GL.getCapabilities();
        Intrinsics.checkNotNullExpressionValue((Object)gLCapabilities, (String)"getCapabilities(...)");
        GLCapabilities capabilities = gLCapabilities;
        boolean openGL20supported = capabilities.OpenGL20;
        SHADERS_SUPPORTED = openGL20supported || capabilities.GL_ARB_vertex_shader && capabilities.GL_ARB_fragment_shader && capabilities.GL_ARB_shader_objects;
        Object log = "Shaders are";
        if (!SHADERS_SUPPORTED) {
            log = (String)log + " not";
        }
        log = (String)log + " available. ";
        if (SHADERS_SUPPORTED) {
            if (capabilities.OpenGL20) {
                log = (String)log + "OpenGL 2.0 is supported. ";
                USING_ARB_SHADERS = false;
                GL_LINK_STATUS = 35714;
                GL_COMPILE_STATUS = 35713;
                GL_VERTEX_SHADER = 35633;
                GL_FRAGMENT_SHADER = 35632;
            } else {
                log = (String)log + "ARB_shader_objects, ARB_vertex_shader, and ARB_fragment_shader are supported. ";
                USING_ARB_SHADERS = true;
                GL_LINK_STATUS = 35714;
                GL_COMPILE_STATUS = 35713;
                GL_VERTEX_SHADER = 35633;
                GL_FRAGMENT_SHADER = 35632;
            }
        } else {
            log = (String)log + "OpenGL 2.0 is not supported and ARB_shader_objects, ARB_vertex_shader, and ARB_fragment_shader are not supported.";
            USING_ARB_SHADERS = false;
            GL_LINK_STATUS = 0;
            GL_COMPILE_STATUS = 0;
            GL_VERTEX_SHADER = 0;
            GL_FRAGMENT_SHADER = 0;
        }
        ChatUtils.INSTANCE.consoleLog((String)log);
    }
}

