/*
 * Decompiled with CFR 0.152.
 */
package org.newsclub.net.unix;

import com.kohlschutter.annotations.compiletime.SuppressFBWarnings;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.newsclub.net.unix.AFAddressFamilyConfig;
import org.newsclub.net.unix.AFDatagramSocket;
import org.newsclub.net.unix.AFServerSocket;
import org.newsclub.net.unix.AFSocket;
import org.newsclub.net.unix.AFSocketAddress;
import org.newsclub.net.unix.AFSocketCapability;
import org.newsclub.net.unix.AFTIPCSocketAddress;
import org.newsclub.net.unix.AFUNIXSocketAddress;
import org.newsclub.net.unix.FileDescriptorAccess;
import org.newsclub.net.unix.NativeUnixSocket;
import org.newsclub.net.unix.RAFChannelProvider;

public final class FileDescriptorCast
implements FileDescriptorAccess {
    private static final Map<Class<?>, CastingProviderMap> PRIMARY_TYPE_PROVIDERS_MAP = Collections.synchronizedMap(new HashMap());
    private final FileDescriptor fdObj;
    private int localPort = 0;
    private int remotePort = 0;
    private static final Function<FileDescriptor, FileInputStream> FD_IS_PROVIDER = System.getProperty("osv.version") != null ? x$0 -> new LenientFileInputStream((FileDescriptor)x$0) : FileInputStream::new;
    private static final CastingProviderMap GLOBAL_PROVIDERS_FINAL = new CastingProviderMap(){

        @Override
        protected void addProviders() {
            this.addProvider(FileDescriptor.class, new CastingProvider<FileDescriptor>(){

                @Override
                public FileDescriptor provideAs(FileDescriptorCast fdc, Class<? super FileDescriptor> desiredType) throws IOException {
                    return fdc.getFileDescriptor();
                }
            });
        }
    };
    private static final CastingProviderMap GLOBAL_PROVIDERS = new CastingProviderMap(){

        @Override
        protected void addProviders() {
            this.addProvider(WritableByteChannel.class, new CastingProvider<WritableByteChannel>(){

                @Override
                public WritableByteChannel provideAs(FileDescriptorCast fdc, Class<? super WritableByteChannel> desiredType) throws IOException {
                    return new FileOutputStream(fdc.getFileDescriptor()).getChannel();
                }
            });
            this.addProvider(ReadableByteChannel.class, new CastingProvider<ReadableByteChannel>(){

                @Override
                public ReadableByteChannel provideAs(FileDescriptorCast fdc, Class<? super ReadableByteChannel> desiredType) throws IOException {
                    return ((FileInputStream)FD_IS_PROVIDER.apply(fdc.getFileDescriptor())).getChannel();
                }
            });
            this.addProvider(FileChannel.class, new CastingProvider<FileChannel>(){

                @Override
                public FileChannel provideAs(FileDescriptorCast fdc, Class<? super FileChannel> desiredType) throws IOException {
                    return RAFChannelProvider.getFileChannel(fdc.getFileDescriptor());
                }
            });
            this.addProvider(FileOutputStream.class, new CastingProvider<FileOutputStream>(){

                @Override
                public FileOutputStream provideAs(FileDescriptorCast fdc, Class<? super FileOutputStream> desiredType) throws IOException {
                    return new FileOutputStream(fdc.getFileDescriptor());
                }
            });
            this.addProvider(FileInputStream.class, new CastingProvider<FileInputStream>(){

                @Override
                public FileInputStream provideAs(FileDescriptorCast fdc, Class<? super FileInputStream> desiredType) throws IOException {
                    return (FileInputStream)FD_IS_PROVIDER.apply(fdc.getFileDescriptor());
                }
            });
            if (AFSocket.supports(AFSocketCapability.CAPABILITY_FD_AS_REDIRECT)) {
                this.addProvider(ProcessBuilder.Redirect.class, new CastingProvider<ProcessBuilder.Redirect>(){

                    @Override
                    public ProcessBuilder.Redirect provideAs(FileDescriptorCast fdc, Class<? super ProcessBuilder.Redirect> desiredType) throws IOException {
                        ProcessBuilder.Redirect red = NativeUnixSocket.initRedirect(fdc.getFileDescriptor());
                        if (red == null) {
                            throw new ClassCastException("Cannot access file descriptor as " + desiredType);
                        }
                        return red;
                    }
                });
            }
        }
    };
    private final CastingProviderMap cpm;

    private FileDescriptorCast(FileDescriptor fdObj, CastingProviderMap cpm) {
        this.fdObj = Objects.requireNonNull(fdObj);
        this.cpm = Objects.requireNonNull(cpm);
    }

    private static void registerCastingProviders(Class<?> primaryType, CastingProviderMap cpm) {
        Objects.requireNonNull(primaryType);
        CastingProviderMap prev = PRIMARY_TYPE_PROVIDERS_MAP.put(primaryType, cpm);
        if (prev != null) {
            PRIMARY_TYPE_PROVIDERS_MAP.put(primaryType, prev);
            throw new IllegalStateException("Already registered: " + primaryType);
        }
    }

    static <A extends AFSocketAddress> void registerCastingProviders(final AFAddressFamilyConfig<A> config) {
        final Class<AFSocket<A>> socketClass = config.socketClass();
        final Class<AFDatagramSocket<A>> datagramSocketClass = config.datagramSocketClass();
        FileDescriptorCast.registerCastingProviders(socketClass, new CastingProviderMap(){

            @Override
            protected void addProviders() {
                this.addProviders(GLOBAL_PROVIDERS);
                CastingProvider<AFSocket> cpSocket = (fdc, desiredType) -> AFSocket.newInstance(config.socketConstructor(), null, fdc.getFileDescriptor(), fdc.localPort, fdc.remotePort);
                CastingProvider<AFServerSocket> cpServerSocket = (fdc, desiredType) -> AFServerSocket.newInstance(config.serverSocketConstructor(), fdc.getFileDescriptor(), fdc.localPort, fdc.remotePort);
                this.addProvider(socketClass, cpSocket);
                this.addProvider(config.serverSocketClass(), cpServerSocket);
                this.addProvider(config.socketChannelClass(), (fdc, desiredType) -> cpSocket.provideAs(fdc, AFSocket.class).getChannel());
                this.addProvider(config.serverSocketChannelClass(), (fdc, desiredType) -> cpServerSocket.provideAs(fdc, AFServerSocket.class).getChannel());
            }
        });
        FileDescriptorCast.registerCastingProviders(datagramSocketClass, new CastingProviderMap(){

            @Override
            protected void addProviders() {
                this.addProviders(GLOBAL_PROVIDERS);
                CastingProvider<AFDatagramSocket> cpDatagramSocket = (fdc, desiredType) -> AFDatagramSocket.newInstance(config.datagramSocketConstructor(), fdc.getFileDescriptor(), fdc.localPort, fdc.remotePort);
                this.addProvider(datagramSocketClass, cpDatagramSocket);
                this.addProvider(config.datagramChannelClass(), (fdc, desiredType) -> cpDatagramSocket.provideAs(fdc, AFDatagramSocket.class).getChannel());
            }
        });
    }

    public static FileDescriptorCast using(FileDescriptor fdObj) throws IOException {
        Class<Object> primaryType;
        if (!fdObj.valid()) {
            throw new IOException("Not a valid file descriptor");
        }
        Class<?> clazz = primaryType = NativeUnixSocket.isLoaded() ? NativeUnixSocket.primaryType(fdObj) : null;
        if (primaryType == null) {
            primaryType = FileDescriptor.class;
        }
        FileDescriptorCast.triggerInit();
        CastingProviderMap map = PRIMARY_TYPE_PROVIDERS_MAP.get(primaryType);
        return new FileDescriptorCast(fdObj, map == null ? GLOBAL_PROVIDERS : map);
    }

    private static void triggerInit() {
        AFUNIXSocketAddress.addressFamily().getClass();
        AFTIPCSocketAddress.addressFamily().getClass();
    }

    public FileDescriptorCast withLocalPort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException();
        }
        this.localPort = port;
        return this;
    }

    public FileDescriptorCast withRemotePort(int port) {
        if (port < 0) {
            throw new IllegalArgumentException();
        }
        this.remotePort = port;
        return this;
    }

    public <K> @NonNull K as(Class<K> desiredType) throws IOException {
        Objects.requireNonNull(desiredType);
        CastingProvider<K> provider = this.cpm.get(desiredType);
        if (provider != null) {
            K obj = desiredType.cast(provider.provideAs(this, desiredType));
            Objects.requireNonNull(obj);
            return obj;
        }
        throw new ClassCastException("Cannot access file descriptor as " + desiredType);
    }

    public boolean isAvailable(Class<?> desiredType) throws IOException {
        return this.cpm.providers.containsKey(desiredType);
    }

    public Set<Class<?>> availableTypes() {
        return this.cpm.classes;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public FileDescriptor getFileDescriptor() {
        return this.fdObj;
    }

    private static abstract class CastingProviderMap {
        private final Map<Class<?>, CastingProvider<?>> providers = new HashMap();
        private final Set<Class<?>> classes = Collections.unmodifiableSet(this.providers.keySet());

        protected CastingProviderMap() {
            this.addProviders();
            this.addProviders(GLOBAL_PROVIDERS_FINAL);
        }

        protected abstract void addProviders();

        protected final <T> void addProvider(Class<T> type2, CastingProvider<?> cp) {
            Objects.requireNonNull(type2);
            this.addProvider0(type2, cp);
        }

        private void addProvider0(Class<?> type2, CastingProvider<?> cp) {
            if (this.providers.put(type2, cp) != cp) {
                for (Class<?> cl : type2.getInterfaces()) {
                    this.addProvider0(cl, cp);
                }
                Class<?> scl = type2.getSuperclass();
                if (scl != null) {
                    this.addProvider0(scl, cp);
                }
            }
        }

        protected final void addProviders(CastingProviderMap other) {
            if (other == null || other == this) {
                return;
            }
            this.providers.putAll(other.providers);
        }

        public <T> CastingProvider<? extends T> get(Class<T> desiredType) {
            return this.providers.get(desiredType);
        }
    }

    @FunctionalInterface
    private static interface CastingProvider<T> {
        public T provideAs(FileDescriptorCast var1, Class<? super T> var2) throws IOException;
    }

    private static final class LenientFileInputStream
    extends FileInputStream {
        private LenientFileInputStream(FileDescriptor fdObj) {
            super(fdObj);
        }

        @Override
        public int available() throws IOException {
            try {
                return super.available();
            }
            catch (IOException e) {
                String msg = e.getMessage();
                if ("Invalid seek".equals(msg)) {
                    return 0;
                }
                throw e;
            }
        }
    }
}

