/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data.entity;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.data.entity.EntityOpacityManager$onTick$;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.SkyHanniRenderEntityEvent;
import at.hannibal2.skyhanni.events.entity.EntityOpacityActiveEvent;
import at.hannibal2.skyhanni.events.entity.EntityOpacityEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniTickEvent;
import at.hannibal2.skyhanni.events.render.EntityRenderLayersEvent;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0011\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0014\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0017\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lat/hannibal2/skyhanni/data/entity/EntityOpacityManager;", "", "<init>", "()V", "", "onSecondPassed", "onTick", "Lnet/minecraft/entity/EntityLivingBase;", "entity", "", "canChangeOpacity", "(Lnet/minecraft/entity/EntityLivingBase;)Z", "", "opacity", "(Lnet/minecraft/entity/EntityLivingBase;)I", "Lat/hannibal2/skyhanni/events/SkyHanniRenderEntityEvent$Pre;", "event", "onPreRender", "(Lat/hannibal2/skyhanni/events/SkyHanniRenderEntityEvent$Pre;)V", "Lat/hannibal2/skyhanni/events/SkyHanniRenderEntityEvent$Post;", "onPostRender", "(Lat/hannibal2/skyhanni/events/SkyHanniRenderEntityEvent$Post;)V", "Lat/hannibal2/skyhanni/events/render/EntityRenderLayersEvent$Pre;", "onRender", "(Lat/hannibal2/skyhanni/events/render/EntityRenderLayersEvent$Pre;)V", "shouldHide", "Z", "", "entities", "Ljava/util/Map;", "active", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nEntityOpacityManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityOpacityManager.kt\nat/hannibal2/skyhanni/data/entity/EntityOpacityManager\n+ 2 EntityUtils.kt\nat/hannibal2/skyhanni/utils/EntityUtils\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,91:1\n142#2,4:92\n180#2:96\n477#3:97\n*S KotlinDebug\n*F\n+ 1 EntityOpacityManager.kt\nat/hannibal2/skyhanni/data/entity/EntityOpacityManager\n*L\n36#1:92,4\n36#1:96\n36#1:97\n*E\n"})
public final class EntityOpacityManager {
    @NotNull
    public static final EntityOpacityManager INSTANCE = new EntityOpacityManager();
    private static boolean shouldHide;
    @NotNull
    private static Map<EntityLivingBase, Integer> entities;
    private static boolean active;

    private EntityOpacityManager() {
    }

    @HandleEvent(eventType=SecondPassedEvent.class)
    public final void onSecondPassed() {
        EntityOpacityActiveEvent event = new EntityOpacityActiveEvent();
        event.post();
        active = event.isActive();
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(eventType=SkyHanniTickEvent.class, onlyOnSkyblock=true)
    public final void onTick() {
        void this_$iv$iv;
        void this_$iv;
        if (!active) {
            return;
        }
        Map entities = new LinkedHashMap();
        EntityUtils entityUtils = EntityUtils.INSTANCE;
        double radius$iv = 80.0;
        boolean $i$f$getEntitiesNextToPlayer = false;
        void var7_6 = this_$iv;
        LorenzVec location$iv$iv = LocationUtils.INSTANCE.playerLocation();
        boolean $i$f$getEntitiesNearby = false;
        void this_$iv$iv$iv = this_$iv$iv;
        boolean $i$f$getEntities = false;
        Sequence<Entity> $this$filterIsInstance$iv$iv$iv$iv = this_$iv$iv$iv.getAllEntities();
        boolean $i$f$filterIsInstance = false;
        Sequence<Entity> sequence2 = SequencesKt.filter($this$filterIsInstance$iv$iv$iv$iv, onTick$$inlined$getEntitiesNextToPlayer$1.INSTANCE);
        Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Iterator<Entity> iterator2 = SequencesKt.filter(sequence2, (Function1)new Function1<EntityLivingBase, Boolean>(location$iv$iv, radius$iv){
            final /* synthetic */ LorenzVec $location;
            final /* synthetic */ double $radius;
            {
                this.$location = $location;
                this.$radius = $radius;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Boolean invoke(Entity it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return LocationUtils.INSTANCE.distanceTo(it, this.$location) < this.$radius;
            }
        }).iterator();
        while (iterator2.hasNext()) {
            EntityLivingBase entity = (EntityLivingBase)iterator2.next();
            EntityOpacityEvent<EntityLivingBase> event = new EntityOpacityEvent<EntityLivingBase>(entity);
            event.post();
            Integer n = event.getOpacity();
            if (n == null) continue;
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = it;
            entities.put(entity, n2);
        }
        EntityOpacityManager.entities = entities;
    }

    private final boolean canChangeOpacity(EntityLivingBase entity) {
        EntityLivingBase[] entityLivingBaseArray = new EntityLivingBase[]{entity};
        return CollectionUtils.INSTANCE.containsKeys(entities, entityLivingBaseArray) && this.opacity(entity) < 100;
    }

    private final int opacity(EntityLivingBase entity) {
        Integer n = entities.get(entity);
        if (n == null) {
            throw new IllegalStateException("can not read opacity bc not in map".toString());
        }
        return n;
    }

    @HandleEvent
    public final void onPreRender(@NotNull SkyHanniRenderEntityEvent.Pre<EntityLivingBase> event) {
        boolean canChangeOpacity;
        Intrinsics.checkNotNullParameter(event, "event");
        if (!active) {
            return;
        }
        shouldHide = canChangeOpacity = this.canChangeOpacity((EntityLivingBase)event.getEntity());
        if (!canChangeOpacity) {
            return;
        }
        int opacity = this.opacity((EntityLivingBase)event.getEntity());
        if (opacity <= 0) {
            event.cancel();
            return;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)opacity / 100.0f));
    }

    @HandleEvent
    public final void onPostRender(@NotNull SkyHanniRenderEntityEvent.Post<EntityLivingBase> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!active) {
            return;
        }
        if (!this.canChangeOpacity((EntityLivingBase)event.getEntity())) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
    }

    @HandleEvent
    public final void onRender(@NotNull EntityRenderLayersEvent.Pre<EntityLivingBase> event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!active) {
            return;
        }
        if (!this.canChangeOpacity((EntityLivingBase)event.getEntity())) {
            return;
        }
        if (!shouldHide) {
            return;
        }
        event.cancel();
    }

    static {
        entities = MapsKt.emptyMap();
    }
}

