/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.internal;

import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.opengl.GL11;

public class GlScissorStack {
    private static final LinkedList<Bounds> boundsStack = new LinkedList();

    public static boolean isEmpty() {
        return boundsStack.isEmpty();
    }

    public static void push(int left, int top, int right, int bottom, ScaledResolution scaledResolution, boolean bypassInclusion) {
        int temp;
        if (right < left) {
            temp = right;
            right = left;
            left = temp;
        }
        if (bottom < top) {
            temp = bottom;
            bottom = top;
            top = temp;
        }
        if (boundsStack.isEmpty() || bypassInclusion) {
            boundsStack.push(new Bounds(left, top, right, bottom));
        } else {
            boundsStack.push(boundsStack.peek().createSubBound(left, top, right, bottom));
        }
        if (!boundsStack.isEmpty()) {
            boundsStack.peek().set(scaledResolution);
        }
        GL11.glEnable((int)3089);
    }

    public static void refresh(ScaledResolution scaledResolution) {
        if (!boundsStack.isEmpty()) {
            boundsStack.peek().set(scaledResolution);
            GL11.glEnable((int)3089);
        } else {
            GL11.glDisable((int)3089);
        }
    }

    public static void pop(ScaledResolution scaledResolution) {
        if (!boundsStack.isEmpty()) {
            boundsStack.pop();
        }
        if (boundsStack.isEmpty()) {
            GL11.glDisable((int)3089);
        } else {
            boundsStack.peek().set(scaledResolution);
        }
    }

    public static void clear() {
        boundsStack.clear();
        GL11.glDisable((int)3089);
    }

    private static class Bounds {
        int left;
        int top;
        int right;
        int bottom;

        public Bounds(int left, int top, int right, int bottom) {
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }

        public Bounds createSubBound(int left, int top, int right, int bottom) {
            left = Math.max(left, this.left);
            top = Math.max(top, this.top);
            right = Math.min(right, this.right);
            if (top > (bottom = Math.min(bottom, this.bottom))) {
                top = bottom;
            }
            if (left > right) {
                left = right;
            }
            return new Bounds(left, top, right, bottom);
        }

        public void set(ScaledResolution scaledResolution) {
            int height = Minecraft.func_71410_x().field_71440_d;
            int scale = scaledResolution.func_78325_e();
            GL11.glScissor((int)(this.left * scale), (int)(height - this.bottom * scale), (int)((this.right - this.left) * scale), (int)((this.bottom - this.top) * scale));
        }
    }
}

