/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.combat.damageindicator;

import at.hannibal2.skyhanni.data.ElectionApi;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.features.combat.damageindicator.BossType;
import at.hannibal2.skyhanni.features.combat.damageindicator.DamageIndicatorManager;
import at.hannibal2.skyhanni.features.combat.damageindicator.EntityResult;
import at.hannibal2.skyhanni.features.combat.damageindicator.MobFinder$findGuardians$;
import at.hannibal2.skyhanni.features.dungeon.DungeonApi;
import at.hannibal2.skyhanni.features.dungeon.DungeonLividFinder;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.features.garden.pests.PestType;
import at.hannibal2.skyhanni.features.rift.RiftApi;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityWolf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\bJ\u0019\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\bJ\u0019\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\bJ\u0019\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\bJ\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\bJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000f\u0010\bJ\u0019\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\bJ\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\bJ\u0019\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\bJ\u0019\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0013\u0010\bJ\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\bJ\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0015\u0010\bJ\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0016\u0010\bJ\u0019\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0017\u0010\bJ\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0018\u0010\bJ\u0019\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0019\u0010\bJ\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\bJ\u0019\u0010\u001b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001b\u0010\bJ\u0019\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001c\u0010\bJ\u0019\u0010\u001d\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001d\u0010\bJ\u0019\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001e\u0010\bJ\u0019\u0010\u001f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001f\u0010\bJ\u0019\u0010 \u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b \u0010\bJ\u0019\u0010!\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b!\u0010\bJ\u0019\u0010\"\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\"\u0010\bJ#\u0010(\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%2\u0006\u0010$\u001a\u00020#H\u0002\u00a2\u0006\u0004\b(\u0010)J\u0015\u0010-\u001a\u00020,2\u0006\u0010+\u001a\u00020*\u00a2\u0006\u0004\b-\u0010.J\u0015\u00100\u001a\u00020,2\u0006\u0010$\u001a\u00020/\u00a2\u0006\u0004\b0\u00101J\u000f\u00102\u001a\u00020,H\u0002\u00a2\u0006\u0004\b2\u0010\u0003J\u000f\u00103\u001a\u00020,H\u0002\u00a2\u0006\u0004\b3\u0010\u0003R\u0016\u00105\u001a\u0002048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0016\u00108\u001a\u0002078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0016\u0010:\u001a\u0002048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u00106R\u0016\u0010;\u001a\u0002078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u00109R\u0016\u0010<\u001a\u0002048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u00106R\u0016\u0010=\u001a\u0002078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u00109R\u001a\u0010@\u001a\b\u0012\u0004\u0012\u00020?0>8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b@\u0010AR\u0016\u0010B\u001a\u0002048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u00106R\u0016\u0010C\u001a\u0002078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bC\u00109R\u0016\u0010D\u001a\u0002048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bD\u00106R\u0016\u0010E\u001a\u0002078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u00109R\u001a\u0010G\u001a\b\u0012\u0004\u0012\u00020F0>8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bG\u0010AR\u0016\u0010H\u001a\u0002048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bH\u00106R\u0016\u0010I\u001a\u0002078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bI\u00109R\u0016\u0010J\u001a\u0002048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u00106R\u0016\u0010K\u001a\u0002078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bK\u00109R\u0016\u0010L\u001a\u0002048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bL\u00106R\u0018\u0010M\u001a\u0004\u0018\u00010F8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u0018\u0010O\u001a\u0004\u0018\u00010?8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bO\u0010PR\u0016\u0010Q\u001a\u0002078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bQ\u00109R\u0014\u0010S\u001a\u00020R8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bS\u0010TR\u0016\u0010U\u001a\u0002048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bU\u00106R\u0016\u0010V\u001a\u0002078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bV\u00109R,\u0010Y\u001a\u001a\u0012\u0004\u0012\u00020X\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%0W8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bY\u0010ZR\u0016\u0010[\u001a\u0002048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b[\u00106R\u0016\u0010\\\u001a\u0002078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\\\u00109\u00a8\u0006]"}, d2={"Lat/hannibal2/skyhanni/features/combat/damageindicator/MobFinder;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/data/mob/Mob;", "mob", "Lat/hannibal2/skyhanni/features/combat/damageindicator/EntityResult;", "tryAdd$1_8_9", "(Lat/hannibal2/skyhanni/data/mob/Mob;)Lat/hannibal2/skyhanni/features/combat/damageindicator/EntityResult;", "tryAdd", "tryAddGarden", "tryAddGardenPest", "tryAddDungeon", "tryAddDungeonF1", "tryAddDungeonF2", "tryAddDungeonF3", "tryAddDungeonF4", "tryAddDungeonF5", "tryAddDungeonF6", "tryAddRift", "tryAddEntityBlaze", "tryAddEntitySkeleton", "tryAddEntityOtherPlayerMP", "tryAddEntityWither", "tryAddEntityEnderman", "tryAddEntityDragon", "tryAddEntityIronGolem", "tryAddEntityZombie", "tryAddEntityMagmaCube", "tryAddEntityHorse", "tryAddEntityPigZombie", "tryAddEntitySpider", "checkArachne", "tryAddEntityWolf", "tryAddEntityGuardian", "Lnet/minecraft/entity/monster/EntityGiantZombie;", "entity", "Lkotlin/Pair;", "Lkotlin/time/Duration;", "Lat/hannibal2/skyhanni/features/combat/damageindicator/BossType;", "checkExtraF6GiantsDelay", "(Lnet/minecraft/entity/monster/EntityGiantZombie;)Lkotlin/Pair;", "", "message", "", "handleChat", "(Ljava/lang/String;)V", "Lnet/minecraft/entity/Entity;", "handleNewEntity", "(Lnet/minecraft/entity/Entity;)V", "findGuardians", "calcGuardiansTotalHealth", "", "floor1bonzo1", "Z", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "floor1bonzo1SpawnTime", "J", "floor1bonzo2", "floor1bonzo2SpawnTime", "floor2summons1", "floor2summons1SpawnTime", "", "Lnet/minecraft/client/entity/EntityOtherPlayerMP;", "floor2summonsDiedOnce", "Ljava/util/List;", "floor2secondPhase", "floor2secondPhaseSpawnTime", "floor3GuardianShield", "floor3GuardianShieldSpawnTime", "Lnet/minecraft/entity/monster/EntityGuardian;", "guardians", "floor3Professor", "floor3ProfessorSpawnTime", "floor3ProfessorGuardianPrepare", "floor3ProfessorGuardianPrepareSpawnTime", "floor3ProfessorGuardian", "floor3ProfessorGuardianEntity", "Lnet/minecraft/entity/monster/EntityGuardian;", "floor5lividEntity", "Lnet/minecraft/client/entity/EntityOtherPlayerMP;", "floor5lividEntitySpawnTime", "Ljava/util/regex/Pattern;", "correctLividPattern", "Ljava/util/regex/Pattern;", "floor6Giants", "floor6GiantsSpawnTime", "", "Ljava/util/UUID;", "floor6GiantsSeparateDelay", "Ljava/util/Map;", "floor6Sadan", "floor6SadanSpawnTime", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nMobFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobFinder.kt\nat/hannibal2/skyhanni/features/combat/damageindicator/MobFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 5 EntityUtils.kt\nat/hannibal2/skyhanni/utils/EntityUtils\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,624:1\n295#2,2:625\n1#3:627\n1#3:629\n8#4:628\n180#5:630\n477#6:631\n*S KotlinDebug\n*F\n+ 1 MobFinder.kt\nat/hannibal2/skyhanni/features/combat/damageindicator/MobFinder\n*L\n127#1:625,2\n581#1:629\n581#1:628\n596#1:630\n596#1:631\n*E\n"})
public final class MobFinder {
    private boolean floor1bonzo1;
    private long floor1bonzo1SpawnTime = SimpleTimeMark.Companion.farPast();
    private boolean floor1bonzo2;
    private long floor1bonzo2SpawnTime = SimpleTimeMark.Companion.farPast();
    private boolean floor2summons1;
    private long floor2summons1SpawnTime = SimpleTimeMark.Companion.farPast();
    @NotNull
    private final List<EntityOtherPlayerMP> floor2summonsDiedOnce = new ArrayList();
    private boolean floor2secondPhase;
    private long floor2secondPhaseSpawnTime = SimpleTimeMark.Companion.farPast();
    private boolean floor3GuardianShield;
    private long floor3GuardianShieldSpawnTime = SimpleTimeMark.Companion.farPast();
    @NotNull
    private final List<EntityGuardian> guardians = new ArrayList();
    private boolean floor3Professor;
    private long floor3ProfessorSpawnTime = SimpleTimeMark.Companion.farPast();
    private boolean floor3ProfessorGuardianPrepare;
    private long floor3ProfessorGuardianPrepareSpawnTime = SimpleTimeMark.Companion.farPast();
    private boolean floor3ProfessorGuardian;
    @Nullable
    private EntityGuardian floor3ProfessorGuardianEntity;
    @Nullable
    private EntityOtherPlayerMP floor5lividEntity;
    private long floor5lividEntitySpawnTime = SimpleTimeMark.Companion.farPast();
    @NotNull
    private final Pattern correctLividPattern;
    private boolean floor6Giants;
    private long floor6GiantsSpawnTime;
    @NotNull
    private final Map<UUID, Pair<Duration, BossType>> floor6GiantsSeparateDelay;
    private boolean floor6Sadan;
    private long floor6SadanSpawnTime;

    public MobFinder() {
        String string = "\u00a7c\\[BOSS] (.*) Livid\u00a7r\u00a7f: Impossible! How did you figure out which one I was\\?!";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        this.correctLividPattern = pattern;
        this.floor6GiantsSpawnTime = SimpleTimeMark.Companion.farPast();
        this.floor6GiantsSeparateDelay = new LinkedHashMap();
        this.floor6SadanSpawnTime = SimpleTimeMark.Companion.farPast();
    }

    @Nullable
    public final EntityResult tryAdd$1_8_9(@NotNull Mob mob) {
        EntityLivingBase entity;
        Intrinsics.checkNotNullParameter(mob, "mob");
        return DungeonApi.INSTANCE.inDungeon() ? this.tryAddDungeon(mob) : (RiftApi.INSTANCE.inRift() ? this.tryAddRift(mob) : (GardenApi.INSTANCE.inGarden() ? this.tryAddGarden(mob) : (Intrinsics.areEqual(mob.getName(), "Dummy") ? new EntityResult(null, false, false, BossType.DUMMY, 7, null) : ((entity = mob.getBaseEntity()) instanceof EntityOtherPlayerMP ? this.tryAddEntityOtherPlayerMP(mob) : (entity instanceof EntityIronGolem ? this.tryAddEntityIronGolem(mob) : (entity instanceof EntityPigZombie ? this.tryAddEntityPigZombie(mob) : (entity instanceof EntityMagmaCube ? this.tryAddEntityMagmaCube(mob) : (entity instanceof EntityEnderman ? this.tryAddEntityEnderman(mob) : (entity instanceof EntitySkeleton ? this.tryAddEntitySkeleton(mob) : (entity instanceof EntityGuardian ? this.tryAddEntityGuardian(mob) : (entity instanceof EntityZombie ? this.tryAddEntityZombie(mob) : (entity instanceof EntityWither ? this.tryAddEntityWither(mob) : (entity instanceof EntityDragon ? this.tryAddEntityDragon(mob) : (entity instanceof EntitySpider ? this.tryAddEntitySpider(mob) : (entity instanceof EntityHorse ? this.tryAddEntityHorse(mob) : (entity instanceof EntityBlaze ? this.tryAddEntityBlaze(mob) : (entity instanceof EntityWolf ? this.tryAddEntityWolf(mob) : null)))))))))))))))));
    }

    private final EntityResult tryAddGarden(Mob mob) {
        EntityLivingBase entity = mob.getBaseEntity();
        if (entity instanceof EntitySilverfish || entity instanceof EntityBat) {
            return this.tryAddGardenPest(mob);
        }
        return null;
    }

    private final EntityResult tryAddGardenPest(Mob mob) {
        EntityResult entityResult;
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = PestType.Companion.getFilterableEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PestType it = (PestType)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual(mob.getName(), it.getDisplayName())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        PestType pestType = v0;
        if (pestType != null) {
            PestType it = pestType;
            boolean bl = false;
            entityResult = new EntityResult(null, false, false, it.getDamageIndicatorBoss(), 7, null);
        } else {
            entityResult = null;
        }
        return entityResult;
    }

    private final EntityResult tryAddDungeon(Mob mob) {
        EntityResult entityResult;
        String[] stringArray = new String[]{"F1", "M1"};
        if (DungeonApi.INSTANCE.isOneOf(stringArray)) {
            entityResult = this.tryAddDungeonF1(mob);
        } else {
            stringArray = new String[]{"F2", "M2"};
            if (DungeonApi.INSTANCE.isOneOf(stringArray)) {
                entityResult = this.tryAddDungeonF2(mob);
            } else {
                stringArray = new String[]{"F3", "M3"};
                if (DungeonApi.INSTANCE.isOneOf(stringArray)) {
                    entityResult = this.tryAddDungeonF3(mob);
                } else {
                    stringArray = new String[]{"F4", "M4"};
                    if (DungeonApi.INSTANCE.isOneOf(stringArray)) {
                        entityResult = this.tryAddDungeonF4(mob);
                    } else {
                        stringArray = new String[]{"F5", "M5"};
                        if (DungeonApi.INSTANCE.isOneOf(stringArray)) {
                            entityResult = this.tryAddDungeonF5(mob);
                        } else {
                            stringArray = new String[]{"F6", "M6"};
                            entityResult = DungeonApi.INSTANCE.isOneOf(stringArray) ? this.tryAddDungeonF6(mob) : null;
                        }
                    }
                }
            }
        }
        return entityResult;
    }

    private final EntityResult tryAddDungeonF1(Mob mob) {
        EntityResult entityResult;
        if (this.floor1bonzo1 && Intrinsics.areEqual(mob.getName(), "Bonzo")) {
            entityResult = new EntityResult(SimpleTimeMark.box-impl(this.floor1bonzo1SpawnTime), false, false, BossType.DUNGEON_F1_BONZO_FIRST, 6, null);
        } else if (this.floor1bonzo2 && Intrinsics.areEqual(mob.getName(), "Bonzo")) {
            long l = this.floor1bonzo2SpawnTime;
            BossType bossType = BossType.DUNGEON_F1_BONZO_SECOND;
            entityResult = new EntityResult(SimpleTimeMark.box-impl(l), false, true, bossType, 2, null);
        } else {
            entityResult = null;
        }
        return entityResult;
    }

    private final EntityResult tryAddDungeonF2(Mob mob) {
        EntityLivingBase entity = mob.getBaseEntity();
        if (Intrinsics.areEqual(entity.func_70005_c_(), "Summon ") && entity instanceof EntityOtherPlayerMP) {
            if (this.floor2summons1 && !this.floor2summonsDiedOnce.contains(entity)) {
                if ((int)((EntityOtherPlayerMP)entity).func_110143_aJ() != 0) {
                    return new EntityResult(SimpleTimeMark.box-impl(this.floor2summons1SpawnTime), false, false, BossType.DUNGEON_F2_SUMMON, 6, null);
                }
                this.floor2summonsDiedOnce.add((EntityOtherPlayerMP)entity);
            }
            if (this.floor2secondPhase) {
                return new EntityResult(SimpleTimeMark.box-impl(this.floor2secondPhaseSpawnTime), false, false, BossType.DUNGEON_F2_SUMMON, 6, null);
            }
        }
        if (this.floor2secondPhase && entity instanceof EntityOtherPlayerMP && Intrinsics.areEqual(((EntityOtherPlayerMP)entity).func_70005_c_(), "Scarf ")) {
            return new EntityResult(SimpleTimeMark.box-impl(this.floor2secondPhaseSpawnTime), false, true, BossType.DUNGEON_F2_SCARF, 2, null);
        }
        return null;
    }

    private final EntityResult tryAddDungeonF3(Mob mob) {
        EntityLivingBase entity = mob.getBaseEntity();
        if (entity instanceof EntityGuardian && this.floor3GuardianShield) {
            if (this.guardians.size() == 4) {
                this.calcGuardiansTotalHealth();
            } else {
                this.findGuardians();
            }
            if (this.guardians.contains(entity)) {
                return new EntityResult(SimpleTimeMark.box-impl(this.floor3GuardianShieldSpawnTime), true, false, BossType.DUNGEON_F3_GUARDIAN, 4, null);
            }
        }
        if (this.floor3Professor && Intrinsics.areEqual(mob.getName(), "The Professor")) {
            return new EntityResult(SimpleTimeMark.box-impl(this.floor3ProfessorSpawnTime), Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(this.floor3ProfessorSpawnTime), DurationKt.toDuration(1, DurationUnit.SECONDS)) > 0, false, BossType.DUNGEON_F3_PROFESSOR_1, 4, null);
        }
        if (this.floor3ProfessorGuardianPrepare && Intrinsics.areEqual(mob.getName(), "The Professor")) {
            return new EntityResult(SimpleTimeMark.box-impl(this.floor3ProfessorGuardianPrepareSpawnTime), true, false, BossType.DUNGEON_F3_PROFESSOR_2, 4, null);
        }
        if (entity instanceof EntityGuardian && this.floor3ProfessorGuardian && Intrinsics.areEqual(entity, this.floor3ProfessorGuardianEntity)) {
            return new EntityResult(null, false, true, BossType.DUNGEON_F3_PROFESSOR_2, 3, null);
        }
        return null;
    }

    private final EntityResult tryAddDungeonF4(Mob mob) {
        if (mob.getBaseEntity() instanceof EntityGhast) {
            BossType bossType = BossType.DUNGEON_F4_THORN;
            return new EntityResult(null, true, true, bossType, 1, null);
        }
        return null;
    }

    private final EntityResult tryAddDungeonF5(Mob mob) {
        if (Intrinsics.areEqual(mob.getBaseEntity(), DungeonLividFinder.INSTANCE.getLivid())) {
            BossType bossType = BossType.DUNGEON_F5;
            return new EntityResult(null, true, true, bossType, 1, null);
        }
        return null;
    }

    private final EntityResult tryAddDungeonF6(Mob mob) {
        EntityLivingBase entity = mob.getBaseEntity();
        if (!(entity instanceof EntityGiantZombie) || ((EntityGiantZombie)entity).func_82150_aj()) {
            return null;
        }
        if (this.floor6Giants && entity.field_70163_u > 68.0) {
            Pair<Duration, BossType> pair = this.checkExtraF6GiantsDelay((EntityGiantZombie)entity);
            long extraDelay = pair.component1().unbox-impl();
            BossType bossType = pair.component2();
            return new EntityResult(SimpleTimeMark.box-impl(SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.plus-qeHQSLg(this.floor6GiantsSpawnTime, extraDelay), DurationKt.toDuration(5, DurationUnit.SECONDS))), Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(this.floor6GiantsSpawnTime), extraDelay) > 0, false, bossType, 4, null);
        }
        if (this.floor6Sadan) {
            long l = this.floor6SadanSpawnTime;
            BossType bossType = BossType.DUNGEON_F6_SADAN;
            return new EntityResult(SimpleTimeMark.box-impl(l), true, true, bossType, null);
        }
        return null;
    }

    private final EntityResult tryAddRift(Mob mob) {
        EntityResult entityResult;
        switch (mob.getName()) {
            case "Leech Supreme": {
                entityResult = new EntityResult(null, false, false, BossType.LEECH_SUPREME, 7, null);
                break;
            }
            case "Bloodfiend ": {
                EntityLivingBase entity = mob.getBaseEntity();
                int hp = ElectionApi.INSTANCE.ignoreDerpy(EntityUtils.INSTANCE.getBaseMaxHealth(entity));
                if (EntityUtils.INSTANCE.hasMaxHealth(entity, 625, true, hp)) {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_BLOODFIEND_1, 7, null);
                    break;
                }
                if (EntityUtils.INSTANCE.hasMaxHealth(entity, 1100, true, hp)) {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_BLOODFIEND_2, 7, null);
                    break;
                }
                if (EntityUtils.INSTANCE.hasMaxHealth(entity, 1800, true, hp)) {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_BLOODFIEND_3, 7, null);
                    break;
                }
                if (EntityUtils.INSTANCE.hasMaxHealth(entity, 2400, true, hp)) {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_BLOODFIEND_4, 7, null);
                    break;
                }
                if (EntityUtils.INSTANCE.hasMaxHealth(entity, 3000, true, hp)) {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_BLOODFIEND_5, 7, null);
                    break;
                }
                entityResult = null;
                break;
            }
            case "Bacte": {
                entityResult = new EntityResult(null, false, false, BossType.BACTE, 7, null);
                break;
            }
            case "Sun Gecko": {
                entityResult = new EntityResult(null, false, false, BossType.SUN_GECKO, 7, null);
                break;
            }
            default: {
                entityResult = null;
            }
        }
        return entityResult;
    }

    private final EntityResult tryAddEntityBlaze(Mob mob) {
        EntityResult entityResult;
        String string = mob.getName();
        if (Intrinsics.areEqual(string, "Ashfang")) {
            entityResult = new EntityResult(null, false, false, BossType.NETHER_ASHFANG, 7, null);
        } else if (Intrinsics.areEqual(string, "Inferno Demonlord")) {
            switch (mob.getLevelOrTier()) {
                case 1: {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_BLAZE_1, 7, null);
                    break;
                }
                case 2: {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_BLAZE_2, 7, null);
                    break;
                }
                case 3: {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_BLAZE_3, 7, null);
                    break;
                }
                case 4: {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_BLAZE_4, 7, null);
                    break;
                }
                default: {
                    entityResult = null;
                    break;
                }
            }
        } else {
            entityResult = null;
        }
        return entityResult;
    }

    private final EntityResult tryAddEntitySkeleton(Mob mob) {
        if (StringsKt.contains$default((CharSequence)mob.getName(), "\u24c6\u24ca\u24b6\u24cf\u24be\u24be", false, 2, null)) {
            EntityLivingBase entity = mob.getBaseEntity();
            return EntityUtils.INSTANCE.hasBossHealth(entity, 10000000) ? new EntityResult(null, false, false, BossType.SLAYER_BLAZE_QUAZII_4, 7, null) : (EntityUtils.INSTANCE.hasBossHealth(entity, 5000000) ? new EntityResult(null, false, false, BossType.SLAYER_BLAZE_QUAZII_3, 7, null) : (EntityUtils.INSTANCE.hasBossHealth(entity, 1750000) ? new EntityResult(null, false, false, BossType.SLAYER_BLAZE_QUAZII_2, 7, null) : (EntityUtils.INSTANCE.hasBossHealth(entity, 500000) ? new EntityResult(null, false, false, BossType.SLAYER_BLAZE_QUAZII_1, 7, null) : null)));
        }
        return Intrinsics.areEqual(mob.getName(), "Bladesoul") ? new EntityResult(null, false, false, BossType.NETHER_BLADESOUL, 7, null) : null;
    }

    private final EntityResult tryAddEntityOtherPlayerMP(Mob mob) {
        EntityResult entityResult;
        switch (mob.getName()) {
            case "Mage Outlaw": {
                entityResult = new EntityResult(null, false, false, BossType.NETHER_MAGE_OUTLAW, 7, null);
                break;
            }
            case "DukeBarb": {
                entityResult = new EntityResult(null, false, false, BossType.NETHER_BARBARIAN_DUKE, 7, null);
                break;
            }
            case "Minos Inquisitor": {
                entityResult = new EntityResult(null, false, false, BossType.MINOS_INQUISITOR, 7, null);
                break;
            }
            case "Minos Champion": {
                entityResult = new EntityResult(null, false, false, BossType.MINOS_CHAMPION, 7, null);
                break;
            }
            case "Minotaur ": {
                entityResult = new EntityResult(null, false, false, BossType.MINOTAUR, 7, null);
                break;
            }
            case "Ragnarok": {
                entityResult = new EntityResult(null, false, false, BossType.RAGNAROK, 7, null);
                break;
            }
            default: {
                entityResult = null;
            }
        }
        return entityResult;
    }

    private final EntityResult tryAddEntityWither(Mob mob) {
        return Intrinsics.areEqual(mob.getName(), "Vanquisher") ? new EntityResult(null, false, false, BossType.NETHER_VANQUISHER, 7, null) : null;
    }

    private final EntityResult tryAddEntityEnderman(Mob mob) {
        EntityResult entityResult;
        if (!Intrinsics.areEqual(mob.getName(), "Voidgloom Seraph")) {
            return null;
        }
        switch (mob.getLevelOrTier()) {
            case 1: {
                entityResult = new EntityResult(null, false, false, BossType.SLAYER_ENDERMAN_1, 7, null);
                break;
            }
            case 2: {
                entityResult = new EntityResult(null, false, false, BossType.SLAYER_ENDERMAN_2, 7, null);
                break;
            }
            case 3: {
                entityResult = new EntityResult(null, false, false, BossType.SLAYER_ENDERMAN_3, 7, null);
                break;
            }
            case 4: {
                entityResult = new EntityResult(null, false, false, BossType.SLAYER_ENDERMAN_4, 7, null);
                break;
            }
            default: {
                entityResult = null;
            }
        }
        return entityResult;
    }

    private final EntityResult tryAddEntityDragon(Mob mob) {
        return IslandType.THE_END.isCurrent() ? new EntityResult(null, false, false, BossType.END_ENDER_DRAGON, 7, null) : (IslandType.WINTER.isCurrent() ? new EntityResult(null, false, false, BossType.WINTER_REINDRAKE, 7, null) : null);
    }

    private final EntityResult tryAddEntityIronGolem(Mob mob) {
        return Intrinsics.areEqual(mob.getName(), "Endstone Protector") ? new EntityResult(null, false, false, BossType.END_ENDSTONE_PROTECTOR, 7, null) : (EntityUtils.hasMaxHealth$default(EntityUtils.INSTANCE, mob.getBaseEntity(), 1500000, false, 0, 6, null) ? new EntityResult(null, false, false, BossType.GAIA_CONSTRUCT, 7, null) : (EntityUtils.hasMaxHealth$default(EntityUtils.INSTANCE, mob.getBaseEntity(), 100000000, false, 0, 6, null) ? new EntityResult(null, false, false, BossType.LORD_JAWBUS, 7, null) : null));
    }

    private final EntityResult tryAddEntityZombie(Mob mob) {
        EntityResult entityResult;
        String string = mob.getName();
        if (Intrinsics.areEqual(string, "Revenant Horror")) {
            switch (mob.getLevelOrTier()) {
                case 1: {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_ZOMBIE_1, 7, null);
                    break;
                }
                case 2: {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_ZOMBIE_2, 7, null);
                    break;
                }
                case 3: {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_ZOMBIE_3, 7, null);
                    break;
                }
                case 4: {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_ZOMBIE_4, 7, null);
                    break;
                }
                case 5: {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_ZOMBIE_5, 7, null);
                    break;
                }
                default: {
                    entityResult = null;
                    break;
                }
            }
        } else {
            entityResult = Intrinsics.areEqual(string, "Atoned Horror") ? new EntityResult(null, false, false, BossType.SLAYER_ZOMBIE_5, 7, null) : null;
        }
        return entityResult;
    }

    private final EntityResult tryAddEntityMagmaCube(Mob mob) {
        EntityResult entityResult;
        if (Intrinsics.areEqual(mob.getName(), "Magma Boss")) {
            BossType bossType = BossType.NETHER_MAGMA_BOSS;
            entityResult = new EntityResult(null, true, false, bossType, 5, null);
        } else {
            entityResult = null;
        }
        return entityResult;
    }

    private final EntityResult tryAddEntityHorse(Mob mob) {
        return Intrinsics.areEqual(mob.getName(), "Headless Horseman") ? new EntityResult(null, false, false, BossType.HUB_HEADLESS_HORSEMAN, 7, null) : null;
    }

    private final EntityResult tryAddEntityPigZombie(Mob mob) {
        EntityResult entityResult;
        if (StringsKt.contains$default((CharSequence)mob.getName(), "\u24c9\u24ce\u24c5\u24bd\u24c4\u24ba\u24ca\u24c8", false, 2, null)) {
            EntityLivingBase entity = mob.getBaseEntity();
            entityResult = EntityUtils.INSTANCE.hasBossHealth(entity, 10000000) ? new EntityResult(null, false, false, BossType.SLAYER_BLAZE_TYPHOEUS_4, 7, null) : (EntityUtils.INSTANCE.hasBossHealth(entity, 5000000) ? new EntityResult(null, false, false, BossType.SLAYER_BLAZE_TYPHOEUS_3, 7, null) : (EntityUtils.INSTANCE.hasBossHealth(entity, 1750000) ? new EntityResult(null, false, false, BossType.SLAYER_BLAZE_TYPHOEUS_2, 7, null) : (EntityUtils.INSTANCE.hasBossHealth(entity, 500000) ? new EntityResult(null, false, false, BossType.SLAYER_BLAZE_TYPHOEUS_1, 7, null) : null)));
        } else {
            entityResult = null;
        }
        return entityResult;
    }

    private final EntityResult tryAddEntitySpider(Mob mob) {
        if (Intrinsics.areEqual(mob.getName(), "Tarantula Broodfather")) {
            EntityResult entityResult;
            switch (mob.getLevelOrTier()) {
                case 1: {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_SPIDER_1, 7, null);
                    break;
                }
                case 2: {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_SPIDER_2, 7, null);
                    break;
                }
                case 3: {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_SPIDER_3, 7, null);
                    break;
                }
                case 4: {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_SPIDER_4, 7, null);
                    break;
                }
                case 5: {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_SPIDER_5_1, 7, null);
                    break;
                }
                default: {
                    entityResult = null;
                }
            }
            return entityResult;
        }
        if (Intrinsics.areEqual(mob.getName(), "Conjoined Brood")) {
            return new EntityResult(null, false, false, BossType.SLAYER_SPIDER_5_2, 7, null);
        }
        if (IslandType.SPIDER_DEN.isCurrent()) {
            if (Intrinsics.areEqual(mob.getName(), "Broodmother")) {
                return new EntityResult(null, false, false, BossType.BROODMOTHER, 7, null);
            }
            EntityResult entityResult = this.checkArachne(mob);
            if (entityResult != null) {
                EntityResult it = entityResult;
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    private final EntityResult checkArachne(Mob mob) {
        EntityResult entityResult;
        if (!Intrinsics.areEqual(mob.getName(), "Arachne")) {
            return null;
        }
        switch (mob.getLevelOrTier()) {
            case 300: {
                entityResult = new EntityResult(null, false, false, BossType.ARACHNE_SMALL, 7, null);
                break;
            }
            case 500: {
                entityResult = new EntityResult(null, false, false, BossType.ARACHNE_SMALL, 7, null);
                break;
            }
            default: {
                entityResult = null;
            }
        }
        return entityResult;
    }

    private final EntityResult tryAddEntityWolf(Mob mob) {
        EntityResult entityResult;
        if (Intrinsics.areEqual(mob.getName(), "Sven Packmaster")) {
            switch (mob.getLevelOrTier()) {
                case 1: {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_WOLF_1, 7, null);
                    break;
                }
                case 2: {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_WOLF_2, 7, null);
                    break;
                }
                case 3: {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_WOLF_3, 7, null);
                    break;
                }
                case 4: {
                    entityResult = new EntityResult(null, false, false, BossType.SLAYER_WOLF_4, 7, null);
                    break;
                }
                default: {
                    entityResult = null;
                    break;
                }
            }
        } else {
            entityResult = null;
        }
        return entityResult;
    }

    private final EntityResult tryAddEntityGuardian(Mob mob) {
        return EntityUtils.hasMaxHealth$default(EntityUtils.INSTANCE, mob.getBaseEntity(), 35000000, false, 0, 6, null) ? new EntityResult(null, false, false, BossType.THUNDER, 7, null) : null;
    }

    private final Pair<Duration, BossType> checkExtraF6GiantsDelay(EntityGiantZombie entity) {
        UUID uuid = entity.func_110124_au();
        Pair<Duration, BossType> pair = this.floor6GiantsSeparateDelay.get(uuid);
        if (pair != null) {
            Pair<Duration, BossType> it = pair;
            boolean bl = false;
            return it;
        }
        LorenzVec middle = new LorenzVec(-8, 0, 56);
        LorenzVec loc = LorenzVecKt.getLorenzVec((Entity)entity);
        int pos = 0;
        BossType type2 = null;
        if (loc.getX() > middle.getX() && loc.getZ() > middle.getZ()) {
            pos = 2;
            type2 = BossType.DUNGEON_F6_GIANT_3;
        } else if (loc.getX() > middle.getX() && loc.getZ() < middle.getZ()) {
            pos = 3;
            type2 = BossType.DUNGEON_F6_GIANT_4;
        } else if (loc.getX() < middle.getX() && loc.getZ() < middle.getZ()) {
            pos = 0;
            type2 = BossType.DUNGEON_F6_GIANT_1;
        } else if (loc.getX() < middle.getX() && loc.getZ() > middle.getZ()) {
            pos = 1;
            type2 = BossType.DUNGEON_F6_GIANT_2;
        } else {
            pos = 0;
            type2 = BossType.DUNGEON_F6_GIANT_1;
        }
        long extraDelay = Duration.times-UwyO8pc(DurationKt.toDuration(900, DurationUnit.MILLISECONDS), pos);
        Pair<Duration, BossType> pair2 = TuplesKt.to(Duration.box-impl(extraDelay), type2);
        this.floor6GiantsSeparateDelay.put(uuid, pair2);
        return pair2;
    }

    public final void handleChat(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (!DungeonApi.INSTANCE.inDungeon()) {
            return;
        }
        switch (message) {
            case "\u00a7c[BOSS] Bonzo\u00a7r\u00a7f: Gratz for making it this far, but I'm basically unbeatable.": {
                this.floor1bonzo1 = true;
                this.floor1bonzo1SpawnTime = SimpleTimeMark.Companion.fromNow-qeHQSLg(DurationKt.toDuration(11.25, DurationUnit.SECONDS));
                break;
            }
            case "\u00a7c[BOSS] Bonzo\u00a7r\u00a7f: Oh noes, you got me.. what ever will I do?!": {
                this.floor1bonzo1 = false;
                break;
            }
            case "\u00a7c[BOSS] Bonzo\u00a7r\u00a7f: Oh I'm dead!": {
                this.floor1bonzo2 = true;
                this.floor1bonzo2SpawnTime = SimpleTimeMark.Companion.fromNow-qeHQSLg(DurationKt.toDuration(4.2, DurationUnit.SECONDS));
                break;
            }
            case "\u00a7c[BOSS] Bonzo\u00a7r\u00a7f: Alright, maybe I'm just weak after all..": {
                this.floor1bonzo2 = false;
                break;
            }
            case "\u00a7c[BOSS] Scarf\u00a7r\u00a7f: ARISE, MY CREATIONS!": {
                this.floor2summons1 = true;
                this.floor2summons1SpawnTime = SimpleTimeMark.Companion.fromNow-qeHQSLg(DurationKt.toDuration(3.5, DurationUnit.SECONDS));
                break;
            }
            case "\u00a7c[BOSS] Scarf\u00a7r\u00a7f: Those toys are not strong enough I see.": {
                this.floor2summons1 = false;
                break;
            }
            case "\u00a7c[BOSS] Scarf\u00a7r\u00a7f: Don't get too excited though.": {
                this.floor2secondPhase = true;
                this.floor2secondPhaseSpawnTime = SimpleTimeMark.Companion.fromNow-qeHQSLg(DurationKt.toDuration(6.3, DurationUnit.SECONDS));
                break;
            }
            case "\u00a7c[BOSS] Scarf\u00a7r\u00a7f: Whatever...": {
                this.floor2secondPhase = false;
                break;
            }
            case "\u00a7c[BOSS] The Professor\u00a7r\u00a7f: I was burdened with terrible news recently...": {
                this.floor3GuardianShield = true;
                this.floor3GuardianShieldSpawnTime = SimpleTimeMark.Companion.fromNow-qeHQSLg(DurationKt.toDuration(15.4, DurationUnit.SECONDS));
                break;
            }
            case "\u00a7c[BOSS] The Professor\u00a7r\u00a7f: Oh? You found my Guardians' one weakness?": {
                this.floor3GuardianShield = false;
                DamageIndicatorManager.INSTANCE.removeDamageIndicator(BossType.DUNGEON_F3_GUARDIAN);
                this.floor3Professor = true;
                this.floor3ProfessorSpawnTime = SimpleTimeMark.Companion.fromNow-qeHQSLg(DurationKt.toDuration(10.3, DurationUnit.SECONDS));
                break;
            }
            case "\u00a7c[BOSS] The Professor\u00a7r\u00a7f: I see. You have forced me to use my ultimate technique.": {
                this.floor3Professor = false;
                this.floor3ProfessorGuardianPrepare = true;
                this.floor3ProfessorGuardianPrepareSpawnTime = SimpleTimeMark.Companion.fromNow-qeHQSLg(DurationKt.toDuration(10.5, DurationUnit.SECONDS));
                break;
            }
            case "\u00a7c[BOSS] The Professor\u00a7r\u00a7f: The process is irreversible, but I'll be stronger than a Wither now!": {
                this.floor3ProfessorGuardian = true;
                break;
            }
            case "\u00a7c[BOSS] The Professor\u00a7r\u00a7f: What?! My Guardian power is unbeatable!": {
                this.floor3ProfessorGuardian = false;
                break;
            }
            case "\u00a7c[BOSS] Livid\u00a7r\u00a7f: This Orb you see, is Thorn, or what is left of him.": {
                this.floor5lividEntity = DungeonLividFinder.INSTANCE.getLivid();
                this.floor5lividEntitySpawnTime = SimpleTimeMark.Companion.fromNow-qeHQSLg(DurationKt.toDuration(13, DurationUnit.SECONDS));
                break;
            }
            case "\u00a7c[BOSS] Sadan\u00a7r\u00a7f: ENOUGH!": {
                this.floor6Giants = true;
                this.floor6GiantsSpawnTime = SimpleTimeMark.Companion.fromNow-qeHQSLg(DurationKt.toDuration(2.8, DurationUnit.SECONDS));
                break;
            }
            case "\u00a7c[BOSS] Sadan\u00a7r\u00a7f: You did it. I understand now, you have earned my respect.": {
                this.floor6Giants = false;
                this.floor6Sadan = true;
                this.floor6SadanSpawnTime = SimpleTimeMark.Companion.fromNow-qeHQSLg(DurationKt.toDuration(11.5, DurationUnit.SECONDS));
                break;
            }
            case "\u00a7c[BOSS] Sadan\u00a7r\u00a7f: NOOOOOOOOO!!! THIS IS IMPOSSIBLE!!": {
                this.floor6Sadan = false;
            }
        }
        Object object = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv = this.correctLividPattern;
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(message);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$handleChat_u24lambda_u244 = it$iv;
            boolean bl2 = false;
            this.floor5lividEntity = null;
        }
    }

    public final void handleNewEntity(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        if (DungeonApi.INSTANCE.inDungeon() && this.floor3ProfessorGuardian && entity instanceof EntityGuardian && this.floor3ProfessorGuardianEntity == null) {
            this.floor3ProfessorGuardianEntity = (EntityGuardian)entity;
            this.floor3ProfessorGuardianPrepare = false;
        }
    }

    private final void findGuardians() {
        this.guardians.clear();
        EntityUtils this_$iv = EntityUtils.INSTANCE;
        boolean $i$f$getEntities = false;
        Sequence<Entity> $this$filterIsInstance$iv$iv = this_$iv.getAllEntities();
        boolean $i$f$filterIsInstance = false;
        Sequence<Entity> sequence2 = SequencesKt.filter($this$filterIsInstance$iv$iv, findGuardians$$inlined$getEntities$1.INSTANCE);
        Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Iterator<Entity> iterator2 = sequence2.iterator();
        while (iterator2.hasNext()) {
            EntityGuardian entity = (EntityGuardian)iterator2.next();
            if (EntityUtils.hasMaxHealth$default(EntityUtils.INSTANCE, (EntityLivingBase)entity, 1000000, true, 0, 4, null) || EntityUtils.hasMaxHealth$default(EntityUtils.INSTANCE, (EntityLivingBase)entity, 1200000, true, 0, 4, null)) {
                this.guardians.add(entity);
            }
            if (EntityUtils.hasMaxHealth$default(EntityUtils.INSTANCE, (EntityLivingBase)entity, 120000000, true, 0, 4, null) || EntityUtils.hasMaxHealth$default(EntityUtils.INSTANCE, (EntityLivingBase)entity, 240000000, true, 0, 4, null)) {
                this.guardians.add(entity);
            }
            if (!EntityUtils.hasMaxHealth$default(EntityUtils.INSTANCE, (EntityLivingBase)entity, 140000000, true, 0, 4, null) && !EntityUtils.hasMaxHealth$default(EntityUtils.INSTANCE, (EntityLivingBase)entity, 280000000, true, 0, 4, null)) continue;
            this.guardians.add(entity);
        }
    }

    private final void calcGuardiansTotalHealth() {
        int totalHealth = 0;
        for (EntityGuardian guardian : this.guardians) {
            totalHealth += (int)guardian.func_110143_aJ();
        }
        if (totalHealth == 0) {
            this.floor3GuardianShield = false;
            this.guardians.clear();
        }
    }
}

