/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.dungeon;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.ItemClickEvent;
import at.hannibal2.skyhanni.events.ReceiveParticleEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.utils.BezierCurve;
import at.hannibal2.skyhanni.utils.BezierFitter;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0003J\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0003J\u000f\u0010\u0014\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0003J\u000f\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u001b\u0010\"\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u001b\u0010%\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u001f\u001a\u0004\b$\u0010!R\u0016\u0010'\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0016\u0010)\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010(R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0018\u0010.\u001a\u0004\u0018\u00010-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0018\u00101\u001a\u0004\u0018\u0001008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0014\u00104\u001a\u0002038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105\u00a8\u00066"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonSecretTrackerLocator;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;", "event", "", "onReceiveParticle", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChatMessage", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "repredictPoint", "Lat/hannibal2/skyhanni/events/ItemClickEvent;", "onUseAbility", "(Lat/hannibal2/skyhanni/events/ItemClickEvent;)V", "onWorldChange", "reset", "", "isEnabled", "()Z", "getConfig", "config", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "secretTrackerMessagePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getSecretTrackerMessagePattern", "()Ljava/util/regex/Pattern;", "secretTrackerMessagePattern", "noMissingSecretsPattern$delegate", "getNoMissingSecretsPattern", "noMissingSecretsPattern", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastParticle", "J", "lastAbilityUse", "Lat/hannibal2/skyhanni/utils/BezierFitter;", "bezierFitter", "Lat/hannibal2/skyhanni/utils/BezierFitter;", "", "secretDistance", "Ljava/lang/Integer;", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "secretLocation", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "SECRET_COMPASS", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nDungeonSecretTrackerLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonSecretTrackerLocator.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonSecretTrackerLocator\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n11#2:144\n1#3:145\n*S KotlinDebug\n*F\n+ 1 DungeonSecretTrackerLocator.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonSecretTrackerLocator\n*L\n98#1:144\n98#1:145\n*E\n"})
public final class DungeonSecretTrackerLocator {
    @NotNull
    public static final DungeonSecretTrackerLocator INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern secretTrackerMessagePattern$delegate;
    @NotNull
    private static final RepoPattern noMissingSecretsPattern$delegate;
    private static long lastParticle;
    private static long lastAbilityUse;
    @NotNull
    private static final BezierFitter bezierFitter;
    @Nullable
    private static Integer secretDistance;
    @Nullable
    private static LorenzVec secretLocation;
    @NotNull
    private static final NeuInternalName SECRET_COMPASS;

    private DungeonSecretTrackerLocator() {
    }

    private final boolean getConfig() {
        return SkyHanniMod.feature.getDungeon().getDungeonSecretCompass();
    }

    private final Pattern getSecretTrackerMessagePattern() {
        return (Pattern)secretTrackerMessagePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getNoMissingSecretsPattern() {
        return (Pattern)noMissingSecretsPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    @HandleEvent(onlyOnIsland=IslandType.CATACOMBS, receiveCancelled=true)
    public final void onReceiveParticle(@NotNull ReceiveParticleEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        EnumParticleTypes type2 = event.getType();
        if (type2 != EnumParticleTypes.VILLAGER_HAPPY) {
            return;
        }
        if (event.getCount() != 1 || !(event.getSpeed() == 0.0f)) {
            return;
        }
        lastParticle = SimpleTimeMark.Companion.now-uFjCsEo();
        LorenzVec currLoc = event.getLocation();
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastAbilityUse), DurationKt.toDuration(1, DurationUnit.SECONDS)) > 0) {
            return;
        }
        if (bezierFitter.isEmpty()) {
            bezierFitter.addPoint(currLoc);
            return;
        }
        LorenzVec lorenzVec = bezierFitter.getLastPoint();
        if (lorenzVec == null) {
            return;
        }
        double distToLast = lorenzVec.distance(currLoc);
        if (distToLast == 0.0 || distToLast > 1.0) {
            return;
        }
        bezierFitter.addPoint(currLoc);
        this.repredictPoint();
    }

    @HandleEvent(onlyOnIsland=IslandType.CATACOMBS)
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        LorenzVec lorenzVec = secretLocation;
        if (lorenzVec == null) {
            return;
        }
        LorenzVec location = lorenzVec;
        double distance = location.distance(WorldRenderUtils.INSTANCE.exactPlayerEyeLocation(event));
        if (distance > 3.0) {
            String formattedDistance = NumberUtil.INSTANCE.addSeparators((int)distance);
            WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event, location, "\u00a7d\u00a7lSECRET", 1.7, 0.0f, 0.0, 0.0, false, false, null, 504, null);
            WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event, location.add(0.0, -0.1 - distance / 20.4, 0.0), " \u00a7r\u00a7e" + formattedDistance + 'm', 1.0, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        } else {
            this.reset();
        }
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(onlyOnIsland=IslandType.CATACOMBS)
    public final void onChatMessage(@NotNull SkyHanniChatEvent event) {
        void $this$findMatcher$iv;
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getSecretTrackerMessagePattern();
        String text$iv = event.getMessage();
        boolean $i$f$findMatcher = false;
        Matcher it$iv = $this$findMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.find()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChatMessage_u24lambda_u240 = it$iv;
            boolean bl2 = false;
            String string = $this$onChatMessage_u24lambda_u240.group("distance");
            Intrinsics.checkNotNullExpressionValue(string, "group(...)");
            int distance1 = Integer.parseInt(string);
            String string2 = RegexUtils.INSTANCE.groupOrNull($this$onChatMessage_u24lambda_u240, "distance2");
            int distance2 = string2 != null ? Integer.parseInt(string2) : 0;
            secretDistance = (int)Math.sqrt(distance1 * distance1 + distance2 * distance2);
            INSTANCE.repredictPoint();
        }
        if (RegexUtils.INSTANCE.matches(this.getNoMissingSecretsPattern(), event.getMessage())) {
            this.reset();
        }
    }

    private final void repredictPoint() {
        BezierCurve curve = bezierFitter.fit();
        Integer knownDistance = secretDistance;
        if (curve != null && knownDistance != null) {
            secretLocation = curve.at((double)knownDistance.intValue() * 2.0);
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.CATACOMBS)
    public final void onUseAbility(@NotNull ItemClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (event.getClickType() != ClickType.RIGHT_CLICK) {
            return;
        }
        ItemStack itemStack = event.getItemInHand();
        if (itemStack == null) {
            return;
        }
        ItemStack item2 = itemStack;
        if (!Intrinsics.areEqual(ItemUtils.INSTANCE.getInternalNameOrNull(item2), SECRET_COMPASS)) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastParticle), DurationKt.toDuration(0.2, DurationUnit.SECONDS)) < 0) {
            event.cancel();
            return;
        }
        bezierFitter.reset();
        lastAbilityUse = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    @HandleEvent
    public final void onWorldChange() {
        this.reset();
        lastAbilityUse = SimpleTimeMark.Companion.farPast();
    }

    private final void reset() {
        secretLocation = null;
        bezierFitter.reset();
    }

    private final boolean isEnabled() {
        return this.getConfig();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(DungeonSecretTrackerLocator.class, "secretTrackerMessagePattern", "getSecretTrackerMessagePattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(DungeonSecretTrackerLocator.class, "noMissingSecretsPattern", "getNoMissingSecretsPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new DungeonSecretTrackerLocator();
        patternGroup = RepoPattern.Companion.group("dungeon.secrettracker");
        secretTrackerMessagePattern$delegate = patternGroup.pattern("message", "There's a secret (?:\u00a7.)*(?<distance>\\d+) blocks(?:.+and (?<distance2>\\d+) blocks)?");
        noMissingSecretsPattern$delegate = patternGroup.pattern("no.missing", "\u00a7cThere are no missing secrets near you!");
        lastParticle = SimpleTimeMark.Companion.farPast();
        lastAbilityUse = SimpleTimeMark.Companion.farPast();
        bezierFitter = new BezierFitter(1);
        SECRET_COMPASS = NeuInternalName.Companion.toInternalName("SECRET_TRACKER");
    }
}

