/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.compat.BlockCompatKt;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\u0010\u001d\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0006\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\t\u001a\u00020\b*\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\f\u001a\u00020\u000b*\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u000f*\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0011\u0010\u0015\u001a\u00020\u000b*\u00020\b\u00a2\u0006\u0004\b\u0015\u0010\u0016J+\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\b\b\u0002\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001b\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001b\u0010\u001fJ\u000f\u0010 \u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b \u0010!J\u0017\u0010\"\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\"\u0010#J%\u0010(\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020%H\u0002\u00a2\u0006\u0004\b(\u0010)JG\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0-2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020%2\b\b\u0002\u0010*\u001a\u00020%2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0+\u00a2\u0006\u0004\b(\u0010.J;\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0-2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020%2\b\b\u0002\u0010*\u001a\u00020%2\u0006\u0010/\u001a\u00020\u0005\u00a2\u0006\u0004\b(\u00100R\u0014\u00104\u001a\u0002018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u001d\u00106\u001a\b\u0012\u0004\u0012\u00020\u0005058\u0006\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109\u00a8\u0006:"}, d2={"Lat/hannibal2/skyhanni/utils/BlockUtils;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lnet/minecraft/block/Block;", "getBlockAt", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Lnet/minecraft/block/Block;", "Lnet/minecraft/block/state/IBlockState;", "getBlockStateAt", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Lnet/minecraft/block/state/IBlockState;", "", "isInLoadedChunk", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Z", "position", "", "getTextureFromSkull", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Ljava/lang/String;", "Lnet/minecraft/tileentity/TileEntitySkull;", "getSkullTexture", "(Lnet/minecraft/tileentity/TileEntitySkull;)Ljava/lang/String;", "isBabyCrop", "(Lnet/minecraft/block/state/IBlockState;)Z", "start", "direction", "", "distance", "rayTrace", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;D)Lat/hannibal2/skyhanni/utils/LorenzVec;", "end", "Lnet/minecraft/util/MovingObjectPosition;", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;)Lnet/minecraft/util/MovingObjectPosition;", "getTargetedBlock", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "getTargetedBlockAtDistance", "(D)Lat/hannibal2/skyhanni/utils/LorenzVec;", "center", "", "", "Lnet/minecraft/util/BlockPos;", "nearbyBlocks", "(Lat/hannibal2/skyhanni/utils/LorenzVec;I)Ljava/lang/Iterable;", "radius", "Lkotlin/Function1;", "condition", "", "(Lat/hannibal2/skyhanni/utils/LorenzVec;IILkotlin/jvm/functions/Function1;)Ljava/util/Map;", "filter", "(Lat/hannibal2/skyhanni/utils/LorenzVec;IILnet/minecraft/block/Block;)Ljava/util/Map;", "Lnet/minecraft/client/multiplayer/WorldClient;", "getWorld", "()Lnet/minecraft/client/multiplayer/WorldClient;", "world", "", "redstoneOreBlocks", "Ljava/util/List;", "getRedstoneOreBlocks", "()Ljava/util/List;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nBlockUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockUtils.kt\nat/hannibal2/skyhanni/utils/BlockUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1#2:119\n1#2:130\n1611#3,9:120\n1863#3:129\n1864#3:131\n1620#3:132\n*S KotlinDebug\n*F\n+ 1 BlockUtils.kt\nat/hannibal2/skyhanni/utils/BlockUtils\n*L\n101#1:130\n101#1:120,9\n101#1:129\n101#1:131\n101#1:132\n*E\n"})
public final class BlockUtils {
    @NotNull
    public static final BlockUtils INSTANCE;
    @NotNull
    private static final List<Block> redstoneOreBlocks;

    private BlockUtils() {
    }

    private final WorldClient getWorld() {
        return MinecraftCompat.INSTANCE.getLocalWorld();
    }

    @NotNull
    public final Block getBlockAt(@NotNull LorenzVec $this$getBlockAt) {
        Intrinsics.checkNotNullParameter($this$getBlockAt, "<this>");
        Block block = this.getBlockStateAt($this$getBlockAt).func_177230_c();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        return block;
    }

    @NotNull
    public final IBlockState getBlockStateAt(@NotNull LorenzVec $this$getBlockStateAt) {
        Intrinsics.checkNotNullParameter($this$getBlockStateAt, "<this>");
        IBlockState iBlockState = this.getWorld().func_180495_p($this$getBlockStateAt.toBlockPos());
        Intrinsics.checkNotNullExpressionValue(iBlockState, "getBlockState(...)");
        return iBlockState;
    }

    public final boolean isInLoadedChunk(@NotNull LorenzVec $this$isInLoadedChunk) {
        Intrinsics.checkNotNullParameter($this$isInLoadedChunk, "<this>");
        return this.getWorld().func_175668_a($this$isInLoadedChunk.toBlockPos(), false);
    }

    @Nullable
    public final String getTextureFromSkull(@NotNull LorenzVec position) {
        Intrinsics.checkNotNullParameter(position, "position");
        TileEntity tileEntity = this.getWorld().func_175625_s(position.toBlockPos());
        TileEntitySkull tileEntitySkull = tileEntity instanceof TileEntitySkull ? (TileEntitySkull)tileEntity : null;
        if (tileEntitySkull == null) {
            return null;
        }
        TileEntitySkull entity = tileEntitySkull;
        return this.getSkullTexture(entity);
    }

    @Nullable
    public final String getSkullTexture(@NotNull TileEntitySkull $this$getSkullTexture) {
        Intrinsics.checkNotNullParameter($this$getSkullTexture, "<this>");
        NBTTagCompound nBTTagCompound = $this$getSkullTexture.serializeNBT().func_74775_l("Owner");
        Intrinsics.checkNotNullExpressionValue(nBTTagCompound, "getCompoundTag(...)");
        return ItemUtils.INSTANCE.getSkullTexture(nBTTagCompound);
    }

    public final boolean isBabyCrop(@NotNull IBlockState $this$isBabyCrop) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter($this$isBabyCrop, "<this>");
            Collection collection = $this$isBabyCrop.func_177230_c().func_176194_O().func_177623_d();
            Intrinsics.checkNotNullExpressionValue(collection, "getProperties(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                IProperty it = (IProperty)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.func_177701_a(), "age")) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        Object var3_7 = v1;
        PropertyInteger propertyInteger = var3_7 instanceof PropertyInteger ? (PropertyInteger)var3_7 : null;
        if (propertyInteger == null) {
            return false;
        }
        PropertyInteger property = propertyInteger;
        Integer n = (Integer)$this$isBabyCrop.func_177229_b((IProperty)property);
        return n != null && n == 0;
    }

    private final LorenzVec rayTrace(LorenzVec start2, LorenzVec direction, double distance) {
        LorenzVec target = start2.plus(direction.normalize().times(distance));
        MovingObjectPosition result2 = this.rayTrace(start2, target);
        MovingObjectPosition movingObjectPosition = result2;
        return movingObjectPosition != null && (movingObjectPosition = movingObjectPosition.func_178782_a()) != null ? LorenzVecKt.toLorenzVec((BlockPos)movingObjectPosition) : null;
    }

    static /* synthetic */ LorenzVec rayTrace$default(BlockUtils blockUtils, LorenzVec lorenzVec, LorenzVec lorenzVec2, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 50.0;
        }
        return blockUtils.rayTrace(lorenzVec, lorenzVec2, d);
    }

    @Nullable
    public final MovingObjectPosition rayTrace(@NotNull LorenzVec start2, @NotNull LorenzVec end) {
        Intrinsics.checkNotNullParameter(start2, "start");
        Intrinsics.checkNotNullParameter(end, "end");
        return this.getWorld().func_72933_a(start2.toVec3(), end.toVec3());
    }

    @Nullable
    public final LorenzVec getTargetedBlock() {
        MovingObjectPosition movingObjectPosition = Minecraft.func_71410_x().field_71476_x;
        if (movingObjectPosition == null) {
            return null;
        }
        MovingObjectPosition mouseOverObject = movingObjectPosition;
        if (mouseOverObject.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return null;
        }
        BlockPos blockPos = mouseOverObject.func_178782_a();
        Intrinsics.checkNotNullExpressionValue(blockPos, "getBlockPos(...)");
        return LorenzVecKt.toLorenzVec(blockPos).roundToBlock();
    }

    @Nullable
    public final LorenzVec getTargetedBlockAtDistance(double distance) {
        LorenzVec lorenzVec = LocationUtils.INSTANCE.playerEyeLocation();
        Vec3 vec3 = MinecraftCompat.INSTANCE.getLocalPlayer().func_70040_Z();
        Intrinsics.checkNotNullExpressionValue(vec3, "getLookVec(...)");
        LorenzVec lorenzVec2 = this.rayTrace(lorenzVec, LorenzVecKt.toLorenzVec(vec3), distance);
        return lorenzVec2 != null ? lorenzVec2.roundToBlock() : null;
    }

    private final Iterable<BlockPos> nearbyBlocks(LorenzVec center, int distance) {
        BlockPos from = center.add(-distance, -distance, -distance).toBlockPos();
        BlockPos to = center.add(distance, distance, distance).toBlockPos();
        Iterable iterable = BlockPos.func_177980_a((BlockPos)from, (BlockPos)to);
        Intrinsics.checkNotNullExpressionValue(iterable, "getAllInBox(...)");
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<LorenzVec, IBlockState> nearbyBlocks(@NotNull LorenzVec center, int distance, int radius, @NotNull Function1<? super IBlockState, Boolean> condition) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(center, "center");
        Intrinsics.checkNotNullParameter(condition, "condition");
        Iterable<BlockPos> $this$mapNotNull$iv = this.nearbyBlocks(center, distance);
        boolean $i$f$mapNotNull = false;
        Iterable<BlockPos> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair<LorenzVec, IBlockState> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            BlockPos it = (BlockPos)element$iv$iv;
            boolean bl2 = false;
            LorenzVec loc = LorenzVecKt.toLorenzVec(it);
            IBlockState state = INSTANCE.getBlockStateAt(loc);
            if ((condition.invoke((IBlockState)state) != false && center.distance(loc) <= (double)radius ? TuplesKt.to(loc, state) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((List)destination$iv$iv);
    }

    public static /* synthetic */ Map nearbyBlocks$default(BlockUtils blockUtils, LorenzVec lorenzVec, int n, int n2, Function1 function1, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        return blockUtils.nearbyBlocks(lorenzVec, n, n2, function1);
    }

    @NotNull
    public final Map<LorenzVec, IBlockState> nearbyBlocks(@NotNull LorenzVec center, int distance, int radius, @NotNull Block filter2) {
        Intrinsics.checkNotNullParameter(center, "center");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        return this.nearbyBlocks(center, distance, radius, arg_0 -> BlockUtils.nearbyBlocks$lambda$2(filter2, arg_0));
    }

    public static /* synthetic */ Map nearbyBlocks$default(BlockUtils blockUtils, LorenzVec lorenzVec, int n, int n2, Block block, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        return blockUtils.nearbyBlocks(lorenzVec, n, n2, block);
    }

    @NotNull
    public final List<Block> getRedstoneOreBlocks() {
        return redstoneOreBlocks;
    }

    private static final boolean nearbyBlocks$lambda$2(Block $filter, IBlockState it) {
        Intrinsics.checkNotNullParameter($filter, "$filter");
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.func_177230_c(), $filter);
    }

    static {
        List<Block> list;
        INSTANCE = new BlockUtils();
        List<Block> $this$redstoneOreBlocks_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        BlockCompatKt.addRedstoneOres($this$redstoneOreBlocks_u24lambda_u243);
        redstoneOreBlocks = CollectionsKt.build(list);
    }
}

