/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data.bazaar;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigManager;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.ArgContext;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.config.features.dev.DebugConfig;
import at.hannibal2.skyhanni.data.bazaar.BazaarApiResponseJson;
import at.hannibal2.skyhanni.data.bazaar.BazaarProduct;
import at.hannibal2.skyhanni.data.bazaar.BazaarQuickStatus;
import at.hannibal2.skyhanni.data.bazaar.BazaarSummary;
import at.hannibal2.skyhanni.data.bazaar.HypixelBazaarFetcher;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.features.inventory.bazaar.BazaarData;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.NeuItems;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.api.ApiStaticGetPath;
import at.hannibal2.skyhanni.utils.api.ApiUtils;
import at.hannibal2.skyhanni.utils.api.JsonApiResponse;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\u0003J\u0010\u0010\n\u001a\u00020\u0006H\u0082@\u00a2\u0006\u0004\b\n\u0010\u000bJ/\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\f2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0013\u0010\u0019\u001a\u00020\u0015*\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ/\u0010 \u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\r2\n\u0010\u001e\u001a\u00060\u001cj\u0002`\u001d2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020$H\u0007\u00a2\u0006\u0004\b%\u0010&R\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0014\u0010-\u001a\u00020*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010/\u001a\u00020.8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b/\u00100R.\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u0016\u00108\u001a\u0002078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0016\u0010:\u001a\u0002078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u00109R\u0016\u0010;\u001a\u00020.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u00100R\u0016\u0010<\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u0010=\u00a8\u0006>"}, d2={"Lat/hannibal2/skyhanni/data/bazaar/HypixelBazaarFetcher;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "event", "", "onDebug", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "onTick", "fetchAndProcessBazaarData", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "", "Lat/hannibal2/skyhanni/data/bazaar/BazaarProduct;", "products", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "Lat/hannibal2/skyhanni/features/inventory/bazaar/BazaarData;", "process", "(Ljava/util/Map;)Ljava/util/Map;", "key", "", "isUnobtainableBazaarProduct", "(Ljava/lang/String;)Z", "Lat/hannibal2/skyhanni/data/bazaar/BazaarQuickStatus;", "isEmpty", "(Lat/hannibal2/skyhanni/data/bazaar/BazaarQuickStatus;)Z", "fetchType", "Ljava/lang/Exception;", "Lkotlin/Exception;", "e", "rawResponse", "onError", "(Ljava/lang/String;Ljava/lang/Exception;Ljava/lang/String;)V", "canFetch", "()Z", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "Lat/hannibal2/skyhanni/utils/api/ApiStaticGetPath;", "bzStatic", "Lat/hannibal2/skyhanni/utils/api/ApiStaticGetPath;", "Lat/hannibal2/skyhanni/config/features/dev/DebugConfig;", "getDebugConfig", "()Lat/hannibal2/skyhanni/config/features/dev/DebugConfig;", "debugConfig", "", "HIDDEN_FAILED_ATTEMPTS", "I", "latestProductInformation", "Ljava/util/Map;", "getLatestProductInformation", "()Ljava/util/Map;", "setLatestProductInformation", "(Ljava/util/Map;)V", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastSuccessfulFetch", "J", "nextFetchTime", "failedAttempts", "nextFetchIsManual", "Z", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nHypixelBazaarFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HypixelBazaarFetcher.kt\nat/hannibal2/skyhanni/data/bazaar/HypixelBazaarFetcher\n+ 2 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n24#2:172\n136#3,9:173\n216#3:182\n217#3:185\n145#3:186\n1#4:183\n1#4:184\n*S KotlinDebug\n*F\n+ 1 HypixelBazaarFetcher.kt\nat/hannibal2/skyhanni/data/bazaar/HypixelBazaarFetcher\n*L\n75#1:172\n89#1:173,9\n89#1:182\n89#1:185\n89#1:186\n89#1:184\n*E\n"})
public final class HypixelBazaarFetcher {
    @NotNull
    public static final HypixelBazaarFetcher INSTANCE = new HypixelBazaarFetcher();
    @NotNull
    private static final ApiStaticGetPath bzStatic = new ApiStaticGetPath("https://api.hypixel.net/v2/skyblock/bazaar", "Hypixel Bazaar", false, false, 12, null);
    private static final int HIDDEN_FAILED_ATTEMPTS = 3;
    @NotNull
    private static Map<NeuInternalName, BazaarData> latestProductInformation = MapsKt.emptyMap();
    private static long lastSuccessfulFetch = SimpleTimeMark.Companion.farPast();
    private static long nextFetchTime = SimpleTimeMark.Companion.farPast();
    private static int failedAttempts;
    private static boolean nextFetchIsManual;

    private HypixelBazaarFetcher() {
    }

    private final DebugConfig getDebugConfig() {
        return SkyHanniMod.feature.getDev().getDebug();
    }

    @NotNull
    public final Map<NeuInternalName, BazaarData> getLatestProductInformation() {
        return latestProductInformation;
    }

    public final void setLatestProductInformation(@NotNull Map<NeuInternalName, BazaarData> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        latestProductInformation = map;
    }

    @HandleEvent
    public final void onDebug(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.title("Bazaar Data Fetcher from API");
        Object[] objectArray = new String[]{"failedAttempts: " + failedAttempts, "nextFetchIsManual: " + nextFetchIsManual, "nextFetchTime: " + Duration.toString-impl((long)SimpleTimeMark.timeUntil-UwyO8pc(nextFetchTime)), "lastSuccessfulFetch: " + Duration.toString-impl((long)SimpleTimeMark.passedSince-UwyO8pc(lastSuccessfulFetch))};
        List data = CollectionsKt.listOf((Object[])objectArray);
        if (failedAttempts == 0) {
            event.addIrrelevant(data);
        } else {
            event.addData(data);
        }
    }

    @HandleEvent
    public final void onTick() {
        if (!this.canFetch()) {
            return;
        }
        if (ApiUtils.INSTANCE.isBazaarDisabled()) {
            return;
        }
        SkyHanniMod.launchIOCoroutine-8Mi8wO0$default(SkyHanniMod.INSTANCE, "bazaar api fetch", 0L, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = HypixelBazaarFetcher.access$fetchAndProcessBazaarData(HypixelBazaarFetcher.INSTANCE, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object fetchAndProcessBazaarData(Continuation<? super Unit> $completion) {
        if (!($completion instanceof fetchAndProcessBazaarData.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ HypixelBazaarFetcher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HypixelBazaarFetcher.access$fetchAndProcessBazaarData(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                HypixelBazaarFetcher.nextFetchTime = SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.MINUTES));
                fetchType = HypixelBazaarFetcher.nextFetchIsManual != false ? "manual" : "automatic";
                HypixelBazaarFetcher.nextFetchIsManual = false;
                $continuation.L$0 = this;
                $continuation.L$1 = fetchType;
                $continuation.label = 1;
                v0 = ApiUtils.INSTANCE.getJsonResponse(HypixelBazaarFetcher.bzStatic, (Continuation<? super JsonApiResponse<JsonElement>>)$continuation);
                ** if (v0 != var10_4) goto lbl24
lbl23:
                // 1 sources

                return var10_4;
lbl24:
                // 1 sources

                ** GOTO lbl32
            }
            case 1: {
                fetchType = (String)$continuation.L$1;
                this = (HypixelBazaarFetcher)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl32:
                    // 2 sources

                    v1 = ((JsonApiResponse)v0).assertSuccessWithData();
                    if (v1 == null) {
                        HypixelBazaarFetcher.onError$default(this, fetchType, new Exception("Failed to fetch bazaar data from Hypixel API"), null, 4, null);
                        return Unit.INSTANCE;
                    }
                    jsonResponse = (JsonElement)v1.component2();
                    $this$fromJson$iv = ConfigManager.Companion.getGson();
                    $i$f$fromJson = false;
                    v2 = $this$fromJson$iv.fromJson(jsonResponse, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(BazaarApiResponseJson.class)));
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"fromJson(...)");
                    response = (BazaarApiResponseJson)v2;
                    if (response.getSuccess()) {
                        HypixelBazaarFetcher.latestProductInformation = this.process(response.getProducts());
                        HypixelBazaarFetcher.failedAttempts = 0;
                        HypixelBazaarFetcher.lastSuccessfulFetch = SimpleTimeMark.Companion.now-uFjCsEo();
                    } else {
                        var7_9 = jsonResponse.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)var7_9, (String)"toString(...)");
                        rawResponse = var7_9;
                        this.onError(fetchType, new Exception("success=false, cause=" + response.getCause()), rawResponse);
                    }
                }
                catch (Exception e) {
                    HypixelBazaarFetcher.onError$default(this, fetchType, e, null, 4, null);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final Map<NeuInternalName, BazaarData> process(Map<String, BazaarProduct> products) {
        void $this$mapNotNullTo$iv$iv;
        Map<String, BazaarProduct> $this$mapNotNull$iv = products;
        boolean $i$f$mapNotNull = false;
        Map<String, BazaarProduct> map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            double instantSellPrice;
            Double d;
            Double d2;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            String key = (String)entry.getKey();
            BazaarProduct product = (BazaarProduct)entry.getValue();
            NeuInternalName internalName2 = NeuItems.INSTANCE.transHypixelNameToInternalName(key);
            Iterator iterator3 = ((Iterable)product.getBuySummary()).iterator();
            if (!iterator3.hasNext()) {
                d2 = null;
            } else {
                BazaarSummary it = (BazaarSummary)iterator3.next();
                boolean bl3 = false;
                double d3 = it.getPricePerUnit();
                while (iterator3.hasNext()) {
                    BazaarSummary it2 = (BazaarSummary)iterator3.next();
                    $i$a$-minOfOrNull-HypixelBazaarFetcher$process$1$instantBuyPrice$1 = false;
                    double d4 = it2.getPricePerUnit();
                    d3 = Math.min(d3, d4);
                }
                d2 = d3;
            }
            double instantBuyPrice = d2 != null ? d2 : 0.0;
            Iterator iterator4 = ((Iterable)product.getSellSummary()).iterator();
            if (!iterator4.hasNext()) {
                d = null;
            } else {
                BazaarSummary it = (BazaarSummary)iterator4.next();
                boolean bl4 = false;
                double d5 = it.getPricePerUnit();
                while (iterator4.hasNext()) {
                    BazaarSummary it3 = (BazaarSummary)iterator4.next();
                    $i$a$-maxOfOrNull-HypixelBazaarFetcher$process$1$instantSellPrice$1 = false;
                    double d6 = it3.getPricePerUnit();
                    d5 = Math.max(d5, d6);
                }
                d = d5;
            }
            double d7 = instantSellPrice = d != null ? d : 0.0;
            if (INSTANCE.isEmpty(product.getQuickStatus())) {
                pair = null;
            } else if (NeuItems.INSTANCE.getItemStackOrNull(internalName2) == null) {
                if (!INSTANCE.isUnobtainableBazaarProduct(key) && INSTANCE.getDebugConfig().getPrintMissingBazaarItems()) {
                    System.out.println((Object)("Unknown bazaar product: " + key + "/" + internalName2));
                }
                pair = null;
            } else {
                pair = TuplesKt.to((Object)internalName2, (Object)new BazaarData(ItemUtils.INSTANCE.getRepoItemName(internalName2), instantBuyPrice, instantSellPrice, product));
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final boolean isUnobtainableBazaarProduct(String key) {
        String string = key;
        return Intrinsics.areEqual((Object)string, (Object)"ENCHANTMENT_COUNTER_STRIKE_3") || Intrinsics.areEqual((Object)string, (Object)"ENCHANTMENT_COUNTER_STRIKE_4");
    }

    private final boolean isEmpty(BazaarQuickStatus $this$isEmpty) {
        BazaarQuickStatus $this$isEmpty_u24lambda_u243 = $this$isEmpty;
        boolean bl = false;
        return $this$isEmpty_u24lambda_u243.getSellPrice() == 0.0 && $this$isEmpty_u24lambda_u243.getSellVolume() == 0L && $this$isEmpty_u24lambda_u243.getSellMovingWeek() == 0L && $this$isEmpty_u24lambda_u243.getSellOrders() == 0L && $this$isEmpty_u24lambda_u243.getBuyPrice() == 0.0 && $this$isEmpty_u24lambda_u243.getBuyVolume() == 0L && $this$isEmpty_u24lambda_u243.getBuyMovingWeek() == 0L && $this$isEmpty_u24lambda_u243.getBuyOrders() == 0L;
    }

    private final void onError(String fetchType, Exception e, String rawResponse) {
        String userMessage = "Failed fetching bazaar price data from hypixel";
        int n = failedAttempts;
        if ((failedAttempts = n + 1) <= 3) {
            nextFetchTime = SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.SECONDS));
            ChatUtils.debug$default(ChatUtils.INSTANCE, userMessage + ". (errorMessage=" + e.getMessage() + ", failedAttempts=" + failedAttempts + ", " + fetchType, false, 2, null);
            e.printStackTrace();
        } else {
            nextFetchTime = SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.MINUTES));
            if (rawResponse == null || Intrinsics.areEqual((Object)rawResponse, (Object)"{}")) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7cFailed loading Bazaar Price data!\n\u00a7cPlease wait until the Hypixel API is sending correct data again! There is nothing else to do at the moment.", false, null, true, false, null, 54, null);
            } else {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"fetchType", (Object)fetchType), TuplesKt.to((Object)"failedAttempts", (Object)failedAttempts), TuplesKt.to((Object)"rawResponse", (Object)rawResponse)};
                ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, userMessage, pairArray, false, false, false, 56, null);
            }
        }
    }

    static /* synthetic */ void onError$default(HypixelBazaarFetcher hypixelBazaarFetcher, String string, Exception exception, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        hypixelBazaarFetcher.onError(string, exception, string2);
    }

    private final boolean canFetch() {
        return SkyBlockUtils.INSTANCE.getOnHypixel() && SimpleTimeMark.isInPast-impl(nextFetchTime);
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.registerBrigadier("shupdatebazaarprices", (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)HypixelBazaarFetcher::onCommandRegistration$lambda$5));
    }

    private static final Unit onCommandRegistration$lambda$5$lambda$4(ArgContext $this$callback) {
        Intrinsics.checkNotNullParameter((Object)$this$callback, (String)"$this$callback");
        failedAttempts = 0;
        nextFetchIsManual = true;
        nextFetchTime = SimpleTimeMark.Companion.now-uFjCsEo();
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Manually updating the bazaar prices right now..", false, null, false, false, null, 62, null);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$5(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Forcefully updating the bazaar prices right now.");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_BUG_FIX);
        $this$registerBrigadier.callback((Function1<ArgContext, Unit>)((Function1)HypixelBazaarFetcher::onCommandRegistration$lambda$5$lambda$4));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$fetchAndProcessBazaarData(HypixelBazaarFetcher $this, Continuation $completion) {
        return $this.fetchAndProcessBazaarData((Continuation<? super Unit>)$completion);
    }
}

