/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data.repo;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.SkyHanniEvent;
import at.hannibal2.skyhanni.config.ConfigManager;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.ArgContext;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierArgument;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierBuilder;
import at.hannibal2.skyhanni.config.features.dev.DebugConfig;
import at.hannibal2.skyhanni.data.repo.AbstractRepoConfig;
import at.hannibal2.skyhanni.data.repo.AbstractRepoLocationConfig;
import at.hannibal2.skyhanni.data.repo.AbstractRepoManager;
import at.hannibal2.skyhanni.data.repo.AbstractRepoReloadEvent;
import at.hannibal2.skyhanni.data.repo.ChatProgressUpdates;
import at.hannibal2.skyhanni.data.repo.DiskRepoFileSystem;
import at.hannibal2.skyhanni.data.repo.RepoCommit;
import at.hannibal2.skyhanni.data.repo.RepoCommitStorage;
import at.hannibal2.skyhanni.data.repo.RepoComparison;
import at.hannibal2.skyhanni.data.repo.RepoFileSystem;
import at.hannibal2.skyhanni.data.repo.RepoLogger;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.GitHubUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.chat.TextHelper;
import at.hannibal2.skyhanni.utils.json.JsonUtilsKt;
import at.hannibal2.skyhanni.utils.system.LazyVar;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003:\u0002\u00b1\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\n\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\n\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u001f\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\nH\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0019\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001d\u001a\u00020\nH\u0001\u00a2\u0006\u0004\b\u001f\u0010 JB\u0010&\u001a\u00028\u0001\"\n\b\u0001\u0010!\u0018\u0001*\u00020\u00032\u0006\u0010\"\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010#2\b\b\u0002\u0010%\u001a\u00020\u0006H\u0081\b\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010*\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\n2\b\b\u0002\u0010)\u001a\u00020\u0015\u00a2\u0006\u0004\b*\u0010+J\u0019\u0010-\u001a\u00020\u00112\b\b\u0002\u0010,\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b-\u0010.J\r\u0010/\u001a\u00020\u0011\u00a2\u0006\u0004\b/\u0010\u0005J\u000f\u00101\u001a\u000200H\u0002\u00a2\u0006\u0004\b1\u00102J\u000f\u00103\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b3\u0010\u0005J\u0010\u00104\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0004\b4\u00105J\"\u00108\u001a\u00020\u00112\u0006\u00106\u001a\u00020\u00152\b\b\u0002\u00107\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0004\b8\u00109J\u0010\u0010:\u001a\u00020\u0011H\u0082@\u00a2\u0006\u0004\b:\u00105J\u001a\u0010=\u001a\u0004\u0018\u00010<2\u0006\u0010;\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0004\b=\u0010>J6\u0010@\u001a\u0002002\u0006\u00107\u001a\u00020\u00152\b\b\u0002\u0010;\u001a\u00020\u00152\b\b\u0002\u0010)\u001a\u00020\u00152\b\b\u0002\u0010?\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0004\b@\u0010AJ\u000f\u0010B\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\bB\u0010\u0005J\u0017\u0010D\u001a\u00020\u00112\b\b\u0002\u0010C\u001a\u00020\n\u00a2\u0006\u0004\bD\u0010EJ\u0010\u0010F\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0004\bF\u00105J\u001a\u0010G\u001a\u00020\u00112\b\b\u0002\u0010C\u001a\u00020\nH\u0082@\u00a2\u0006\u0004\bG\u0010HR'\u0010O\u001a\b\u0012\u0004\u0012\u00028\u00000I8BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\bJ\u0010K\u0012\u0004\bN\u0010\u0005\u001a\u0004\bL\u0010MR?\u0010U\u001a&\u0012\f\u0012\n Q*\u0004\u0018\u00018\u00008\u0000 Q*\u0012\u0012\f\u0012\n Q*\u0004\u0018\u00018\u00008\u0000\u0018\u00010P0P8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bR\u0010K\u001a\u0004\bS\u0010TR\u0014\u0010W\u001a\u00020\n8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u0010\u000eR\u0014\u0010Y\u001a\u00020\n8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bX\u0010\u000eR\u001b\u0010\\\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bZ\u0010K\u001a\u0004\b[\u0010\u000eR\u001c\u0010]\u001a\u0004\u0018\u00010\n8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b]\u0010^\u001a\u0004\b_\u0010\u000eR\u0014\u0010c\u001a\u00020`8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\ba\u0010bR\u0018\u0010g\u001a\u0006\u0012\u0002\b\u00030d8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\be\u0010fR\u0014\u0010k\u001a\u00020h8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bi\u0010jR\u001b\u0010p\u001a\u00020l8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bm\u0010K\u001a\u0004\bn\u0010oR\u001b\u0010s\u001a\u00020h8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bq\u0010K\u001a\u0004\br\u0010jR\u001b\u0010v\u001a\u00020h8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bt\u0010K\u001a\u0004\bu\u0010jR\u001b\u0010{\u001a\u00020w8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bx\u0010K\u001a\u0004\by\u0010zR\u001a\u0010}\u001a\b\u0012\u0004\u0012\u00020\n0|8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b}\u0010~R\u001a\u0010\u007f\u001a\b\u0012\u0004\u0012\u00020\n0|8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u007f\u0010~R\u0018\u0010\u0083\u0001\u001a\u00030\u0080\u00018BX\u0082\u0004\u00a2\u0006\b\u001a\u0006\b\u0081\u0001\u0010\u0082\u0001R\u001d\u0010\u0085\u0001\u001a\u00030\u0084\u00018\u0006\u00a2\u0006\u0010\n\u0006\b\u0085\u0001\u0010\u0086\u0001\u001a\u0006\b\u0087\u0001\u0010\u0088\u0001R\u001f\u0010\u0089\u0001\u001a\u00020\u00158\u0016X\u0096D\u00a2\u0006\u0010\n\u0006\b\u0089\u0001\u0010\u008a\u0001\u001a\u0006\b\u008b\u0001\u0010\u008c\u0001R\u001f\u0010\u008d\u0001\u001a\u00020\u00158\u0016X\u0096D\u00a2\u0006\u0010\n\u0006\b\u008d\u0001\u0010\u008a\u0001\u001a\u0006\b\u008e\u0001\u0010\u008c\u0001R\u001f\u0010\u008f\u0001\u001a\u00020\u00158\u0016X\u0096D\u00a2\u0006\u0010\n\u0006\b\u008f\u0001\u0010\u008a\u0001\u001a\u0006\b\u0090\u0001\u0010\u008c\u0001R\u0016\u0010\u0092\u0001\u001a\u00020\n8&X\u00a6\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0091\u0001\u0010\u000eR\u0016\u0010\u0094\u0001\u001a\u00020\n8&X\u00a6\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0093\u0001\u0010\u000eR\u0016\u0010\u0096\u0001\u001a\u00020\n8&X\u00a6\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0095\u0001\u0010\u000eR5\u0010\u009f\u0001\u001a\u00030\u0097\u00012\b\u0010\u0098\u0001\u001a\u00030\u0097\u00018F@BX\u0086\u008e\u0002\u00a2\u0006\u0018\n\u0006\b\u0099\u0001\u0010\u009a\u0001\u001a\u0006\b\u009b\u0001\u0010\u009c\u0001\"\u0006\b\u009d\u0001\u0010\u009e\u0001R,\u0010\u00a2\u0001\u001a\u00030\u00a0\u00012\b\u0010\u00a1\u0001\u001a\u00030\u00a0\u00018\u0006@BX\u0086\u000e\u00a2\u0006\u0010\n\u0006\b\u00a2\u0001\u0010\u00a3\u0001\u001a\u0006\b\u00a4\u0001\u0010\u00a5\u0001R*\u0010\u00a6\u0001\u001a\u00020\u00152\u0007\u0010\u00a1\u0001\u001a\u00020\u00158\u0006@BX\u0086\u000e\u00a2\u0006\u0010\n\u0006\b\u00a6\u0001\u0010\u008a\u0001\u001a\u0006\b\u00a6\u0001\u0010\u008c\u0001R\u0019\u0010\u00a7\u0001\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u00a7\u0001\u0010\u008a\u0001R\u0019\u0010\u00a8\u0001\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u00a8\u0001\u0010\u008a\u0001R\u001a\u0010\u00aa\u0001\u001a\u00030\u00a9\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u00aa\u0001\u0010\u00ab\u0001R\u001d\u0010\u00ad\u0001\u001a\u00030\u00ac\u00018\u0006\u00a2\u0006\u0010\n\u0006\b\u00ad\u0001\u0010\u00ae\u0001\u001a\u0006\b\u00af\u0001\u0010\u00b0\u0001\u00a8\u0006\u00b2\u0001"}, d2={"Lat/hannibal2/skyhanni/data/repo/AbstractRepoManager;", "Lat/hannibal2/skyhanni/data/repo/AbstractRepoReloadEvent;", "E", "", "<init>", "()V", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "", "", "getFailedConstants", "()Ljava/util/List;", "getGitHubRepoPath", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "event", "", "registerCommands", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "fileName", "", "addSuccessfulConstant", "(Ljava/lang/String;)Z", "addUnsuccessfulConstant", "dir", "name", "resolvePath", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "path", "Lcom/google/gson/JsonElement;", "readJsonElement", "(Ljava/lang/String;)Lcom/google/gson/JsonElement;", "T", "directory", "Ljava/lang/reflect/Type;", "type", "gson", "getRepoData", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/reflect/Type;Lcom/google/gson/Gson;)Ljava/lang/Object;", "reason", "forceReset", "updateRepo", "(Ljava/lang/String;Z)V", "manual", "resetRepositoryLocation", "(Z)V", "initRepo", "Lat/hannibal2/skyhanni/data/repo/AbstractRepoManager$FetchUnpackResult;", "switchToBackupRepo", "()Lat/hannibal2/skyhanni/data/repo/AbstractRepoManager$FetchUnpackResult;", "reportExtraStatusInfo", "isRepeatErrorOrFixed", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "joinEvent", "command", "displayRepoStatus", "(ZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onJoinStatusError", "silentError", "Lat/hannibal2/skyhanni/data/repo/RepoComparison;", "getCommitComparison", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "switchToBackupOnFail", "fetchAndUnpackRepo", "(ZZZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "prepCleanRepoFileSystem", "answerMessage", "reloadLocalRepo", "(Ljava/lang/String;)V", "extraReloadCoroutineWork", "reloadRepository", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Ljava/lang/Class;", "eventClass$delegate", "Lkotlin/Lazy;", "getEventClass", "()Ljava/lang/Class;", "getEventClass$annotations", "eventClass", "Ljava/lang/reflect/Constructor;", "kotlin.jvm.PlatformType", "eventCtor$delegate", "getEventCtor", "()Ljava/lang/reflect/Constructor;", "eventCtor", "getCommonName", "commonName", "getCommonShortNameCased", "commonShortNameCased", "commonShortName$delegate", "getCommonShortName", "commonShortName", "backupRepoResourcePath", "Ljava/lang/String;", "getBackupRepoResourcePath", "Lat/hannibal2/skyhanni/config/features/dev/DebugConfig;", "getDebugConfig", "()Lat/hannibal2/skyhanni/config/features/dev/DebugConfig;", "debugConfig", "Lat/hannibal2/skyhanni/data/repo/AbstractRepoConfig;", "getConfig", "()Lat/hannibal2/skyhanni/data/repo/AbstractRepoConfig;", "config", "Ljava/io/File;", "getConfigDirectory", "()Ljava/io/File;", "configDirectory", "Lat/hannibal2/skyhanni/data/repo/RepoLogger;", "logger$delegate", "getLogger", "()Lat/hannibal2/skyhanni/data/repo/RepoLogger;", "logger", "repoDirectory$delegate", "getRepoDirectory", "repoDirectory", "repoZipFile$delegate", "getRepoZipFile", "repoZipFile", "Lat/hannibal2/skyhanni/data/repo/RepoCommitStorage;", "commitStorage$delegate", "getCommitStorage", "()Lat/hannibal2/skyhanni/data/repo/RepoCommitStorage;", "commitStorage", "", "successfulConstants", "Ljava/util/Set;", "unsuccessfulConstants", "Lat/hannibal2/skyhanni/utils/GitHubUtils$RepoLocation;", "getGithubRepoLocation", "()Lat/hannibal2/skyhanni/utils/GitHubUtils$RepoLocation;", "githubRepoLocation", "Lkotlinx/coroutines/sync/Mutex;", "repoMutex", "Lkotlinx/coroutines/sync/Mutex;", "getRepoMutex", "()Lkotlinx/coroutines/sync/Mutex;", "shouldRegisterUpdateCommand", "Z", "getShouldRegisterUpdateCommand", "()Z", "shouldRegisterStatusCommand", "getShouldRegisterStatusCommand", "shouldRegisterReloadCommand", "getShouldRegisterReloadCommand", "getUpdateCommand", "updateCommand", "getStatusCommand", "statusCommand", "getReloadCommand", "reloadCommand", "Lat/hannibal2/skyhanni/data/repo/RepoFileSystem;", "<set-?>", "repoFileSystem$delegate", "Lat/hannibal2/skyhanni/utils/system/LazyVar;", "getRepoFileSystem", "()Lat/hannibal2/skyhanni/data/repo/RepoFileSystem;", "setRepoFileSystem", "(Lat/hannibal2/skyhanni/data/repo/RepoFileSystem;)V", "repoFileSystem", "Lat/hannibal2/skyhanni/data/repo/RepoCommit;", "value", "localRepoCommit", "Lat/hannibal2/skyhanni/data/repo/RepoCommit;", "getLocalRepoCommit", "()Lat/hannibal2/skyhanni/data/repo/RepoCommit;", "isUsingBackup", "shouldManuallyReload", "loadingError", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "latestError", "J", "Lat/hannibal2/skyhanni/data/repo/ChatProgressUpdates;", "progress", "Lat/hannibal2/skyhanni/data/repo/ChatProgressUpdates;", "getProgress", "()Lat/hannibal2/skyhanni/data/repo/ChatProgressUpdates;", "FetchUnpackResult", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nAbstractRepoManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n+ 2 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 6 BrigadierBuilder.kt\nat/hannibal2/skyhanni/config/commands/brigadier/BrigadierBuilder\n*L\n1#1,476:1\n24#2:477\n1#3:478\n1563#4:479\n1634#4,3:480\n116#5,10:483\n116#5,11:493\n265#6,6:504\n168#6,9:510\n*S KotlinDebug\n*F\n+ 1 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n*L\n166#1:477\n330#1:479\n330#1:480,3\n372#1:483,10\n440#1:493,11\n118#1:504,6\n118#1:510,9\n*E\n"})
public abstract class AbstractRepoManager<E extends AbstractRepoReloadEvent> {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Lazy eventClass$delegate = LazyKt.lazy(() -> AbstractRepoManager.eventClass_delegate$lambda$0(this));
    @NotNull
    private final Lazy eventCtor$delegate = LazyKt.lazy(() -> AbstractRepoManager.eventCtor_delegate$lambda$1(this));
    @NotNull
    private final Lazy commonShortName$delegate = LazyKt.lazy(() -> AbstractRepoManager.commonShortName_delegate$lambda$2(this));
    @Nullable
    private final String backupRepoResourcePath;
    @NotNull
    private final Lazy logger$delegate = LazyKt.lazy(() -> AbstractRepoManager.logger_delegate$lambda$3(this));
    @NotNull
    private final Lazy repoDirectory$delegate = LazyKt.lazy(() -> AbstractRepoManager.repoDirectory_delegate$lambda$4(this));
    @NotNull
    private final Lazy repoZipFile$delegate = LazyKt.lazy(() -> AbstractRepoManager.repoZipFile_delegate$lambda$5(this));
    @NotNull
    private final Lazy commitStorage$delegate = LazyKt.lazy(() -> AbstractRepoManager.commitStorage_delegate$lambda$6(this));
    @NotNull
    private final Set<String> successfulConstants = new LinkedHashSet();
    @NotNull
    private final Set<String> unsuccessfulConstants = new LinkedHashSet();
    @NotNull
    private final Mutex repoMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    private final boolean shouldRegisterUpdateCommand;
    private final boolean shouldRegisterStatusCommand;
    private final boolean shouldRegisterReloadCommand;
    @NotNull
    private final LazyVar repoFileSystem$delegate = new LazyVar(() -> AbstractRepoManager.repoFileSystem_delegate$lambda$7(this));
    @NotNull
    private RepoCommit localRepoCommit = new RepoCommit(null, null, 3, null);
    private boolean isUsingBackup;
    private boolean shouldManuallyReload;
    private boolean loadingError;
    private long latestError = SimpleTimeMark.Companion.farPast();
    @NotNull
    private final ChatProgressUpdates progress = new ChatProgressUpdates();

    public AbstractRepoManager() {
        this.shouldRegisterUpdateCommand = true;
        this.shouldRegisterStatusCommand = true;
        this.shouldRegisterReloadCommand = true;
    }

    @NotNull
    public Gson getGson() {
        return ConfigManager.Companion.getGson();
    }

    private final Class<E> getEventClass() {
        Lazy lazy = this.eventClass$delegate;
        return (Class)lazy.getValue();
    }

    private static /* synthetic */ void getEventClass$annotations() {
    }

    private final Constructor<E> getEventCtor() {
        Lazy lazy = this.eventCtor$delegate;
        return (Constructor)lazy.getValue();
    }

    @NotNull
    public abstract String getCommonName();

    @NotNull
    public abstract String getCommonShortNameCased();

    private final String getCommonShortName() {
        Lazy lazy = this.commonShortName$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public String getBackupRepoResourcePath() {
        return this.backupRepoResourcePath;
    }

    private final DebugConfig getDebugConfig() {
        return SkyHanniMod.feature.getDev().getDebug();
    }

    @NotNull
    public abstract AbstractRepoConfig<?> getConfig();

    @NotNull
    public abstract File getConfigDirectory();

    @NotNull
    public final RepoLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (RepoLogger)lazy.getValue();
    }

    @NotNull
    public final File getRepoDirectory() {
        Lazy lazy = this.repoDirectory$delegate;
        return (File)lazy.getValue();
    }

    private final File getRepoZipFile() {
        Lazy lazy = this.repoZipFile$delegate;
        return (File)lazy.getValue();
    }

    private final RepoCommitStorage getCommitStorage() {
        Lazy lazy = this.commitStorage$delegate;
        return (RepoCommitStorage)lazy.getValue();
    }

    private final GitHubUtils.RepoLocation getGithubRepoLocation() {
        return new GitHubUtils.RepoLocation((AbstractRepoLocationConfig)this.getConfig().getLocation(), this.getDebugConfig().getLogRepoErrors());
    }

    @NotNull
    public final Mutex getRepoMutex() {
        return this.repoMutex;
    }

    public boolean getShouldRegisterUpdateCommand() {
        return this.shouldRegisterUpdateCommand;
    }

    public boolean getShouldRegisterStatusCommand() {
        return this.shouldRegisterStatusCommand;
    }

    public boolean getShouldRegisterReloadCommand() {
        return this.shouldRegisterReloadCommand;
    }

    @NotNull
    public abstract String getUpdateCommand();

    @NotNull
    public abstract String getStatusCommand();

    @NotNull
    public abstract String getReloadCommand();

    @NotNull
    public final RepoFileSystem getRepoFileSystem() {
        return (RepoFileSystem)this.repoFileSystem$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final void setRepoFileSystem(RepoFileSystem repoFileSystem) {
        this.repoFileSystem$delegate.setValue(this, $$delegatedProperties[0], repoFileSystem);
    }

    @NotNull
    public final RepoCommit getLocalRepoCommit() {
        return this.localRepoCommit;
    }

    public final boolean isUsingBackup() {
        return this.isUsingBackup;
    }

    @NotNull
    public final ChatProgressUpdates getProgress() {
        return this.progress;
    }

    @NotNull
    public final List<String> getFailedConstants() {
        return CollectionsKt.toList((Iterable)this.unsuccessfulConstants);
    }

    @NotNull
    public final String getGitHubRepoPath() {
        return this.getGithubRepoLocation().getLocation();
    }

    public final void registerCommands(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.getShouldRegisterUpdateCommand()) {
            event.registerBrigadier(this.getUpdateCommand(), (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)arg_0 -> AbstractRepoManager.registerCommands$lambda$10(this, arg_0)));
        }
        if (this.getShouldRegisterStatusCommand()) {
            event.registerBrigadier(this.getStatusCommand(), (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)arg_0 -> AbstractRepoManager.registerCommands$lambda$11(this, arg_0)));
        }
        if (this.getShouldRegisterReloadCommand()) {
            event.registerBrigadier(this.getReloadCommand(), (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)arg_0 -> AbstractRepoManager.registerCommands$lambda$13(this, arg_0)));
        }
    }

    public final boolean addSuccessfulConstant(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return this.successfulConstants.add(fileName);
    }

    public final boolean addUnsuccessfulConstant(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return this.unsuccessfulConstants.add(fileName);
    }

    @PublishedApi
    @NotNull
    public final String resolvePath(@NotNull String dir, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return dir + "/" + name2 + ".json";
    }

    @PublishedApi
    @Nullable
    public final JsonElement readJsonElement(@NotNull String path) {
        JsonElement jsonElement;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.getRepoFileSystem().exists(path)) {
            return RepoFileSystem.DefaultImpls.readAllBytesAsJsonElement$default(this.getRepoFileSystem(), path, null, 2, null);
        }
        File onDisk = FilesKt.resolve((File)this.getRepoDirectory(), (String)path);
        if (!onDisk.isFile()) {
            this.getLogger().logNonDestructiveError("Repo file not found: " + path);
            jsonElement = null;
        } else {
            jsonElement = JsonUtilsKt.getJson$default(onDisk, null, 1, null);
        }
        return jsonElement;
    }

    @PublishedApi
    public final /* synthetic */ <T> T getRepoData(String directory, String fileName, Type type2, Gson gson) {
        Object $this$getRepoData_u24lambda_u2414;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        boolean $i$f$getRepoData = false;
        Object object = this;
        try {
            Object object2;
            $this$getRepoData_u24lambda_u2414 = object;
            boolean bl = false;
            String path = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414).resolvePath(directory, fileName);
            JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414).readJsonElement(path);
            if (jsonElement == null) {
                ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414).getLogger().throwError("Repo file '" + fileName + "' not found.");
                throw new KotlinNothingValueException();
            }
            JsonElement json2 = jsonElement;
            if (type2 == null) {
                Gson $this$fromJson$iv = gson;
                boolean $i$f$fromJson = false;
                Intrinsics.reifiedOperationMarker((int)6, (String)"T");
                Object object3 = $this$fromJson$iv.fromJson(json2, ReflectJvmMapping.getJavaType(null));
                object2 = object3;
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"fromJson(...)");
            } else {
                Object object4 = gson.fromJson(json2, type2);
                object2 = object4;
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"fromJson(...)");
            }
            $this$getRepoData_u24lambda_u2414 = Result.constructor-impl((Object)object2);
        }
        catch (Throwable bl) {
            $this$getRepoData_u24lambda_u2414 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$getRepoData_u24lambda_u2414;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable e = throwable;
            boolean bl = false;
            this.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + fileName + "'", e);
            throw new KotlinNothingValueException();
        }
        return (T)object;
    }

    public static /* synthetic */ Object getRepoData$default(AbstractRepoManager $this, String directory, String fileName, Type type2, Gson gson, int n, Object object) {
        Object $this$getRepoData_u24lambda_u2414;
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getRepoData");
        }
        if ((n & 4) != 0) {
            type2 = null;
        }
        if ((n & 8) != 0) {
            gson = $this.getGson();
        }
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        boolean $i$f$getRepoData = false;
        object = $this;
        try {
            Object object2;
            $this$getRepoData_u24lambda_u2414 = (AbstractRepoManager)object;
            boolean bl = false;
            String path = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414).resolvePath(directory, fileName);
            JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414).readJsonElement(path);
            if (jsonElement == null) {
                ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414).getLogger().throwError("Repo file '" + fileName + "' not found.");
                throw new KotlinNothingValueException();
            }
            JsonElement json2 = jsonElement;
            if (type2 == null) {
                Gson $this$fromJson$iv = gson;
                boolean $i$f$fromJson = false;
                Intrinsics.reifiedOperationMarker((int)6, (String)"T");
                Object object3 = $this$fromJson$iv.fromJson(json2, ReflectJvmMapping.getJavaType(null));
                object2 = object3;
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"fromJson(...)");
            } else {
                Object object4 = gson.fromJson(json2, type2);
                object2 = object4;
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"fromJson(...)");
            }
            $this$getRepoData_u24lambda_u2414 = Result.constructor-impl((Object)object2);
        }
        catch (Throwable bl) {
            $this$getRepoData_u24lambda_u2414 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$getRepoData_u24lambda_u2414;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable e = throwable;
            boolean bl = false;
            $this.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + fileName + "'", e);
            throw new KotlinNothingValueException();
        }
        return object;
    }

    public final void updateRepo(@NotNull String reason, boolean forceReset) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.progress.start("updateRepo " + this.getCommonName() + " Repo");
        this.progress.update("reason: " + reason);
        this.progress.update("Remove and re-download, forceReset=" + forceReset);
        this.shouldManuallyReload = true;
        if (!((AbstractRepoLocationConfig)this.getConfig().getLocation()).getValid()) {
            this.getLogger().errorToChat("Invalid " + this.getCommonName() + " Repo settings detected, resetting default settings.");
            AbstractRepoManager.resetRepositoryLocation$default(this, false, 1, null);
        }
        SkyHanniMod.INSTANCE.launchIOCoroutine-8Mi8wO0(this.getCommonName() + " updateRepo", DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.MINUTES), (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, forceReset, null){
            int label;
            final /* synthetic */ AbstractRepoManager<E> this$0;
            final /* synthetic */ boolean $forceReset;
            {
                this.this$0 = $receiver;
                this.$forceReset = $forceReset;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = AbstractRepoManager.fetchAndUnpackRepo$default(this.this$0, true, false, this.$forceReset, false, (Continuation)this, 10, null);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (!((FetchUnpackResult)v0).getCanContinue()) {
                            this.this$0.getLogger().warn("Failed to fetch & unpack repo - aborting repository reload.");
                            return Unit.INSTANCE;
                        }
                        this.label = 2;
                        v1 = AbstractRepoManager.access$reloadRepository(this.this$0, this.this$0.getCommonName() + " Repo updated successfully.", (Continuation)this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        if (AbstractRepoManager.access$getUnsuccessfulConstants$p(this.this$0).isEmpty() && !this.this$0.isUsingBackup()) {
                            return Unit.INSTANCE;
                        }
                        var3_3 = new Pair[]{TuplesKt.to((Object)"usingBackupRepo", (Object)Boxing.boxBoolean((boolean)this.this$0.isUsingBackup())), TuplesKt.to((Object)"unsuccessfulConstants", (Object)AbstractRepoManager.access$getUnsuccessfulConstants$p(this.this$0))};
                        informed = RepoLogger.logErrorStateWithData$default(this.this$0.getLogger(), "Error updating reading " + this.this$0.getCommonName() + " Repo", "no success", var3_3, false, false, false, null, 120, null);
                        if (informed) {
                            return Unit.INSTANCE;
                        }
                        RepoLogger.logToChat$default(this.this$0.getLogger(), "\u00a7cFailed to load the " + this.this$0.getCommonShortNameCased() + " repo! See above for more infos.", null, 2, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static /* synthetic */ void updateRepo$default(AbstractRepoManager abstractRepoManager, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateRepo");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        abstractRepoManager.updateRepo(string, bl);
    }

    private final void resetRepositoryLocation(boolean manual) {
        Object $this$resetRepositoryLocation_u24lambda_u2417 = this.getConfig().getLocation();
        boolean bl = false;
        if (((AbstractRepoLocationConfig)$this$resetRepositoryLocation_u24lambda_u2417).hasDefaultSettings()) {
            if (manual) {
                RepoLogger.logToChat$default(this.getLogger(), this.getCommonShortNameCased() + " Repo settings are already on default!", null, 2, null);
            }
            return;
        }
        ((AbstractRepoLocationConfig)$this$resetRepositoryLocation_u24lambda_u2417).reset();
        if (manual) {
            ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, "Reset " + this.getCommonName() + " Repo settings to default. Click \u00a7aUpdate Repo Now \u00a7ein config or run /" + this.getUpdateCommand() + " to update!", () -> AbstractRepoManager.resetRepositoryLocation$lambda$17$lambda$16(this), "\u00a7eClick to update the " + this.getCommonShortNameCased() + " Repo!", 0L, false, null, false, false, 248, null);
        }
    }

    static /* synthetic */ void resetRepositoryLocation$default(AbstractRepoManager abstractRepoManager, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resetRepositoryLocation");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        abstractRepoManager.resetRepositoryLocation(bl);
    }

    public final void initRepo() {
        this.progress.start("init " + this.getCommonName() + " repo");
        this.shouldManuallyReload = true;
        AtomicBoolean loaded = new AtomicBoolean(false);
        Job job2 = SkyHanniMod.INSTANCE.launchIOCoroutine-8Mi8wO0(this.getCommonName() + " repo init", DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.MINUTES), (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, loaded, null){
            int label;
            final /* synthetic */ AbstractRepoManager<E> this$0;
            final /* synthetic */ AtomicBoolean $loaded;
            {
                this.this$0 = $receiver;
                this.$loaded = $loaded;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        if (!this.this$0.getConfig().getRepoAutoUpdate()) ** GOTO lbl18
                        this.label = 1;
                        v0 = AbstractRepoManager.fetchAndUnpackRepo$default(this.this$0, false, false, false, false, (Continuation)this, 14, null);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        if (!((FetchUnpackResult)v0).getCanContinue()) {
                            this.this$0.getProgress().end("Failed to fetch & unpack repo - aborting repository reload.");
                            this.this$0.getLogger().warn("Failed to fetch & unpack repo - aborting repository reload.");
                            return Unit.INSTANCE;
                        }
lbl18:
                        // 3 sources

                        this.$loaded.set(true);
                        this.label = 2;
                        v1 = AbstractRepoManager.reloadRepository$default(this.this$0, null, (Continuation)this, 1, null);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl27
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl27:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        job2.invokeOnCompletion(arg_0 -> AbstractRepoManager.initRepo$lambda$18(loaded, this, arg_0));
    }

    private final FetchUnpackResult switchToBackupRepo() {
        Object object = this;
        try {
            AbstractRepoManager $this$switchToBackupRepo_u24lambda_u2419 = object;
            boolean bl = false;
            $this$switchToBackupRepo_u24lambda_u2419.progress.update("call switchToBackupRepo");
            if ($this$switchToBackupRepo_u24lambda_u2419.getBackupRepoResourcePath() == null) {
                $this$switchToBackupRepo_u24lambda_u2419.progress.update("No backup repo resource path provided, cannot switch to backup repo.");
                $this$switchToBackupRepo_u24lambda_u2419.getLogger().warn("No backup repo resource path provided, cannot switch to backup repo.");
                return FetchUnpackResult.FAILED;
            }
            $this$switchToBackupRepo_u24lambda_u2419.getLogger().debug("Attempting to switch to backup repo");
            InputStream inputStream = $this$switchToBackupRepo_u24lambda_u2419.getClass().getClassLoader().getResourceAsStream($this$switchToBackupRepo_u24lambda_u2419.getBackupRepoResourcePath());
            if (inputStream == null) {
                $this$switchToBackupRepo_u24lambda_u2419.getLogger().throwError("Failed to find backup resource '" + $this$switchToBackupRepo_u24lambda_u2419.getBackupRepoResourcePath() + "'");
                throw new KotlinNothingValueException();
            }
            InputStream inputStream2 = inputStream;
            $this$switchToBackupRepo_u24lambda_u2419.prepCleanRepoFileSystem();
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(inputStream2, $this$switchToBackupRepo_u24lambda_u2419.getRepoZipFile().toPath(), copyOptionArray);
            if (!$this$switchToBackupRepo_u24lambda_u2419.getRepoFileSystem().loadFromZip($this$switchToBackupRepo_u24lambda_u2419.getRepoZipFile(), $this$switchToBackupRepo_u24lambda_u2419.getLogger())) {
                $this$switchToBackupRepo_u24lambda_u2419.getLogger().throwError("Failed to load backup repo from zip file: " + $this$switchToBackupRepo_u24lambda_u2419.getRepoZipFile().getAbsolutePath());
                throw new KotlinNothingValueException();
            }
            $this$switchToBackupRepo_u24lambda_u2419.isUsingBackup = true;
            $this$switchToBackupRepo_u24lambda_u2419.progress.update("writeToFile: switchToBackupRepo");
            $this$switchToBackupRepo_u24lambda_u2419.getCommitStorage().writeToFile(new RepoCommit("backup-repo", null, null));
            $this$switchToBackupRepo_u24lambda_u2419.progress.update("Successfully switched to backup repo");
            $this$switchToBackupRepo_u24lambda_u2419.getLogger().debug("Successfully switched to backup repo");
            return FetchUnpackResult.SWITCHED_TO_BACKUP;
        }
        catch (Throwable bl) {
            Object object2;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable e = object2 = throwable;
                boolean bl2 = false;
                this.getLogger().logNonDestructiveError("Failed to switch to backup repo: " + e.getMessage());
                this.progress.update("Failed to switch to backup repo: " + e.getMessage());
            }
            object2 = FetchUnpackResult.FAILED;
            return (FetchUnpackResult)((Object)(Result.isFailure-impl((Object)object) ? object2 : object));
        }
    }

    public void reportExtraStatusInfo() {
    }

    /*
     * Unable to fully structure code
     */
    private final Object isRepeatErrorOrFixed(Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isRepeatErrorOrFixed.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AbstractRepoManager<E> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AbstractRepoManager.access$isRepeatErrorOrFixed(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.progress.update("call isRepeatErrorOrFixed");
                if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(this.latestError), (long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)) < 0 || !this.getConfig().getRepoAutoUpdate()) {
                    return Boxing.boxBoolean((boolean)true);
                }
                this.latestError = SimpleTimeMark.Companion.now-uFjCsEo();
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.getCommitComparison(false, (Continuation<RepoComparison>)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl27
            }
            case 1: {
                this = (AbstractRepoManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                v1 = comparison = (RepoComparison)v0;
                if (v1 != null) {
                    it = v1;
                    $i$a$-let-AbstractRepoManager$isRepeatErrorOrFixed$isOutdated$1 = false;
                    v2 = !it.getHashesMatch();
                } else {
                    $this$isRepeatErrorOrFixed_u24lambda_u2422 = this;
                    $i$a$-run-AbstractRepoManager$isRepeatErrorOrFixed$isOutdated$2 = false;
                    $this$isRepeatErrorOrFixed_u24lambda_u2422.getLogger().logNonDestructiveError("Failed to fetch latest commit for repo status check.");
                    v2 = false;
                }
                isOutdated = v2;
                if (!isOutdated) ** GOTO lbl57
                RepoLogger.logToChat$default(this.getLogger(), "Repo Issue caught, however the repo is outdated.\n\u00a7aTrying to update it now...", null, 2, null);
                $continuation.L$0 = this;
                $continuation.label = 2;
                v3 = AbstractRepoManager.fetchAndUnpackRepo$default(this, false, false, false, false, (Continuation)$continuation, 14, null);
                if (v3 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl51
            }
            case 2: {
                this = (AbstractRepoManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl51:
                // 2 sources

                if ((result = (FetchUnpackResult)v3) == FetchUnpackResult.SUCCESS) {
                    RepoLogger.logToChat$default(this.getLogger(), "\u00a7a" + this.getCommonName() + " Repo updated successfully!", null, 2, null);
                    this.progress.update("repo update successfully!");
                    return Boxing.boxBoolean((boolean)true);
                }
                RepoLogger.logToChat$default(this.getLogger(), "\u00a7cFailed to update the " + this.getCommonName() + " Repo.", null, 2, null);
                this.progress.update("Failed to update the " + this.getCommonName() + " Repo.");
lbl57:
                // 2 sources

                return Boxing.boxBoolean((boolean)false);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object displayRepoStatus(boolean var1_1, boolean var2_2, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof displayRepoStatus.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AbstractRepoManager<E> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.displayRepoStatus(false, false, (Continuation<Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (joinEvent == false) break;
                $continuation.label = 1;
                v0 = this.onJoinStatusError((Continuation<Unit>)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl21:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        v1 = this.getCommitStorage().readFromFile();
        if (v1 == null) {
            v1 = new RepoCommit(null, null, 3, null);
        }
        currentDownloadedCommit = v1.component1();
        if (this.unsuccessfulConstants.isEmpty() && ((Collection)this.successfulConstants).isEmpty() == false) {
            RepoLogger.logToChat$default(this.getLogger(), this.getCommonName() + " Repo working fine! Commit hash: \u00a7b" + currentDownloadedCommit + "\u00a7r", null, 2, null);
            this.reportExtraStatusInfo();
            return Unit.INSTANCE;
        }
        if (command != false) ** GOTO lbl45
        $continuation.L$0 = this;
        $continuation.L$1 = currentDownloadedCommit;
        $continuation.label = 2;
        v2 = this.isRepeatErrorOrFixed((Continuation<Boolean>)$continuation);
        if (v2 == var9_6) {
            return var9_6;
        }
        ** GOTO lbl43
        {
            case 2: {
                currentDownloadedCommit = (String)$continuation.L$1;
                this = (AbstractRepoManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl43:
                // 2 sources

                if (((Boolean)v2).booleanValue()) {
                    return Unit.INSTANCE;
                }
lbl45:
                // 3 sources

                this.getLogger().errorToChat(this.getCommonName() + " Repo has errors! Commit hash: \u00a7b" + currentDownloadedCommit + "\u00a7r");
                if (((Collection)this.successfulConstants).isEmpty() == false) {
                    RepoLogger.logToChat$default(this.getLogger(), "Successful Constants \u00a77(" + this.successfulConstants.size() + "):", null, 2, null);
                }
                for (String constant : this.successfulConstants) {
                    RepoLogger.logToChat$default(this.getLogger(), "   - \u00a77" + constant, null, 2, null);
                }
                this.getLogger().logToChat("Unsuccessful Constants \u00a77(" + this.unsuccessfulConstants.size() + "):", "\u00a7e");
                for (String constant : this.unsuccessfulConstants) {
                    this.getLogger().logToChat("   - \u00a77" + constant, "\u00a7e");
                }
                this.reportExtraStatusInfo();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object displayRepoStatus$default(AbstractRepoManager abstractRepoManager, boolean bl, boolean bl2, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: displayRepoStatus");
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return abstractRepoManager.displayRepoStatus(bl, bl2, (Continuation<Unit>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object onJoinStatusError(Continuation<? super Unit> $completion) {
        if (!($completion instanceof onJoinStatusError.1)) ** GOTO lbl-1000
        var14_2 = $completion;
        if ((var14_2.label & -2147483648) != 0) {
            var14_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AbstractRepoManager<E> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AbstractRepoManager.access$onJoinStatusError(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.unsuccessfulConstants.isEmpty()) ** GOTO lbl24
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.isRepeatErrorOrFixed((Continuation<Boolean>)$continuation);
                if (v0 == var15_4) {
                    return var15_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (AbstractRepoManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) ** GOTO lbl25
lbl24:
                // 2 sources

                return Unit.INSTANCE;
lbl25:
                // 1 sources

                $this$onJoinStatusError_u24lambda_u2423 = var3_5 = CollectionsKt.createListBuilder();
                $i$a$-buildList-AbstractRepoManager$onJoinStatusError$text$1 = false;
                $this$onJoinStatusError_u24lambda_u2423.add("\u00a7c[SkyHanni-4.20.0] \u00a77" + this.getCommonName() + " Repo Issue!");
                $this$onJoinStatusError_u24lambda_u2423.add("\u00a7cSome features may not work. Please report this error on the Discord if it persists!");
                $this$onJoinStatusError_u24lambda_u2423.add("\u00a77Repo Auto Update Value: \u00a7c" + this.getConfig().getRepoAutoUpdate());
                $this$onJoinStatusError_u24lambda_u2423.add("\u00a77Backup Repo Value: \u00a7c" + this.isUsingBackup);
                if (!this.getConfig().getRepoAutoUpdate()) {
                    $this$onJoinStatusError_u24lambda_u2423.add("\u00a74You have Repo Auto Update turned off, please try turning that on.");
                }
                $this$onJoinStatusError_u24lambda_u2423.add("\u00a7cUnsuccessful Constants \u00a77(" + this.unsuccessfulConstants.size() + "):");
                for (String constant : this.unsuccessfulConstants) {
                    $this$onJoinStatusError_u24lambda_u2423.add("   \u00a7e- \u00a77" + constant);
                }
                $this$map$iv = CollectionsKt.build((List)var3_5);
                $i$f$map = false;
                $i$a$-buildList-AbstractRepoManager$onJoinStatusError$text$1 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var10_15 = (String)item$iv$iv;
                    var12_17 = destination$iv$iv;
                    $i$a$-map-AbstractRepoManager$onJoinStatusError$text$2 = false;
                    var12_17.add(TextHelper.asComponent$default(TextHelper.INSTANCE, (String)it, null, 1, null));
                }
                text = (List)destination$iv$iv;
                var3_5 = new Object[]{text};
                TextHelper.send$default(TextHelper.INSTANCE, TextHelper.INSTANCE.multiline(var3_5), 0, 1, null);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object getCommitComparison(boolean var1_1, Continuation<? super RepoComparison> $completion) {
        if (!($completion instanceof getCommitComparison.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AbstractRepoManager<E> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AbstractRepoManager.access$getCommitComparison(this.this$0, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getCommitStorage().readFromFile();
                if (v0 == null) {
                    v0 = new RepoCommit(null, null, 3, null);
                }
                this.localRepoCommit = v0;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = this.getGithubRepoLocation().getLatestCommit(silentError != false, (Continuation<? super RepoCommit>)$continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl26
            }
            case 1: {
                this = (AbstractRepoManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl26:
                // 2 sources

                v2 = (RepoCommit)v1;
                if (v2 == null) {
                    return null;
                }
                latestRepoCommit = v2;
                return new RepoComparison(this.getCommonName(), this.localRepoCommit, latestRepoCommit);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object fetchAndUnpackRepo(boolean var1_1, boolean var2_2, boolean var3_3, boolean var4_4, Continuation<? super FetchUnpackResult> $completion) {
        if (!($completion instanceof fetchAndUnpackRepo.1)) ** GOTO lbl-1000
        var20_6 = $completion;
        if ((var20_6.label & -2147483648) != 0) {
            var20_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                boolean Z$0;
                boolean Z$1;
                boolean Z$2;
                boolean Z$3;
                /* synthetic */ Object result;
                final /* synthetic */ AbstractRepoManager<E> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AbstractRepoManager.access$fetchAndUnpackRepo(this.this$0, false, false, false, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var21_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.repoMutex;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.Z$0 = command;
                $continuation.Z$1 = silentError;
                $continuation.Z$2 = forceReset;
                $continuation.Z$3 = switchToBackupOnFail;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var21_8) {
                    return var21_8;
                }
                ** GOTO lbl38
            }
            case 1: {
                $i$f$withLock = false;
                switchToBackupOnFail = $continuation.Z$3;
                forceReset = $continuation.Z$2;
                silentError = $continuation.Z$1;
                command = $continuation.Z$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (AbstractRepoManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl38:
                // 3 sources

                $i$a$-withLock$default-AbstractRepoManager$fetchAndUnpackRepo$2 = false;
                this.progress.update("call fetchAndUnpackRepo");
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.Z$0 = command;
                $continuation.Z$1 = forceReset;
                $continuation.Z$2 = switchToBackupOnFail;
                $continuation.label = 2;
                v1 = this.getCommitComparison(silentError != false, (Continuation<RepoComparison>)$continuation);
                ** if (v1 != var21_8) goto lbl50
lbl49:
                // 1 sources

                return var21_8;
lbl50:
                // 1 sources

                ** GOTO lbl64
            }
            case 2: {
                $i$f$withLock = false;
                $i$a$-withLock$default-AbstractRepoManager$fetchAndUnpackRepo$2 = false;
                switchToBackupOnFail = $continuation.Z$2;
                forceReset = $continuation.Z$1;
                command = $continuation.Z$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (AbstractRepoManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl64:
                // 2 sources

                if ((RepoComparison)v1 != null) ** GOTO lbl71
                $this$fetchAndUnpackRepo_u24lambda_u2426_u24lambda_u2425 = this;
                $i$a$-run-AbstractRepoManager$fetchAndUnpackRepo$2$comparison$1 = false;
                var18_20 = switchToBackupOnFail != false ? $this$fetchAndUnpackRepo_u24lambda_u2426_u24lambda_u2425.switchToBackupRepo() : FetchUnpackResult.FAILED;
                $this$withLock_u24default$iv.unlock(owner$iv);
                return var18_20;
lbl71:
                // 2 sources

                comparison = v2;
                if (!comparison.getHashesMatch() || forceReset || !this.getRepoDirectory().exists() || !this.unsuccessfulConstants.isEmpty()) ** GOTO lbl80
                if (command) {
                    comparison.reportRepoUpToDate();
                    this.shouldManuallyReload = false;
                }
                var17_22 = FetchUnpackResult.SUCCESS;
                $this$withLock_u24default$iv.unlock(owner$iv);
                return var17_22;
lbl80:
                // 2 sources

                if (command) {
                    if (!comparison.getHashesMatch()) {
                        this.progress.update("hashes don't match, outdated!");
                        RepoComparison.reportRepoOutdated$default(comparison, null, 1, null);
                    } else if (forceReset) {
                        comparison.reportForceRebuild();
                    }
                }
                this.progress.update("call prepCleanRepoFileSystem");
                this.prepCleanRepoFileSystem();
                this.progress.update("call downloadCommitZipToFile");
                $continuation.L$0 = this;
                $continuation.L$1 = $this$withLock_u24default$iv;
                $continuation.L$2 = comparison;
                $continuation.Z$0 = switchToBackupOnFail;
                $continuation.label = 3;
                v3 = GitHubUtils.RepoLocation.downloadCommitZipToFile$default(this.getGithubRepoLocation(), this.getRepoZipFile(), null, (Continuation)$continuation, 2, null);
                ** if (v3 != var21_8) goto lbl98
lbl97:
                // 1 sources

                return var21_8;
lbl98:
                // 1 sources

                ** GOTO lbl111
            }
            case 3: {
                $i$a$-withLock$default-AbstractRepoManager$fetchAndUnpackRepo$2 = false;
                $i$f$withLock = false;
                switchToBackupOnFail = $continuation.Z$0;
                comparison = (RepoComparison)$continuation.L$2;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (AbstractRepoManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl111:
                // 2 sources

                if (!((Boolean)v3).booleanValue()) {
                    this.progress.update("Failed to download the repo zip file from GitHub.");
                    this.getLogger().logNonDestructiveError("Failed to download the repo zip file from GitHub.");
                    if (switchToBackupOnFail) {
                        v4 = this.switchToBackupRepo();
                    } else {
                        this.progress.update("FetchUnpackResult.FAILED");
                        v4 = FetchUnpackResult.FAILED;
                    }
                    var16_23 = v4;
                    return var16_23;
                }
                this.progress.update("call loadFromZip");
                if (!this.getRepoFileSystem().loadFromZip(this.getRepoZipFile(), this.getLogger())) {
                    this.getLogger().logNonDestructiveError("Failed to unpack the downloaded zip file.");
                    var15_24 = switchToBackupOnFail != false ? this.switchToBackupRepo() : FetchUnpackResult.FAILED;
                    return var15_24;
                }
                this.progress.update("writeToFile: fetchAndUnpackRepo");
                this.getCommitStorage().writeToFile(comparison.getLatest());
                this.isUsingBackup = false;
                var14_25 = FetchUnpackResult.SUCCESS;
                return var14_25;
            }
            catch (Throwable var13_26) {
                throw var13_26;
            }
            {
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object fetchAndUnpackRepo$default(AbstractRepoManager abstractRepoManager, boolean bl, boolean bl2, boolean bl3, boolean bl4, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: fetchAndUnpackRepo");
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            bl4 = true;
        }
        return abstractRepoManager.fetchAndUnpackRepo(bl, bl2, bl3, bl4, (Continuation<FetchUnpackResult>)continuation);
    }

    private final void prepCleanRepoFileSystem() {
        System.out.println((Object)"call prepCleanRepoFileSystem");
        FilesKt.deleteRecursively((File)this.getRepoDirectory());
        this.setRepoFileSystem(RepoFileSystem.Companion.createAndClean(this.getRepoDirectory(), this.getConfig().getUnzipToMemory()));
        this.getRepoDirectory().mkdirs();
        this.getRepoZipFile().createNewFile();
    }

    public final void reloadLocalRepo(@NotNull String answerMessage) {
        Intrinsics.checkNotNullParameter((Object)answerMessage, (String)"answerMessage");
        this.progress.update("call reloadLocalRepo");
        this.shouldManuallyReload = true;
        SkyHanniMod.launchIOCoroutine-8Mi8wO0$default(SkyHanniMod.INSTANCE, this.getCommonName() + " reloadLocalRepo", 0L, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, answerMessage, null){
            int label;
            final /* synthetic */ AbstractRepoManager<E> this$0;
            final /* synthetic */ String $answerMessage;
            {
                this.this$0 = $receiver;
                this.$answerMessage = $answerMessage;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = AbstractRepoManager.access$reloadRepository(this.this$0, this.$answerMessage, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    public static /* synthetic */ void reloadLocalRepo$default(AbstractRepoManager abstractRepoManager, String object, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reloadLocalRepo");
        }
        if ((n & 1) != 0) {
            object = abstractRepoManager.getCommonName() + " Repo loaded from local files successfully.";
        }
        abstractRepoManager.reloadLocalRepo((String)object);
    }

    @Nullable
    public Object extraReloadCoroutineWork(@NotNull Continuation<? super Unit> $completion) {
        return AbstractRepoManager.extraReloadCoroutineWork$suspendImpl(this, $completion);
    }

    static /* synthetic */ <E extends AbstractRepoReloadEvent> Object extraReloadCoroutineWork$suspendImpl(AbstractRepoManager<E> $this, Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object reloadRepository(String var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof reloadRepository.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ AbstractRepoManager<E> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AbstractRepoManager.access$reloadRepository(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$withLock_u24default$iv = this.repoMutex;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = answerMessage;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl32
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                answerMessage = (String)$continuation.L$1;
                this = (AbstractRepoManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 3 sources

                $i$a$-withLock$default-AbstractRepoManager$reloadRepository$2 = false;
                this.progress.update("call reloadRepository");
                if (this.shouldManuallyReload) ** GOTO lbl40
                var11_15 = Unit.INSTANCE;
                $this$withLock_u24default$iv.unlock(owner$iv);
                return var11_15;
lbl40:
                // 2 sources

                this.loadingError = false;
                this.successfulConstants.clear();
                this.unsuccessfulConstants.clear();
                this.progress.update("call extraReloadCoroutineWork");
                $continuation.L$0 = this;
                $continuation.L$1 = answerMessage;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.label = 2;
                v1 = this.extraReloadCoroutineWork((Continuation<Unit>)$continuation);
                ** if (v1 != var14_5) goto lbl51
lbl50:
                // 1 sources

                return var14_5;
lbl51:
                // 1 sources

                ** GOTO lbl63
            }
            case 2: {
                $i$a$-withLock$default-AbstractRepoManager$reloadRepository$2 = false;
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                answerMessage = (String)$continuation.L$1;
                this = (AbstractRepoManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl63:
                // 2 sources

                this.progress.update("call eventCtor.newInstance");
                var7_16 = new Object[]{this};
                ((SkyHanniEvent)this.getEventCtor().newInstance(var7_16)).post((Function1<? super Throwable, Unit>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, reloadRepository$lambda$29$lambda$27(at.hannibal2.skyhanni.data.repo.AbstractRepoManager java.lang.Throwable ), (Ljava/lang/Throwable;)Lkotlin/Unit;)((AbstractRepoManager)this));
                var8_17 = this;
                $continuation.L$0 = this;
                $continuation.L$1 = answerMessage;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.L$3 = var8_17;
                $continuation.label = 3;
                v2 = this.getRepoFileSystem().transitionAfterReload((Continuation<? super RepoFileSystem>)$continuation);
                ** if (v2 != var14_5) goto lbl76
lbl75:
                // 1 sources

                return var14_5;
lbl76:
                // 1 sources

                ** GOTO lbl89
            }
            case 3: {
                $i$a$-withLock$default-AbstractRepoManager$reloadRepository$2 = false;
                $i$f$withLock = false;
                var8_17 = (AbstractRepoManager)$continuation.L$3;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                answerMessage = (String)$continuation.L$1;
                this = (AbstractRepoManager)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl89:
                    // 2 sources

                    var8_17.setRepoFileSystem((RepoFileSystem)v2);
                    if (((CharSequence)answerMessage).length() > 0 && !this.loadingError) {
                        this.progress.end(answerMessage);
                        RepoLogger.logToChat$default(this.getLogger(), "\u00a7a" + answerMessage, null, 2, null);
                    } else if (this.loadingError) {
                        this.progress.end("Error with the " + this.getCommonShortName() + " Repo detected");
                        ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, "Error with the " + this.getCommonShortName() + " Repo detected, try /" + this.getUpdateCommand() + " to fix it!", (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, reloadRepository$lambda$29$lambda$28(at.hannibal2.skyhanni.data.repo.AbstractRepoManager ), ()Lkotlin/Unit;)((AbstractRepoManager)this), "\u00a7eClick to update the Repo!", 0L, false, "\u00a7c", false, false, 216, null);
                        if (this.unsuccessfulConstants.isEmpty()) {
                            this.unsuccessfulConstants.add("All Constants");
                        }
                    } else {
                        this.progress.end("done.");
                    }
                    var9_18 = Unit.INSTANCE;
                }
                catch (Throwable var10_19) {
                    throw var10_19;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var9_18;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object reloadRepository$default(AbstractRepoManager abstractRepoManager, String string, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reloadRepository");
        }
        if ((n & 1) != 0) {
            string = "";
        }
        return abstractRepoManager.reloadRepository(string, (Continuation<Unit>)continuation);
    }

    private static final Class eventClass_delegate$lambda$0(AbstractRepoManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Type type2 = this$0.getClass().getGenericSuperclass();
        Intrinsics.checkNotNull((Object)type2, (String)"null cannot be cast to non-null type java.lang.reflect.ParameterizedType");
        Type type3 = ((ParameterizedType)type2).getActualTypeArguments()[0];
        Intrinsics.checkNotNull((Object)type3, (String)"null cannot be cast to non-null type java.lang.Class<E of at.hannibal2.skyhanni.data.repo.AbstractRepoManager.eventClass_delegate$lambda$0>");
        return (Class)type3;
    }

    private static final Constructor eventCtor_delegate$lambda$1(AbstractRepoManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Class[] classArray = new Class[]{AbstractRepoManager.class};
        return this$0.getEventClass().getConstructor(classArray);
    }

    private static final String commonShortName_delegate$lambda$2(AbstractRepoManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = this$0.getCommonShortNameCased().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    private static final RepoLogger logger_delegate$lambda$3(AbstractRepoManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new RepoLogger("[Repo - " + this$0.getCommonName() + "]");
    }

    private static final File repoDirectory_delegate$lambda$4(AbstractRepoManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new File(this$0.getConfigDirectory(), "repo");
    }

    private static final File repoZipFile_delegate$lambda$5(AbstractRepoManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new File(this$0.getRepoDirectory(), this$0.getCommonShortName() + "-repo-" + ((AbstractRepoLocationConfig)this$0.getConfig().getLocation()).getDefaultBranch() + ".zip");
    }

    private static final RepoCommitStorage commitStorage_delegate$lambda$6(AbstractRepoManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new RepoCommitStorage(new File(this$0.getConfigDirectory(), "currentCommit.json"));
    }

    private static final RepoFileSystem repoFileSystem_delegate$lambda$7(AbstractRepoManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new DiskRepoFileSystem(this$0.getRepoDirectory());
    }

    private static final Unit registerCommands$lambda$10$lambda$8(AbstractRepoManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateRepo("/" + this$0.getUpdateCommand(), true);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit registerCommands$lambda$10(AbstractRepoManager this$0, BaseBrigadierBuilder $this$registerBrigadier) {
        void name$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Remove and re-download the " + this$0.getCommonName() + " repo");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_BUG_FIX);
        $this$registerBrigadier.simpleCallback((Function0<Unit>)((Function0)() -> AbstractRepoManager.registerCommands$lambda$10$lambda$8(this$0)));
        String string = "force";
        BoolArgumentType boolArgumentType = BoolArgumentType.bool();
        Intrinsics.checkNotNullExpressionValue((Object)boolArgumentType, (String)"bool(...)");
        ArgumentType argument$iv = (ArgumentType)boolArgumentType;
        SuggestionProvider suggestions$iv = null;
        boolean $i$f$argCallback = false;
        BrigadierBuilder this_$iv$iv = $this$registerBrigadier;
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            this_$iv$iv.internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, Boolean>>, Unit>((String)name$iv, $this$registerBrigadier, this$0){
                final /* synthetic */ String $name;
                final /* synthetic */ BaseBrigadierBuilder $this_registerBrigadier$inlined;
                final /* synthetic */ AbstractRepoManager this$0;
                {
                    this.$name = $name;
                    this.$this_registerBrigadier$inlined = baseBrigadierBuilder;
                    this.this$0 = abstractRepoManager;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, Boolean>> $this$internalArg) {
                    void it;
                    Intrinsics.checkNotNullParameter($this$internalArg, (String)"$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<Boolean> brigadierArgument = new BrigadierArgument<Boolean>(argumentName$iv, Boolean.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, Boolean>> $this$argCallback_u24lambda_u2412 = $this$internalArg;
                    boolean bl = false;
                    $this$argCallback_u24lambda_u2412.callback((Function1<ArgContext, Unit>)((Function1)new Function1<ArgContext, Unit>((BrigadierArgument)it, this.$this_registerBrigadier$inlined, this.this$0){
                        final /* synthetic */ BrigadierArgument $it;
                        final /* synthetic */ BaseBrigadierBuilder $this_registerBrigadier$inlined;
                        final /* synthetic */ AbstractRepoManager this$0;
                        {
                            this.$it = $it;
                            this.$this_registerBrigadier$inlined = baseBrigadierBuilder;
                            this.this$0 = abstractRepoManager;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter((Object)$this$callback, (String)"$this$callback");
                            Boolean it = (Boolean)$this$callback.getArg(this.$it);
                            ArgContext $this$registerCommands_u24lambda_u2410_u24lambda_u249 = $this$callback;
                            boolean bl = false;
                            this.$this_registerBrigadier$inlined.setDescription("optionally only re-download if the repo is out of date");
                            String string = "/" + this.this$0.getUpdateCommand() + " force";
                            Intrinsics.checkNotNull((Object)it);
                            this.this$0.updateRepo(string, it);
                        }
                    }));
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv$iv = (String)pair.component1();
            String argName$iv$iv = (String)pair.component2();
            String[] stringArray = new String[]{literalNames$iv$iv};
            this_$iv$iv.literal(stringArray, (Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)((Function1)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv$iv, argument$iv, suggestions$iv, $this$registerBrigadier, this$0){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                final /* synthetic */ BaseBrigadierBuilder $this_registerBrigadier$inlined;
                final /* synthetic */ AbstractRepoManager this$0;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                    this.$this_registerBrigadier$inlined = baseBrigadierBuilder;
                    this.this$0 = abstractRepoManager;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, (String)"$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, (SuggestionProvider<Object>)this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, Boolean>>, Unit>(this.$argName, this.$this_registerBrigadier$inlined, this.this$0){
                        final /* synthetic */ String $argName;
                        final /* synthetic */ BaseBrigadierBuilder $this_registerBrigadier$inlined;
                        final /* synthetic */ AbstractRepoManager this$0;
                        {
                            this.$argName = $argName;
                            this.$this_registerBrigadier$inlined = baseBrigadierBuilder;
                            this.this$0 = abstractRepoManager;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, Boolean>> $this$internalArg) {
                            void it;
                            Intrinsics.checkNotNullParameter($this$internalArg, (String)"$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<Boolean> brigadierArgument = new BrigadierArgument<Boolean>(argumentName$iv, Boolean.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, Boolean>> $this$argCallback_u24lambda_u2412 = $this$internalArg;
                            boolean bl = false;
                            $this$argCallback_u24lambda_u2412.callback((Function1<ArgContext, Unit>)((Function1)new Function1<ArgContext, Unit>((BrigadierArgument)it, this.$this_registerBrigadier$inlined, this.this$0){
                                final /* synthetic */ BrigadierArgument $it;
                                final /* synthetic */ BaseBrigadierBuilder $this_registerBrigadier$inlined;
                                final /* synthetic */ AbstractRepoManager this$0;
                                {
                                    this.$it = $it;
                                    this.$this_registerBrigadier$inlined = baseBrigadierBuilder;
                                    this.this$0 = abstractRepoManager;
                                }

                                public final void invoke(ArgContext $this$callback) {
                                    Intrinsics.checkNotNullParameter((Object)$this$callback, (String)"$this$callback");
                                    Boolean it = (Boolean)$this$callback.getArg(this.$it);
                                    ArgContext $this$registerCommands_u24lambda_u2410_u24lambda_u249 = $this$callback;
                                    boolean bl = false;
                                    this.$this_registerBrigadier$inlined.setDescription("optionally only re-download if the repo is out of date");
                                    String string = "/" + this.this$0.getUpdateCommand() + " force";
                                    Intrinsics.checkNotNull((Object)it);
                                    this.this$0.updateRepo(string, it);
                                }
                            }));
                        }
                    });
                }
            }));
        }
        return Unit.INSTANCE;
    }

    private static final Unit registerCommands$lambda$11(AbstractRepoManager this$0, BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Shows the status of the " + this$0.getCommonName() + " repo");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_BUG_FIX);
        $this$registerBrigadier.coroutineSimpleCallback((Function2<ArgContext, Continuation<Unit>, Object>)((Function2)new Function2<ArgContext, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ AbstractRepoManager<E> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.displayRepoStatus(true, true, (Continuation<Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(ArgContext p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit registerCommands$lambda$13$lambda$12(AbstractRepoManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.progress.start("Reloading the local " + this$0.getCommonName() + " repo via /" + this$0.getReloadCommand());
        AbstractRepoManager.reloadLocalRepo$default(this$0, null, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit registerCommands$lambda$13(AbstractRepoManager this$0, BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Reloads the local " + this$0.getCommonName() + " repo");
        $this$registerBrigadier.setCategory(CommandCategory.DEVELOPER_TEST);
        $this$registerBrigadier.simpleCallback((Function0<Unit>)((Function0)() -> AbstractRepoManager.registerCommands$lambda$13$lambda$12(this$0)));
        return Unit.INSTANCE;
    }

    private static final Unit resetRepositoryLocation$lambda$17$lambda$16(AbstractRepoManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AbstractRepoManager.updateRepo$default(this$0, "click in chat after reset", false, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit initRepo$lambda$18(AtomicBoolean $loaded, AbstractRepoManager this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$loaded, (String)"$loaded");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!$loaded.get()) {
            this$0.progress.update("reached timeout");
        }
        return Unit.INSTANCE;
    }

    private static final Unit reloadRepository$lambda$29$lambda$27(AbstractRepoManager this$0, Throwable error) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this$0.progress.update("Error while posting repo reload event");
        this$0.getLogger().logErrorWithData(error, "Error while posting repo reload event");
        this$0.loadingError = true;
        return Unit.INSTANCE;
    }

    private static final Unit reloadRepository$lambda$29$lambda$28(AbstractRepoManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AbstractRepoManager.updateRepo$default(this$0, "click on chat after error", false, 2, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$reloadRepository(AbstractRepoManager $this, String answerMessage, Continuation $completion) {
        return $this.reloadRepository(answerMessage, (Continuation<Unit>)$completion);
    }

    public static final /* synthetic */ Set access$getUnsuccessfulConstants$p(AbstractRepoManager $this) {
        return $this.unsuccessfulConstants;
    }

    public static final /* synthetic */ Object access$isRepeatErrorOrFixed(AbstractRepoManager $this, Continuation $completion) {
        return $this.isRepeatErrorOrFixed((Continuation<Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$onJoinStatusError(AbstractRepoManager $this, Continuation $completion) {
        return $this.onJoinStatusError((Continuation<Unit>)$completion);
    }

    public static final /* synthetic */ Object access$getCommitComparison(AbstractRepoManager $this, boolean silentError, Continuation $completion) {
        return $this.getCommitComparison(silentError, (Continuation<RepoComparison>)$completion);
    }

    public static final /* synthetic */ Object access$fetchAndUnpackRepo(AbstractRepoManager $this, boolean command2, boolean silentError, boolean forceReset, boolean switchToBackupOnFail, Continuation $completion) {
        return $this.fetchAndUnpackRepo(command2, silentError, forceReset, switchToBackupOnFail, (Continuation<FetchUnpackResult>)$completion);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AbstractRepoManager.class, "repoFileSystem", "getRepoFileSystem()Lat/hannibal2/skyhanni/data/repo/RepoFileSystem;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000b\n\u0002\b\n\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0013\b\u0002\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lat/hannibal2/skyhanni/data/repo/AbstractRepoManager$FetchUnpackResult;", "", "", "canContinue", "<init>", "(Ljava/lang/String;IZ)V", "Z", "getCanContinue", "()Z", "SUCCESS", "SWITCHED_TO_BACKUP", "FAILED", "1.21.5"})
    private static final class FetchUnpackResult
    extends Enum<FetchUnpackResult> {
        private final boolean canContinue;
        public static final /* enum */ FetchUnpackResult SUCCESS = new FetchUnpackResult("SUCCESS", 0, false, 1, null);
        public static final /* enum */ FetchUnpackResult SWITCHED_TO_BACKUP = new FetchUnpackResult("SWITCHED_TO_BACKUP", 1, false, 1, null);
        public static final /* enum */ FetchUnpackResult FAILED = new FetchUnpackResult(false);
        private static final /* synthetic */ FetchUnpackResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private FetchUnpackResult(boolean canContinue) {
            this.canContinue = canContinue;
        }

        /* synthetic */ FetchUnpackResult(String string, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = true;
            }
            this(bl);
        }

        public final boolean getCanContinue() {
            return this.canContinue;
        }

        public static FetchUnpackResult[] values() {
            return (FetchUnpackResult[])$VALUES.clone();
        }

        public static FetchUnpackResult valueOf(String value) {
            return Enum.valueOf(FetchUnpackResult.class, value);
        }

        @NotNull
        public static EnumEntries<FetchUnpackResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fetchUnpackResultArray = new FetchUnpackResult[]{FetchUnpackResult.SUCCESS, FetchUnpackResult.SWITCHED_TO_BACKUP, FetchUnpackResult.FAILED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

