/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.fishing.FishingConfig;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.IslandGraphs;
import at.hannibal2.skyhanni.data.model.GraphNode;
import at.hannibal2.skyhanni.data.model.GraphNodeTag;
import at.hannibal2.skyhanni.events.ItemClickEvent;
import at.hannibal2.skyhanni.events.ReceiveParticleEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.ParticlePathBezierFitter;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_1799;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0003J\u000f\u0010\u0017\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u000f\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001e\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010 \u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010!R\u0014\u0010$\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0018\u0010&\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0016\u0010+\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010!R\u0016\u0010,\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010!R\u0016\u0010-\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lat/hannibal2/skyhanni/features/fishing/FishingHotspotRadar;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;", "event", "", "onReceiveParticle", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "location", "pathFind", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/events/ItemClickEvent;", "onUseAbility", "(Lat/hannibal2/skyhanni/events/ItemClickEvent;)V", "onWorldChange", "reset", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/fishing/FishingConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/fishing/FishingConfig;", "config", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastParticle", "J", "lastAbilityUse", "Lat/hannibal2/skyhanni/utils/ParticlePathBezierFitter;", "bezierFitter", "Lat/hannibal2/skyhanni/utils/ParticlePathBezierFitter;", "hotspotLocation", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "HOTSPOT_RADAR", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "foundTime", "lastUpdate", "isUnknown", "Z", "1.21.5"})
public final class FishingHotspotRadar {
    @NotNull
    public static final FishingHotspotRadar INSTANCE = new FishingHotspotRadar();
    private static long lastParticle = SimpleTimeMark.Companion.farPast();
    private static long lastAbilityUse = SimpleTimeMark.Companion.farPast();
    @NotNull
    private static final ParticlePathBezierFitter bezierFitter = new ParticlePathBezierFitter(3);
    @Nullable
    private static LorenzVec hotspotLocation;
    @NotNull
    private static final NeuInternalName HOTSPOT_RADAR;
    private static long foundTime;
    private static long lastUpdate;
    private static boolean isUnknown;

    private FishingHotspotRadar() {
    }

    private final FishingConfig getConfig() {
        return SkyHanniMod.feature.getFishing();
    }

    @HandleEvent(onlyOnSkyblock=true, receiveCancelled=true)
    public final void onReceiveParticle(@NotNull ReceiveParticleEvent event) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!this.isEnabled()) {
                return;
            }
            class_2396<?> type2 = event.getType();
            if (!Intrinsics.areEqual(type2, (Object)class_2398.field_11240)) {
                return;
            }
            if (event.getCount() != 1 || !(event.getSpeed() == 0.0f)) {
                return;
            }
            lastParticle = SimpleTimeMark.Companion.now-uFjCsEo();
            LorenzVec currLoc = event.getLocation();
            if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastAbilityUse), (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS)) > 0) {
                return;
            }
            if (bezierFitter.isEmpty()) {
                bezierFitter.addPoint(currLoc);
                return;
            }
            LorenzVec lorenzVec = bezierFitter.getLastPoint();
            if (lorenzVec == null) {
                return;
            }
            double distToLast = lorenzVec.distance(currLoc);
            if (distToLast == 0.0 || distToLast > 3.0) {
                return;
            }
            bezierFitter.addPoint(currLoc);
            LorenzVec lorenzVec2 = bezierFitter.solve();
            if (lorenzVec2 == null) {
                return;
            }
            LorenzVec guess = lorenzVec2;
            if (!SkyBlockUtils.INSTANCE.getCurrentIsland().isInBounds(guess)) {
                hotspotLocation = null;
                return;
            }
            hotspotLocation = guess;
            isUnknown = false;
            lastUpdate = SimpleTimeMark.Companion.now-uFjCsEo();
            LorenzVec lorenzVec3 = hotspotLocation;
            if (lorenzVec3 == null) break block9;
            LorenzVec it = lorenzVec3;
            boolean bl = false;
            DelayedRun.INSTANCE.runNextTick((Function0<Unit>)((Function0)() -> FishingHotspotRadar.onReceiveParticle$lambda$1$lambda$0(it)));
        }
    }

    private final void pathFind(LorenzVec location) {
        if (!this.getConfig().getGuessHotspotRadarPathFind()) {
            return;
        }
        foundTime = SimpleTimeMark.Companion.farFuture-uFjCsEo();
        GraphNode graphNode = IslandGraphs.INSTANCE.findClosestNode(location, (Function1<? super GraphNode, Boolean>)((Function1)FishingHotspotRadar::pathFind$lambda$2), 15.0);
        if (graphNode == null) {
            FishingHotspotRadar $this$pathFind_u24lambda_u244 = this;
            boolean bl = false;
            isUnknown = true;
            IslandGraphs.pathFind$default(IslandGraphs.INSTANCE, location, "\u00a7cUnknown Fishing Hotspot", LorenzColor.RED.toColor(), null, null, () -> FishingHotspotRadar.pathFind$lambda$4$lambda$3($this$pathFind_u24lambda_u244), 24, null);
            return;
        }
        GraphNode found = graphNode;
        IslandGraphs.pathFind$default(IslandGraphs.INSTANCE, found, "\u00a7bFishing Hotspot", LorenzColor.AQUA.toColor(), null, false, null, FishingHotspotRadar::pathFind$lambda$5, 28, null);
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        LorenzVec location;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                LorenzVec lorenzVec = hotspotLocation;
                if (lorenzVec == null) {
                    return;
                }
                location = lorenzVec;
                if (!isUnknown) break block4;
                if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastUpdate), (long)DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS)) >= 0) break block5;
            }
            return;
        }
        IslandGraphs.INSTANCE.reportLocation(location, "Found no path to fishing hotspot", "no node with tag 'fishing hotspot' found near the radar hotspot target", true, true);
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LorenzVec lorenzVec = hotspotLocation;
        if (lorenzVec == null) {
            return;
        }
        LorenzVec location = lorenzVec;
        double distance = location.distance(WorldRenderUtils.INSTANCE.exactPlayerEyeLocation(event));
        if (this.getConfig().getLineToHotspot()) {
            WorldRenderUtils.INSTANCE.drawLineToEye(event, location, LorenzColor.toChromaColor$default(LorenzColor.LIGHT_PURPLE, 0, 0, 3, null), 3, false);
        }
        if (distance > 10.0) {
            String formattedDistance = NumberUtil.INSTANCE.addSeparators((int)distance);
            WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event, location.add(-0.5, 1.7, -0.5), "\u00a7d\u00a7lHOTSPOT", 1.7, 0.0f, 0.0, 0.0, false, false, null, 504, null);
            WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event, location.add(-0.5, 1.6 - distance / 20.4, -0.5), " \u00a7r\u00a7e" + formattedDistance + "m", 1.0, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        } else {
            this.reset();
            foundTime = SimpleTimeMark.Companion.now-uFjCsEo();
        }
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onUseAbility(@NotNull ItemClickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (event.getClickType() != ClickType.RIGHT_CLICK) {
            return;
        }
        class_1799 class_17992 = event.getItemInHand();
        if (class_17992 == null) {
            return;
        }
        class_1799 item2 = class_17992;
        if (!Intrinsics.areEqual((Object)ItemUtils.INSTANCE.getInternalNameOrNull(item2), (Object)HOTSPOT_RADAR)) {
            return;
        }
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastParticle), (long)DurationKt.toDuration((double)0.2, (DurationUnit)DurationUnit.SECONDS)) < 0) {
            event.cancel();
            return;
        }
        bezierFitter.reset();
        lastAbilityUse = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    @HandleEvent
    public final void onWorldChange() {
        this.reset();
        foundTime = SimpleTimeMark.Companion.farPast();
        lastAbilityUse = SimpleTimeMark.Companion.farPast();
    }

    private final void reset() {
        hotspotLocation = null;
        bezierFitter.reset();
    }

    private final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && this.getConfig().getGuessHotspotRadar();
    }

    private static final Unit onReceiveParticle$lambda$1$lambda$0(LorenzVec $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        INSTANCE.pathFind($it);
        return Unit.INSTANCE;
    }

    private static final boolean pathFind$lambda$2(GraphNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.hasTag(GraphNodeTag.FISHING_HOTSPOT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean pathFind$lambda$4$lambda$3(FishingHotspotRadar $this_run) {
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        if (!$this_run.getConfig().getGuessHotspotRadarPathFind()) return false;
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(foundTime), (long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS)) >= 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean pathFind$lambda$5() {
        if (!INSTANCE.getConfig().getGuessHotspotRadarPathFind()) return false;
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(foundTime), (long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS)) >= 0) return false;
        return true;
    }

    static {
        HOTSPOT_RADAR = NeuInternalName.Companion.toInternalName("HOTSPOT_RADAR");
        foundTime = SimpleTimeMark.Companion.farPast();
        lastUpdate = SimpleTimeMark.Companion.farPast();
    }
}

