/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing.tracker;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandBuilder;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.features.fishing.FishingProfitTrackerConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.ItemAddManager;
import at.hannibal2.skyhanni.data.jsonobjects.repo.FishingProfitItemsJson;
import at.hannibal2.skyhanni.data.repo.AbstractRepoManager;
import at.hannibal2.skyhanni.data.repo.AbstractRepoReloadEvent;
import at.hannibal2.skyhanni.events.ItemAddEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.fishing.FishingBobberCastEvent;
import at.hannibal2.skyhanni.events.fishing.FishingCatchEvent;
import at.hannibal2.skyhanni.events.fishing.SeaCreatureFishEvent;
import at.hannibal2.skyhanni.features.fishing.FishingApi;
import at.hannibal2.skyhanni.features.nether.kuudra.KuudraApi;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.ItemCategory;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderDisplayHelper;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.collection.RenderableCollectionUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.RenderableUtils;
import at.hannibal2.skyhanni.utils.renderables.ScrollValue;
import at.hannibal2.skyhanni.utils.renderables.Searchable;
import at.hannibal2.skyhanni.utils.renderables.SearchableKt;
import at.hannibal2.skyhanni.utils.renderables.container.HorizontalContainerRenderable;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.tracker.ItemTrackerData;
import at.hannibal2.skyhanni.utils.tracker.SkyHanniItemTracker;
import at.hannibal2.skyhanni.utils.tracker.SkyHanniTracker;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001TB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000f\u001a\u0012\u0012\b\u0012\u00060\fj\u0002`\r\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J-\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016*\b\u0012\u0004\u0012\u00020\u00120\u00152\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020 H\u0007\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b#\u0010\u0003J\u000f\u0010$\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b$\u0010\u0003J'\u0010(\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010*\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010-\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020,H\u0007\u00a2\u0006\u0004\b-\u0010.J\u0017\u00100\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020/H\u0007\u00a2\u0006\u0004\b0\u00101J\u0017\u00103\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u000202H\u0007\u00a2\u0006\u0004\b3\u00104J\u000f\u00105\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b5\u00106J\u0017\u00108\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u000207H\u0007\u00a2\u0006\u0004\b8\u00109R\u0011\u0010=\u001a\u00020:8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u001b\u0010C\u001a\u00020>8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010@\u001a\u0004\bA\u0010BR\u0016\u0010E\u001a\u00020D8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010FR\u001a\u0010H\u001a\b\u0012\u0004\u0012\u00020\t0G8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010IR\u0014\u0010J\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u0018\u0010L\u001a\u00060\fj\u0002`\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bL\u0010MR\u001a\u0010N\u001a\u00060\fj\u0002`\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bN\u0010MR(\u0010O\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00110\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bO\u0010PR\u0014\u0010Q\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u00106R\u0014\u0010S\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u00106\u00a8\u0006U"}, d2={"Lat/hannibal2/skyhanni/features/fishing/tracker/FishingProfitTracker;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/features/fishing/tracker/FishingProfitTracker$Data;", "data", "", "", "Lat/hannibal2/skyhanni/features/fishing/tracker/CategoryName;", "", "getCurrentCategories", "(Lat/hannibal2/skyhanni/features/fishing/tracker/FishingProfitTracker$Data;)Ljava/util/Map;", "", "Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "drawDisplay", "(Lat/hannibal2/skyhanni/features/fishing/tracker/FishingProfitTracker$Data;)Ljava/util/List;", "", "Lkotlin/Function1;", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "", "addCategories", "(Ljava/util/List;Lat/hannibal2/skyhanni/features/fishing/tracker/FishingProfitTracker$Data;)Lkotlin/jvm/functions/Function1;", "checkMissingItems", "(Lat/hannibal2/skyhanni/features/fishing/tracker/FishingProfitTracker$Data;)V", "Lat/hannibal2/skyhanni/events/ItemAddEvent;", "onItemAdd", "(Lat/hannibal2/skyhanni/events/ItemAddEvent;)V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "addCatch", "onWorldChange", "internalName", "amount", "command", "tryAddItem", "(Lat/hannibal2/skyhanni/utils/NeuInternalName;IZ)V", "isAllowedItem", "(Lat/hannibal2/skyhanni/utils/NeuInternalName;)Z", "Lat/hannibal2/skyhanni/events/fishing/FishingBobberCastEvent;", "onBobberThrow", "(Lat/hannibal2/skyhanni/events/fishing/FishingBobberCastEvent;)V", "Lat/hannibal2/skyhanni/events/fishing/FishingCatchEvent;", "onCatch", "(Lat/hannibal2/skyhanni/events/fishing/FishingCatchEvent;)V", "Lat/hannibal2/skyhanni/events/fishing/SeaCreatureFishEvent;", "onSeaCreatureFish", "(Lat/hannibal2/skyhanni/events/fishing/SeaCreatureFishEvent;)V", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "Lat/hannibal2/skyhanni/config/features/fishing/FishingProfitTrackerConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/fishing/FishingProfitTrackerConfig;", "config", "Ljava/util/regex/Pattern;", "coinsChatPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getCoinsChatPattern", "()Ljava/util/regex/Pattern;", "coinsChatPattern", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastCatchTime", "J", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniItemTracker;", "tracker", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniItemTracker;", "MAGMA_FISH", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "NAME_ALL", "Ljava/lang/String;", "currentCategory", "itemCategories", "Ljava/util/Map;", "isRecentPickup", "getShouldShow", "shouldShow", "Data", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nFishingProfitTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FishingProfitTracker.kt\nat/hannibal2/skyhanni/features/fishing/tracker/FishingProfitTracker\n+ 2 AbstractRepoReloadEvent.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoReloadEvent\n+ 3 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n+ 4 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 RenderableUtils.kt\nat/hannibal2/skyhanni/utils/renderables/RenderableUtils\n+ 7 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 8 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 9 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n13#2,7:282\n21#2,6:299\n162#3,5:289\n167#3,4:295\n24#4:294\n1788#5,4:305\n241#6,10:309\n344#6,10:319\n253#6:329\n354#6,20:330\n386#6,2:350\n385#6,14:352\n259#6:366\n630#7,3:367\n188#7,3:372\n8#8:370\n1#9:371\n*S KotlinDebug\n*F\n+ 1 FishingProfitTracker.kt\nat/hannibal2/skyhanni/features/fishing/tracker/FishingProfitTracker\n*L\n107#1:282,7\n107#1:299,6\n107#1:289,5\n107#1:295,4\n107#1:294\n114#1:305,4\n151#1:309,10\n151#1:319,10\n151#1:329\n151#1:330,20\n151#1:350,2\n151#1:352,14\n151#1:366\n176#1:367,3\n253#1:372,3\n208#1:370\n208#1:371\n*E\n"})
public final class FishingProfitTracker {
    @NotNull
    public static final FishingProfitTracker INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern coinsChatPattern$delegate;
    private static long lastCatchTime;
    @NotNull
    private static final SkyHanniItemTracker<Data> tracker;
    @NotNull
    private static final NeuInternalName MAGMA_FISH;
    @NotNull
    private static final String NAME_ALL = "All";
    @NotNull
    private static String currentCategory;
    @NotNull
    private static Map<String, ? extends List<NeuInternalName>> itemCategories;

    private FishingProfitTracker() {
    }

    @NotNull
    public final FishingProfitTrackerConfig getConfig() {
        return SkyHanniMod.feature.getFishing().getFishingProfitTracker();
    }

    private final Pattern getCoinsChatPattern() {
        return (Pattern)coinsChatPattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String constant$iv = "FishingProfitItems";
        Object type$iv = null;
        Gson gson$iv = ((AbstractRepoReloadEvent)event).getGson();
        boolean $i$f$getConstant = false;
        Object object2 = event;
        try {
            Object $this$getRepoData_u24lambda_u2414$iv$iv;
            void this_$iv$iv;
            AbstractRepoReloadEvent $this$getConstant_u24lambda_u242$iv = object2;
            boolean bl = false;
            AbstractRepoManager<?> abstractRepoManager = $this$getConstant_u24lambda_u242$iv.getManager();
            String directory$iv$iv = "constants";
            boolean $i$f$getRepoData = false;
            Object object3 = this_$iv$iv;
            try {
                $this$getRepoData_u24lambda_u2414$iv$iv = object3;
                boolean bl2 = false;
                String path$iv$iv = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).resolvePath(directory$iv$iv, constant$iv);
                JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).readJsonElement(path$iv$iv);
                if (jsonElement == null) {
                    ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).getLogger().throwError("Repo file '" + constant$iv + "' not found.");
                    throw new KotlinNothingValueException();
                }
                JsonElement json$iv$iv = jsonElement;
                Gson $this$fromJson$iv$iv$iv = gson$iv;
                boolean $i$f$fromJson = false;
                Object object4 = $this$fromJson$iv$iv$iv.fromJson(json$iv$iv, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(FishingProfitItemsJson.class)));
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"fromJson(...)");
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)object4);
            }
            catch (Throwable bl2) {
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object3 = $this$getRepoData_u24lambda_u2414$iv$iv;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
            if (throwable != null) {
                Throwable e$iv$iv = throwable;
                boolean bl3 = false;
                this_$iv$iv.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + constant$iv + "'", e$iv$iv);
                throw new KotlinNothingValueException();
            }
            Object constantData$iv = object3;
            $this$getConstant_u24lambda_u242$iv.getManager().addSuccessfulConstant(constant$iv);
            object = constantData$iv;
        }
        catch (Throwable bl) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable it$iv = throwable;
                boolean bl4 = false;
                ((AbstractRepoReloadEvent)event).getManager().addUnsuccessfulConstant(constant$iv);
                ((AbstractRepoReloadEvent)event).getManager().getLogger().throwErrorWithCause("Could not load constant '" + constant$iv + "'", it$iv);
                throw new KotlinNothingValueException();
            }
            throw new KotlinNothingValueException();
        }
        itemCategories = ((FishingProfitItemsJson)object).getCategories();
    }

    private final Map<String, Integer> getCurrentCategories(Data data) {
        Map map = new LinkedHashMap();
        map.put(NAME_ALL, data.getItems().size());
        for (Map.Entry<String, ? extends List<NeuInternalName>> entry : itemCategories.entrySet()) {
            int amount;
            int n;
            String name2 = entry.getKey();
            List<NeuInternalName> items = entry.getValue();
            Iterable $this$count$iv = items;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    NeuInternalName it = (NeuInternalName)element$iv;
                    boolean bl = false;
                    if (!data.getItems().containsKey(it) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if ((amount = n) <= 0) continue;
            Integer n2 = amount;
            map.put(name2, n2);
        }
        return map;
    }

    private final List<Searchable> drawDisplay(Data data) {
        List list;
        List $this$drawDisplay_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        RenderableCollectionUtils.addSearchString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u244, "\u00a7e\u00a7lFishing Profit Tracker", null, null, null, 14, null);
        Function1<NeuInternalName, Boolean> filter = INSTANCE.addCategories($this$drawDisplay_u24lambda_u244, data);
        double profit = SkyHanniItemTracker.drawItems$default(tracker, data, filter, $this$drawDisplay_u24lambda_u244, null, null, null, null, null, 248, null);
        long fishedCount = data.getTotalCatchAmount();
        $this$drawDisplay_u24lambda_u244.add(SearchableKt.toSearchable$default(Renderable.Companion.hoverTips$default(Renderable.Companion, "\u00a77Times fished: \u00a7e" + NumberUtil.INSTANCE.addSeparators(fishedCount), CollectionsKt.listOf((Object)("\u00a77You've reeled in \u00a7e" + NumberUtil.INSTANCE.addSeparators(fishedCount) + " \u00a77catches.")), null, null, null, false, false, false, null, null, 1020, null), null, 1, null));
        $this$drawDisplay_u24lambda_u244.add(tracker.addTotalProfit(profit, data.getTotalCatchAmount(), "catch"));
        tracker.addPriceFromButton($this$drawDisplay_u24lambda_u244);
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    private final Function1<NeuInternalName, Boolean> addCategories(List<Searchable> $this$addCategories, Data data) {
        Map<String, Integer> amounts = this.getCurrentCategories(data);
        this.checkMissingItems(data);
        List list = CollectionsKt.toList((Iterable)amounts.keySet());
        if (!list.contains(currentCategory)) {
            currentCategory = NAME_ALL;
        }
        if (tracker.isInventoryOpen()) {
            void label$iv;
            List list2;
            void current$iv;
            RenderableUtils renderableUtils = RenderableUtils.INSTANCE;
            String string = "Category";
            String string2 = currentCategory;
            boolean enableUniverseScroll$iv = true;
            boolean $i$f$addButton = false;
            List<Searchable> list3 = $this$addCategories;
            ScrollValue scrollValue$iv$iv = new ScrollValue();
            boolean $i$f$createButtonNew = false;
            Object it$iv = current$iv;
            boolean bl = false;
            void v0 = it$iv;
            if (v0 == null) {
                throw new IllegalStateException("it is null in non-nullable getName()".toString());
            }
            String it = v0;
            boolean bl2 = false;
            String currentName$iv$iv = it + " \u00a77(" + amounts.get(it) + ")";
            List $this$createButtonNew_u24lambda_u2430$iv$iv = list2 = CollectionsKt.createListBuilder();
            boolean bl3 = false;
            $this$createButtonNew_u24lambda_u2430$iv$iv.add("\u00a7a" + (String)label$iv);
            $this$createButtonNew_u24lambda_u2430$iv$iv.add(" ");
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Object entry$iv$iv;
                it$iv = entry$iv$iv = iterator2.next();
                bl = false;
                Object e = it$iv;
                if (e == null) {
                    throw new IllegalStateException("it is null in non-nullable getName()".toString());
                }
                it = (String)e;
                bl2 = false;
                String name$iv$iv = it + " \u00a77(" + amounts.get(it) + ")";
                boolean bl4 = Intrinsics.areEqual(entry$iv$iv, (Object)current$iv) ? $this$createButtonNew_u24lambda_u2430$iv$iv.add("\u00a7e\u25b6 " + name$iv$iv) : $this$createButtonNew_u24lambda_u2430$iv$iv.add("\u00a77  " + name$iv$iv);
            }
            $this$createButtonNew_u24lambda_u2430$iv$iv.add(" ");
            $this$createButtonNew_u24lambda_u2430$iv$iv.add("\u00a7bRight-click to go backwards!");
            $this$createButtonNew_u24lambda_u2430$iv$iv.add("\u00a7eClick to switch " + (String)label$iv + "!");
            $this$createButtonNew_u24lambda_u2430$iv$iv.add("\u00a78You can also mouse scroll!");
            List tips$iv$iv = CollectionsKt.build((List)list2);
            Function1 onClick$iv$iv = (Function1)new Function1<Integer, Unit>(list, (Object)current$iv){
                final /* synthetic */ List $universe;
                final /* synthetic */ Object $current;
                {
                    this.$universe = $universe;
                    this.$current = $current;
                }

                public final void invoke(int keyCode) {
                    Object next;
                    Object object;
                    if (System.currentTimeMillis() - ChatUtils.INSTANCE.getLastButtonClicked() < 150L) {
                        return;
                    }
                    switch (keyCode) {
                        case 0: {
                            object = RenderableUtils.INSTANCE.circle(this.$universe, this.$current);
                            break;
                        }
                        case 1: {
                            object = RenderableUtils.INSTANCE.circleBackwards(this.$universe, this.$current);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    Object it = next = object;
                    boolean bl = false;
                    Object object2 = it;
                    if (object2 == null) {
                        throw new IllegalStateException("it is null in non-nullable onChange()".toString());
                    }
                    String it2 = (String)object2;
                    boolean bl2 = false;
                    FishingProfitTracker.access$setCurrentCategory$p(it2);
                    FishingProfitTracker.access$getTracker$p().update();
                    SoundUtils.INSTANCE.playClickSound();
                    ChatUtils.INSTANCE.setLastButtonClicked(System.currentTimeMillis());
                }
            };
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)0, (Object)new Function0<Unit>((Function1<? super Integer, Unit>)onClick$iv$iv){
                final /* synthetic */ Function1<Integer, Unit> $onClick;
                {
                    this.$onClick = $onClick;
                }

                public final void invoke() {
                    this.$onClick.invoke((Object)0);
                }
            }), TuplesKt.to((Object)1, (Object)new Function0<Unit>((Function1<? super Integer, Unit>)onClick$iv$iv){
                final /* synthetic */ Function1<Integer, Unit> $onClick;
                {
                    this.$onClick = $onClick;
                }

                public final void invoke() {
                    this.$onClick.invoke((Object)1);
                }
            })};
            Map clickMap$iv$iv = MapsKt.mapOf((Pair[])pairArray);
            list3.add(SearchableKt.toSearchable$default(HorizontalContainerRenderable.Companion.horizontal$default(HorizontalContainerRenderable.Companion, Renderable.Companion, 0, null, null, (Function1)new Function1<List<Renderable>, Unit>((String)label$iv, currentName$iv$iv, (List<String>)tips$iv$iv, enableUniverseScroll$iv, (Map<Integer, ? extends Function0<Unit>>)clickMap$iv$iv, scrollValue$iv$iv){
                final /* synthetic */ String $label;
                final /* synthetic */ String $currentName;
                final /* synthetic */ List<String> $tips;
                final /* synthetic */ boolean $enableUniverseScroll;
                final /* synthetic */ Map<Integer, Function0<Unit>> $clickMap;
                final /* synthetic */ ScrollValue $scrollValue;
                {
                    this.$label = $label;
                    this.$currentName = $currentName;
                    this.$tips = $tips;
                    this.$enableUniverseScroll = $enableUniverseScroll;
                    this.$clickMap = $clickMap;
                    this.$scrollValue = $scrollValue;
                }

                public final void invoke(List<Renderable> $this$horizontal) {
                    Renderable renderable2;
                    Intrinsics.checkNotNullParameter($this$horizontal, (String)"$this$horizontal");
                    RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$horizontal, "\u00a77" + this.$label + " \u00a7a[", 0.0, null, null, 14, null);
                    Renderable displayFormat2 = Renderable.Companion.hoverTips$default(Renderable.Companion, "\u00a7e" + this.$currentName, this.$tips, null, null, null, false, false, false, null, RenderableUtils.createButtonNew.displayFormat.1.INSTANCE, 444, null);
                    boolean bl = this.$enableUniverseScroll;
                    if (bl) {
                        renderable2 = Renderable.Companion.clickableAndScrollable$default(Renderable.Companion, displayFormat2, this.$clickMap, false, null, this.$scrollValue, 8, null);
                    } else if (!bl) {
                        renderable2 = Renderable.Companion.clickable$default(Renderable.Companion, displayFormat2, this.$clickMap, false, null, null, null, 56, null);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    Renderable it = renderable2;
                    boolean bl2 = false;
                    $this$horizontal.add(it);
                    RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$horizontal, "\u00a7a]", 0.0, null, null, 14, null);
                }
            }, 7, null), null, 1, null));
        }
        Function1 filter = Intrinsics.areEqual((Object)currentCategory, (Object)NAME_ALL) ? FishingProfitTracker::addCategories$lambda$7 : FishingProfitTracker::addCategories$lambda$8;
        return filter;
    }

    private final void checkMissingItems(Data data) {
        List missingItems = new ArrayList();
        for (NeuInternalName internalName2 : data.getItems().keySet()) {
            boolean bl;
            block5: {
                if (Intrinsics.areEqual((Object)internalName2, (Object)NeuInternalName.Companion.toInternalName("ATTRIBUTE_SHARD"))) continue;
                Map<String, ? extends List<NeuInternalName>> $this$none$iv = itemCategories;
                boolean $i$f$none = false;
                if ($this$none$iv.isEmpty()) {
                    bl = true;
                } else {
                    Iterator<Map.Entry<String, ? extends List<NeuInternalName>>> iterator2 = $this$none$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<String, ? extends List<NeuInternalName>> element$iv;
                        Map.Entry<String, ? extends List<NeuInternalName>> it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (!it.getValue().contains(internalName2)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            missingItems.add(internalName2);
        }
        if (!((Collection)missingItems).isEmpty()) {
            String label = StringUtils.pluralize$default(StringUtils.INSTANCE, missingItems.size(), "item", null, true, 4, null);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"missingItems", (Object)missingItems)};
            ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "Loaded " + label + " not in a fishing category", "Found items missing in itemCategories", pairArray, false, true, false, null, 104, null);
        }
    }

    @HandleEvent
    public final void onItemAdd(@NotNull ItemAddEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (event.getSource() == ItemAddManager.Source.COMMAND) {
            if (!this.getConfig().getEnabled()) {
                return;
            }
            this.tryAddItem(event.getInternalName(), event.getAmount(), true);
            return;
        }
        DelayedRun.INSTANCE.runDelayed-bouF650(DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS), (Function0<Unit>)((Function0)() -> FishingProfitTracker.onItemAdd$lambda$10(event)));
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onChat(@NotNull SkyHanniChatEvent event) {
        void $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getCoinsChatPattern();
        String text$iv = event.getMessage();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$onChat_u24lambda_u2411 = it$iv;
            boolean bl2 = false;
            NeuInternalName neuInternalName = NeuInternalName.Companion.getSKYBLOCK_COIN();
            String string = $this$onChat_u24lambda_u2411.group("coins");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            INSTANCE.tryAddItem(neuInternalName, NumberUtil.INSTANCE.formatInt(string), false);
            INSTANCE.addCatch();
        }
    }

    private final void addCatch() {
        tracker.modify((Function1<Data, Unit>)((Function1)FishingProfitTracker::addCatch$lambda$12));
        lastCatchTime = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRecentPickup() {
        if (!this.getConfig().getShowWhenPickup()) return false;
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastCatchTime), (long)DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS)) >= 0) return false;
        return true;
    }

    private final boolean getShouldShow() {
        return this.isRecentPickup() || FishingApi.INSTANCE.isFishing(false);
    }

    @HandleEvent
    public final void onWorldChange() {
        lastCatchTime = SimpleTimeMark.Companion.farPast();
    }

    private final void tryAddItem(NeuInternalName internalName2, int amount, boolean command2) {
        if (!FishingApi.INSTANCE.isFishing(false)) {
            return;
        }
        if (!this.isAllowedItem(internalName2)) {
            ChatUtils.debug$default(ChatUtils.INSTANCE, "Ignored non-fishing item pickup: " + internalName2 + "'", false, 2, null);
            return;
        }
        SkyHanniItemTracker.addItem$default(tracker, internalName2, amount, command2, false, 8, null);
    }

    private final boolean isAllowedItem(NeuInternalName internalName2) {
        boolean bl;
        block3: {
            Map<String, ? extends List<NeuInternalName>> $this$any$iv = itemCategories;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<String, ? extends List<NeuInternalName>>> iterator2 = $this$any$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, ? extends List<NeuInternalName>> element$iv;
                    Map.Entry<String, ? extends List<NeuInternalName>> it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!it.getValue().contains(internalName2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @HandleEvent
    public final void onBobberThrow(@NotNull FishingBobberCastEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        tracker.firstUpdate();
    }

    @HandleEvent
    public final void onCatch(@NotNull FishingCatchEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.addCatch();
    }

    @HandleEvent
    public final void onSeaCreatureFish(@NotNull SeaCreatureFishEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.addCatch();
    }

    private final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && !KuudraApi.INSTANCE.getInKuudra();
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.register("shresetfishingtracker", (Function1<? super CommandBuilder, Unit>)((Function1)FishingProfitTracker::onCommandRegistration$lambda$17));
    }

    private static final Data tracker$lambda$0() {
        return new Data(0L, 1, null);
    }

    private static final Data tracker$lambda$1(ProfileSpecificStorage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFishing().getFishingProfitTracker();
    }

    private static final List tracker$lambda$2(Data it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.drawDisplay(it);
    }

    private static final boolean addCategories$lambda$7(NeuInternalName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean addCategories$lambda$8(NeuInternalName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List list = itemCategories.get(currentCategory);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list.contains(it);
    }

    private static final Unit onItemAdd$lambda$10(ItemAddEvent $event) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        INSTANCE.tryAddItem($event.getInternalName(), $event.getAmount(), false);
        return Unit.INSTANCE;
    }

    private static final Unit addCatch$lambda$12(Data it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        long l = it.getTotalCatchAmount();
        it.setTotalCatchAmount(l + 1L);
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$13() {
        return INSTANCE.isEnabled() && INSTANCE.getConfig().getEnabled() && INSTANCE.getShouldShow();
    }

    private static final Unit _init_$lambda$14() {
        tracker.renderDisplay(INSTANCE.getConfig().getPosition());
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$17$lambda$16(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        tracker.resetCommand();
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$17(CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        $this$register.setDescription("Resets the Fishing Profit Tracker");
        $this$register.setCategory(CommandCategory.USERS_RESET);
        $this$register.callback((Function1<? super String[], Unit>)((Function1)FishingProfitTracker::onCommandRegistration$lambda$17$lambda$16));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$setCurrentCategory$p(String string) {
        currentCategory = string;
    }

    public static final /* synthetic */ SkyHanniItemTracker access$getTracker$p() {
        return tracker;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FishingProfitTracker.class, "coinsChatPattern", "getCoinsChatPattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new FishingProfitTracker();
        coinsChatPattern$delegate = RepoPattern.Companion.pattern("fishing.tracker.chat.coins", "\u00a7(?<colorCode>.*)\u26c3 \u00a7r(?<catch>.*) CATCH! \u00a7r\u00a7fYou caught \u00a7r\u00a76(?<coins>[\\d,]+) Coins\u00a7r\u00a7f!");
        lastCatchTime = SimpleTimeMark.Companion.farPast();
        tracker = new SkyHanniItemTracker("Fishing Profit Tracker", FishingProfitTracker::tracker$lambda$0, FishingProfitTracker::tracker$lambda$1, null, FishingProfitTracker::tracker$lambda$2, 8, null);
        MAGMA_FISH = NeuInternalName.Companion.toInternalName("MAGMA_FISH");
        currentCategory = NAME_ALL;
        itemCategories = MapsKt.emptyMap();
        new RenderDisplayHelper(null, true, true, FishingProfitTracker::_init_$lambda$13, null, FishingProfitTracker::_init_$lambda$14, 17, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001a\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001a\u0010\u001d\u001a\u00020\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010 \u001a\u00020\u001fH\u00d6\u0001\u00a2\u0006\u0004\b \u0010!J\u0010\u0010\"\u001a\u00020\bH\u00d6\u0001\u00a2\u0006\u0004\b\"\u0010#R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010$\u001a\u0004\b%\u0010\u0017\"\u0004\b&\u0010\u0005\u00a8\u0006'"}, d2={"Lat/hannibal2/skyhanni/features/fishing/tracker/FishingProfitTracker$Data;", "Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData;", "", "totalCatchAmount", "<init>", "(J)V", "timesGained", "", "", "getDescription", "(J)Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;", "item", "getCoinName", "(Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;)Ljava/lang/String;", "getCoinDescription", "(Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;)Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "internalName", "", "getCustomPricePer", "(Lat/hannibal2/skyhanni/utils/NeuInternalName;)D", "component1", "()J", "copy", "(J)Lat/hannibal2/skyhanni/features/fishing/tracker/FishingProfitTracker$Data;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "J", "getTotalCatchAmount", "setTotalCatchAmount", "1.21.5"})
    public static final class Data
    extends ItemTrackerData {
        @Expose
        private long totalCatchAmount;

        public Data(long totalCatchAmount) {
            this.totalCatchAmount = totalCatchAmount;
        }

        public /* synthetic */ Data(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 0L;
            }
            this(l);
        }

        public final long getTotalCatchAmount() {
            return this.totalCatchAmount;
        }

        public final void setTotalCatchAmount(long l) {
            this.totalCatchAmount = l;
        }

        @Override
        @NotNull
        public List<String> getDescription(long timesGained) {
            double percentage = (double)timesGained / (double)this.totalCatchAmount;
            String catchRate = NumberUtil.INSTANCE.formatPercentage(RangesKt.coerceAtMost((double)percentage, (double)1.0));
            Object[] objectArray = new String[]{"\u00a77Caught \u00a7e" + NumberUtil.INSTANCE.addSeparators(timesGained) + " \u00a77times.", "\u00a77Your catch rate: \u00a7c" + catchRate};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @Override
        @NotNull
        public String getCoinName(@NotNull ItemTrackerData.TrackedItem item2) {
            Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
            return "\u00a76Fished Coins";
        }

        @Override
        @NotNull
        public List<String> getCoinDescription(@NotNull ItemTrackerData.TrackedItem item2) {
            Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
            String mobKillCoinsFormat = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, item2.getTotalAmount(), false, 1, null);
            return CollectionsKt.listOf((Object)("\u00a77You fished up \u00a76" + mobKillCoinsFormat + " coins \u00a77already."));
        }

        @Override
        public double getCustomPricePer(@NotNull NeuInternalName internalName2) {
            Intrinsics.checkNotNullParameter((Object)internalName2, (String)"internalName");
            return internalName2.getItemCategoryOrNull() == ItemCategory.TROPHY_FISH ? SkyHanniTracker.Companion.getPricePer(MAGMA_FISH) * (double)FishingApi.INSTANCE.getFilletPerTrophy(internalName2) : super.getCustomPricePer(internalName2);
        }

        public final long component1() {
            return this.totalCatchAmount;
        }

        @NotNull
        public final Data copy(long totalCatchAmount) {
            return new Data(totalCatchAmount);
        }

        public static /* synthetic */ Data copy$default(Data data, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = data.totalCatchAmount;
            }
            return data.copy(l);
        }

        @NotNull
        public String toString() {
            return "Data(totalCatchAmount=" + this.totalCatchAmount + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.totalCatchAmount);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data = (Data)other;
            return this.totalCatchAmount == data.totalCatchAmount;
        }

        public Data() {
            this(0L, 1, null);
        }
    }
}

