/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.visitor;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.data.jsonobjects.repo.GardenJson;
import at.hannibal2.skyhanni.data.jsonobjects.repo.GardenVisitor;
import at.hannibal2.skyhanni.data.repo.AbstractRepoManager;
import at.hannibal2.skyhanni.data.repo.AbstractRepoReloadEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR4\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00100\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lat/hannibal2/skyhanni/features/garden/visitor/GardenVisitorColorNames;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "", "name", "getColoredName", "(Ljava/lang/String;)Ljava/lang/String;", "", "visitorColors", "Ljava/util/Map;", "", "visitorItems", "getVisitorItems", "()Ljava/util/Map;", "setVisitorItems", "(Ljava/util/Map;)V", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nGardenVisitorColorNames.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GardenVisitorColorNames.kt\nat/hannibal2/skyhanni/features/garden/visitor/GardenVisitorColorNames\n+ 2 AbstractRepoReloadEvent.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoReloadEvent\n+ 3 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n+ 4 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n*L\n1#1,32:1\n13#2,7:33\n21#2,6:50\n162#3,5:40\n167#3,4:46\n24#4:45\n*S KotlinDebug\n*F\n+ 1 GardenVisitorColorNames.kt\nat/hannibal2/skyhanni/features/garden/visitor/GardenVisitorColorNames\n*L\n17#1:33,7\n17#1:50,6\n17#1:40,5\n17#1:46,4\n17#1:45\n*E\n"})
public final class GardenVisitorColorNames {
    @NotNull
    public static final GardenVisitorColorNames INSTANCE = new GardenVisitorColorNames();
    @NotNull
    private static final Map<String, String> visitorColors = new LinkedHashMap();
    @NotNull
    private static Map<String, List<String>> visitorItems = new LinkedHashMap();

    private GardenVisitorColorNames() {
    }

    @NotNull
    public final Map<String, List<String>> getVisitorItems() {
        return visitorItems;
    }

    public final void setVisitorItems(@NotNull Map<String, List<String>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        visitorItems = map;
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String constant$iv = "Garden";
        Object type$iv = null;
        Gson gson$iv = ((AbstractRepoReloadEvent)event).getGson();
        boolean $i$f$getConstant = false;
        Object object2 = event;
        try {
            Object $this$getRepoData_u24lambda_u2414$iv$iv;
            void this_$iv$iv;
            AbstractRepoReloadEvent $this$getConstant_u24lambda_u242$iv = object2;
            boolean bl = false;
            AbstractRepoManager<?> abstractRepoManager = $this$getConstant_u24lambda_u242$iv.getManager();
            String directory$iv$iv = "constants";
            boolean $i$f$getRepoData = false;
            Object object3 = this_$iv$iv;
            try {
                $this$getRepoData_u24lambda_u2414$iv$iv = object3;
                boolean bl2 = false;
                String path$iv$iv = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).resolvePath(directory$iv$iv, constant$iv);
                JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).readJsonElement(path$iv$iv);
                if (jsonElement == null) {
                    ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).getLogger().throwError("Repo file '" + constant$iv + "' not found.");
                    throw new KotlinNothingValueException();
                }
                JsonElement json$iv$iv = jsonElement;
                Gson $this$fromJson$iv$iv$iv = gson$iv;
                boolean $i$f$fromJson = false;
                Object object4 = $this$fromJson$iv$iv$iv.fromJson(json$iv$iv, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(GardenJson.class)));
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"fromJson(...)");
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)object4);
            }
            catch (Throwable bl2) {
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object3 = $this$getRepoData_u24lambda_u2414$iv$iv;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
            if (throwable != null) {
                Throwable e$iv$iv = throwable;
                boolean bl3 = false;
                this_$iv$iv.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + constant$iv + "'", e$iv$iv);
                throw new KotlinNothingValueException();
            }
            Object constantData$iv = object3;
            $this$getConstant_u24lambda_u242$iv.getManager().addSuccessfulConstant(constant$iv);
            object = constantData$iv;
        }
        catch (Throwable bl) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable it$iv = throwable;
                boolean bl4 = false;
                ((AbstractRepoReloadEvent)event).getManager().addUnsuccessfulConstant(constant$iv);
                ((AbstractRepoReloadEvent)event).getManager().getLogger().throwErrorWithCause("Could not load constant '" + constant$iv + "'", it$iv);
                throw new KotlinNothingValueException();
            }
            throw new KotlinNothingValueException();
        }
        GardenJson data = (GardenJson)object;
        visitorColors.clear();
        visitorItems.clear();
        for (Map.Entry<String, GardenVisitor> entry : data.getVisitors().entrySet()) {
            String visitor = entry.getKey();
            GardenVisitor visitorData = entry.getValue();
            visitorColors.put(visitor, visitorData.getRarity().getColor().getChatColor());
            visitorItems.put(visitor, visitorData.getNeedItems());
        }
    }

    @NotNull
    public final String getColoredName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        String cleanName = StringUtils.removeColor$default(StringUtils.INSTANCE, name2, false, 1, null);
        String string = visitorColors.get(cleanName);
        if (string == null) {
            return name2;
        }
        String color = string;
        return color + cleanName;
    }
}

