/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.api.enoughupdates;

import at.hannibal2.skyhanni.api.enoughupdates.EnoughUpdatesManager;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigManager;
import at.hannibal2.skyhanni.data.jsonobjects.repo.ItemsJson;
import at.hannibal2.skyhanni.data.repo.AbstractRepoManager;
import at.hannibal2.skyhanni.data.repo.AbstractRepoReloadEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.UtilsPatterns;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 :2\u00020\u0001:\u0001:B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0011\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0011\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u0011\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u000fJ\u000f\u0010\u0013\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u000fJ\u000f\u0010\u0014\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u000fJ\u000f\u0010\u0015\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u000fJ\u000f\u0010\u0016\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u000fJ\u000f\u0010\u0017\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u000fJ\u0011\u0010\u0018\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u000fJ\u0011\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u000fJ\u001f\u0010\u001c\u001a\u0004\u0018\u00010\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0019\u0010\u001f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0011\u0010!\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0004\b!\u0010\u000fJ\u0017\u0010%\u001a\u00020$2\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b(\u0010)J\u0011\u0010*\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0004\b*\u0010\u000fJ\u0011\u0010,\u001a\u0004\u0018\u00010+H\u0002\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010.\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b.\u0010/R\u0018\u00100\u001a\u0004\u0018\u00010'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0018\u00103\u001a\u0004\u0018\u0001028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0018\u00105\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0018\u00108\u001a\u0004\u0018\u0001078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109\u00a8\u0006;"}, d2={"Lat/hannibal2/skyhanni/api/enoughupdates/ItemResolutionQuery;", "", "<init>", "()V", "Lnet/minecraft/item/ItemStack;", "stack", "withItemStack", "(Lnet/minecraft/item/ItemStack;)Lat/hannibal2/skyhanni/api/enoughupdates/ItemResolutionQuery;", "", "internalName", "withKnownInternalName", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/api/enoughupdates/ItemResolutionQuery;", "withCurrentGuiContext", "()Lat/hannibal2/skyhanni/api/enoughupdates/ItemResolutionQuery;", "resolveInternalName", "()Ljava/lang/String;", "resolvePetName", "resolveRuneName", "resolveEnchantedBookNameFromNBT", "resolveCrabHatName", "resolvePhoneCase", "resolveSlothHatName", "resolvePotionName", "resolveBalloonHatName", "resolveAttributeShardName", "resolveItemInCatacombsRngMeter", "", "lore", "resolveItemInAttributeMenu", "(Ljava/util/List;)Ljava/lang/String;", "displayName", "resolveItemInHuntingBoxMenu", "(Ljava/lang/String;)Ljava/lang/String;", "resolveContextualName", "Lnet/minecraft/inventory/IInventory;", "chest", "", "isBazaar", "(Lnet/minecraft/inventory/IInventory;)Z", "Lnet/minecraft/nbt/NBTTagCompound;", "getExtraAttributes", "()Lnet/minecraft/nbt/NBTTagCompound;", "resolveFromSkyblock", "Lcom/google/gson/JsonObject;", "resolveToItemListJson", "()Lcom/google/gson/JsonObject;", "resolveToItemStack", "()Lnet/minecraft/item/ItemStack;", "compound", "Lnet/minecraft/nbt/NBTTagCompound;", "Lnet/minecraft/item/Item;", "itemType", "Lnet/minecraft/item/Item;", "knownInternalName", "Ljava/lang/String;", "Lnet/minecraft/client/gui/GuiScreen;", "guiContext", "Lnet/minecraft/client/gui/GuiScreen;", "Companion", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nItemResolutionQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemResolutionQuery.kt\nat/hannibal2/skyhanni/api/enoughupdates/ItemResolutionQuery\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,385:1\n27#2:386\n14#2,2:387\n17#2:390\n1#3:389\n1#3:391\n*S KotlinDebug\n*F\n+ 1 ItemResolutionQuery.kt\nat/hannibal2/skyhanni/api/enoughupdates/ItemResolutionQuery\n*L\n300#1:386\n300#1:387,2\n300#1:390\n300#1:389\n*E\n"})
public final class ItemResolutionQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private NBTTagCompound compound;
    @Nullable
    private Item itemType;
    @Nullable
    private String knownInternalName;
    @Nullable
    private GuiScreen guiContext;
    @NotNull
    private static final Pattern petPattern;
    @NotNull
    private static final List<String> petRarities;
    @NotNull
    private static final Pattern BAZAAR_ENCHANTMENT_PATTERN;
    @NotNull
    private static Map<String, String> renamedEnchantments;
    @NotNull
    private static Map<String, String> shardNameOverrides;

    @NotNull
    public final ItemResolutionQuery withItemStack(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        this.itemType = stack.func_77973_b();
        this.compound = stack.func_77978_p();
        return this;
    }

    @NotNull
    public final ItemResolutionQuery withKnownInternalName(@NotNull String internalName2) {
        Intrinsics.checkNotNullParameter(internalName2, "internalName");
        this.knownInternalName = internalName2;
        return this;
    }

    @NotNull
    public final ItemResolutionQuery withCurrentGuiContext() {
        this.guiContext = Minecraft.func_71410_x().field_71462_r;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final String resolveInternalName() {
        block25: {
            block32: {
                block31: {
                    block30: {
                        block28: {
                            block27: {
                                block26: {
                                    block29: {
                                        block24: {
                                            var1_1 = this.knownInternalName;
                                            if (var1_1 != null) {
                                                it = var1_1;
                                                $i$a$-let-ItemResolutionQuery$resolveInternalName$1 = false;
                                                return it;
                                            }
                                            resolvedName = this.resolveFromSkyblock();
                                            if (resolvedName != null) break block24;
                                            v0 = this.resolveContextualName();
                                            break block25;
                                        }
                                        var2_4 = resolvedName;
                                        switch (var2_4.hashCode()) {
                                            case -1544686227: {
                                                if (!var2_4.equals("PARTY_HAT_CRAB")) {
                                                    ** break;
                                                }
                                                break block26;
                                            }
                                            case -482800776: {
                                                if (!var2_4.equals("ABICASE")) {
                                                    ** break;
                                                }
                                                break block27;
                                            }
                                            case -626021107: {
                                                if (!var2_4.equals("PARTY_HAT_SLOTH")) {
                                                    ** break;
                                                }
                                                break block28;
                                            }
                                            case -941613003: {
                                                if (!var2_4.equals("PARTY_HAT_CRAB_ANIMATED")) {
                                                    ** break;
                                                }
                                                break block26;
                                            }
                                            case 1968673840: {
                                                if (!var2_4.equals("ENCHANTED_BOOK")) {
                                                    ** break;
                                                }
                                                break block29;
                                            }
                                            case -1929101933: {
                                                if (!var2_4.equals("POTION")) {
                                                    ** break;
                                                }
                                                break block30;
                                            }
                                            case -710099340: {
                                                if (!var2_4.equals("BALLOON_HAT_2024")) {
                                                    ** break;
                                                }
                                                break block31;
                                            }
                                            case -710099339: {
                                                if (!var2_4.equals("BALLOON_HAT_2025")) {
                                                    ** break;
                                                }
                                                break block31;
                                            }
                                            case 1358997563: {
                                                if (!var2_4.equals("ATTRIBUTE_SHARD")) {
                                                    ** break;
                                                }
                                                break block32;
                                            }
                                            case 2527034: {
                                                if (var2_4.equals("RUNE")) break;
                                                ** break;
                                            }
                                            case 262406888: {
                                                if (var2_4.equals("UNIQUE_RUNE")) break;
                                                ** break;
                                            }
                                            case 79103: {
                                                if (!var2_4.equals("PET")) ** break;
                                                v0 = this.resolvePetName();
                                                break block25;
                                            }
                                        }
                                        v0 = this.resolveRuneName();
                                        break block25;
                                    }
                                    v0 = this.resolveEnchantedBookNameFromNBT();
                                    break block25;
                                }
                                v0 = this.resolveCrabHatName();
                                break block25;
                            }
                            v0 = this.resolvePhoneCase();
                            break block25;
                        }
                        v0 = this.resolveSlothHatName();
                        break block25;
                    }
                    v0 = this.resolvePotionName();
                    break block25;
                }
                v0 = this.resolveBalloonHatName();
                break block25;
            }
            v0 = this.resolveAttributeShardName();
            break block25;
lbl82:
            // 13 sources

            v0 = resolvedName;
        }
        resolvedName = v0;
        return resolvedName;
    }

    private final String resolvePetName() {
        String petInfo = this.getExtraAttributes().func_74779_i("petInfo");
        CharSequence charSequence = petInfo;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        try {
            JsonObject petInfoObject = (JsonObject)ConfigManager.Companion.getGson().fromJson(petInfo, JsonObject.class);
            String petId = petInfoObject.get("type").getAsString();
            String petTier = petInfoObject.get("tier").getAsString();
            int rarityIndex = petRarities.indexOf(petTier);
            StringBuilder stringBuilder = new StringBuilder();
            Intrinsics.checkNotNull(petId);
            String string = petId.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            return stringBuilder.append(string).append(';').append(rarityIndex).toString();
        }
        catch (Exception e) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("petInfo", petInfo)};
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Error while resolving pet information", pairArray, false, false, false, 56, null);
            return null;
        }
    }

    private final String resolveRuneName() {
        NBTTagCompound runes = this.getExtraAttributes().func_74775_l("runes");
        Set set = runes.func_150296_c();
        Intrinsics.checkNotNullExpressionValue(set, "getKeySet(...)");
        String runeName = (String)CollectionsKt.singleOrNull(set);
        CharSequence charSequence = runeName;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = runeName.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        return stringBuilder.append(string).append("_RUNE;").append(runes.func_74762_e(runeName)).toString();
    }

    private final String resolveEnchantedBookNameFromNBT() {
        NBTTagCompound enchantments = this.getExtraAttributes().func_74775_l("enchantments");
        Set set = enchantments.func_150296_c();
        Intrinsics.checkNotNullExpressionValue(set, "getKeySet(...)");
        String enchantName = (String)CollectionsKt.singleOrNull(set);
        CharSequence charSequence = enchantName;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = enchantName.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        return stringBuilder.append(string).append(';').append(enchantments.func_74762_e(enchantName)).toString();
    }

    private final String resolveCrabHatName() {
        int crabHatYear = this.getExtraAttributes().func_74762_e("party_hat_year");
        String color = this.getExtraAttributes().func_74779_i("party_hat_color");
        StringBuilder stringBuilder = new StringBuilder().append("PARTY_HAT_CRAB_");
        Intrinsics.checkNotNull(color);
        String string = color.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        return stringBuilder.append(string).append(crabHatYear == 2022 ? "_ANIMATED" : "").toString();
    }

    private final String resolvePhoneCase() {
        String model = this.getExtraAttributes().func_74779_i("model");
        StringBuilder stringBuilder = new StringBuilder().append("ABICASE_");
        Intrinsics.checkNotNull(model);
        String string = model.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        return stringBuilder.append(string).toString();
    }

    private final String resolveSlothHatName() {
        String emoji = this.getExtraAttributes().func_74779_i("party_hat_emoji");
        StringBuilder stringBuilder = new StringBuilder().append("PARTY_HAT_SLOTH_");
        Intrinsics.checkNotNull(emoji);
        String string = emoji.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        return stringBuilder.append(string).toString();
    }

    private final String resolvePotionName() {
        String string;
        String potion = this.getExtraAttributes().func_74779_i("potion");
        int potionLvl = this.getExtraAttributes().func_74762_e("potion_level");
        String string2 = this.getExtraAttributes().func_74779_i("potion_name");
        Intrinsics.checkNotNullExpressionValue(string2, "getString(...)");
        String potionName = StringsKt.replace$default(string2, " ", "_", false, 4, null);
        String potionType = this.getExtraAttributes().func_74779_i("potion_type");
        if (((CharSequence)potionName).length() > 0) {
            StringBuilder stringBuilder = new StringBuilder().append("POTION_");
            String string3 = potionName.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
            string = stringBuilder.append(string3).append(';').append(potionLvl).toString();
        } else {
            CharSequence charSequence = potion;
            if (!(charSequence == null || charSequence.length() == 0)) {
                StringBuilder stringBuilder = new StringBuilder().append("POTION_");
                String string4 = potion.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string4, "toUpperCase(...)");
                string = stringBuilder.append(string4).append(';').append(potionLvl).toString();
            } else {
                charSequence = potionType;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    StringBuilder stringBuilder = new StringBuilder().append("POTION_");
                    String string5 = potionType.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string5, "toUpperCase(...)");
                    string = stringBuilder.append(string5).toString();
                } else {
                    string = "WATER_BOTTLE";
                }
            }
        }
        return string;
    }

    private final String resolveBalloonHatName() {
        String color = this.getExtraAttributes().func_74779_i("party_hat_color");
        int balloonHatYear = this.getExtraAttributes().func_74762_e("party_hat_year");
        StringBuilder stringBuilder = new StringBuilder().append("BALLOON_HAT_").append(balloonHatYear).append('_');
        Intrinsics.checkNotNull(color);
        String string = color.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        return stringBuilder.append(string).toString();
    }

    private final String resolveAttributeShardName() {
        NBTTagCompound attributes = this.getExtraAttributes().func_74775_l("attributes");
        Set set = attributes.func_150296_c();
        Intrinsics.checkNotNullExpressionValue(set, "getKeySet(...)");
        String attributeName = (String)CollectionsKt.singleOrNull(set);
        CharSequence charSequence = attributeName;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder().append("ATTRIBUTE_SHARD_");
        String string = attributeName.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        return stringBuilder.append(string).append(';').append(attributes.func_74762_e(attributeName)).toString();
    }

    private final String resolveItemInCatacombsRngMeter() {
        String s;
        List<String> lore = ItemUtils.INSTANCE.getLore(this.compound);
        if (lore.size() > 16 && Intrinsics.areEqual(s = lore.get(15), "\u00a77Selected Drop")) {
            String displayName = lore.get(16);
            return Companion.findInternalNameByDisplayName(displayName, false);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final String resolveItemInAttributeMenu(List<String> lore) {
        void this_$iv;
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern $this$firstMatcher$iv = UtilsPatterns.INSTANCE.getAttributeSourcePattern();
        boolean $i$f$firstMatcher = false;
        void var5_5 = this_$iv;
        Pattern pattern = $this$firstMatcher$iv;
        Sequence sequence$iv$iv = CollectionsKt.asSequence((Iterable)lore);
        boolean $i$f$firstMatcher2 = false;
        Iterator iterator2 = sequence$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$firstMatcher$iv$iv;
            String line$iv$iv = (String)iterator2.next();
            Matcher it$iv$iv = $this$firstMatcher$iv$iv.matcher(line$iv$iv);
            boolean bl = false;
            if (!it$iv$iv.matches()) continue;
            Intrinsics.checkNotNull(it$iv$iv);
            Matcher $this$resolveItemInAttributeMenu_u24lambda_u241 = it$iv$iv;
            boolean bl2 = false;
            String string = $this$resolveItemInAttributeMenu_u24lambda_u241.group("source");
            Intrinsics.checkNotNullExpressionValue(string, "group(...)");
            return Companion.attributeNameToInternalName(string);
        }
        return null;
    }

    private final String resolveItemInHuntingBoxMenu(String displayName) {
        return Companion.attributeNameToInternalName(StringUtils.removeColor$default(StringUtils.INSTANCE, displayName, false, 1, null));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String resolveContextualName() {
        String string;
        Object object;
        block17: {
            GuiScreen guiScreen = this.guiContext;
            if (!(guiScreen instanceof GuiChest)) return null;
            GuiChest guiChest = (GuiChest)guiScreen;
            if (guiChest == null) {
                return null;
            }
            GuiChest chest = guiChest;
            Container container = chest.field_147002_h;
            Intrinsics.checkNotNull(container, "null cannot be cast to non-null type net.minecraft.inventory.ContainerChest");
            ContainerChest inventorySlots = (ContainerChest)container;
            String guiName = InventoryUtils.INSTANCE.openInventoryName();
            IInventory iInventory = inventorySlots.func_85151_d();
            Intrinsics.checkNotNullExpressionValue(iInventory, "getLowerChestInventory(...)");
            boolean isOnBazaar = this.isBazaar(iInventory);
            String string2 = ItemUtils.INSTANCE.getDisplayName(this.compound);
            if (string2 == null) {
                return null;
            }
            String displayName = string2;
            displayName = StringsKt.removePrefix(StringsKt.removePrefix(displayName, (CharSequence)"\u00a76\u00a7lSELL "), (CharSequence)"\u00a7a\u00a7lBUY ");
            if (this.itemType == Items.field_151134_bR && isOnBazaar && this.compound != null) {
                return Companion.resolveEnchantmentByName(displayName);
            }
            if (this.itemType == Items.field_151144_bL && StringsKt.contains$default((CharSequence)displayName, "Essence", false, 2, null) && (object = Companion.findInternalNameByDisplayName(displayName, false)) != null) {
                return object;
            }
            if (StringsKt.endsWith$default(displayName, "Enchanted Book", false, 2, null) && StringsKt.startsWith$default(guiName, "Superpairs", false, 2, null)) break block17;
            if (Intrinsics.areEqual(guiName, "Catacombs RNG Meter")) {
                return this.resolveItemInCatacombsRngMeter();
            }
            if (StringsKt.startsWith$default(guiName, "Choose Pet", false, 2, null)) {
                return Companion.findInternalNameByDisplayName(displayName, false);
            }
            if (StringsKt.endsWith$default(guiName, "Experimentation Table RNG", false, 2, null)) {
                return Companion.resolveEnchantmentByName(displayName);
            }
            if (Intrinsics.areEqual(guiName, "Attribute Menu")) {
                return this.resolveItemInAttributeMenu(ItemUtils.INSTANCE.getLore(this.compound));
            }
            switch (guiName.hashCode()) {
                case 1084575430: {
                    if (guiName.equals("Shard Fusion")) return this.resolveItemInHuntingBoxMenu(displayName);
                    break;
                }
                case -1351043153: {
                    if (guiName.equals("Fusion Box")) return this.resolveItemInHuntingBoxMenu(displayName);
                    break;
                }
                case -1053726374: {
                    if (guiName.equals("Hunting Box")) {
                        return this.resolveItemInHuntingBoxMenu(displayName);
                    } else {
                        break;
                    }
                }
            }
            if (Intrinsics.areEqual(guiName, "Confirm Fusion")) {
                String string3 = CollectionsKt.firstOrNull(ItemUtils.INSTANCE.getLore(this.compound));
                if (string3 != null) return this.resolveItemInHuntingBoxMenu(string3);
                return null;
            }
            if (!Intrinsics.areEqual(guiName, "Dye Compendium")) return null;
            return Companion.findInternalNameByDisplayName(displayName, false);
        }
        object = ItemUtils.INSTANCE.getLore(this.compound).iterator();
        do {
            String enchantmentIdCandidate;
            if (!object.hasNext()) {
                return null;
            }
            String loreLine = (String)object.next();
            string = enchantmentIdCandidate = Companion.resolveEnchantmentByName(loreLine);
        } while (string == null);
        return string;
    }

    private final boolean isBazaar(IInventory chest) {
        if (StringsKt.startsWith$default(InventoryUtils.INSTANCE.openInventoryName(), "Bazaar \u279c ", false, 2, null)) {
            return true;
        }
        int bazaarSlot = chest.func_70302_i_() - 5;
        if (bazaarSlot < 0) {
            return false;
        }
        ItemStack itemStack = chest.func_70301_a(bazaarSlot);
        if (itemStack == null) {
            return false;
        }
        ItemStack stackInSlot = itemStack;
        if (stackInSlot.field_77994_a == 0) {
            return false;
        }
        List<String> lore = ItemUtils.INSTANCE.getLore(stackInSlot);
        return lore.contains("\u00a77To Bazaar");
    }

    private final NBTTagCompound getExtraAttributes() {
        NBTTagCompound nBTTagCompound = this.compound;
        if (nBTTagCompound == null || (nBTTagCompound = ItemUtils.INSTANCE.getExtraAttributes(nBTTagCompound)) == null) {
            nBTTagCompound = new NBTTagCompound();
        }
        return nBTTagCompound;
    }

    private final String resolveFromSkyblock() {
        String internalName2 = this.getExtraAttributes().func_74779_i("id");
        CharSequence charSequence = internalName2;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        String string = internalName2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        return StringsKt.replace$default(string, ":", "-", false, 4, null);
    }

    private final JsonObject resolveToItemListJson() {
        String string = this.resolveInternalName();
        if (string == null) {
            return null;
        }
        String internalName2 = string;
        return EnoughUpdatesManager.INSTANCE.getItemById(internalName2);
    }

    @Nullable
    public final ItemStack resolveToItemStack() {
        JsonObject jsonObject = this.resolveToItemListJson();
        if (jsonObject == null) {
            return null;
        }
        JsonObject json2 = jsonObject;
        return EnoughUpdatesManager.jsonToStack$default(EnoughUpdatesManager.INSTANCE, json2, false, false, 6, null);
    }

    static {
        Object object = ".*(\\[Lvl .*] )\u00a7(.).*";
        int n = 0;
        Pattern pattern = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
        petPattern = pattern;
        object = new String[]{"COMMON", "UNCOMMON", "RARE", "EPIC", "LEGENDARY", "MYTHIC"};
        petRarities = CollectionsKt.listOf(object);
        object = "ENCHANTMENT_(\\D*)_(\\d+)";
        n = 0;
        Pattern pattern2 = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue(pattern2, "compile(...)");
        BAZAAR_ENCHANTMENT_PATTERN = pattern2;
        renamedEnchantments = MapsKt.emptyMap();
        shardNameOverrides = MapsKt.emptyMap();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J/\u0010\u0014\u001a\u0004\u0018\u00010\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00162\u0006\u0010\r\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\t\u00a2\u0006\u0004\b\u0019\u0010\fJ\u0013\u0010\u001a\u001a\u00020\t*\u00020\tH\u0002\u00a2\u0006\u0004\b\u001a\u0010\fJ\u0017\u0010\u001c\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001b\u001a\u00020\t\u00a2\u0006\u0004\b\u001c\u0010\fR\u0014\u0010\u001e\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u001d\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0 8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010\u001fR\"\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\"\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010(\u00a8\u0006*"}, d2={"Lat/hannibal2/skyhanni/api/enoughupdates/ItemResolutionQuery$Companion;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "", "hypixelId", "transformHypixelBazaarToNeuItemId", "(Ljava/lang/String;)Ljava/lang/String;", "displayName", "", "mayBeMangled", "findInternalNameByDisplayName", "(Ljava/lang/String;Z)Ljava/lang/String;", "", "candidateInternalNames", "filterInternalNameCandidates", "(Ljava/util/Collection;Ljava/lang/String;Z)Ljava/lang/String;", "", "findInternalNameCandidatesForDisplayName", "(Ljava/lang/String;)Ljava/util/Set;", "resolveEnchantmentByName", "renamedEnchantmentCheck", "attributeName", "attributeNameToInternalName", "Ljava/util/regex/Pattern;", "petPattern", "Ljava/util/regex/Pattern;", "", "petRarities", "Ljava/util/List;", "getPetRarities", "()Ljava/util/List;", "BAZAAR_ENCHANTMENT_PATTERN", "", "renamedEnchantments", "Ljava/util/Map;", "shardNameOverrides", "1.8.9"})
    @SourceDebugExtension(value={"SMAP\nItemResolutionQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemResolutionQuery.kt\nat/hannibal2/skyhanni/api/enoughupdates/ItemResolutionQuery$Companion\n+ 2 AbstractRepoReloadEvent.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoReloadEvent\n+ 3 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n+ 4 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n+ 5 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,385:1\n13#2,7:386\n21#2,6:403\n162#3,5:393\n167#3,4:399\n24#4:398\n8#5:409\n1#6:410\n*S KotlinDebug\n*F\n+ 1 ItemResolutionQuery.kt\nat/hannibal2/skyhanni/api/enoughupdates/ItemResolutionQuery$Companion\n*L\n61#1:386,7\n61#1:403,6\n61#1:393,5\n61#1:399,4\n61#1:398\n150#1:409\n150#1:410\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getPetRarities() {
            return petRarities;
        }

        /*
         * WARNING - void declaration
         */
        @HandleEvent
        public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
            Object object;
            Intrinsics.checkNotNullParameter(event, "event");
            String constant$iv = "Items";
            Object type$iv = null;
            Gson gson$iv = ((AbstractRepoReloadEvent)event).getGson();
            boolean $i$f$getConstant = false;
            Object object2 = event;
            try {
                Object $this$getRepoData_u24lambda_u2414$iv$iv;
                void this_$iv$iv;
                AbstractRepoReloadEvent $this$getConstant_u24lambda_u242$iv = object2;
                boolean bl = false;
                AbstractRepoManager<?> abstractRepoManager = $this$getConstant_u24lambda_u242$iv.getManager();
                String directory$iv$iv = "constants";
                boolean $i$f$getRepoData = false;
                Object object3 = this_$iv$iv;
                try {
                    $this$getRepoData_u24lambda_u2414$iv$iv = object3;
                    boolean bl2 = false;
                    String path$iv$iv = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).resolvePath(directory$iv$iv, constant$iv);
                    JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).readJsonElement(path$iv$iv);
                    if (jsonElement == null) {
                        ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).getLogger().throwError("Repo file '" + constant$iv + "' not found.");
                        throw new KotlinNothingValueException();
                    }
                    JsonElement json$iv$iv = jsonElement;
                    Gson $this$fromJson$iv$iv$iv = gson$iv;
                    boolean $i$f$fromJson = false;
                    Object object4 = $this$fromJson$iv$iv$iv.fromJson(json$iv$iv, ReflectJvmMapping.getJavaType(Reflection.typeOf(ItemsJson.class)));
                    Intrinsics.checkNotNullExpressionValue(object4, "fromJson(...)");
                    $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl(object4);
                }
                catch (Throwable bl2) {
                    $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl(ResultKt.createFailure(bl2));
                }
                object3 = $this$getRepoData_u24lambda_u2414$iv$iv;
                Throwable throwable = Result.exceptionOrNull-impl(object3);
                if (throwable != null) {
                    Throwable e$iv$iv = throwable;
                    boolean bl3 = false;
                    this_$iv$iv.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv$iv);
                    throw new KotlinNothingValueException();
                }
                Object constantData$iv = object3;
                $this$getConstant_u24lambda_u242$iv.getManager().addSuccessfulConstant(constant$iv);
                object = constantData$iv;
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl(ResultKt.createFailure(bl));
                Throwable throwable = Result.exceptionOrNull-impl(object2);
                if (throwable != null) {
                    Throwable it$iv = throwable;
                    boolean bl4 = false;
                    ((AbstractRepoReloadEvent)event).getManager().addUnsuccessfulConstant(constant$iv);
                    ((AbstractRepoReloadEvent)event).getManager().getLogger().throwErrorWithCause("Could not load constant '" + constant$iv + '\'', it$iv);
                    throw new KotlinNothingValueException();
                }
                throw new KotlinNothingValueException();
            }
            ItemsJson data2 = (ItemsJson)object;
            renamedEnchantments = data2.getRenamedEnchantments();
            shardNameOverrides = data2.getShardNameOverrides();
        }

        @NotNull
        public final String transformHypixelBazaarToNeuItemId(@NotNull String hypixelId) {
            Intrinsics.checkNotNullParameter(hypixelId, "hypixelId");
            String string = ItemUtils.INSTANCE.getBazaarOverrides().get(hypixelId);
            if (string != null) {
                String it = string;
                boolean bl = false;
                return it;
            }
            Matcher matcher = BAZAAR_ENCHANTMENT_PATTERN.matcher(hypixelId);
            if (matcher.matches()) {
                return matcher.group(1) + ';' + matcher.group(2);
            }
            return StringsKt.replace$default(hypixelId, ":", "-", false, 4, null);
        }

        @Nullable
        public final String findInternalNameByDisplayName(@NotNull String displayName, boolean mayBeMangled) {
            Intrinsics.checkNotNullParameter(displayName, "displayName");
            return this.filterInternalNameCandidates((Collection<String>)this.findInternalNameCandidatesForDisplayName(displayName), displayName, mayBeMangled);
        }

        private final String filterInternalNameCandidates(Collection<String> candidateInternalNames, String displayName, boolean mayBeMangled) {
            String itemName2 = displayName;
            boolean isPet = StringsKt.contains$default((CharSequence)itemName2, "[Lvl ", false, 2, null);
            String petRarity = null;
            if (isPet) {
                Matcher matcher = petPattern.matcher(itemName2);
                Intrinsics.checkNotNullExpressionValue(matcher, "matcher(...)");
                Matcher matcher2 = matcher;
                if (matcher2.matches()) {
                    String string = matcher2.group(1);
                    Intrinsics.checkNotNullExpressionValue(string, "group(...)");
                    itemName2 = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default(StringsKt.replace$default(itemName2, string, "", false, 4, null), "\u2726", "", false, 4, null))).toString();
                    petRarity = matcher2.group(2);
                }
            }
            String cleanDisplayName = StringUtils.removeColor$default(StringUtils.INSTANCE, itemName2, false, 1, null);
            String bestMatch = null;
            int bestMatchLength = -1;
            for (String internalName2 : candidateInternalNames) {
                boolean isExactMatch;
                String unCleanItemDisplayName = EnoughUpdatesManager.INSTANCE.getDisplayName(internalName2);
                String cleanItemDisplayName = StringUtils.removeColor$default(StringUtils.INSTANCE, unCleanItemDisplayName, false, 1, null);
                if (((CharSequence)cleanItemDisplayName).length() == 0) continue;
                if (isPet) {
                    Matcher matcher;
                    if (!StringsKt.contains$default((CharSequence)cleanItemDisplayName, "[Lvl {LVL}] ", false, 2, null)) continue;
                    cleanItemDisplayName = StringsKt.replace$default(cleanItemDisplayName, "[Lvl {LVL}] ", "", false, 4, null);
                    Intrinsics.checkNotNullExpressionValue(petPattern.matcher(unCleanItemDisplayName), "matcher(...)");
                    if (matcher.matches() && !Intrinsics.areEqual(matcher.group(2), petRarity)) continue;
                }
                boolean isMangledMatch = mayBeMangled && !StringsKt.contains$default((CharSequence)cleanDisplayName, cleanItemDisplayName, false, 2, null);
                boolean bl = isExactMatch = !mayBeMangled && !Intrinsics.areEqual(cleanItemDisplayName, cleanDisplayName);
                if (isMangledMatch || isExactMatch || cleanItemDisplayName.length() <= bestMatchLength) continue;
                bestMatchLength = cleanItemDisplayName.length();
                bestMatch = internalName2;
            }
            return bestMatch;
        }

        private final Set<String> findInternalNameCandidatesForDisplayName(String displayName) {
            boolean isPet = StringsKt.contains$default((CharSequence)displayName, "[Lvl ", false, 2, null);
            String cleanDisplayName = StringUtils.INSTANCE.cleanString(displayName);
            TreeMap<String, Map<String, List<Integer>>> titleWordMap = EnoughUpdatesManager.INSTANCE.getTitleWordMap();
            HashSet<String> candidates = new HashSet<String>();
            String[] stringArray = new String[]{" "};
            for (String partialDisplayName : StringsKt.split$default((CharSequence)cleanDisplayName, stringArray, false, 0, 6, null)) {
                Object object;
                if (((CharSequence)partialDisplayName).length() == 0 || !titleWordMap.containsKey(partialDisplayName) || (object = titleWordMap.get(partialDisplayName)) == null || (object = object.keySet()) == null) continue;
                Object c = object;
                Iterator iterator2 = c.iterator();
                while (iterator2.hasNext()) {
                    String s = (String)iterator2.next();
                    if (isPet && !StringsKt.contains$default((CharSequence)s, ";", false, 2, null)) continue;
                    candidates.add(s);
                }
            }
            return candidates;
        }

        @Nullable
        public final String resolveEnchantmentByName(@NotNull String displayName) {
            String string;
            Intrinsics.checkNotNullParameter(displayName, "displayName");
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern $this$matchMatcher$iv = UtilsPatterns.INSTANCE.getEnchantmentNamePattern();
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(displayName);
            boolean bl = false;
            if (it$iv.matches()) {
                Intrinsics.checkNotNull(it$iv);
                Matcher $this$resolveEnchantmentByName_u24lambda_u241 = it$iv;
                boolean bl2 = false;
                String string2 = $this$resolveEnchantmentByName_u24lambda_u241.group("name");
                Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
                String name2 = StringsKt.replace$default(((Object)StringsKt.trim((CharSequence)string2)).toString(), "'", "", false, 4, null);
                String string3 = $this$resolveEnchantmentByName_u24lambda_u241.group("format");
                Intrinsics.checkNotNullExpressionValue(string3, "group(...)");
                String string4 = string3.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
                boolean ultimate = StringsKt.contains$default((CharSequence)string4, "\u00a7l", false, 2, null);
                String prefix = ultimate && !Intrinsics.areEqual(name2, "Ultimate Wise") && !Intrinsics.areEqual(name2, "Ultimate Jerry") ? "ULTIMATE_" : "";
                String string5 = StringsKt.replace$default(StringsKt.replace$default(Companion.renamedEnchantmentCheck(name2), " ", "_", false, 4, null), "-", "_", false, 4, null).toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string5, "toUpperCase(...)");
                String cleanedEnchantName = string5;
                StringBuilder stringBuilder = new StringBuilder().append(prefix).append(cleanedEnchantName).append(';');
                String string6 = $this$resolveEnchantmentByName_u24lambda_u241.group("level");
                Intrinsics.checkNotNullExpressionValue(string6, "group(...)");
                String string7 = stringBuilder.append(NumberUtil.INSTANCE.romanToDecimal(string6)).toString().toUpperCase(Locale.ROOT);
                string = string7;
                Intrinsics.checkNotNullExpressionValue(string7, "toUpperCase(...)");
            } else {
                string = null;
            }
            return string;
        }

        private final String renamedEnchantmentCheck(String $this$renamedEnchantmentCheck) {
            String string = (String)renamedEnchantments.get($this$renamedEnchantmentCheck);
            if (string == null) {
                string = $this$renamedEnchantmentCheck;
            }
            return string;
        }

        @Nullable
        public final String attributeNameToInternalName(@NotNull String attributeName) {
            Intrinsics.checkNotNullParameter(attributeName, "attributeName");
            String string = attributeName.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            String fixedAttributeName = StringsKt.replace$default(string, " ", "_", false, 4, null);
            String string2 = (String)shardNameOverrides.get(fixedAttributeName);
            if (string2 == null) {
                string2 = fixedAttributeName;
            }
            fixedAttributeName = string2;
            String shardName = "SHARD_" + fixedAttributeName;
            return ItemUtils.INSTANCE.getBazaarOverrides().get(shardName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

