/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.event.hoppity;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.data.jsonobjects.repo.neu.HoppityInfo;
import at.hannibal2.skyhanni.data.jsonobjects.repo.neu.HoppityRarityInfo;
import at.hannibal2.skyhanni.data.jsonobjects.repo.neu.MythicRabbitInfo;
import at.hannibal2.skyhanni.data.jsonobjects.repo.neu.NeuHoppityJson;
import at.hannibal2.skyhanni.data.repo.AbstractRepoManager;
import at.hannibal2.skyhanni.data.repo.AbstractRepoReloadEvent;
import at.hannibal2.skyhanni.events.NeuRepositoryReloadEvent;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityCollectionStats;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001$B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u0004*\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019R#\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u001a8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR \u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001cR \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u001cR\u0011\u0010#\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006%"}, d2={"Lat/hannibal2/skyhanni/features/event/hoppity/HoppityCollectionData;", "", "<init>", "()V", "", "rabbit", "Lat/hannibal2/skyhanni/features/event/hoppity/HoppityCollectionStats$RabbitCollectionRarity;", "getRarity", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/event/hoppity/HoppityCollectionStats$RabbitCollectionRarity;", "rarity", "", "knownRabbitsOfRarity", "(Lat/hannibal2/skyhanni/features/event/hoppity/HoppityCollectionStats$RabbitCollectionRarity;)I", "", "isKnownRabbit", "(Ljava/lang/String;)Z", "Lat/hannibal2/skyhanni/features/event/hoppity/HoppityCollectionData$ChocolateBonuses;", "getChocolateBonuses", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/event/hoppity/HoppityCollectionData$ChocolateBonuses;", "toApiName", "(Ljava/lang/String;)Ljava/lang/String;", "Lat/hannibal2/skyhanni/events/NeuRepositoryReloadEvent;", "event", "", "onNeuRepoReload", "(Lat/hannibal2/skyhanni/events/NeuRepositoryReloadEvent;)V", "", "rabbitRarities", "Ljava/util/Map;", "getRabbitRarities", "()Ljava/util/Map;", "rarityBonuses", "specialBonuses", "getKnownRabbitCount", "()I", "knownRabbitCount", "ChocolateBonuses", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nHoppityCollectionData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoppityCollectionData.kt\nat/hannibal2/skyhanni/features/event/hoppity/HoppityCollectionData\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 AbstractRepoReloadEvent.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoReloadEvent\n+ 4 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n+ 5 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,65:1\n503#2,7:66\n13#3,7:73\n21#3,6:90\n156#4,5:80\n161#4,4:86\n24#5:85\n216#6,2:96\n*S KotlinDebug\n*F\n+ 1 HoppityCollectionData.kt\nat/hannibal2/skyhanni/features/event/hoppity/HoppityCollectionData\n*L\n24#1:66,7\n47#1:73,7\n47#1:90,6\n47#1:80,5\n47#1:86,4\n47#1:85\n58#1:96,2\n*E\n"})
public final class HoppityCollectionData {
    @NotNull
    public static final HoppityCollectionData INSTANCE = new HoppityCollectionData();
    @NotNull
    private static final Map<String, HoppityCollectionStats.RabbitCollectionRarity> rabbitRarities = new LinkedHashMap();
    @NotNull
    private static final Map<HoppityCollectionStats.RabbitCollectionRarity, ChocolateBonuses> rarityBonuses = new LinkedHashMap();
    @NotNull
    private static final Map<String, ChocolateBonuses> specialBonuses = new LinkedHashMap();

    private HoppityCollectionData() {
    }

    @NotNull
    public final Map<String, HoppityCollectionStats.RabbitCollectionRarity> getRabbitRarities() {
        return rabbitRarities;
    }

    public final int getKnownRabbitCount() {
        return rabbitRarities.size();
    }

    @Nullable
    public final HoppityCollectionStats.RabbitCollectionRarity getRarity(@NotNull String rabbit) {
        Intrinsics.checkNotNullParameter(rabbit, "rabbit");
        String apiName = this.toApiName(rabbit);
        return rabbitRarities.get(apiName);
    }

    public final int knownRabbitsOfRarity(@NotNull HoppityCollectionStats.RabbitCollectionRarity rarity) {
        Intrinsics.checkNotNullParameter((Object)rarity, "rarity");
        Map<String, HoppityCollectionStats.RabbitCollectionRarity> $this$filterValues$iv = rabbitRarities;
        boolean $i$f$filterValues = false;
        LinkedHashMap<String, HoppityCollectionStats.RabbitCollectionRarity> result$iv = new LinkedHashMap<String, HoppityCollectionStats.RabbitCollectionRarity>();
        for (Map.Entry<String, HoppityCollectionStats.RabbitCollectionRarity> entry$iv : $this$filterValues$iv.entrySet()) {
            HoppityCollectionStats.RabbitCollectionRarity it = entry$iv.getValue();
            boolean bl = false;
            if (!(it == rarity)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return ((Map)result$iv).size();
    }

    public final boolean isKnownRabbit(@NotNull String rabbit) {
        Intrinsics.checkNotNullParameter(rabbit, "rabbit");
        return rabbitRarities.containsKey(this.toApiName(rabbit));
    }

    @NotNull
    public final ChocolateBonuses getChocolateBonuses(@NotNull String rabbit) {
        Intrinsics.checkNotNullParameter(rabbit, "rabbit");
        String apiName = this.toApiName(rabbit);
        HoppityCollectionStats.RabbitCollectionRarity rarity = rabbitRarities.get(apiName);
        ChocolateBonuses chocolateBonuses = specialBonuses.get(apiName);
        if (chocolateBonuses == null && (chocolateBonuses = rarityBonuses.get((Object)rarity)) == null) {
            chocolateBonuses = new ChocolateBonuses(0, 0.0);
        }
        return chocolateBonuses;
    }

    private final String toApiName(String $this$toApiName) {
        String string;
        if (Intrinsics.areEqual($this$toApiName, "Fish the Rabbit")) {
            string = "fish";
        } else {
            String string2 = $this$toApiName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            CharSequence charSequence = string2;
            Regex regex = new Regex("[- ]");
            String string3 = "_";
            string = regex.replace(charSequence, string3);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onNeuRepoReload(@NotNull NeuRepositoryReloadEvent event) {
        Object object;
        Intrinsics.checkNotNullParameter(event, "event");
        rabbitRarities.clear();
        rarityBonuses.clear();
        specialBonuses.clear();
        String constant$iv = "hoppity";
        Object var4_3 = null;
        Gson gson$iv = ((AbstractRepoReloadEvent)event).getGson();
        boolean $i$f$getConstant = false;
        Map.Entry<String, MythicRabbitInfo> entry = event;
        try {
            Object $this$getRepoData_u24lambda_u2414$iv$iv;
            void this_$iv$iv;
            AbstractRepoReloadEvent $this$getConstant_u24lambda_u242$iv = entry;
            boolean bl = false;
            AbstractRepoManager<?> abstractRepoManager = $this$getConstant_u24lambda_u242$iv.getManager();
            String directory$iv$iv = "constants";
            boolean $i$f$getRepoData = false;
            Object object2 = this_$iv$iv;
            try {
                $this$getRepoData_u24lambda_u2414$iv$iv = object2;
                boolean bl2 = false;
                String path$iv$iv = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).resolvePath(directory$iv$iv, constant$iv);
                JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).readJsonElement(path$iv$iv);
                if (jsonElement == null) {
                    ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).getLogger().throwError("Repo file '" + (String)constant$iv + "' not found.");
                    throw new KotlinNothingValueException();
                }
                JsonElement json$iv$iv = jsonElement;
                Gson $this$fromJson$iv$iv$iv = gson$iv;
                boolean $i$f$fromJson = false;
                Object object3 = $this$fromJson$iv$iv$iv.fromJson(json$iv$iv, ReflectJvmMapping.getJavaType(Reflection.typeOf(NeuHoppityJson.class)));
                Intrinsics.checkNotNullExpressionValue(object3, "fromJson(...)");
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl(object3);
            }
            catch (Throwable bl2) {
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl(ResultKt.createFailure(bl2));
            }
            object2 = $this$getRepoData_u24lambda_u2414$iv$iv;
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable != null) {
                Throwable e$iv$iv = throwable;
                boolean bl3 = false;
                this_$iv$iv.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + (String)constant$iv + '\'', e$iv$iv);
                throw new KotlinNothingValueException();
            }
            Object constantData$iv = object2;
            $this$getConstant_u24lambda_u242$iv.getManager().addSuccessfulConstant(constant$iv);
            object = constantData$iv;
        }
        catch (Throwable bl) {
            entry = Result.constructor-impl(ResultKt.createFailure(bl));
            Throwable throwable = Result.exceptionOrNull-impl(entry);
            if (throwable != null) {
                Throwable it$iv = throwable;
                boolean bl4 = false;
                ((AbstractRepoReloadEvent)event).getManager().addUnsuccessfulConstant(constant$iv);
                ((AbstractRepoReloadEvent)event).getManager().getLogger().throwErrorWithCause("Could not load constant '" + (String)constant$iv + '\'', it$iv);
                throw new KotlinNothingValueException();
            }
            throw new KotlinNothingValueException();
        }
        HoppityInfo data2 = ((NeuHoppityJson)object).getHoppity();
        for (Map.Entry entry2 : data2.getRarities().entrySet()) {
            String rarityString = (String)entry2.getKey();
            HoppityRarityInfo rarityData = (HoppityRarityInfo)entry2.getValue();
            String string = rarityString.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            HoppityCollectionStats.RabbitCollectionRarity rarity = HoppityCollectionStats.RabbitCollectionRarity.valueOf(string);
            for (String rabbit : rarityData.getRabbits()) {
                rabbitRarities.put(rabbit, rarity);
            }
            rarityBonuses.put(rarity, new ChocolateBonuses(rarityData.getChocolate(), rarityData.getMultiplier()));
        }
        Map<String, MythicRabbitInfo> $this$forEach$iv = data2.getSpecial();
        boolean bl = false;
        Iterator<Map.Entry<String, MythicRabbitInfo>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, MythicRabbitInfo> element$iv;
            entry = element$iv = iterator2.next();
            boolean bl2 = false;
            String rabbit = entry.getKey();
            MythicRabbitInfo data3 = entry.getValue();
            specialBonuses.put(rabbit, new ChocolateBonuses(data3.getChocolate(), data3.getMultiplier()));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lat/hannibal2/skyhanni/features/event/hoppity/HoppityCollectionData$ChocolateBonuses;", "", "", "chocolate", "", "multiplier", "<init>", "(ID)V", "component1", "()I", "component2", "()D", "copy", "(ID)Lat/hannibal2/skyhanni/features/event/hoppity/HoppityCollectionData$ChocolateBonuses;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getChocolate", "D", "getMultiplier", "1.8.9"})
    public static final class ChocolateBonuses {
        private final int chocolate;
        private final double multiplier;

        public ChocolateBonuses(int chocolate, double multiplier) {
            this.chocolate = chocolate;
            this.multiplier = multiplier;
        }

        public final int getChocolate() {
            return this.chocolate;
        }

        public final double getMultiplier() {
            return this.multiplier;
        }

        public final int component1() {
            return this.chocolate;
        }

        public final double component2() {
            return this.multiplier;
        }

        @NotNull
        public final ChocolateBonuses copy(int chocolate, double multiplier) {
            return new ChocolateBonuses(chocolate, multiplier);
        }

        public static /* synthetic */ ChocolateBonuses copy$default(ChocolateBonuses chocolateBonuses, int n, double d, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = chocolateBonuses.chocolate;
            }
            if ((n2 & 2) != 0) {
                d = chocolateBonuses.multiplier;
            }
            return chocolateBonuses.copy(n, d);
        }

        @NotNull
        public String toString() {
            return "ChocolateBonuses(chocolate=" + this.chocolate + ", multiplier=" + this.multiplier + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.chocolate);
            result2 = result2 * 31 + Double.hashCode(this.multiplier);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChocolateBonuses)) {
                return false;
            }
            ChocolateBonuses chocolateBonuses = (ChocolateBonuses)other;
            if (this.chocolate != chocolateBonuses.chocolate) {
                return false;
            }
            return Double.compare(this.multiplier, chocolateBonuses.multiplier) == 0;
        }
    }
}

