/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.fishing.RareCatchesConfig;
import at.hannibal2.skyhanni.data.PartyApi;
import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.data.title.TitleManager;
import at.hannibal2.skyhanni.events.MobEvent;
import at.hannibal2.skyhanni.events.RenderEntityOutlineEvent;
import at.hannibal2.skyhanni.events.fishing.SeaCreatureFishEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonApi;
import at.hannibal2.skyhanni.features.fishing.SeaCreature;
import at.hannibal2.skyhanni.features.fishing.SeaCreatureManager;
import at.hannibal2.skyhanni.features.nether.kuudra.KuudraApi;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.MobUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.collection.TimeLimitedSet;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySlime;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0003J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b \u0010\u001fR\u0014\u0010$\u001a\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0016\u0010&\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020,0(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010+R1\u00102\u001a\u001f\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b/\u0012\b\b0\u0012\u0004\b\b(\u001d\u0012\u0006\u0012\u0004\u0018\u0001010.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103\u00a8\u00064"}, d2={"Lat/hannibal2/skyhanni/features/fishing/SeaCreatureFeatures;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;", "event", "", "onMobSpawn", "(Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/MobEvent$FirstSeen$SkyblockMob;", "onMobFirstSeen", "(Lat/hannibal2/skyhanni/events/MobEvent$FirstSeen$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;", "onMobDespawn", "(Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/fishing/SeaCreatureFishEvent;", "onSeaCreatureFish", "(Lat/hannibal2/skyhanni/events/fishing/SeaCreatureFishEvent;)V", "onWorldChange", "Lat/hannibal2/skyhanni/events/RenderEntityOutlineEvent;", "onRenderEntityOutlines", "(Lat/hannibal2/skyhanni/events/RenderEntityOutlineEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "", "isEnabled", "()Z", "Lnet/minecraft/entity/Entity;", "entity", "isRareSeaCreature", "(Lnet/minecraft/entity/Entity;)Z", "isRareSeaCreatureBody", "Lat/hannibal2/skyhanni/config/features/fishing/RareCatchesConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/fishing/RareCatchesConfig;", "config", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastRareCatch", "J", "Lat/hannibal2/skyhanni/utils/collection/TimeLimitedSet;", "Lat/hannibal2/skyhanni/data/mob/Mob;", "rareSeaCreatures", "Lat/hannibal2/skyhanni/utils/collection/TimeLimitedSet;", "", "entityIds", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Ljava/awt/Color;", "getEntityOutlineColor", "Lkotlin/jvm/functions/Function1;", "1.8.9"})
public final class SeaCreatureFeatures {
    @NotNull
    public static final SeaCreatureFeatures INSTANCE = new SeaCreatureFeatures();
    private static long lastRareCatch = SimpleTimeMark.Companion.farPast();
    @NotNull
    private static final TimeLimitedSet<Mob> rareSeaCreatures = new TimeLimitedSet(DurationKt.toDuration(6, DurationUnit.MINUTES), null, 2, null);
    @NotNull
    private static final TimeLimitedSet<Integer> entityIds = new TimeLimitedSet(DurationKt.toDuration(6, DurationUnit.MINUTES), null, 2, null);
    @NotNull
    private static final Function1<Entity, Color> getEntityOutlineColor = SeaCreatureFeatures::getEntityOutlineColor$lambda$2;

    private SeaCreatureFeatures() {
    }

    private final RareCatchesConfig getConfig() {
        return SkyHanniMod.feature.getFishing().getRareCatches();
    }

    @HandleEvent
    public final void onMobSpawn(@NotNull MobEvent.Spawn.SkyblockMob event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        Mob mob = event.getMob();
        SeaCreature seaCreature = SeaCreatureManager.INSTANCE.getAllFishingMobs().get(mob.getName());
        if (seaCreature == null) {
            return;
        }
        SeaCreature creature = seaCreature;
        if (!creature.getRare()) {
            return;
        }
        rareSeaCreatures.add(mob);
        if (!this.getConfig().getHighlight()) {
            return;
        }
        mob.highlight(LorenzColor.toChromaColor$default(LorenzColor.GREEN, 0, 0, 3, null));
    }

    @HandleEvent
    public final void onMobFirstSeen(@NotNull MobEvent.FirstSeen.SkyblockMob event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        Mob mob = event.getMob();
        if (!rareSeaCreatures.contains(mob)) {
            return;
        }
        EntityLivingBase entity = mob.getBaseEntity();
        boolean shouldNotify = !entityIds.contains(entity.func_145782_y());
        entityIds.addIfAbsent(entity.func_145782_y());
        SeaCreature seaCreature = SeaCreatureManager.INSTANCE.getAllFishingMobs().get(mob.getName());
        if (seaCreature == null) {
            return;
        }
        SeaCreature creature = seaCreature;
        if (!creature.getRare()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastRareCatch), DurationKt.toDuration(1, DurationUnit.SECONDS)) < 0) {
            return;
        }
        if (Intrinsics.areEqual(mob.getName(), "Water Hydra") && entity.func_110143_aJ() == (float)EntityUtils.INSTANCE.getBaseMaxHealth(entity) / (float)2) {
            return;
        }
        if (this.getConfig().getAlertOtherCatches() && shouldNotify) {
            String text = this.getConfig().getCreatureName() ? creature.getDisplayName() + " NEARBY!" : creature.getRarity().getChatColorCode() + "RARE SEA CREATURE!";
            TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, text, null, DurationKt.toDuration(1.5, DurationUnit.SECONDS), null, null, null, 0.0, false, false, null, 0L, null, null, 0L, 16378, null);
            if (this.getConfig().getPlaySound()) {
                SoundUtils.playBeepSound$default(SoundUtils.INSTANCE, 0.0f, 1, null);
            }
        }
    }

    @HandleEvent
    public final void onMobDespawn(@NotNull MobEvent.DeSpawn.SkyblockMob event) {
        Intrinsics.checkNotNullParameter(event, "event");
        rareSeaCreatures.remove(event.getMob());
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onSeaCreatureFish(@NotNull SeaCreatureFishEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.getSeaCreature().getRare()) {
            return;
        }
        if (this.getConfig().getAlertOwnCatches()) {
            String text = this.getConfig().getCreatureName() ? event.getSeaCreature().getDisplayName() + '!' : event.getSeaCreature().getRarity().getChatColorCode() + "RARE CATCH!";
            TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, text, null, 0L, null, null, null, 0.0, false, false, null, 0L, null, null, 0L, 16382, null);
            if (this.getConfig().getPlaySound()) {
                SoundUtils.playBeepSound$default(SoundUtils.INSTANCE, 0.0f, 1, null);
            }
            lastRareCatch = SimpleTimeMark.Companion.now-uFjCsEo();
        }
        if (this.getConfig().getAnnounceRareInParty() && PartyApi.INSTANCE.isInParty()) {
            StringBuilder stringBuilder;
            String name2 = event.getSeaCreature().getName();
            StringBuilder $this$onSeaCreatureFish_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if (event.getDoubleHook()) {
                $this$onSeaCreatureFish_u24lambda_u240.append("DOUBLE HOOK: ");
            }
            $this$onSeaCreatureFish_u24lambda_u240.append("I caught " + StringUtils.INSTANCE.optionalAn(name2) + ' ' + name2 + '!');
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String message = string;
            HypixelCommands.partyChat$default(HypixelCommands.INSTANCE, message, false, 2, null);
        }
    }

    @HandleEvent
    public final void onWorldChange() {
        rareSeaCreatures.clear();
        entityIds.clear();
    }

    @HandleEvent
    public final void onRenderEntityOutlines(@NotNull RenderEntityOutlineEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (this.isEnabled() && this.getConfig().getHighlight() && event.getType() == RenderEntityOutlineEvent.Type.NO_XRAY) {
            event.queueEntitiesToOutline(getEntityOutlineColor);
        }
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "fishing.rareSeaCreatureHighlight", "fishing.rareCatches.highlight", null, 8, null);
    }

    private final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && !DungeonApi.INSTANCE.inDungeon() && !KuudraApi.INSTANCE.getInKuudra();
    }

    @JvmStatic
    public static final boolean isRareSeaCreature(@NotNull Entity entity) {
        boolean bl;
        Intrinsics.checkNotNullParameter(entity, "entity");
        Object object = entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        if (object != null && (object = MobUtils.INSTANCE.getMob((EntityLivingBase)object)) != null) {
            Object mob = object;
            boolean bl2 = false;
            bl = rareSeaCreatures.contains(mob);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isRareSeaCreatureBody(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        if (!(entity instanceof EntitySlime)) return false;
        if (!SeaCreatureFeatures.isRareSeaCreature(entity)) return false;
        return true;
    }

    private static final Color getEntityOutlineColor$lambda$2(Entity entity) {
        Color color;
        Intrinsics.checkNotNullParameter(entity, "entity");
        Object object = entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        if (object != null && (object = MobUtils.INSTANCE.getMob((EntityLivingBase)object)) != null) {
            Object mob = object;
            boolean bl = false;
            color = rareSeaCreatures.contains(mob) && LocationUtils.INSTANCE.distanceToPlayer(entity) < 30.0 ? LorenzColor.GREEN.toColor() : null;
        } else {
            color = null;
        }
        return color;
    }
}

