/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.test.command;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.data.mob.MobData;
import at.hannibal2.skyhanni.data.mob.MobFilter;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.OSUtils;
import at.hannibal2.skyhanni.utils.compat.EntityCompatKt;
import at.hannibal2.skyhanni.utils.compat.InventoryCompat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Rotations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\r\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0010\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\f\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J!\u0010\u0013\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\f\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J!\u0010\u0016\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\f\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J!\u0010\u0019\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\f\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ!\u0010\u001c\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\f\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ!\u0010\u001f\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J#\u0010#\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u00050\n2\b\u0010\"\u001a\u0004\u0018\u00010!H\u0002\u00a2\u0006\u0004\b#\u0010$J!\u0010(\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020%2\b\u0010'\u001a\u0004\u0018\u00010&H\u0002\u00a2\u0006\u0004\b(\u0010)J\u001b\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050*2\u0006\u0010'\u001a\u00020&\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010/\u001a\u00020\u00072\u0006\u0010.\u001a\u00020-H\u0007\u00a2\u0006\u0004\b/\u00100J\u0013\u00102\u001a\u00020\u0005*\u000201H\u0002\u00a2\u0006\u0004\b2\u00103\u00a8\u00064"}, d2={"Lat/hannibal2/skyhanni/test/command/CopyNearbyEntitiesCommand;", "", "<init>", "()V", "", "", "args", "", "command", "([Ljava/lang/String;)V", "", "Lnet/minecraft/entity/item/EntityArmorStand;", "entity", "addArmorStand", "(Ljava/util/List;Lnet/minecraft/entity/item/EntityArmorStand;)V", "Lnet/minecraft/entity/monster/EntityEnderman;", "addEnderman", "(Ljava/util/List;Lnet/minecraft/entity/monster/EntityEnderman;)V", "Lnet/minecraft/entity/monster/EntityMagmaCube;", "addMagmaCube", "(Ljava/util/List;Lnet/minecraft/entity/monster/EntityMagmaCube;)V", "Lnet/minecraft/entity/item/EntityItem;", "addItem", "(Ljava/util/List;Lnet/minecraft/entity/item/EntityItem;)V", "Lnet/minecraft/client/entity/EntityOtherPlayerMP;", "addOtherPlayer", "(Ljava/util/List;Lnet/minecraft/client/entity/EntityOtherPlayerMP;)V", "Lnet/minecraft/entity/monster/EntityCreeper;", "addCreeper", "(Ljava/util/List;Lnet/minecraft/entity/monster/EntityCreeper;)V", "Lnet/minecraft/entity/boss/EntityWither;", "addWither", "(Ljava/util/List;Lnet/minecraft/entity/boss/EntityWither;)V", "Lnet/minecraft/item/ItemStack;", "stack", "printItemStackData", "(Ljava/util/List;Lnet/minecraft/item/ItemStack;)V", "Lnet/minecraft/entity/Entity;", "Lat/hannibal2/skyhanni/data/mob/Mob;", "mob", "getType", "(Lnet/minecraft/entity/Entity;Lat/hannibal2/skyhanni/data/mob/Mob;)Ljava/lang/String;", "", "getMobInfo", "(Lat/hannibal2/skyhanni/data/mob/Mob;)Ljava/util/List;", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "event", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "Lnet/minecraft/entity/EntityLivingBase;", "asString", "(Lnet/minecraft/entity/EntityLivingBase;)Ljava/lang/String;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nCopyNearbyEntitiesCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CopyNearbyEntitiesCommand.kt\nat/hannibal2/skyhanni/test/command/CopyNearbyEntitiesCommand\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,375:1\n607#2:376\n1557#3:377\n1628#3,3:378\n1557#3:382\n1628#3,3:383\n1#4:381\n*S KotlinDebug\n*F\n+ 1 CopyNearbyEntitiesCommand.kt\nat/hannibal2/skyhanni/test/command/CopyNearbyEntitiesCommand\n*L\n56#1:376\n133#1:377\n133#1:378,3\n342#1:382\n342#1:383,3\n*E\n"})
public final class CopyNearbyEntitiesCommand {
    @NotNull
    public static final CopyNearbyEntitiesCommand INSTANCE = new CopyNearbyEntitiesCommand();

    private CopyNearbyEntitiesCommand() {
    }

    /*
     * WARNING - void declaration
     */
    private final void command(String[] args2) {
        List<String> list;
        int searchRadius = 0;
        searchRadius = 10;
        if (args2.length == 1) {
            searchRadius = Integer.parseInt(args2[0]);
        }
        LorenzVec start2 = LocationUtils.INSTANCE.playerLocation();
        int counter = 0;
        List<String> $this$command_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Sequence<Entity> $this$sortedBy$iv = EntityUtils.INSTANCE.getAllEntities();
        boolean $i$f$sortedBy = false;
        Iterator<Entity> iterator2 = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Entity it = (Entity)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.func_145782_y());
                it = (Entity)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.func_145782_y());
            }
        }).iterator();
        while (iterator2.hasNext()) {
            ItemStack[] armor2;
            Entity entity = iterator2.next();
            BlockPos position = entity.func_180425_c();
            Intrinsics.checkNotNull(position);
            LorenzVec vec = LorenzVecKt.toLorenzVec(position);
            double distance = start2.distance(vec);
            Mob mob = MobData.INSTANCE.getEntityToMob().get(entity);
            if (distance >= (double)searchRadius) continue;
            String simpleName2 = entity.getClass().getSimpleName();
            $this$command_u24lambda_u242.add("entity: " + simpleName2);
            IChatComponent displayName = entity.func_145748_c_();
            $this$command_u24lambda_u242.add("name: '" + entity.func_70005_c_() + '\'');
            if (entity instanceof EntityArmorStand) {
                $this$command_u24lambda_u242.add("cleanName: '" + EntityUtils.INSTANCE.cleanName(entity) + '\'');
            }
            $this$command_u24lambda_u242.add("displayName: '" + displayName.func_150254_d() + '\'');
            $this$command_u24lambda_u242.add("entityId: " + entity.func_145782_y());
            $this$command_u24lambda_u242.add("Type of Mob: " + INSTANCE.getType(entity, mob));
            $this$command_u24lambda_u242.add("uuid version: " + entity.func_110124_au().version() + " (" + entity.func_110124_au() + ')');
            $this$command_u24lambda_u242.add("location data:");
            $this$command_u24lambda_u242.add("-  vec: " + vec);
            $this$command_u24lambda_u242.add("-  distance: " + distance);
            float rotationYaw = entity.field_70177_z;
            float rotationPitch = entity.field_70125_A;
            $this$command_u24lambda_u242.add("-  rotationYaw: " + rotationYaw);
            $this$command_u24lambda_u242.add("-  rotationPitch: " + rotationPitch);
            Entity firstPassenger = EntityCompatKt.getFirstPassenger(entity);
            $this$command_u24lambda_u242.add("firstPassenger: " + firstPassenger);
            Entity ridingEntity = entity.field_70154_o;
            $this$command_u24lambda_u242.add("ridingEntity: " + ridingEntity);
            if (entity.func_82150_aj()) {
                $this$command_u24lambda_u242.add("Invisible: true");
            }
            if (entity instanceof EntityLivingBase) {
                $this$command_u24lambda_u242.add("EntityLivingBase:");
                int baseMaxHealth = EntityUtils.INSTANCE.getBaseMaxHealth((EntityLivingBase)entity);
                int health = (int)((EntityLivingBase)entity).func_110143_aJ();
                $this$command_u24lambda_u242.add("-  baseMaxHealth: " + baseMaxHealth);
                $this$command_u24lambda_u242.add("-  health: " + health);
            }
            if (entity instanceof EntityPlayer && (armor2 = EntityUtils.INSTANCE.getArmorInventory((EntityLivingBase)entity)) != null) {
                $this$command_u24lambda_u242.add("armor:");
                for (IndexedValue<ItemStack> indexedValue : ArraysKt.withIndex(armor2)) {
                    int i2 = indexedValue.component1();
                    ItemStack itemStack = indexedValue.component2();
                    Object object = itemStack;
                    if (object == null || (object = object.func_82833_r()) == null) {
                        object = "null";
                    }
                    Object name2 = object;
                    $this$command_u24lambda_u242.add("-  at: " + i2 + ": " + (String)name2);
                }
            }
            if ((armor2 = entity) instanceof EntityArmorStand) {
                INSTANCE.addArmorStand($this$command_u24lambda_u242, (EntityArmorStand)entity);
            } else if (armor2 instanceof EntityEnderman) {
                INSTANCE.addEnderman($this$command_u24lambda_u242, (EntityEnderman)entity);
            } else if (armor2 instanceof EntityMagmaCube) {
                INSTANCE.addMagmaCube($this$command_u24lambda_u242, (EntityMagmaCube)entity);
            } else if (armor2 instanceof EntityItem) {
                INSTANCE.addItem($this$command_u24lambda_u242, (EntityItem)entity);
            } else if (armor2 instanceof EntityOtherPlayerMP) {
                INSTANCE.addOtherPlayer($this$command_u24lambda_u242, (EntityOtherPlayerMP)entity);
            } else if (armor2 instanceof EntityCreeper) {
                INSTANCE.addCreeper($this$command_u24lambda_u242, (EntityCreeper)entity);
            } else if (armor2 instanceof EntityWither) {
                INSTANCE.addWither($this$command_u24lambda_u242, (EntityWither)entity);
            }
            if (mob != null && mob.getMobType() != Mob.Type.PLAYER) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                IndexedValue<ItemStack> indexedValue;
                $this$command_u24lambda_u242.add("MobInfo: ");
                Object armor2 = INSTANCE.getMobInfo(mob);
                List<String> list2 = $this$command_u24lambda_u242;
                boolean $i$f$map = false;
                indexedValue = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add("-  " + (String)it);
                }
                list2.addAll((List)destination$iv$iv);
            }
            $this$command_u24lambda_u242.add("");
            $this$command_u24lambda_u242.add("");
            int n = counter;
            counter = n + 1;
        }
        List resultList = CollectionsKt.build(list);
        if (counter != 0) {
            String string = CollectionsKt.joinToString$default(resultList, "\n", null, null, 0, null, null, 62, null);
            OSUtils.INSTANCE.copyToClipboard(string);
            ChatUtils.chat$default(ChatUtils.INSTANCE, counter + " entities copied into the clipboard!", false, null, false, false, null, 62, null);
        } else {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "No entities found in a search radius of " + searchRadius + '!', false, null, false, false, null, 62, null);
        }
    }

    private final void addArmorStand(List<String> $this$addArmorStand, EntityArmorStand entity) {
        $this$addArmorStand.add("EntityArmorStand:");
        Rotations rotations = entity.func_175418_s();
        Intrinsics.checkNotNullExpressionValue(rotations, "getHeadRotation(...)");
        LorenzVec headRotation = LorenzVecKt.toLorenzVec(rotations);
        Rotations rotations2 = entity.func_175408_t();
        Intrinsics.checkNotNullExpressionValue(rotations2, "getBodyRotation(...)");
        LorenzVec bodyRotation = LorenzVecKt.toLorenzVec(rotations2);
        $this$addArmorStand.add("-  headRotation: " + headRotation);
        $this$addArmorStand.add("-  bodyRotation: " + bodyRotation);
        $this$addArmorStand.add("-  inventory:");
        ItemStack[] itemStackArray = EntityCompatKt.getInventoryItems(entity);
        int n = itemStackArray.length;
        for (int j = 0; j < n; ++j) {
            int id = j;
            ItemStack stack = itemStackArray[j];
            ItemStack adjustedStack = InventoryCompat.INSTANCE.orNull(stack);
            $this$addArmorStand.add("-  id " + id + " (" + adjustedStack + ')');
            this.printItemStackData($this$addArmorStand, adjustedStack);
        }
    }

    private final void addEnderman(List<String> $this$addEnderman, EntityEnderman entity) {
        $this$addEnderman.add("EntityEnderman:");
        IBlockState heldBlockState = EntityUtils.INSTANCE.getBlockInHand(entity);
        $this$addEnderman.add("-  heldBlockState: " + heldBlockState);
        if (heldBlockState != null) {
            Block block = heldBlockState.func_177230_c();
            $this$addEnderman.add("-  block: " + block);
        }
    }

    private final void addMagmaCube(List<String> $this$addMagmaCube, EntityMagmaCube entity) {
        $this$addMagmaCube.add("EntityMagmaCube:");
        float squishFactor = entity.field_70811_b;
        int slimeSize = entity.func_70809_q();
        $this$addMagmaCube.add("-  factor: " + squishFactor);
        $this$addMagmaCube.add("-  slimeSize: " + slimeSize);
    }

    private final void addItem(List<String> $this$addItem, EntityItem entity) {
        block0: {
            $this$addItem.add("EntityItem:");
            ItemStack stack = entity.func_92059_d();
            String stackName = stack.func_82833_r();
            String stackDisplayName = stack.func_82833_r();
            Intrinsics.checkNotNull(stack);
            String cleanName = ItemUtils.INSTANCE.cleanName(stack);
            boolean itemEnchanted = ItemUtils.INSTANCE.isEnchanted(stack);
            int itemDamage = stack.func_77952_i();
            int stackSize = stack.field_77994_a;
            int maxStackSize = stack.func_77976_d();
            String skullTexture = ItemUtils.INSTANCE.getSkullTexture(stack);
            $this$addItem.add("-  name: '" + stackName + '\'');
            $this$addItem.add("-  stackDisplayName: '" + stackDisplayName + '\'');
            $this$addItem.add("-  cleanName: '" + cleanName + '\'');
            $this$addItem.add("-  itemEnchanted: '" + itemEnchanted + '\'');
            $this$addItem.add("-  itemDamage: '" + itemDamage + '\'');
            $this$addItem.add("-  stackSize: '" + stackSize + '\'');
            $this$addItem.add("-  maxStackSize: '" + maxStackSize + '\'');
            String string = skullTexture;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            $this$addItem.add("-  skullTexture: '" + it + '\'');
        }
    }

    private final void addOtherPlayer(List<String> $this$addOtherPlayer, EntityOtherPlayerMP entity) {
        $this$addOtherPlayer.add("EntityOtherPlayerMP:");
        String skinTexture = EntityUtils.INSTANCE.getSkinTexture((EntityPlayer)entity);
        $this$addOtherPlayer.add("-  skin texture: " + skinTexture);
    }

    private final void addCreeper(List<String> $this$addCreeper, EntityCreeper entity) {
        $this$addCreeper.add("EntityCreeper:");
        int creeperState = entity.func_70832_p();
        boolean ignite = entity.func_146078_ca();
        boolean powered = entity.func_70830_n();
        $this$addCreeper.add("-  creeperState: '" + creeperState + '\'');
        $this$addCreeper.add("-  ignite: '" + ignite + '\'');
        $this$addCreeper.add("-  powered: '" + powered + '\'');
    }

    private final void addWither(List<String> $this$addWither, EntityWither entity) {
        $this$addWither.add("EntityWither:");
        int invulTime = entity.func_82212_n();
        boolean isArmored = entity.func_82205_o();
        $this$addWither.add("-  invulTime: '" + invulTime + '\'');
        $this$addWither.add("-  armored: '" + isArmored + '\'');
    }

    private final void printItemStackData(List<String> $this$printItemStackData, ItemStack stack) {
        if (stack != null) {
            String skullTexture = ItemUtils.INSTANCE.getSkullTexture(stack);
            if (skullTexture != null) {
                $this$printItemStackData.add("-     skullTexture:");
                $this$printItemStackData.add("-     " + skullTexture);
            }
            String cleanName = ItemUtils.INSTANCE.cleanName(stack);
            String stackName = stack.func_82833_r();
            String type2 = stack.getClass().getName();
            $this$printItemStackData.add("-     name: '" + stackName + '\'');
            $this$printItemStackData.add("-     cleanName: '" + cleanName + '\'');
            $this$printItemStackData.add("-     type: " + type2);
        }
    }

    private final String getType(Entity entity, Mob mob) {
        StringBuilder stringBuilder;
        StringBuilder $this$getType_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (entity instanceof EntityLivingBase && MobFilter.INSTANCE.isDisplayNpc((EntityLivingBase)entity)) {
            $this$getType_u24lambda_u244.append("DisplayNPC, ");
        }
        if (entity instanceof EntityPlayer && EntityUtils.INSTANCE.isNpc((EntityPlayer)entity)) {
            $this$getType_u24lambda_u244.append("NPC, ");
        }
        if (entity instanceof EntityPlayer && MobFilter.INSTANCE.isRealPlayer((EntityPlayer)entity)) {
            $this$getType_u24lambda_u244.append("RealPlayer, ");
        }
        Mob mob2 = mob;
        if ((mob2 != null ? mob2.getMobType() : null) == Mob.Type.SUMMON) {
            $this$getType_u24lambda_u244.append("Summon, ");
        }
        if (MobFilter.INSTANCE.isSkyBlockMob(entity)) {
            StringBuilder stringBuilder2;
            $this$getType_u24lambda_u244.append("SkyblockMob(");
            if (mob == null) {
                $this$getType_u24lambda_u244.append(LocationUtils.INSTANCE.distanceToPlayer(entity) > 22.0 ? "Not in Range" : "None");
                stringBuilder2 = $this$getType_u24lambda_u244.append(")");
            } else {
                $this$getType_u24lambda_u244.append(mob.getMobType().name());
                if (Intrinsics.areEqual(mob.getBaseEntity(), entity)) {
                    $this$getType_u24lambda_u244.append("/Base");
                }
                $this$getType_u24lambda_u244.append(")\"");
                $this$getType_u24lambda_u244.append(mob.getName());
                stringBuilder2 = $this$getType_u24lambda_u244.append("\"");
            }
            $this$getType_u24lambda_u244.append(", ");
        }
        StringBuilder stringBuilder3 = ((CharSequence)$this$getType_u24lambda_u244).length() > 0 ? $this$getType_u24lambda_u244.delete($this$getType_u24lambda_u244.length() - 2, $this$getType_u24lambda_u244.length()) : $this$getType_u24lambda_u244.append("NONE");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getMobInfo(@NotNull Mob mob) {
        void it;
        Object object;
        int $i$f$map;
        List<String> list;
        Object object2;
        List<String> list2;
        Intrinsics.checkNotNullParameter(mob, "mob");
        List<String> $this$getMobInfo_u24lambda_u247 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$getMobInfo_u24lambda_u247.add("Name: " + mob.getName());
        $this$getMobInfo_u24lambda_u247.add("Type: " + (Object)((Object)mob.getMobType()));
        $this$getMobInfo_u24lambda_u247.add("Base Entity: " + INSTANCE.asString(mob.getBaseEntity()));
        EntityArmorStand entityArmorStand = mob.getArmorStand();
        $this$getMobInfo_u24lambda_u247.add("ArmorStand: " + (entityArmorStand != null ? INSTANCE.asString((EntityLivingBase)entityArmorStand) : null));
        if (!((Collection)mob.getExtraEntities()).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$getMobInfo_u24lambda_u247.add("Extra Entities");
            object2 = mob.getExtraEntities();
            list = $this$getMobInfo_u24lambda_u247;
            $i$f$map = 0;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                EntityLivingBase entityLivingBase = (EntityLivingBase)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                object.add("  " + INSTANCE.asString((EntityLivingBase)it2));
            }
            list.addAll((List)destination$iv$iv);
        }
        if (mob.getHologram1Delegate().isInitialized()) {
            EntityArmorStand entityArmorStand2 = mob.getHologram1();
            $this$getMobInfo_u24lambda_u247.add("Hologram1: " + (entityArmorStand2 != null ? INSTANCE.asString((EntityLivingBase)entityArmorStand2) : null));
        }
        if (mob.getHologram2Delegate().isInitialized()) {
            EntityArmorStand entityArmorStand3 = mob.getHologram2();
            $this$getMobInfo_u24lambda_u247.add("Hologram2: " + (entityArmorStand3 != null ? INSTANCE.asString((EntityLivingBase)entityArmorStand3) : null));
        }
        if (mob.getOwner() != null) {
            $this$getMobInfo_u24lambda_u247.add("Owner: " + mob.getOwner().getOwnerName());
        }
        object2 = mob.getLevelOrTier();
        $i$f$map = ((Number)object2).intValue();
        object = new StringBuilder().append("Level or Tier: ");
        list = $this$getMobInfo_u24lambda_u247;
        boolean bl3 = false;
        boolean bl4 = it != -1;
        list.add(((StringBuilder)object).append(bl4 ? object2 : null).toString());
        if (mob.getMobType() == Mob.Type.DUNGEON) {
            $this$getMobInfo_u24lambda_u247.add("Is Starred: " + mob.getHasStar());
            StringBuilder stringBuilder = new StringBuilder().append("Attribute: ");
            Object object3 = mob.getAttribute();
            if (object3 == null) {
                object3 = "NONE";
            }
            $this$getMobInfo_u24lambda_u247.add(stringBuilder.append(object3).toString());
        }
        if (!Intrinsics.areEqual(mob.getBoundingBox(), mob.getBaseEntity().func_174813_aQ())) {
            $this$getMobInfo_u24lambda_u247.add("Bounding Box: " + mob.getBoundingBox());
        }
        return CollectionsKt.build(list2);
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        event.registerBrigadier("shcopyentities", CopyNearbyEntitiesCommand::onCommandRegistration$lambda$9);
    }

    private final String asString(EntityLivingBase $this$asString) {
        return $this$asString.func_145782_y() + " - " + $this$asString.getClass().getSimpleName() + " \"" + $this$asString.func_70005_c_() + '\"';
    }

    private static final Unit onCommandRegistration$lambda$9$lambda$8(String[] it) {
        Intrinsics.checkNotNullParameter(it, "it");
        INSTANCE.command(it);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$9(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter($this$registerBrigadier, "$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Copies the entities in the specified radius around the player into the clipboard");
        $this$registerBrigadier.setCategory(CommandCategory.DEVELOPER_DEBUG);
        $this$registerBrigadier.legacyCallbackArgs(CopyNearbyEntitiesCommand::onCommandRegistration$lambda$9$lambda$8);
        return Unit.INSTANCE;
    }
}

