/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config.features.gui.customscoreboard;

import at.hannibal2.skyhanni.config.features.gui.customscoreboard.BackgroundOutlineConfig;
import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.Accordion;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorBoolean;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorButton;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorColour;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorSlider;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.OSUtils;
import com.google.gson.annotations.Expose;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\"\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\"\u0010\u0013\u001a\u00020\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\"\u0010\u0019\u001a\u00020\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0014\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001a\u0010\u001d\u001a\u00020\u001c8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\"\u0010!\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\u0006\u001a\u0004\b\"\u0010\b\"\u0004\b#\u0010\nR\"\u0010$\u001a\u00020\u00128\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010\u0014\u001a\u0004\b%\u0010\u0016\"\u0004\b&\u0010\u0018R\u001a\u0010(\u001a\u00020'8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lat/hannibal2/skyhanni/config/features/gui/customscoreboard/BackgroundConfig;", "", "<init>", "()V", "", "enabled", "Z", "getEnabled", "()Z", "setEnabled", "(Z)V", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "color", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "getColor", "()Lio/github/notenoughupdates/moulconfig/ChromaColour;", "setColor", "(Lio/github/notenoughupdates/moulconfig/ChromaColour;)V", "", "borderSize", "I", "getBorderSize", "()I", "setBorderSize", "(I)V", "roundedCornerSmoothness", "getRoundedCornerSmoothness", "setRoundedCornerSmoothness", "Lat/hannibal2/skyhanni/config/features/gui/customscoreboard/BackgroundOutlineConfig;", "outline", "Lat/hannibal2/skyhanni/config/features/gui/customscoreboard/BackgroundOutlineConfig;", "getOutline", "()Lat/hannibal2/skyhanni/config/features/gui/customscoreboard/BackgroundOutlineConfig;", "useCustomBackgroundImage", "getUseCustomBackgroundImage", "setUseCustomBackgroundImage", "customBackgroundImageOpacity", "getCustomBackgroundImageOpacity", "setCustomBackgroundImageOpacity", "Ljava/lang/Runnable;", "runnable", "Ljava/lang/Runnable;", "getRunnable", "()Ljava/lang/Runnable;", "1.21.8"})
public final class BackgroundConfig {
    @Expose
    @ConfigOption(name="Enabled", desc="Show a background behind the scoreboard.")
    @ConfigEditorBoolean
    private boolean enabled = true;
    @Expose
    @ConfigOption(name="Background Color", desc="The color of the background.")
    @ConfigEditorColour
    @NotNull
    private ChromaColour color;
    @Expose
    @ConfigOption(name="Background Border Size", desc="The size of the border around the background.")
    @ConfigEditorSlider(minValue=0.0f, maxValue=20.0f, minStep=1.0f)
    private int borderSize;
    @Expose
    @ConfigOption(name="Rounded Corner Smoothness", desc="The smoothness of the rounded corners.")
    @ConfigEditorSlider(minValue=0.0f, maxValue=30.0f, minStep=1.0f)
    private int roundedCornerSmoothness;
    @Expose
    @ConfigOption(name="Background Outline", desc="")
    @Accordion
    @NotNull
    private final BackgroundOutlineConfig outline;
    @Expose
    @ConfigOption(name="Custom Background Image", desc="See below on how to add your own custom background.")
    @ConfigEditorBoolean
    private boolean useCustomBackgroundImage;
    @Expose
    @ConfigOption(name="Background Image Opacity", desc="The opacity of the custom background image.")
    @ConfigEditorSlider(minValue=0.0f, maxValue=100.0f, minStep=1.0f)
    private int customBackgroundImageOpacity;
    @ConfigOption(name="Pack Creator", desc="Click here to open the background creator. You can use this website to add your own image into as your Scoreboard Background.")
    @ConfigEditorButton(buttonText="Create")
    @NotNull
    private final Runnable runnable;

    public BackgroundConfig() {
        Color color = Color.BLACK;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"BLACK");
        this.color = ColorUtils.toChromaColor$default(color, 80, 0, 2, null);
        this.borderSize = 5;
        this.roundedCornerSmoothness = 10;
        this.outline = new BackgroundOutlineConfig();
        this.customBackgroundImageOpacity = 100;
        this.runnable = BackgroundConfig::runnable$lambda$0;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @NotNull
    public final ChromaColour getColor() {
        return this.color;
    }

    public final void setColor(@NotNull ChromaColour chromaColour) {
        Intrinsics.checkNotNullParameter((Object)chromaColour, (String)"<set-?>");
        this.color = chromaColour;
    }

    public final int getBorderSize() {
        return this.borderSize;
    }

    public final void setBorderSize(int n) {
        this.borderSize = n;
    }

    public final int getRoundedCornerSmoothness() {
        return this.roundedCornerSmoothness;
    }

    public final void setRoundedCornerSmoothness(int n) {
        this.roundedCornerSmoothness = n;
    }

    @NotNull
    public final BackgroundOutlineConfig getOutline() {
        return this.outline;
    }

    public final boolean getUseCustomBackgroundImage() {
        return this.useCustomBackgroundImage;
    }

    public final void setUseCustomBackgroundImage(boolean bl) {
        this.useCustomBackgroundImage = bl;
    }

    public final int getCustomBackgroundImageOpacity() {
        return this.customBackgroundImageOpacity;
    }

    public final void setCustomBackgroundImageOpacity(int n) {
        this.customBackgroundImageOpacity = n;
    }

    @NotNull
    public final Runnable getRunnable() {
        return this.runnable;
    }

    private static final void runnable$lambda$0() {
        OSUtils.openBrowser("https://j10a1n15.github.io/j10a1n15/pages/background.html");
    }
}

