/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.processor;

import at.hannibal2.skyhanni.deps.moulconfig.Config;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.Accordion;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.Category;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigAccordionId;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorAccordion;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorButton;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigEditorInfoText;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigOption;
import at.hannibal2.skyhanni.deps.moulconfig.internal.BoundField;
import at.hannibal2.skyhanni.deps.moulconfig.internal.Warnings;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ConfigStructureReader;
import com.google.gson.annotations.Expose;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;

public class ConfigProcessorDriver {
    private final List<Class<? extends Annotation>> nonStoredConfigOptions = Arrays.asList(ConfigEditorAccordion.class, ConfigEditorInfoText.class, ConfigEditorButton.class);
    public final ConfigStructureReader reader;
    public boolean warnForPrivateFields = true;
    public int nextAnnotation = 1000000000;
    public boolean checkExpose = true;

    public ConfigProcessorDriver(ConfigStructureReader reader) {
        this.reader = reader;
    }

    private static List<Field> getAllFields(Class<?> type2) {
        if (type2 == null) {
            return new ArrayList<Field>();
        }
        List<Field> fields2 = ConfigProcessorDriver.getAllFields(type2.getSuperclass());
        fields2.addAll(Arrays.asList(type2.getDeclaredFields()));
        return fields2;
    }

    public void processCategory(Object categoryObject, List<BoundField> deferredSubCategories) {
        Class<?> categoryClass = categoryObject.getClass();
        Stack<Integer> accordionStack = new Stack<Integer>();
        HashSet<Integer> usedAccordionIds = new HashSet<Integer>();
        for (Field field : ConfigProcessorDriver.getAllFields(categoryClass)) {
            Accordion accordionClassAnnotation;
            ConfigAccordionId parentAccordion;
            ConfigOption optionAnnotation;
            if (field.getAnnotation(Category.class) != null) {
                deferredSubCategories.add(new BoundField(field, categoryObject));
            }
            if ((optionAnnotation = field.getAnnotation(ConfigOption.class)) == null) continue;
            if (this.checkExpose && field.getAnnotation(Expose.class) == null && (field.getModifiers() & 0x80) == 0) {
                if (this.nonStoredConfigOptions.stream().noneMatch(field::isAnnotationPresent)) {
                    Warnings.warn("Non transient @ConfigOption without @Expose in " + categoryClass + " on field " + field);
                }
            }
            if ((field.getModifiers() & 1) != 1) {
                field.setAccessible(true);
                if (this.warnForPrivateFields) {
                    Warnings.warn("@ConfigOption on non public field " + field + " in " + categoryClass);
                }
            }
            if ((parentAccordion = field.getAnnotation(ConfigAccordionId.class)) == null) {
                while (!accordionStack.isEmpty()) {
                    this.reader.endAccordion();
                    accordionStack.pop();
                }
            } else {
                while (!accordionStack.isEmpty() && ((Integer)accordionStack.peek()).intValue() != parentAccordion.id()) {
                    accordionStack.pop();
                    this.reader.endAccordion();
                }
                if (accordionStack.isEmpty()) {
                    Warnings.warn("Invalid @ConfigAccordionId in " + categoryClass + " on field " + field);
                }
            }
            if ((accordionClassAnnotation = field.getAnnotation(Accordion.class)) != null) {
                if (!usedAccordionIds.isEmpty()) {
                    Warnings.warn("Cannot mix @ConfigEditorAccordion and @ConfigAccordionId with @Accordion in class " + categoryClass);
                }
                this.reader.beginAccordion(categoryObject, field, optionAnnotation, ++this.nextAnnotation);
                try {
                    this.reader.pushPath(field.getName());
                    ArrayList<BoundField> subCategory = new ArrayList<BoundField>();
                    this.processCategory(field.get(categoryObject), subCategory);
                    if (!subCategory.isEmpty()) {
                        Warnings.warn("Cannot define sub categories inside of an accordion: " + subCategory.get(0));
                    }
                    this.reader.popPath();
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                this.reader.endAccordion();
                continue;
            }
            ConfigEditorAccordion selfAccordion = field.getAnnotation(ConfigEditorAccordion.class);
            if (selfAccordion != null) {
                if (usedAccordionIds.contains(selfAccordion.id())) {
                    Warnings.warn("Reusing of config accordion id " + selfAccordion.id() + " in " + categoryClass + " on field " + field);
                }
                usedAccordionIds.add(selfAccordion.id());
                accordionStack.push(selfAccordion.id());
                this.reader.beginAccordion(categoryObject, field, optionAnnotation, selfAccordion.id());
                continue;
            }
            this.reader.emitOption(categoryObject, field, optionAnnotation);
        }
        while (!accordionStack.isEmpty()) {
            this.reader.endAccordion();
            accordionStack.pop();
        }
    }

    private void processCategoryMeta(Object parent, Field categoryField, Field parentField) {
        Category categoryAnnotation = categoryField.getAnnotation(Category.class);
        if (categoryAnnotation == null) {
            return;
        }
        if (this.checkExpose && categoryField.getAnnotation(Expose.class) == null) {
            Warnings.warn("@Category without @Expose in " + parent.getClass() + " on field " + categoryField);
        }
        if ((categoryField.getModifiers() & 1) != 1) {
            categoryField.setAccessible(true);
            if (this.warnForPrivateFields) {
                Warnings.warn("@Category on non public field " + categoryField + " in " + parent.getClass());
            }
        }
        ArrayList<BoundField> deferredSubCategories = new ArrayList<BoundField>();
        this.reader.beginCategory(parent, categoryField, categoryAnnotation.name(), categoryAnnotation.desc());
        if (parentField != null) {
            this.reader.setCategoryParent(parentField);
        }
        try {
            this.reader.pushPath(categoryField.getName());
            this.processCategory(categoryField.get(parent), deferredSubCategories);
            this.reader.popPath();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        this.reader.endCategory();
        for (BoundField subCategory : deferredSubCategories) {
            if (parentField == null) {
                this.processCategoryMeta(subCategory.getBoundTo(), subCategory.getField(), categoryField);
                continue;
            }
            Warnings.warn("Found double recursive sub category at " + subCategory);
        }
    }

    public void processConfig(Config configObject) {
        this.reader.beginConfig(configObject.getClass(), this, configObject);
        for (Field categoryField : ConfigProcessorDriver.getAllFields(configObject.getClass())) {
            this.processCategoryMeta(configObject, categoryField, null);
        }
        this.reader.endConfig();
    }
}

