/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.combat.ghosttracker;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.commands.CommandBuilder;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.features.combat.ghostcounter.GhostProfitTrackerConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.ItemAddManager;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.SackApi;
import at.hannibal2.skyhanni.data.jsonobjects.repo.GhostDropsJson;
import at.hannibal2.skyhanni.data.model.TabWidget;
import at.hannibal2.skyhanni.data.repo.AbstractRepoManager;
import at.hannibal2.skyhanni.data.repo.AbstractRepoReloadEvent;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.IslandChangeEvent;
import at.hannibal2.skyhanni.events.ItemAddEvent;
import at.hannibal2.skyhanni.events.PurseChangeCause;
import at.hannibal2.skyhanni.events.PurseChangeEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.SackChangeEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.SkillExpGainEvent;
import at.hannibal2.skyhanni.events.WidgetUpdateEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.item.ShardGainEvent;
import at.hannibal2.skyhanni.events.skyblock.GraphAreaChangeEvent;
import at.hannibal2.skyhanni.features.combat.ghosttracker.GhostTracker;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.collection.RenderableCollectionUtils;
import at.hannibal2.skyhanni.utils.renderables.Searchable;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import at.hannibal2.skyhanni.utils.tracker.ItemTrackerData;
import at.hannibal2.skyhanni.utils.tracker.SkyHanniItemTracker;
import at.hannibal2.skyhanni.utils.tracker.SkyHanniTracker;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002xyB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0003J\u0017\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0016H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u001cH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001d\u0010!\u001a\u00020\f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u0006H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020#H\u0007\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010'\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020&H\u0007\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010*\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020)H\u0007\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010-\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020,H\u0007\u00a2\u0006\u0004\b-\u0010.J\u001f\u00103\u001a\u0002022\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020/H\u0002\u00a2\u0006\u0004\b3\u00104J\u000f\u00106\u001a\u000205H\u0002\u00a2\u0006\u0004\b6\u00107J\u000f\u00108\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b8\u0010\u0003J\u0017\u0010:\u001a\u00020\f2\u0006\u0010\u000b\u001a\u000209H\u0007\u00a2\u0006\u0004\b:\u0010;J\u0017\u0010=\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020<H\u0007\u00a2\u0006\u0004\b=\u0010>R\u0014\u0010B\u001a\u00020?8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0016\u0010F\u001a\u0004\u0018\u00010C8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER$\u0010L\u001a\u00020/2\u0006\u0010G\u001a\u00020/8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u0014\u0010M\u001a\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u00107R\u001c\u0010P\u001a\b\u0012\u0004\u0012\u00020O0N8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010QR\u001c\u0010R\u001a\b\u0012\u0004\u0012\u00020O0N8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bR\u0010QR\u0014\u0010T\u001a\u00020S8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bT\u0010UR\u0016\u0010W\u001a\u00020V8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bW\u0010XR\u0016\u0010Y\u001a\u00020V8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bY\u0010XR\u0016\u0010Z\u001a\u0002058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bZ\u0010[R\u0016\u0010\\\u001a\u0002058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\\\u0010[R\u0014\u0010]\u001a\u00020O8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b]\u0010^R\u001a\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00040_8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b`\u0010aR\u0014\u0010c\u001a\u00020b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bc\u0010dR\u001b\u0010j\u001a\u00020e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bf\u0010g\u001a\u0004\bh\u0010iR\u001b\u0010m\u001a\u00020e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bk\u0010g\u001a\u0004\bl\u0010iR\u001b\u0010p\u001a\u00020e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bn\u0010g\u001a\u0004\bo\u0010iR\u001b\u0010s\u001a\u00020e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bq\u0010g\u001a\u0004\br\u0010iR\u001b\u0010v\u001a\u00020e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bt\u0010g\u001a\u0004\bu\u0010iR\u0014\u0010w\u001a\u00020O8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bw\u0010^\u00a8\u0006z"}, d2={"Lat/hannibal2/skyhanni/features/combat/ghosttracker/GhostTracker;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/features/combat/ghosttracker/GhostTracker$Data;", "data", "", "Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "drawDisplay", "(Lat/hannibal2/skyhanni/features/combat/ghosttracker/GhostTracker$Data;)Ljava/util/List;", "Lat/hannibal2/skyhanni/events/SkillExpGainEvent;", "event", "", "onSkillExp", "(Lat/hannibal2/skyhanni/events/SkillExpGainEvent;)V", "onSecondPassed", "Lat/hannibal2/skyhanni/events/SackChangeEvent;", "onSackChange", "(Lat/hannibal2/skyhanni/events/SackChangeEvent;)V", "Lat/hannibal2/skyhanni/events/item/ShardGainEvent;", "onShard", "(Lat/hannibal2/skyhanni/events/item/ShardGainEvent;)V", "Lat/hannibal2/skyhanni/events/ItemAddEvent;", "onItemAdd", "(Lat/hannibal2/skyhanni/events/ItemAddEvent;)V", "Lat/hannibal2/skyhanni/events/PurseChangeEvent;", "onPurseChange", "(Lat/hannibal2/skyhanni/events/PurseChangeEvent;)V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "", "lines", "parseBestiaryWidget", "(Ljava/util/List;)V", "Lat/hannibal2/skyhanni/events/WidgetUpdateEvent;", "onWidgetUpdate", "(Lat/hannibal2/skyhanni/events/WidgetUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "Lat/hannibal2/skyhanni/events/skyblock/GraphAreaChangeEvent;", "onAreaChange", "(Lat/hannibal2/skyhanni/events/skyblock/GraphAreaChangeEvent;)V", "Lat/hannibal2/skyhanni/events/IslandChangeEvent;", "onIslandChange", "(Lat/hannibal2/skyhanni/events/IslandChangeEvent;)V", "", "mf", "kills", "", "getAverageMagicFind", "(JJ)D", "", "isEnabled", "()Z", "onConfigLoad", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/combat/ghostcounter/GhostProfitTrackerConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/combat/ghostcounter/GhostProfitTrackerConfig;", "config", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$GhostStorage;", "getStorage", "()Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$GhostStorage;", "storage", "value", "getCurrentBestiaryKills", "()J", "setCurrentBestiaryKills", "(J)V", "currentBestiaryKills", "isMaxBestiary", "", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "allowedDrops", "Ljava/util/Set;", "allowedSackDrops", "", "MAX_BESTIARY_KILLS", "I", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastNoWidgetWarningTime", "J", "lastNoGhostBestiaryWidgetWarningTime", "inArea", "Z", "foundGhostBestiary", "ghostShard", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniItemTracker;", "tracker", "Lat/hannibal2/skyhanni/utils/tracker/SkyHanniItemTracker;", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "itemDropPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getItemDropPattern", "()Ljava/util/regex/Pattern;", "itemDropPattern", "killComboEndPattern$delegate", "getKillComboEndPattern", "killComboEndPattern", "bagOfCashPattern$delegate", "getBagOfCashPattern", "bagOfCashPattern", "bestiaryTablistPattern$delegate", "getBestiaryTablistPattern", "bestiaryTablistPattern", "maxBestiaryTablistPattern$delegate", "getMaxBestiaryTablistPattern", "maxBestiaryTablistPattern", "SORROW", "Data", "GhostTrackerLines", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nGhostTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GhostTracker.kt\nat/hannibal2/skyhanni/features/combat/ghosttracker/GhostTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 AbstractRepoReloadEvent.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoReloadEvent\n+ 6 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n+ 7 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n*L\n1#1,410:1\n1863#2,2:411\n774#2:413\n865#2,2:414\n1863#2,2:443\n8#3:416\n8#3:418\n1#4:417\n1#4:419\n1#4:445\n13#5,7:420\n21#5,6:437\n167#6,5:427\n172#6,4:433\n24#7:432\n*S KotlinDebug\n*F\n+ 1 GhostTracker.kt\nat/hannibal2/skyhanni/features/combat/ghosttracker/GhostTracker\n*L\n161#1:411,2\n203#1:413\n203#1:414,2\n208#1:443,2\n238#1:416\n254#1:418\n238#1:417\n254#1:419\n308#1:420,7\n308#1:437,6\n308#1:427,5\n308#1:433,4\n308#1:432\n*E\n"})
public final class GhostTracker {
    @NotNull
    public static final GhostTracker INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static Set<NeuInternalName> allowedDrops;
    @NotNull
    private static Set<NeuInternalName> allowedSackDrops;
    private static final int MAX_BESTIARY_KILLS = 100000;
    private static long lastNoWidgetWarningTime;
    private static long lastNoGhostBestiaryWidgetWarningTime;
    private static boolean inArea;
    private static boolean foundGhostBestiary;
    @NotNull
    private static final NeuInternalName ghostShard;
    @NotNull
    private static final SkyHanniItemTracker<Data> tracker;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern itemDropPattern$delegate;
    @NotNull
    private static final RepoPattern killComboEndPattern$delegate;
    @NotNull
    private static final RepoPattern bagOfCashPattern$delegate;
    @NotNull
    private static final RepoPattern bestiaryTablistPattern$delegate;
    @NotNull
    private static final RepoPattern maxBestiaryTablistPattern$delegate;
    @NotNull
    private static final NeuInternalName SORROW;

    private GhostTracker() {
    }

    private final GhostProfitTrackerConfig getConfig() {
        return SkyHanniMod.feature.getCombat().getGhostCounter();
    }

    private final ProfileSpecificStorage.GhostStorage getStorage() {
        ProfileSpecificStorage profileSpecificStorage = ProfileStorageData.INSTANCE.getProfileSpecific();
        return profileSpecificStorage != null ? profileSpecificStorage.getGhostStorage() : null;
    }

    private final long getCurrentBestiaryKills() {
        ProfileSpecificStorage.GhostStorage ghostStorage = this.getStorage();
        return ghostStorage != null ? ghostStorage.getBestiaryKills() : 0L;
    }

    private final void setCurrentBestiaryKills(long value) {
        block0: {
            ProfileSpecificStorage.GhostStorage ghostStorage = this.getStorage();
            if (ghostStorage == null) break block0;
            ghostStorage.setBestiaryKills(value);
        }
    }

    private final boolean isMaxBestiary() {
        return this.getCurrentBestiaryKills() >= 100000L;
    }

    private final Pattern getItemDropPattern() {
        return (Pattern)itemDropPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getKillComboEndPattern() {
        return (Pattern)killComboEndPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getBagOfCashPattern() {
        return (Pattern)bagOfCashPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    private final Pattern getBestiaryTablistPattern() {
        return (Pattern)bestiaryTablistPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[3]);
    }

    private final Pattern getMaxBestiaryTablistPattern() {
        return (Pattern)maxBestiaryTablistPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[4]);
    }

    private final List<Searchable> drawDisplay(Data data2) {
        List<Searchable> list;
        List<Searchable> $this$drawDisplay_u24lambda_u245 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        RenderableCollectionUtils.addSearchString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u245, "\u00a7e\u00a7lGhost Profit Tracker", null, null, null, 14, null);
        double profit = SkyHanniItemTracker.drawItems$default(tracker, data2, GhostTracker::drawDisplay$lambda$5$lambda$3, $this$drawDisplay_u24lambda_u245, null, null, null, null, null, 248, null);
        Iterable $this$forEach$iv = INSTANCE.getConfig().getGhostTrackerText();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GhostTrackerLines line = (GhostTrackerLines)((Object)element$iv);
            boolean bl2 = false;
            RenderableCollectionUtils.addSearchString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u245, line.getLine().invoke(data2), null, null, null, 14, null);
        }
        $this$drawDisplay_u24lambda_u245.add(tracker.addTotalProfit(profit, data2.getKills(), "kill"));
        return CollectionsKt.build(list);
    }

    @HandleEvent
    public final void onSkillExp(@NotNull SkillExpGainEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!inArea) {
            return;
        }
        if (event.getGained() > 10000.0) {
            return;
        }
        tracker.modify(arg_0 -> GhostTracker.onSkillExp$lambda$6(event, arg_0));
    }

    @HandleEvent(eventType=SecondPassedEvent.class)
    public final void onSecondPassed() {
        if (!this.isEnabled()) {
            return;
        }
        if (!TabWidget.BESTIARY.isActive()) {
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastNoWidgetWarningTime), DurationKt.toDuration(1, DurationUnit.MINUTES)) > 0) {
                lastNoWidgetWarningTime = SimpleTimeMark.Companion.now-uFjCsEo();
                ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, "\u00a7cYou do not have the Bestiary Tab Widget enabled! Ghost Tracker needs this information to work properly.", new Function0<Unit>((Object)HypixelCommands.INSTANCE){

                    public final void invoke() {
                        ((HypixelCommands)this.receiver).widget();
                    }
                }, "\u00a7eClick to run /widget!", 0L, false, null, false, true, 120, null);
            }
        }
        if (TabWidget.BESTIARY.isActive() && !foundGhostBestiary) {
            if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastNoGhostBestiaryWidgetWarningTime), DurationKt.toDuration(1, DurationUnit.MINUTES)) > 0) {
                lastNoGhostBestiaryWidgetWarningTime = SimpleTimeMark.Companion.now-uFjCsEo();
                ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, "\u00a7cGhost Bestiary not found in Bestiary Tab Widget! Ghost Tracker needs this information to work properly.", new Function0<Unit>((Object)HypixelCommands.INSTANCE){

                    public final void invoke() {
                        ((HypixelCommands)this.receiver).widget();
                    }
                }, "\u00a7eClick to run /widget!", 0L, false, null, false, true, 120, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onSackChange(@NotNull SackChangeEvent event) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(event, "event");
        if (!inArea || !ProfileStorageData.INSTANCE.getLoaded()) {
            return;
        }
        Iterable $this$filter$iv = event.getSackChanges();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SackApi.SackChange it = (SackApi.SackChange)element$iv$iv;
            boolean bl = false;
            if (!(allowedSackDrops.contains(it.getInternalName()) && it.getDelta() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allowedChanges = (List)destination$iv$iv;
        tracker.modify(arg_0 -> GhostTracker.onSackChange$lambda$9(allowedChanges, arg_0));
    }

    @HandleEvent
    public final void onShard(@NotNull ShardGainEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!Intrinsics.areEqual(event.getShardInternalName(), ghostShard)) {
            return;
        }
        SkyHanniItemTracker.addItem$default(tracker, ghostShard, event.getAmount(), false, false, 8, null);
    }

    @HandleEvent
    public final void onItemAdd(@NotNull ItemAddEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!inArea || event.getSource() != ItemAddManager.Source.COMMAND) {
            return;
        }
        SkyHanniItemTracker.addItem$default(tracker, event.getInternalName(), event.getAmount(), true, false, 8, null);
    }

    @HandleEvent
    public final void onPurseChange(@NotNull PurseChangeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!inArea) {
            return;
        }
        if (event.getReason() != PurseChangeCause.GAIN_MOB_KILL) {
            return;
        }
        double d = event.getCoins();
        if (!(200.0 <= d ? d <= 15000.0 : false)) {
            return;
        }
        tracker.addCoins((int)event.getCoins(), false);
    }

    @HandleEvent
    public final void onChat(@NotNull SkyHanniChatEvent event) {
        Pattern $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter(event, "event");
        if (!inArea) {
            return;
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getItemDropPattern();
        String text$iv = event.getMessage();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u2411 = it$iv;
            boolean bl2 = false;
            String string = $this$onChat_u24lambda_u2411.group("item");
            Intrinsics.checkNotNullExpressionValue(string, "group(...)");
            NeuInternalName neuInternalName = NeuInternalName.Companion.fromItemNameOrNull(string);
            if (neuInternalName == null) {
                return;
            }
            NeuInternalName internalName2 = neuInternalName;
            String string2 = $this$onChat_u24lambda_u2411.group("mf");
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            int mf = NumberUtil.INSTANCE.formatInt(string2);
            if (!allowedDrops.contains(internalName2)) {
                return;
            }
            SkyHanniItemTracker.addItem$default(tracker, internalName2, 1, false, false, 8, null);
            tracker.modify(arg_0 -> GhostTracker.onChat$lambda$11$lambda$10(mf, internalName2, arg_0));
            return;
        }
        RegexUtils this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getKillComboEndPattern();
        text$iv = event.getMessage();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(text$iv);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull(it$iv);
            Matcher $this$onChat_u24lambda_u2413 = it$iv;
            boolean bl3 = false;
            String string = $this$onChat_u24lambda_u2413.group("kill");
            Intrinsics.checkNotNullExpressionValue(string, "group(...)");
            long kill = NumberUtil.INSTANCE.formatLong(string);
            tracker.modify(arg_0 -> GhostTracker.onChat$lambda$13$lambda$12(kill, arg_0));
            return;
        }
        if (RegexUtils.INSTANCE.matches(this.getBagOfCashPattern(), event.getMessage())) {
            tracker.addCoins(1000000, false);
            return;
        }
    }

    private final void parseBestiaryWidget(List<String> lines) {
        foundGhostBestiary = false;
        for (String line : lines) {
            if (RegexUtils.INSTANCE.matches(this.getMaxBestiaryTablistPattern(), line)) {
                this.setCurrentBestiaryKills(100000L);
                foundGhostBestiary = true;
                return;
            }
            String string = RegexUtils.INSTANCE.matchGroup(this.getBestiaryTablistPattern(), line, "kills");
            if (string == null) {
                continue;
            }
            long kills = NumberUtil.INSTANCE.formatLong(string);
            foundGhostBestiary = true;
            if (kills <= this.getCurrentBestiaryKills()) {
                return;
            }
            long difference = kills - this.getCurrentBestiaryKills();
            if (difference > 50L) {
                this.setCurrentBestiaryKills(kills);
                return;
            }
            this.setCurrentBestiaryKills(kills);
            tracker.modify(arg_0 -> GhostTracker.parseBestiaryWidget$lambda$14(difference, arg_0));
        }
    }

    @HandleEvent
    public final void onWidgetUpdate(@NotNull WidgetUpdateEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.isWidget(TabWidget.BESTIARY)) {
            return;
        }
        if (this.isMaxBestiary() || !inArea) {
            return;
        }
        this.parseBestiaryWidget(event.getLines());
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event) {
        Object object;
        Intrinsics.checkNotNullParameter(event, "event");
        String constant$iv = "GhostDrops";
        Object type$iv = null;
        Gson gson$iv = ((AbstractRepoReloadEvent)event).getGson();
        boolean $i$f$getConstant = false;
        Object object2 = event;
        try {
            Object $this$getRepoData_u24lambda_u2414$iv$iv;
            void this_$iv$iv;
            AbstractRepoReloadEvent $this$getConstant_u24lambda_u242$iv = object2;
            boolean bl = false;
            AbstractRepoManager<?> abstractRepoManager = $this$getConstant_u24lambda_u242$iv.getManager();
            String directory$iv$iv = "constants";
            boolean $i$f$getRepoData = false;
            Object object3 = this_$iv$iv;
            try {
                $this$getRepoData_u24lambda_u2414$iv$iv = object3;
                boolean bl2 = false;
                String path$iv$iv = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).resolvePath(directory$iv$iv, constant$iv);
                JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).readJsonElement(path$iv$iv);
                if (jsonElement == null) {
                    ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).getLogger().throwError("Repo file '" + constant$iv + "' not found.");
                    throw new KotlinNothingValueException();
                }
                JsonElement json$iv$iv = jsonElement;
                Gson $this$fromJson$iv$iv$iv = gson$iv;
                boolean $i$f$fromJson = false;
                Object object4 = $this$fromJson$iv$iv$iv.fromJson(json$iv$iv, ReflectJvmMapping.getJavaType(Reflection.typeOf(GhostDropsJson.class)));
                Intrinsics.checkNotNullExpressionValue(object4, "fromJson(...)");
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl(object4);
            }
            catch (Throwable bl2) {
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl(ResultKt.createFailure(bl2));
            }
            object3 = $this$getRepoData_u24lambda_u2414$iv$iv;
            Throwable throwable = Result.exceptionOrNull-impl(object3);
            if (throwable != null) {
                Throwable e$iv$iv = throwable;
                boolean bl3 = false;
                this_$iv$iv.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv$iv);
                throw new KotlinNothingValueException();
            }
            Object constantData$iv = object3;
            $this$getConstant_u24lambda_u242$iv.getManager().addSuccessfulConstant(constant$iv);
            object = constantData$iv;
        }
        catch (Throwable bl) {
            object2 = Result.constructor-impl(ResultKt.createFailure(bl));
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable != null) {
                Throwable it$iv = throwable;
                boolean bl4 = false;
                ((AbstractRepoReloadEvent)event).getManager().addUnsuccessfulConstant(constant$iv);
                ((AbstractRepoReloadEvent)event).getManager().getLogger().throwErrorWithCause("Could not load constant '" + constant$iv + '\'', it$iv);
                throw new KotlinNothingValueException();
            }
            throw new KotlinNothingValueException();
        }
        GhostDropsJson ghostDropsConstant = (GhostDropsJson)object;
        allowedDrops = ghostDropsConstant.getGhostDrops();
        allowedSackDrops = ghostDropsConstant.getSacksDrops();
    }

    @HandleEvent
    public final void onAreaChange(@NotNull GraphAreaChangeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        boolean bl = inArea = Intrinsics.areEqual(event.getArea(), "The Mist") && IslandType.DWARVEN_MINES.isCurrent();
        if (inArea) {
            this.parseBestiaryWidget(TabWidget.BESTIARY.getLines());
        }
    }

    @HandleEvent
    public final void onIslandChange(@NotNull IslandChangeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getNewIsland() == IslandType.DWARVEN_MINES) {
            tracker.firstUpdate();
        }
    }

    private final double getAverageMagicFind(long mf, long kills) {
        return mf == 0L || kills == 0L ? 0.0 : (double)mf / (double)kills;
    }

    private final boolean isEnabled() {
        return inArea && this.getConfig().getEnabled();
    }

    @HandleEvent(eventType=ConfigLoadEvent.class)
    public final void onConfigLoad() {
        ProfileSpecificStorage.GhostStorage ghostStorage = this.getStorage();
        if (ghostStorage == null) {
            return;
        }
        ProfileSpecificStorage.GhostStorage storage2 = ghostStorage;
        if (storage2.getMigratedTotalKills()) {
            return;
        }
        tracker.modify(GhostTracker::onConfigLoad$lambda$18);
        storage2.setMigratedTotalKills(true);
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        event.register("shresetghosttracker", GhostTracker::onCommandRegistration$lambda$20);
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        String oldPrefix = "#profile.ghostCounter";
        String newPrefix = "#profile.ghostStorage.ghostTracker";
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 67, oldPrefix + ".data.KILLS", newPrefix + ".kills", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 67, oldPrefix + ".data.GHOSTSINCESORROW", newPrefix + ".ghostsSinceSorrow", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 67, oldPrefix + ".data.MAXKILLCOMBO", newPrefix + ".maxKillCombo", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 67, oldPrefix + ".data.SKILLXPGAINED", newPrefix + ".combatXpGained", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 67, oldPrefix + ".totalMF", newPrefix + ".totalMagicFind", null, 8, null);
        event.move(67, oldPrefix + ".data.SORROWCOUNT", newPrefix + ".items.SORROW", onConfigFix.1.INSTANCE);
        event.move(67, oldPrefix + ".data.PLASMACOUNT", newPrefix + ".items.PLASMA", onConfigFix.2.INSTANCE);
        event.move(67, oldPrefix + ".data.VOLTACOUNT", newPrefix + ".items.VOLTA", onConfigFix.3.INSTANCE);
        event.move(67, oldPrefix + ".data.GHOSTLYBOOTS", newPrefix + ".items.GHOST_BOOTS", onConfigFix.4.INSTANCE);
    }

    private static final Data tracker$lambda$0() {
        return new Data(0L, 0L, 0L, 0L, 0L, 0L, 63, null);
    }

    private static final Data tracker$lambda$1(ProfileSpecificStorage it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getGhostStorage().getGhostTracker();
    }

    private static final List tracker$lambda$2(Data it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return INSTANCE.drawDisplay(it);
    }

    private static final boolean drawDisplay$lambda$5$lambda$3(NeuInternalName it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return true;
    }

    private static final Unit onSkillExp$lambda$6(SkillExpGainEvent $event, Data it) {
        Intrinsics.checkNotNullParameter($event, "$event");
        Intrinsics.checkNotNullParameter(it, "it");
        it.setCombatXpGained(it.getCombatXpGained() + (long)$event.getGained());
        return Unit.INSTANCE;
    }

    private static final Unit onSackChange$lambda$9(List $allowedChanges, Data storage2) {
        Intrinsics.checkNotNullParameter($allowedChanges, "$allowedChanges");
        Intrinsics.checkNotNullParameter(storage2, "storage");
        Iterable $this$forEach$iv = $allowedChanges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SackApi.SackChange sackChange = (SackApi.SackChange)element$iv;
            boolean bl = false;
            storage2.addItem(sackChange.getInternalName(), sackChange.getDelta(), false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onChat$lambda$11$lambda$10(int $mf, NeuInternalName $internalName, Data it) {
        Intrinsics.checkNotNullParameter($internalName, "$internalName");
        Intrinsics.checkNotNullParameter(it, "it");
        it.setTotalMagicFind(it.getTotalMagicFind() + (long)$mf);
        long l = it.getTotalMagicFindKills();
        it.setTotalMagicFindKills(l + 1L);
        if (Intrinsics.areEqual($internalName, SORROW)) {
            it.setGhostsSinceSorrow(0L);
        }
        return Unit.INSTANCE;
    }

    private static final Unit onChat$lambda$13$lambda$12(long $kill, Data it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.setMaxKillCombo(RangesKt.coerceAtLeast($kill, it.getMaxKillCombo()));
        return Unit.INSTANCE;
    }

    private static final Unit parseBestiaryWidget$lambda$14(long $difference, Data it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.setKills(it.getKills() + $difference);
        it.setGhostsSinceSorrow(it.getGhostsSinceSorrow() + $difference);
        return Unit.INSTANCE;
    }

    private static final Position _init_$lambda$15() {
        return INSTANCE.getConfig().getPosition();
    }

    private static final boolean _init_$lambda$16() {
        return INSTANCE.isEnabled();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onConfigLoad$lambda$18(Data it) {
        long l;
        Intrinsics.checkNotNullParameter(it, "it");
        Iterable iterable = it.getItems().values();
        Data data2 = it;
        long l2 = 0L;
        for (Object t : iterable) {
            void item2;
            ItemTrackerData.TrackedItem trackedItem = (ItemTrackerData.TrackedItem)t;
            l = l2;
            boolean bl = false;
            long l3 = item2.getTimesGained();
            l2 = l + l3;
        }
        l = l2;
        data2.setTotalMagicFindKills(l);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$20$lambda$19(String[] it) {
        Intrinsics.checkNotNullParameter(it, "it");
        tracker.resetCommand();
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$20(CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter($this$register, "$this$register");
        $this$register.setDescription("Resets the Ghost Profit Tracker");
        $this$register.setCategory(CommandCategory.USERS_RESET);
        $this$register.callback(GhostTracker::onCommandRegistration$lambda$20$lambda$19);
        return Unit.INSTANCE;
    }

    private static final JsonElement onConfigFix$migrateItem(JsonElement oldData) {
        JsonObject jsonObject;
        int oldAmount = oldData.getAsInt();
        JsonObject $this$onConfigFix_u24migrateItem_u24lambda_u2421 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$onConfigFix_u24migrateItem_u24lambda_u2421.addProperty("timesGained", (Number)oldAmount);
        $this$onConfigFix_u24migrateItem_u24lambda_u2421.addProperty("totalAmount", (Number)oldAmount);
        $this$onConfigFix_u24migrateItem_u24lambda_u2421.addProperty("hidden", Boolean.valueOf(false));
        return (JsonElement)jsonObject;
    }

    public static final /* synthetic */ JsonElement access$onConfigFix$migrateItem(JsonElement oldData) {
        return GhostTracker.onConfigFix$migrateItem(oldData);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(GhostTracker.class, "itemDropPattern", "getItemDropPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(GhostTracker.class, "killComboEndPattern", "getKillComboEndPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(GhostTracker.class, "bagOfCashPattern", "getBagOfCashPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(GhostTracker.class, "bestiaryTablistPattern", "getBestiaryTablistPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(GhostTracker.class, "maxBestiaryTablistPattern", "getMaxBestiaryTablistPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new GhostTracker();
        allowedDrops = SetsKt.emptySet();
        allowedSackDrops = SetsKt.emptySet();
        lastNoWidgetWarningTime = SimpleTimeMark.Companion.farPast();
        lastNoGhostBestiaryWidgetWarningTime = SimpleTimeMark.Companion.farPast();
        ghostShard = NeuInternalName.Companion.toInternalName("ATTRIBUTE_SHARD_VEIL;1");
        tracker = new SkyHanniItemTracker("Ghost Tracker", GhostTracker::tracker$lambda$0, GhostTracker::tracker$lambda$1, null, GhostTracker::tracker$lambda$2, 8, null);
        patternGroup = RepoPattern.Companion.group("combat.ghosttracker");
        itemDropPattern$delegate = patternGroup.pattern("itemdrop", "\u00a76\u00a7lRARE DROP! \u00a7r\u00a79(?<item>[^\u00a7]*) \u00a7r\u00a7b\\([+](?:\u00a7.)*(?<mf>\\d*)%? \u00a7r\u00a7b\u272f Magic Find\u00a7r\u00a7b\\)");
        killComboEndPattern$delegate = patternGroup.pattern("killcombo.end", "\u00a7cYour Kill Combo has expired! You reached a (?<kill>[\\d,.]+) Kill Combo!");
        bagOfCashPattern$delegate = patternGroup.pattern("bagofcash", "\u00a7eThe ghost's death materialized \u00a7r\u00a761,000,000 coins \u00a7r\u00a7efrom the mists!");
        bestiaryTablistPattern$delegate = patternGroup.pattern("tablist.bestiary", "\\s*Ghost (?<level>\\d+|[XVI]+)(?:\u00a7.)*: (?:\u00a7.)*(?<kills>[\\d,.]+)\\/(?<killsToNext>[\\d,.]+)");
        maxBestiaryTablistPattern$delegate = patternGroup.pattern("tablist.bestiarymax", "\\s*Ghost (?<level>\\d+|[XVI]+)(?:\u00a7.)*: (?:\u00a7.)*MAX");
        SORROW = NeuInternalName.Companion.toInternalName("SORROW");
        SkyHanniTracker.initRenderer$default(tracker, GhostTracker::_init_$lambda$15, null, null, GhostTracker::_init_$lambda$16, 6, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0013\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u0017J\u0010\u0010\u001a\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u0017J\u0010\u0010\u001b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u0017J\u0010\u0010\u001c\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u0017JL\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001a\u0010\"\u001a\u00020!2\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u00d6\u0003\u00a2\u0006\u0004\b\"\u0010#J\u0010\u0010%\u001a\u00020$H\u00d6\u0001\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010'\u001a\u00020\rH\u00d6\u0001\u00a2\u0006\u0004\b'\u0010(R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010)\u001a\u0004\b*\u0010\u0017\"\u0004\b+\u0010,R\"\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010)\u001a\u0004\b-\u0010\u0017\"\u0004\b.\u0010,R\"\u0010\u0005\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010)\u001a\u0004\b/\u0010\u0017\"\u0004\b0\u0010,R\"\u0010\u0006\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010)\u001a\u0004\b1\u0010\u0017\"\u0004\b2\u0010,R\"\u0010\u0007\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010)\u001a\u0004\b3\u0010\u0017\"\u0004\b4\u0010,R\"\u0010\b\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010)\u001a\u0004\b5\u0010\u0017\"\u0004\b6\u0010,\u00a8\u00067"}, d2={"Lat/hannibal2/skyhanni/features/combat/ghosttracker/GhostTracker$Data;", "Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData;", "", "kills", "ghostsSinceSorrow", "maxKillCombo", "combatXpGained", "totalMagicFind", "totalMagicFindKills", "<init>", "(JJJJJJ)V", "timesGained", "", "", "getDescription", "(J)Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;", "item", "getCoinName", "(Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;)Ljava/lang/String;", "getCoinDescription", "(Lat/hannibal2/skyhanni/utils/tracker/ItemTrackerData$TrackedItem;)Ljava/util/List;", "component1", "()J", "component2", "component3", "component4", "component5", "component6", "copy", "(JJJJJJ)Lat/hannibal2/skyhanni/features/combat/ghosttracker/GhostTracker$Data;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "J", "getKills", "setKills", "(J)V", "getGhostsSinceSorrow", "setGhostsSinceSorrow", "getMaxKillCombo", "setMaxKillCombo", "getCombatXpGained", "setCombatXpGained", "getTotalMagicFind", "setTotalMagicFind", "getTotalMagicFindKills", "setTotalMagicFindKills", "1.8.9"})
    public static final class Data
    extends ItemTrackerData {
        @Expose
        private long kills;
        @Expose
        private long ghostsSinceSorrow;
        @Expose
        private long maxKillCombo;
        @Expose
        private long combatXpGained;
        @Expose
        private long totalMagicFind;
        @Expose
        private long totalMagicFindKills;

        public Data(long kills, long ghostsSinceSorrow, long maxKillCombo, long combatXpGained, long totalMagicFind, long totalMagicFindKills) {
            this.kills = kills;
            this.ghostsSinceSorrow = ghostsSinceSorrow;
            this.maxKillCombo = maxKillCombo;
            this.combatXpGained = combatXpGained;
            this.totalMagicFind = totalMagicFind;
            this.totalMagicFindKills = totalMagicFindKills;
        }

        public /* synthetic */ Data(long l, long l2, long l3, long l4, long l5, long l6, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 0L;
            }
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            if ((n & 4) != 0) {
                l3 = 0L;
            }
            if ((n & 8) != 0) {
                l4 = 0L;
            }
            if ((n & 0x10) != 0) {
                l5 = 0L;
            }
            if ((n & 0x20) != 0) {
                l6 = 0L;
            }
            this(l, l2, l3, l4, l5, l6);
        }

        public final long getKills() {
            return this.kills;
        }

        public final void setKills(long l) {
            this.kills = l;
        }

        public final long getGhostsSinceSorrow() {
            return this.ghostsSinceSorrow;
        }

        public final void setGhostsSinceSorrow(long l) {
            this.ghostsSinceSorrow = l;
        }

        public final long getMaxKillCombo() {
            return this.maxKillCombo;
        }

        public final void setMaxKillCombo(long l) {
            this.maxKillCombo = l;
        }

        public final long getCombatXpGained() {
            return this.combatXpGained;
        }

        public final void setCombatXpGained(long l) {
            this.combatXpGained = l;
        }

        public final long getTotalMagicFind() {
            return this.totalMagicFind;
        }

        public final void setTotalMagicFind(long l) {
            this.totalMagicFind = l;
        }

        public final long getTotalMagicFindKills() {
            return this.totalMagicFindKills;
        }

        public final void setTotalMagicFindKills(long l) {
            this.totalMagicFindKills = l;
        }

        @Override
        @NotNull
        public List<String> getDescription(long timesGained) {
            double percentage = (double)timesGained / (double)this.kills;
            String perKill = NumberUtil.INSTANCE.formatPercentage(RangesKt.coerceAtMost(percentage, 1.0));
            String[] stringArray = new String[]{"\u00a77Dropped \u00a7e" + NumberUtil.INSTANCE.addSeparators(timesGained) + " \u00a77times.", "\u00a77Your drop chance per kill: \u00a7c" + perKill};
            return CollectionsKt.listOf(stringArray);
        }

        @Override
        @NotNull
        public String getCoinName(@NotNull ItemTrackerData.TrackedItem item2) {
            Intrinsics.checkNotNullParameter(item2, "item");
            return "\u00a76Dropped Coins";
        }

        @Override
        @NotNull
        public List<String> getCoinDescription(@NotNull ItemTrackerData.TrackedItem item2) {
            Intrinsics.checkNotNullParameter(item2, "item");
            String coinsFormat = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, item2.getTotalAmount(), false, 1, null);
            String[] stringArray = new String[]{"\u00a77Killing ghosts gives you coins (more with scavenger).", "\u00a77You got \u00a76" + coinsFormat + " coins \u00a77that way."};
            return CollectionsKt.listOf(stringArray);
        }

        public final long component1() {
            return this.kills;
        }

        public final long component2() {
            return this.ghostsSinceSorrow;
        }

        public final long component3() {
            return this.maxKillCombo;
        }

        public final long component4() {
            return this.combatXpGained;
        }

        public final long component5() {
            return this.totalMagicFind;
        }

        public final long component6() {
            return this.totalMagicFindKills;
        }

        @NotNull
        public final Data copy(long kills, long ghostsSinceSorrow, long maxKillCombo, long combatXpGained, long totalMagicFind, long totalMagicFindKills) {
            return new Data(kills, ghostsSinceSorrow, maxKillCombo, combatXpGained, totalMagicFind, totalMagicFindKills);
        }

        public static /* synthetic */ Data copy$default(Data data2, long l, long l2, long l3, long l4, long l5, long l6, int n, Object object) {
            if ((n & 1) != 0) {
                l = data2.kills;
            }
            if ((n & 2) != 0) {
                l2 = data2.ghostsSinceSorrow;
            }
            if ((n & 4) != 0) {
                l3 = data2.maxKillCombo;
            }
            if ((n & 8) != 0) {
                l4 = data2.combatXpGained;
            }
            if ((n & 0x10) != 0) {
                l5 = data2.totalMagicFind;
            }
            if ((n & 0x20) != 0) {
                l6 = data2.totalMagicFindKills;
            }
            return data2.copy(l, l2, l3, l4, l5, l6);
        }

        @NotNull
        public String toString() {
            return "Data(kills=" + this.kills + ", ghostsSinceSorrow=" + this.ghostsSinceSorrow + ", maxKillCombo=" + this.maxKillCombo + ", combatXpGained=" + this.combatXpGained + ", totalMagicFind=" + this.totalMagicFind + ", totalMagicFindKills=" + this.totalMagicFindKills + ')';
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.kills);
            result2 = result2 * 31 + Long.hashCode(this.ghostsSinceSorrow);
            result2 = result2 * 31 + Long.hashCode(this.maxKillCombo);
            result2 = result2 * 31 + Long.hashCode(this.combatXpGained);
            result2 = result2 * 31 + Long.hashCode(this.totalMagicFind);
            result2 = result2 * 31 + Long.hashCode(this.totalMagicFindKills);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data2 = (Data)other;
            if (this.kills != data2.kills) {
                return false;
            }
            if (this.ghostsSinceSorrow != data2.ghostsSinceSorrow) {
                return false;
            }
            if (this.maxKillCombo != data2.maxKillCombo) {
                return false;
            }
            if (this.combatXpGained != data2.combatXpGained) {
                return false;
            }
            if (this.totalMagicFind != data2.totalMagicFind) {
                return false;
            }
            return this.totalMagicFindKills == data2.totalMagicFindKills;
        }

        public Data() {
            this(0L, 0L, 0L, 0L, 0L, 0L, 63, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B*\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\fR(\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\b\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\r\u001a\u0004\b\u000e\u0010\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006\u0016"}, d2={"Lat/hannibal2/skyhanni/features/combat/ghosttracker/GhostTracker$GhostTrackerLines;", "", "", "display", "Lkotlin/Function1;", "Lat/hannibal2/skyhanni/features/combat/ghosttracker/GhostTracker$Data;", "Lkotlin/ExtensionFunctionType;", "line", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/jvm/functions/Function1;)V", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "Lkotlin/jvm/functions/Function1;", "getLine", "()Lkotlin/jvm/functions/Function1;", "KILLS", "GHOSTS_SINCE_SORROW", "MAX_KILL_COMBO", "COMBAT_XP_GAINED", "AVERAGE_MAGIC_FIND", "BESTIARY_KILLS", "1.8.9"})
    public static final class GhostTrackerLines
    extends Enum<GhostTrackerLines> {
        @NotNull
        private final String display;
        @NotNull
        private final Function1<Data, String> line;
        public static final /* enum */ GhostTrackerLines KILLS = new GhostTrackerLines("\u00a77Kills: \u00a7e7,813", GhostTrackerLines::_init_$lambda$0);
        public static final /* enum */ GhostTrackerLines GHOSTS_SINCE_SORROW = new GhostTrackerLines("\u00a77Ghosts Since Sorrow: \u00a7e71", GhostTrackerLines::_init_$lambda$1);
        public static final /* enum */ GhostTrackerLines MAX_KILL_COMBO = new GhostTrackerLines("\u00a77Max Kill Combo: \u00a7e681", GhostTrackerLines::_init_$lambda$2);
        public static final /* enum */ GhostTrackerLines COMBAT_XP_GAINED = new GhostTrackerLines("\u00a77Combat XP Gained: \u00a7e4,687,800", GhostTrackerLines::_init_$lambda$3);
        public static final /* enum */ GhostTrackerLines AVERAGE_MAGIC_FIND = new GhostTrackerLines("\u00a77Average Magic Find: \u00a7b278.9", GhostTrackerLines::_init_$lambda$4);
        public static final /* enum */ GhostTrackerLines BESTIARY_KILLS = new GhostTrackerLines("\u00a77Bestiary Kills: \u00a7e 71,893", GhostTrackerLines::_init_$lambda$5);
        private static final /* synthetic */ GhostTrackerLines[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private GhostTrackerLines(String display, Function1<? super Data, String> line) {
            this.display = display;
            this.line = line;
        }

        @NotNull
        public final Function1<Data, String> getLine() {
            return this.line;
        }

        @NotNull
        public String toString() {
            return this.display;
        }

        public static GhostTrackerLines[] values() {
            return (GhostTrackerLines[])$VALUES.clone();
        }

        public static GhostTrackerLines valueOf(String value) {
            return Enum.valueOf(GhostTrackerLines.class, value);
        }

        @NotNull
        public static EnumEntries<GhostTrackerLines> getEntries() {
            return $ENTRIES;
        }

        private static final String _init_$lambda$0(Data data2) {
            Intrinsics.checkNotNullParameter(data2, "<this>");
            return "\u00a77Kills: \u00a7e" + NumberUtil.INSTANCE.addSeparators(data2.getKills());
        }

        private static final String _init_$lambda$1(Data data2) {
            Intrinsics.checkNotNullParameter(data2, "<this>");
            return "\u00a77Ghosts Since Sorrow: \u00a7e" + NumberUtil.INSTANCE.addSeparators(data2.getGhostsSinceSorrow());
        }

        private static final String _init_$lambda$2(Data data2) {
            Intrinsics.checkNotNullParameter(data2, "<this>");
            return "\u00a77Max Kill Combo: \u00a7e" + NumberUtil.INSTANCE.addSeparators(data2.getMaxKillCombo());
        }

        private static final String _init_$lambda$3(Data data2) {
            Intrinsics.checkNotNullParameter(data2, "<this>");
            return "\u00a77Combat XP Gained: \u00a7e" + NumberUtil.INSTANCE.addSeparators(data2.getCombatXpGained());
        }

        private static final String _init_$lambda$4(Data data2) {
            Intrinsics.checkNotNullParameter(data2, "<this>");
            return "\u00a77Average Magic Find: \u00a7e" + NumberUtil.INSTANCE.roundTo(INSTANCE.getAverageMagicFind(data2.getTotalMagicFind(), data2.getTotalMagicFindKills()), 1);
        }

        private static final String _init_$lambda$5(Data data2) {
            Intrinsics.checkNotNullParameter(data2, "<this>");
            String kills = INSTANCE.getCurrentBestiaryKills() >= 100000L ? "MAX" : NumberUtil.INSTANCE.addSeparators(INSTANCE.getCurrentBestiaryKills());
            return "\u00a77Bestiary Kills: \u00a7e" + kills;
        }

        static {
            $VALUES = ghostTrackerLinesArray = new GhostTrackerLines[]{GhostTrackerLines.KILLS, GhostTrackerLines.GHOSTS_SINCE_SORROW, GhostTrackerLines.MAX_KILL_COMBO, GhostTrackerLines.COMBAT_XP_GAINED, GhostTrackerLines.AVERAGE_MAGIC_FIND, GhostTrackerLines.BESTIARY_KILLS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

