/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.event.hoppity;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.event.hoppity.HoppityCallWarningConfig;
import at.hannibal2.skyhanni.data.PurseApi;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.MessageSendToServerEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityApi;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityEggsManager;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.CFApi;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.GuiRenderUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.compat.GuiScreenUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.time.Instant;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.renderer.GlStateManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0003J\u000f\u0010\u0016\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0003J\u000f\u0010\u0017\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u000f\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001b\u0010 \u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001b\u0010#\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u001d\u001a\u0004\b\"\u0010\u001fR\u0014\u0010'\u001a\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0016\u0010)\u001a\u00020(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0016\u0010+\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0018\u0010.\u001a\u0004\u0018\u00010-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0018\u00100\u001a\u0004\u0018\u00010-8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u0010/R\u0014\u00102\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0016\u00105\u001a\u0002048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00103\u00a8\u00066"}, d2={"Lat/hannibal2/skyhanni/features/event/hoppity/HoppityCallWarning;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "event", "", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/events/MessageSendToServerEvent;", "onCommandSend", "(Lat/hannibal2/skyhanni/events/MessageSendToServerEvent;)V", "onWorldChange", "startWarningUser", "stopWarningUser", "", "isEnabled", "()Z", "Ljava/util/regex/Pattern;", "initHoppityCallPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getInitHoppityCallPattern", "()Ljava/util/regex/Pattern;", "initHoppityCallPattern", "pickupHoppityCallPattern$delegate", "getPickupHoppityCallPattern", "pickupHoppityCallPattern", "Lat/hannibal2/skyhanni/config/features/event/hoppity/HoppityCallWarningConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/event/hoppity/HoppityCallWarningConfig;", "config", "Lnet/minecraft/client/audio/ISound;", "warningSound", "Lnet/minecraft/client/audio/ISound;", "activeWarning", "Z", "Ljava/time/Instant;", "nextWarningTime", "Ljava/time/Instant;", "finalWarningTime", "Lkotlin/time/Duration;", "callLength", "J", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "commandSentTimer", "1.8.9"})
public final class HoppityCallWarning {
    @NotNull
    public static final HoppityCallWarning INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPattern initHoppityCallPattern$delegate;
    @NotNull
    private static final RepoPattern pickupHoppityCallPattern$delegate;
    @NotNull
    private static ISound warningSound;
    private static boolean activeWarning;
    @Nullable
    private static Instant nextWarningTime;
    @Nullable
    private static Instant finalWarningTime;
    private static final long callLength;
    private static long commandSentTimer;

    private HoppityCallWarning() {
    }

    private final Pattern getInitHoppityCallPattern() {
        return (Pattern)initHoppityCallPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getPickupHoppityCallPattern() {
        return (Pattern)pickupHoppityCallPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final HoppityCallWarningConfig getConfig() {
        return HoppityEggsManager.INSTANCE.getConfig().getHoppityCallWarning();
    }

    @HandleEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Property<String> soundProperty = this.getConfig().getHoppityCallSound();
        Property[] propertyArray = new Property[]{soundProperty};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, () -> HoppityCallWarning.onConfigLoad$lambda$0(soundProperty));
        nextWarningTime = null;
        finalWarningTime = null;
    }

    @HandleEvent(priority=-2)
    public final void onChat(@NotNull SkyHanniChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (RegexUtils.INSTANCE.matches(this.getInitHoppityCallPattern(), event.getMessage())) {
            this.startWarningUser();
        }
        if (RegexUtils.INSTANCE.matches(this.getPickupHoppityCallPattern(), event.getMessage())) {
            this.stopWarningUser();
        }
    }

    @HandleEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!activeWarning) {
            return;
        }
        if (nextWarningTime == null || finalWarningTime == null) {
            return;
        }
        Instant currentTime = Instant.now();
        if (currentTime.isAfter(nextWarningTime)) {
            SoundUtils.INSTANCE.repeatSound(100L, 10, warningSound);
            nextWarningTime = currentTime.plusMillis(100L);
        }
        if (currentTime.compareTo(finalWarningTime) >= 0) {
            this.stopWarningUser();
        }
    }

    @HandleEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled() || !activeWarning) {
            return;
        }
        double randomizationAlphaDouble = ((double)2 + Math.sin((double)Instant.now().toEpochMilli() / (double)1000)) * (double)255 / (double)4;
        int randomizationAlphaInt = RangesKt.coerceIn((int)randomizationAlphaDouble, new IntRange(0, 255));
        int shiftedRandomAlpha = randomizationAlphaInt << 24;
        GuiRenderUtils.INSTANCE.drawRect(0, 0, GuiScreenUtils.INSTANCE.getDisplayWidth(), GuiScreenUtils.INSTANCE.getDisplayHeight(), shiftedRandomAlpha | ColorUtils.INSTANCE.toColor(this.getConfig().getFlashColor()).getRGB() & 0xFFFFFF);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onCommandSend(@NotNull MessageSendToServerEvent event) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter(event, "event");
                if (!RegexUtils.INSTANCE.matches(HoppityApi.INSTANCE.getPickupOutgoingCommandPattern(), event.getMessage())) {
                    return;
                }
                if (!this.getConfig().getEnsureCoins()) break block5;
                if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(commandSentTimer), DurationKt.toDuration(5, DurationUnit.SECONDS)) >= 0) break block6;
            }
            return;
        }
        if (PurseApi.INSTANCE.getPurse() >= (double)this.getConfig().getCoinThreshold()) {
            return;
        }
        commandSentTimer = SimpleTimeMark.Companion.now-uFjCsEo();
        event.cancel();
        ChatUtils.clickToActionOrDisable$default(ChatUtils.INSTANCE, "\u00a7cBlocked picking up Hoppity without enough coins!", new MutablePropertyReference0Impl(this.getConfig()){

            public Object get() {
                return ((HoppityCallWarningConfig)this.receiver).getEnsureCoins();
            }

            public void set(Object value) {
                ((HoppityCallWarningConfig)this.receiver).setEnsureCoins((Boolean)value);
            }
        }, "open bank menu", HoppityCallWarning::onCommandSend$lambda$1, false, 16, null);
    }

    @HandleEvent
    public final void onWorldChange() {
        this.stopWarningUser();
    }

    private final void startWarningUser() {
        if (activeWarning) {
            return;
        }
        activeWarning = true;
        SoundUtils.INSTANCE.repeatSound(100L, 10, warningSound);
        Instant currentTime = Instant.now();
        nextWarningTime = currentTime.plusMillis(100L);
        Instant instant = finalWarningTime;
        if (instant == null) {
            instant = currentTime.plusMillis(Duration.getInWholeMilliseconds-impl(callLength));
        }
        finalWarningTime = instant;
    }

    private final void stopWarningUser() {
        activeWarning = false;
        finalWarningTime = null;
        nextWarningTime = null;
    }

    private final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && this.getConfig().getEnabled();
    }

    private static final void onConfigLoad$lambda$0(Property $soundProperty) {
        Intrinsics.checkNotNullParameter($soundProperty, "$soundProperty");
        Object t = $soundProperty.get();
        Intrinsics.checkNotNullExpressionValue(t, "get(...)");
        warningSound = SoundUtils.createSound$default(SoundUtils.INSTANCE, (String)t, 1.0f, 0.0f, 4, null);
    }

    private static final Unit onCommandSend$lambda$1() {
        HypixelCommands.INSTANCE.bank();
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(HoppityCallWarning.class, "initHoppityCallPattern", "getInitHoppityCallPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(HoppityCallWarning.class, "pickupHoppityCallPattern", "getPickupHoppityCallPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new HoppityCallWarning();
        initHoppityCallPattern$delegate = CFApi.INSTANCE.getPatternGroup().pattern("hoppity.call.init", "\u00a7e\u2706 \u00a7r(?:\u00a7a|\u00a7b)Hoppity\u00a7r\u00a7e \u2706.*");
        pickupHoppityCallPattern$delegate = CFApi.INSTANCE.getPatternGroup().pattern("hoppity.call.pickup", "\u00a7e\\[NPC] \u00a7aHoppity\u00a7f: \u00a7b\u2706 \u00a7f\u00a7rWhat's up, .*\u00a7f\\?");
        warningSound = SoundUtils.createSound$default(SoundUtils.INSTANCE, "note.pling", 1.0f, 0.0f, 4, null);
        callLength = DurationKt.toDuration(7, DurationUnit.SECONDS);
        commandSentTimer = SimpleTimeMark.Companion.farPast();
    }
}

