/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.fishing.FishedItemNameConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.features.fishing.FishingApi;
import at.hannibal2.skyhanni.features.fishing.ShowFishingItemName$onTick$;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.SkullTextureHolder;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.collection.TimeLimitedCache;
import at.hannibal2.skyhanni.utils.compat.InventoryCompat;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\fR\u0014\u0010\u0011\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R!\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lat/hannibal2/skyhanni/features/fishing/ShowFishingItemName;", "", "<init>", "()V", "", "onTick", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "event", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "", "inCorrectArea", "()Z", "isEnabled", "Lat/hannibal2/skyhanni/config/features/fishing/FishedItemNameConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/fishing/FishedItemNameConfig;", "config", "Lat/hannibal2/skyhanni/utils/collection/TimeLimitedCache;", "Lnet/minecraft/entity/item/EntityItem;", "", "itemsOnGround", "Lat/hannibal2/skyhanni/utils/collection/TimeLimitedCache;", "", "cheapCoins$delegate", "Lkotlin/Lazy;", "getCheapCoins", "()Ljava/util/Set;", "cheapCoins", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nShowFishingItemName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowFishingItemName.kt\nat/hannibal2/skyhanni/features/fishing/ShowFishingItemName\n+ 2 EntityUtils.kt\nat/hannibal2/skyhanni/utils/EntityUtils\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,85:1\n147#2,4:86\n185#2:90\n477#3:91\n*S KotlinDebug\n*F\n+ 1 ShowFishingItemName.kt\nat/hannibal2/skyhanni/features/fishing/ShowFishingItemName\n*L\n39#1:86,4\n39#1:90\n39#1:91\n*E\n"})
public final class ShowFishingItemName {
    @NotNull
    public static final ShowFishingItemName INSTANCE = new ShowFishingItemName();
    @NotNull
    private static final TimeLimitedCache<EntityItem, String> itemsOnGround = new TimeLimitedCache(DurationKt.toDuration(750, DurationUnit.MILLISECONDS), null, 2, null);
    @NotNull
    private static final Lazy cheapCoins$delegate = LazyKt.lazy(ShowFishingItemName::cheapCoins_delegate$lambda$0);

    private ShowFishingItemName() {
    }

    private final FishedItemNameConfig getConfig() {
        return SkyHanniMod.feature.getFishing().getFishedItemName();
    }

    private final Set<String> getCheapCoins() {
        Lazy lazy = cheapCoins$delegate;
        return (Set)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onTick() {
        void this_$iv$iv;
        void this_$iv;
        if (!this.isEnabled()) {
            return;
        }
        EntityUtils entityUtils = EntityUtils.INSTANCE;
        double radius$iv = 15.0;
        boolean $i$f$getEntitiesNextToPlayer = false;
        void var6_5 = this_$iv;
        LorenzVec location$iv$iv = LocationUtils.INSTANCE.playerLocation();
        boolean $i$f$getEntitiesNearby = false;
        void this_$iv$iv$iv = this_$iv$iv;
        boolean $i$f$getEntities = false;
        Sequence<Entity> $this$filterIsInstance$iv$iv$iv$iv = this_$iv$iv$iv.getAllEntities();
        boolean $i$f$filterIsInstance = false;
        Sequence<Entity> sequence2 = SequencesKt.filter($this$filterIsInstance$iv$iv$iv$iv, onTick$$inlined$getEntitiesNextToPlayer$1.INSTANCE);
        Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Iterator<Entity> iterator2 = SequencesKt.filter(sequence2, (Function1)new Function1<EntityItem, Boolean>(location$iv$iv, radius$iv){
            final /* synthetic */ LorenzVec $location;
            final /* synthetic */ double $radius;
            {
                this.$location = $location;
                this.$radius = $radius;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Boolean invoke(Entity it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return LocationUtils.INSTANCE.distanceTo(it, this.$location) < this.$radius;
            }
        }).iterator();
        while (iterator2.hasNext()) {
            ItemStack itemStack;
            EntityItem entityItem = (EntityItem)iterator2.next();
            if (InventoryCompat.INSTANCE.orNull(entityItem.func_92059_d()) == null) continue;
            String string = itemStack.func_82833_r();
            Intrinsics.checkNotNullExpressionValue(string, "getDisplayName(...)");
            if (Intrinsics.areEqual(StringUtils.removeColor$default(StringUtils.INSTANCE, string, false, 1, null), "Stone")) continue;
            String text = "";
            boolean isBait = FishingApi.INSTANCE.isBait(itemStack);
            if (isBait && !this.getConfig().getShowBaits()) continue;
            if (CollectionsKt.contains((Iterable)this.getCheapCoins(), ItemUtils.INSTANCE.getSkullTexture(itemStack))) {
                text = "\u00a76Coins";
            } else {
                String name2 = ConditionalUtils.INSTANCE.transformIf(itemStack.func_82833_r(), arg_0 -> ShowFishingItemName.onTick$lambda$1(isBait, arg_0), ShowFishingItemName::onTick$lambda$2);
                text = text + (isBait ? "\u00a7c\u00a7l- \u00a7r" : "\u00a7a\u00a7l+ \u00a7r");
                int size = itemStack.field_77994_a;
                if (size != 1) {
                    text = text + "\u00a77x" + size + " \u00a7r";
                }
                text = text + name2;
            }
            itemsOnGround.set(entityItem, text);
        }
    }

    @HandleEvent
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        for (Map.Entry entry : ((Map)itemsOnGround).entrySet()) {
            EntityItem item2 = (EntityItem)entry.getKey();
            String text = (String)entry.getValue();
            LorenzVec location = WorldRenderUtils.INSTANCE.exactLocation(event, (Entity)item2).up(0.8);
            WorldRenderUtils.drawString$default(WorldRenderUtils.INSTANCE, event, location, text, false, null, 12, null);
        }
    }

    private final boolean inCorrectArea() {
        if (IslandType.HUB.isCurrent()) {
            String string = SkyBlockUtils.INSTANCE.getGraphArea();
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (StringsKt.endsWith$default(it, " Atrium", false, 2, null) || StringsKt.endsWith$default(it, " Museum", false, 2, null)) {
                    return false;
                }
                if (Intrinsics.areEqual(it, "Fashion Shop") || Intrinsics.areEqual(it, "Shen's Auction")) {
                    return false;
                }
            }
        }
        return !IslandType.THE_END.isCurrent();
    }

    public final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && this.getConfig().getEnabled() && FishingApi.INSTANCE.getHoldingRod() && this.inCorrectArea();
    }

    private static final Set cheapCoins_delegate$lambda$0() {
        String[] stringArray = new String[]{SkullTextureHolder.INSTANCE.getTexture("COINS_1"), SkullTextureHolder.INSTANCE.getTexture("COINS_2")};
        return SetsKt.setOf(stringArray);
    }

    private static final boolean onTick$lambda$1(boolean $isBait, String $this$transformIf) {
        return $isBait;
    }

    private static final String onTick$lambda$2(String $this$transformIf) {
        StringBuilder stringBuilder = new StringBuilder().append("\u00a77");
        Intrinsics.checkNotNull($this$transformIf);
        return stringBuilder.append(StringUtils.removeColor$default(StringUtils.INSTANCE, $this$transformIf, false, 1, null)).toString();
    }
}

