/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.mining;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigFileType;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.ArgContext;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierArgument;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierArguments;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierBuilder;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierUtils;
import at.hannibal2.skyhanni.config.features.mining.orderedwaypoints.OrderedWaypointsConfig;
import at.hannibal2.skyhanni.config.storage.OrderedWaypointsRoutes;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.model.waypoints.Copyable;
import at.hannibal2.skyhanni.data.model.waypoints.SkyHanniWaypoint;
import at.hannibal2.skyhanni.data.model.waypoints.WaypointFormat;
import at.hannibal2.skyhanni.data.model.waypoints.Waypoints;
import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.events.hypixel.HypixelJoinEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.events.minecraft.WorldChangeEvent;
import at.hannibal2.skyhanni.features.mining.OrderedWaypoints;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ClipboardUtils;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u0017\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0003J\u0017\u0010 \u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b#\u0010!J\u0017\u0010$\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b$\u0010!J\u0017\u0010%\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b%\u0010!J\u0017\u0010&\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b&\u0010!J\u0017\u0010(\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010*\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b*\u0010)J\u0017\u0010+\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b+\u0010)J\u0017\u0010-\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010/\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b/\u0010\u0003J\u0017\u00101\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b1\u0010!J\u001f\u00105\u001a\n\u0012\u0004\u0012\u000204\u0018\u0001032\u0006\u00102\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b5\u00106J'\u00108\u001a\u0004\u0018\u00010\u00152\f\u00107\u001a\b\u0012\u0004\u0012\u000204032\u0006\u0010\u0018\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b8\u00109J\u0015\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00150:H\u0002\u00a2\u0006\u0004\b;\u0010<R\u0014\u0010@\u001a\u00020=8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0016\u0010D\u001a\u0004\u0018\u00010A8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u001c\u0010E\u001a\b\u0012\u0004\u0012\u000204038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010FR\u001a\u0010H\u001a\b\u0012\u0004\u0012\u00020\u000f0G8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010IR\u0016\u0010J\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010KR\u0016\u0010L\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bL\u0010KR\u0018\u0010M\u001a\u0004\u0018\u00010\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bM\u0010N\u00a8\u0006O"}, d2={"Lat/hannibal2/skyhanni/features/mining/OrderedWaypoints;", "", "<init>", "()V", "", "onHypixelJoin", "saveConfig", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "event", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "onWorldChange", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "", "waypointIndice", "", "shouldRenderName", "(I)Z", "", "", "getRouteNames", "()Ljava/util/Set;", "name", "load", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lkotlinx/coroutines/Job;", "setupLoadJob", "(Ljava/lang/String;)Lkotlinx/coroutines/Job;", "unload", "amount", "skip", "(I)V", "number", "skipto", "unskip", "delete", "add", "format", "export", "(Ljava/lang/String;)V", "save", "erase", "value", "toggleSetupMode", "(Z)V", "decideWaypoints", "increment", "incrementIndex", "data", "Lat/hannibal2/skyhanni/data/model/waypoints/Waypoints;", "Lat/hannibal2/skyhanni/data/model/waypoints/SkyHanniWaypoint;", "loadWaypoints", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/data/model/waypoints/Waypoints;", "waypoints", "exportWaypoints", "(Lat/hannibal2/skyhanni/data/model/waypoints/Waypoints;Ljava/lang/String;)Ljava/lang/String;", "", "getWaypointFormats", "()Ljava/util/List;", "Lat/hannibal2/skyhanni/config/features/mining/orderedwaypoints/OrderedWaypointsConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/mining/orderedwaypoints/OrderedWaypointsConfig;", "config", "Lat/hannibal2/skyhanni/config/storage/OrderedWaypointsRoutes;", "getStorage", "()Lat/hannibal2/skyhanni/config/storage/OrderedWaypointsRoutes;", "storage", "orderedWaypointsList", "Lat/hannibal2/skyhanni/data/model/waypoints/Waypoints;", "", "renderWaypoints", "Ljava/util/List;", "currentOrderedWaypointIndex", "I", "lastCloser", "loadJob", "Lkotlinx/coroutines/Job;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nOrderedWaypoints.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrderedWaypoints.kt\nat/hannibal2/skyhanni/features/mining/OrderedWaypoints\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 BrigadierBuilder.kt\nat/hannibal2/skyhanni/config/commands/brigadier/BrigadierBuilder\n*L\n1#1,451:1\n774#2:452\n865#2,2:453\n1863#2,2:455\n295#2,2:457\n1557#2:459\n1628#2,3:460\n168#3,9:463\n162#3,15:472\n162#3,15:487\n162#3,15:502\n162#3,15:517\n162#3,15:532\n168#3,9:547\n162#3,15:556\n168#3,9:571\n265#3,6:580\n168#3,9:586\n*S KotlinDebug\n*F\n+ 1 OrderedWaypoints.kt\nat/hannibal2/skyhanni/features/mining/OrderedWaypoints\n*L\n421#1:452\n421#1:453,2\n426#1:455,2\n444#1:457,2\n448#1:459\n448#1:460,3\n156#1:463,9\n169#1:472,15\n176#1:487,15\n183#1:502,15\n190#1:517,15\n196#1:532,15\n202#1:547,9\n209#1:556,15\n215#1:571,9\n221#1:580,6\n221#1:586,9\n*E\n"})
public final class OrderedWaypoints {
    @NotNull
    public static final OrderedWaypoints INSTANCE = new OrderedWaypoints();
    @NotNull
    private static Waypoints<SkyHanniWaypoint> orderedWaypointsList = new Waypoints(null, 1, null);
    @NotNull
    private static final List<Integer> renderWaypoints = new ArrayList();
    private static int currentOrderedWaypointIndex;
    private static int lastCloser;
    @Nullable
    private static Job loadJob;

    private OrderedWaypoints() {
    }

    private final OrderedWaypointsConfig getConfig() {
        return SkyHanniMod.feature.getMining().getOrderedWaypoints();
    }

    private final OrderedWaypointsRoutes getStorage() {
        return ProfileStorageData.INSTANCE.getOrderedWaypointsRoutes();
    }

    @HandleEvent(eventType=HypixelJoinEvent.class)
    public final void onHypixelJoin() {
        if (SkyHanniMod.INSTANCE.getOrderedWaypointsRoutesData().getRoutes() == null) {
            SkyHanniMod.INSTANCE.getOrderedWaypointsRoutesData().setRoutes(new LinkedHashMap());
            this.saveConfig();
        }
    }

    public final void saveConfig() {
        SkyHanniMod.INSTANCE.getConfigManager().saveConfig(ConfigFileType.ROUTES, "Save file");
    }

    @HandleEvent
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.getConfig().getEnabled()) {
            return;
        }
        int n = ((Collection)renderWaypoints).size();
        for (int i2 = 0; i2 < n; ++i2) {
            ChromaColour wpColor;
            int n2;
            ChromaColour chromaColour = !this.getConfig().getShowAll() ? ((n2 = i2) == 0 ? this.getConfig().getPreviousWaypointColor() : (n2 == 1 ? this.getConfig().getCurrentWaypointColor() : ((2 <= n2 ? n2 <= 1 + (int)this.getConfig().getNextCount() : false) ? this.getConfig().getNextWaypointColor() : this.getConfig().getSetupModeColor()))) : (wpColor = this.getConfig().getShowAllWaypointColor());
            if (orderedWaypointsList.size() <= ((Number)renderWaypoints.get(i2)).intValue()) {
                ChatUtils.debug$default(ChatUtils.INSTANCE, "" + ((Number)renderWaypoints.get(i2)).intValue() + ' ' + i2, false, 2, null);
                continue;
            }
            if (this.getConfig().getFillBlock()) {
                WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event, ((SkyHanniWaypoint)orderedWaypointsList.get(((Number)renderWaypoints.get(i2)).intValue())).getLocation(), ColorUtils.INSTANCE.toColor(wpColor), true, false, 0.0, 0.0, 0.0, 0.0f, false, 504, null);
            } else {
                WorldRenderUtils.INSTANCE.drawEdges(event, ((SkyHanniWaypoint)orderedWaypointsList.get(((Number)renderWaypoints.get(i2)).intValue())).getLocation(), ColorUtils.INSTANCE.toColor(wpColor), (int)this.getConfig().getBlockOutlineThickness(), false);
            }
            if (this.shouldRenderName(i2)) {
                WorldRenderUtils.drawString$default(WorldRenderUtils.INSTANCE, event, ((SkyHanniWaypoint)orderedWaypointsList.get(((Number)renderWaypoints.get(i2)).intValue())).getLocation().add(0.5, 2.5, 0.5), "\u00a7e" + ((SkyHanniWaypoint)orderedWaypointsList.get(((Number)renderWaypoints.get(i2)).intValue())).getNumber(), true, null, 8, null);
            }
            if (!this.getConfig().getShowDistance()) continue;
            WorldRenderUtils.drawString$default(WorldRenderUtils.INSTANCE, event, ((SkyHanniWaypoint)orderedWaypointsList.get(((Number)renderWaypoints.get(i2)).intValue())).getLocation().add(0.5, 2.0, 0.5), "\u00a7e" + NumberUtil.INSTANCE.addSeparators(NumberUtil.INSTANCE.roundTo(LocationUtils.INSTANCE.distanceToPlayer(((SkyHanniWaypoint)orderedWaypointsList.get(((Number)renderWaypoints.get(i2)).intValue())).getLocation()), 1)) + " m", true, null, 8, null);
        }
        if (renderWaypoints.size() <= 1) {
            this.decideWaypoints();
            return;
        }
        SkyHanniWaypoint traceWP = renderWaypoints.size() == 2 ? (SkyHanniWaypoint)orderedWaypointsList.get(((Number)renderWaypoints.get(0)).intValue()) : (SkyHanniWaypoint)orderedWaypointsList.get(((Number)renderWaypoints.get(2)).intValue());
        ChromaColour traceLineColor = this.getConfig().getTraceLineColor();
        if (this.getConfig().getTraceLine() && !this.getConfig().getShowAll() && !this.getConfig().getSetupMode()) {
            WorldRenderUtils.INSTANCE.drawLineToEye(event, traceWP.getLocation().add(0.5, 0.25, 0.5), traceLineColor, (int)this.getConfig().getTraceLineThickness(), true);
        }
        SkyHanniWaypoint currentWP = (SkyHanniWaypoint)orderedWaypointsList.get(((Number)renderWaypoints.get(1)).intValue());
        ChromaColour setupModeLineColor = this.getConfig().getSetupModeLineColor();
        if (this.getConfig().getSetupMode() && !this.getConfig().getShowAll()) {
            double eyePos = this.getConfig().getSneakingDuringRoute() ? 1.54 : 1.62;
            WorldRenderUtils.INSTANCE.draw3DLine(event, currentWP.getLocation().add(0.5, 1.0 + eyePos, 0.5), traceWP.getLocation().add(0.5, 0.5, 0.5), setupModeLineColor, (int)this.getConfig().getSetupModeLineThickness(), true);
        }
        this.decideWaypoints();
    }

    @HandleEvent(eventType=WorldChangeEvent.class)
    public final void onWorldChange() {
        currentOrderedWaypointIndex = 0;
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        event.registerBrigadier("shordered", OrderedWaypoints::onCommandRegistration$lambda$30);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldRenderName(int waypointIndice) {
        if (!this.getConfig().getShowName()) return false;
        if (this.getConfig().getSetupMode()) return true;
        if (this.getConfig().getShowAll()) return true;
        if (0 > waypointIndice) return false;
        if (waypointIndice > 1 + (int)this.getConfig().getNextCount()) return false;
        return true;
    }

    private final Set<String> getRouteNames() {
        Set<String> set;
        Object object = ProfileStorageData.INSTANCE.getOrderedWaypointsRoutes();
        if ((object != null && (object = ((OrderedWaypointsRoutes)object).getRoutes()) != null ? object.keySet() : (set = null)) == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final Object load(String name2, Continuation<? super Unit> $completion) {
        Job job2 = loadJob;
        boolean bl = job2 != null ? job2.isActive() : false;
        if (bl) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "A route is already being loaded. Please wait until it finishes.", false, 2, null);
            return Unit.INSTANCE;
        }
        Job job3 = loadJob = this.setupLoadJob(name2);
        if (job3 != null) {
            Object object = job3.join($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private final Job setupLoadJob(String name2) {
        return SkyHanniMod.launchIOCoroutine-8Mi8wO0$default(SkyHanniMod.INSTANCE, "ordered waypoints setupLoadJob", 0L, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(name2, null){
            Object L$0;
            int label;
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                block12: {
                    var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(var1_1);
                            if (!Intrinsics.areEqual(this.$name, "")) break;
                            var13_3 = OrderedWaypoints.INSTANCE;
                            this.L$0 = var13_3;
                            this.label = 1;
                            v0 = ClipboardUtils.readFromClipboard$default(ClipboardUtils.INSTANCE, 0, this, 1, null);
                            if (v0 == var14_2) {
                                return var14_2;
                            }
                            ** GOTO lbl17
                        }
                        case 1: {
                            var13_3 = (OrderedWaypoints)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            if ((v1 = (String)v0) == null) {
                                v1 = "";
                            }
                            v2 = OrderedWaypoints.access$loadWaypoints(var13_3, v1);
                            break block12;
                        }
                    }
                    v2 = OrderedWaypoints.access$getStorage(OrderedWaypoints.INSTANCE);
                    if (v2 == null || (v2 = v2.getRoutes()) == null || (v2 = (Waypoints)v2.get(this.$name)) == null) {
                        ChatUtils.userError$default(ChatUtils.INSTANCE, "Route " + this.$name + " doesn't exist.\n\u00a7cSaved Routes: " + ((v3 = OrderedWaypoints.access$getStorage(OrderedWaypoints.INSTANCE)) != null && (v3 = v3.getRoutes()) != null && (v3 = v3.keySet()) != null && (v3 = CollectionsKt.toList((Iterable)v3)) != null ? CollectionsKt.joinToString$default(v3, ", ", null, null, 0, null, null, 62, null) : null) + "\n\u00a7cIf you would like to import a route from your clipboard, leave the route name blank.", false, 2, null);
                        return Unit.INSTANCE;
                    }
                }
                loadedRoute = v2;
                if (loadedRoute == null) {
                    ChatUtils.userError$default(ChatUtils.INSTANCE, "There was an error parsing waypoints. Please make sure they are properly formatted and in a supported format.\n\u00a7cSupported Formats: " + CollectionsKt.joinToString$default(OrderedWaypoints.access$getWaypointFormats(OrderedWaypoints.INSTANCE), ", ", null, null, 0, null, null, 62, null), false, 2, null);
                    return Unit.INSTANCE;
                }
                OrderedWaypoints.access$setOrderedWaypointsList$p(loadedRoute.deepCopy());
                $this$minBy$iv = OrderedWaypoints.INSTANCE.access$getOrderedWaypointsList$p();
                $i$f$minByOrThrow = false;
                iterator$iv = $this$minBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v4 = minElem$iv;
                } else {
                    waypoint = (SkyHanniWaypoint)minElem$iv;
                    $i$a$-minByOrThrow-OrderedWaypoints$setupLoadJob$1$1 = false;
                    minValue$iv = LocationUtils.INSTANCE.distanceSqToPlayer(waypoint.getLocation());
                    do {
                        e$iv = iterator$iv.next();
                        waypoint = (SkyHanniWaypoint)e$iv;
                        $i$a$-minByOrThrow-OrderedWaypoints$setupLoadJob$1$1 = false;
                        v$iv = LocationUtils.INSTANCE.distanceSqToPlayer(waypoint.getLocation());
                        if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v4 = minElem$iv;
                }
                OrderedWaypoints.access$setCurrentOrderedWaypointIndex$p(((SkyHanniWaypoint)v4).getNumber() - 1);
                OrderedWaypoints.access$getRenderWaypoints$p().clear();
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Loaded ordered waypoints!", false, null, false, false, null, 62, null);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final void unload() {
        orderedWaypointsList.clear();
        renderWaypoints.clear();
        currentOrderedWaypointIndex = 0;
        lastCloser = 0;
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Unloaded ordered waypoints.", false, null, false, false, null, 62, null);
    }

    private final void skip(int amount) {
        if (orderedWaypointsList.isEmpty()) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "There are no waypoints to skip.", false, 2, null);
            return;
        }
        this.incrementIndex(amount);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Skipped " + amount + ' ' + StringUtils.pluralize$default(StringUtils.INSTANCE, amount, "waypoint", null, false, 12, null) + '.', false, null, false, false, null, 62, null);
    }

    private final void skipto(int number) {
        if (orderedWaypointsList.isEmpty()) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "There are no waypoints to skip to.", false, null, false, false, null, 62, null);
            return;
        }
        int newOrderedWaypointIndex = number - 1;
        if (0 <= newOrderedWaypointIndex && newOrderedWaypointIndex < orderedWaypointsList.size()) {
            currentOrderedWaypointIndex = newOrderedWaypointIndex;
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Skipped to " + (currentOrderedWaypointIndex + 1) + '.', false, null, false, false, null, 62, null);
        } else {
            ChatUtils.userError$default(ChatUtils.INSTANCE, number + " is not between 1 and " + orderedWaypointsList.size() + '.', false, 2, null);
        }
    }

    private final void unskip(int amount) {
        if (orderedWaypointsList.isEmpty()) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "There are no waypoints to unskip.", false, 2, null);
            return;
        }
        this.incrementIndex(-amount);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Unskipped " + amount + " waypoints.", false, null, false, false, null, 62, null);
    }

    private final void delete(int number) {
        if (orderedWaypointsList.isEmpty()) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "There are no waypoints to delete.", false, 2, null);
            return;
        }
        if (number < 1 || number > orderedWaypointsList.size()) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, number + " is not between 1 and " + orderedWaypointsList.size() + '.', false, 2, null);
            return;
        }
        int n = orderedWaypointsList.size();
        for (int i2 = number - 1; i2 < n; ++i2) {
            ((SkyHanniWaypoint)orderedWaypointsList.get(i2)).getOptions().put("name", String.valueOf(((SkyHanniWaypoint)orderedWaypointsList.get(i2)).getNumber() + -1));
            SkyHanniWaypoint skyHanniWaypoint = (SkyHanniWaypoint)orderedWaypointsList.get(i2);
            int n2 = skyHanniWaypoint.getNumber();
            skyHanniWaypoint.setNumber(n2 + -1);
        }
        orderedWaypointsList.remove(number - 1);
        renderWaypoints.clear();
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Removed waypoint " + number + '.', false, null, false, false, null, 62, null);
    }

    private final void add(int number) {
        LorenzVec pos = LocationUtils.INSTANCE.playerLocation().add(0, -1, 0).roundToBlock();
        if (number < 1 || number > orderedWaypointsList.size() + 1) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, number + " is not between 1 and " + (orderedWaypointsList.size() + 1) + '.', false, 2, null);
            return;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to("name", String.valueOf(number))};
        SkyHanniWaypoint newWaypoint = new SkyHanniWaypoint(pos, number, MapsKt.mutableMapOf(pairArray));
        if (number == orderedWaypointsList.size() + 1) {
            orderedWaypointsList.add((SkyHanniWaypoint)((Copyable)newWaypoint));
        } else {
            int n = orderedWaypointsList.size();
            for (int i2 = number - 1; i2 < n; ++i2) {
                ((SkyHanniWaypoint)orderedWaypointsList.get(i2)).getOptions().put("name", String.valueOf(((SkyHanniWaypoint)orderedWaypointsList.get(i2)).getNumber() + 1));
                SkyHanniWaypoint skyHanniWaypoint = (SkyHanniWaypoint)orderedWaypointsList.get(i2);
                int n2 = skyHanniWaypoint.getNumber();
                skyHanniWaypoint.setNumber(n2 + 1);
            }
            orderedWaypointsList.add(number - 1, (SkyHanniWaypoint)((Copyable)newWaypoint));
        }
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Inserted waypoint " + number + " at " + LorenzVec.toCleanString$default(pos, null, 1, null) + '.', false, null, false, false, null, 62, null);
    }

    private final void export(String format) {
        SkyHanniMod.launchIOCoroutine-8Mi8wO0$default(SkyHanniMod.INSTANCE, "ordered waypoints export format:" + format, 0L, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(format, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $format;
            {
                this.$format = $format;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        String route;
                        String string;
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$launchIOCoroutine = (CoroutineScope)this.L$0;
                        if (((CharSequence)this.$format).length() == 0) {
                            string = OrderedWaypoints.access$exportWaypoints(OrderedWaypoints.INSTANCE, OrderedWaypoints.access$getOrderedWaypointsList$p(), "coleweight");
                        } else {
                            Waypoints waypoints = OrderedWaypoints.access$getOrderedWaypointsList$p();
                            String string2 = this.$format;
                            Locale locale = Locale.getDefault();
                            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                            String string3 = string2.toLowerCase(locale);
                            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
                            string = OrderedWaypoints.access$exportWaypoints(OrderedWaypoints.INSTANCE, waypoints, string3);
                        }
                        String string4 = route = string;
                        if (string4 != null) {
                            String it = string4;
                            boolean bl = false;
                            ClipboardUtils.copyToClipboard$default(ClipboardUtils.INSTANCE, it, 0, 2, null);
                            ChatUtils.chat$default(ChatUtils.INSTANCE, "Route was copied to clipboard.", false, null, false, false, null, 62, null);
                        } else {
                            boolean bl = false;
                            ChatUtils.userError$default(ChatUtils.INSTANCE, "Invalid waypoint format specified.\n\u00a7cFormats: " + CollectionsKt.joinToString$default(OrderedWaypoints.access$getWaypointFormats(OrderedWaypoints.INSTANCE), null, null, null, 0, null, export.1::invokeSuspend$lambda$2$lambda$1, 31, null), false, 2, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final CharSequence invokeSuspend$lambda$2$lambda$1(String it) {
                return ", ";
            }
        }, 2, null);
    }

    private final void save(String name2) {
        Object object = ProfileStorageData.INSTANCE.getOrderedWaypointsRoutes();
        if (object != null && (object = ((OrderedWaypointsRoutes)object).getRoutes()) != null) {
            object.put(name2, orderedWaypointsList.deepCopy());
        }
        this.saveConfig();
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Route saved as " + name2 + ". Do /sho load " + name2 + " to import it.", false, null, false, false, null, 62, null);
    }

    private final void erase(String name2) {
        Object object = ProfileStorageData.INSTANCE.getOrderedWaypointsRoutes();
        if (object == null || (object = ((OrderedWaypointsRoutes)object).getRoutes()) == null || (object = (Waypoints)object.remove(name2)) == null) {
            OrderedWaypoints $this$erase_u24lambda_u2431 = this;
            boolean bl = false;
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Route " + name2 + " doesn't exist.", false, 2, null);
            return;
        }
        this.saveConfig();
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Route " + name2 + " successfully deleted.", false, null, false, false, null, 62, null);
    }

    private final void toggleSetupMode(boolean value) {
        this.getConfig().setSetupMode(value);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Toggled setup mode to " + value, false, null, false, false, null, 62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void decideWaypoints() {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        int n;
        int it;
        SkyHanniWaypoint skyHanniWaypoint;
        renderWaypoints.clear();
        if (orderedWaypointsList.isEmpty()) {
            return;
        }
        SkyHanniWaypoint skyHanniWaypoint2 = (SkyHanniWaypoint)CollectionsKt.getOrNull((List)orderedWaypointsList, currentOrderedWaypointIndex - 1);
        if (skyHanniWaypoint2 == null) {
            skyHanniWaypoint2 = (SkyHanniWaypoint)CollectionsKt.last((List)orderedWaypointsList);
        }
        SkyHanniWaypoint beforeWaypoint = skyHanniWaypoint2;
        renderWaypoints.add(beforeWaypoint.getNumber() - 1);
        SkyHanniWaypoint currentWaypoint = (SkyHanniWaypoint)CollectionsKt.getOrNull((List)orderedWaypointsList, currentOrderedWaypointIndex);
        double distanceTo1 = Double.POSITIVE_INFINITY;
        if (currentWaypoint != null) {
            distanceTo1 = LocationUtils.INSTANCE.distanceToPlayer(currentWaypoint.getLocation());
            renderWaypoints.add(currentWaypoint.getNumber() - 1);
        }
        if ((skyHanniWaypoint = (SkyHanniWaypoint)CollectionsKt.getOrNull((List)orderedWaypointsList, currentOrderedWaypointIndex + 1)) == null) {
            skyHanniWaypoint = (SkyHanniWaypoint)CollectionsKt.first((List)orderedWaypointsList);
        }
        SkyHanniWaypoint nextWaypoint = skyHanniWaypoint;
        double distanceTo2 = LocationUtils.INSTANCE.distanceToPlayer(nextWaypoint.getLocation());
        if (!renderWaypoints.contains(nextWaypoint.getNumber() - 1)) {
            renderWaypoints.add(nextWaypoint.getNumber() - 1);
        }
        if ((it = 1) <= (n = (int)this.getConfig().getNextCount() + -1)) {
            while (true) {
                int index;
                if (!renderWaypoints.contains(index = (nextWaypoint.getNumber() - 1 + it) % orderedWaypointsList.size())) {
                    renderWaypoints.add(index);
                }
                if (it == n) break;
                ++it;
            }
        }
        if (lastCloser == currentOrderedWaypointIndex && distanceTo1 > distanceTo2 && distanceTo2 < (double)this.getConfig().getWaypointRange()) {
            this.incrementIndex(1);
            return;
        }
        if (distanceTo1 < (double)this.getConfig().getWaypointRange()) {
            lastCloser = currentOrderedWaypointIndex;
        }
        if (distanceTo2 < (double)this.getConfig().getWaypointRange()) {
            this.incrementIndex(1);
        }
        Iterable $this$filter$iv = orderedWaypointsList;
        boolean $i$f$filter = false;
        Iterable index = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SkyHanniWaypoint it2 = (SkyHanniWaypoint)element$iv$iv;
            boolean bl = false;
            boolean inSetupRange = INSTANCE.getConfig().getSetupMode() && !renderWaypoints.contains(it2.getNumber() - 1) && LocationUtils.INSTANCE.distanceToPlayer(it2.getLocation()) < (double)INSTANCE.getConfig().getSetupModeRange();
            if (!(inSetupRange || INSTANCE.getConfig().getShowAll())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SkyHanniWaypoint waypoint = (SkyHanniWaypoint)element$iv;
            boolean bl = false;
            renderWaypoints.add(waypoint.getNumber() - 1);
        }
    }

    private final void incrementIndex(int increment) {
        currentOrderedWaypointIndex = Math.floorMod(currentOrderedWaypointIndex + increment, orderedWaypointsList.size());
    }

    private final Waypoints<SkyHanniWaypoint> loadWaypoints(String data2) {
        Waypoints waypoints;
        Object object;
        block3: {
            Object object2;
            ServiceLoader<WaypointFormat> serviceLoader = ServiceLoader.load(WaypointFormat.class);
            Intrinsics.checkNotNullExpressionValue(serviceLoader, "load(...)");
            for (Object it : (Iterable)serviceLoader) {
                boolean bl = false;
                if ((it = it.load(data2)) == null) continue;
                object2 = it;
                break block3;
            }
            object2 = object = null;
        }
        if (object != null) {
            Object it = object;
            boolean bl = false;
            waypoints = new Waypoints(CollectionsKt.toMutableList((Collection)it));
        } else {
            waypoints = null;
        }
        return waypoints;
    }

    private final String exportWaypoints(Waypoints<SkyHanniWaypoint> waypoints, String name2) {
        Object v1;
        block1: {
            ServiceLoader<WaypointFormat> serviceLoader = ServiceLoader.load(WaypointFormat.class);
            Intrinsics.checkNotNullExpressionValue(serviceLoader, "load(...)");
            Iterable $this$firstOrNull$iv = serviceLoader;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                WaypointFormat it = (WaypointFormat)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), name2)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        WaypointFormat waypointFormat = v1;
        return waypointFormat != null ? waypointFormat.export(waypoints) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getWaypointFormats() {
        void $this$mapTo$iv$iv;
        ServiceLoader<WaypointFormat> serviceLoader = ServiceLoader.load(WaypointFormat.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, "load(...)");
        Iterable $this$map$iv = serviceLoader;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WaypointFormat waypointFormat = (WaypointFormat)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (List)destination$iv$iv;
    }

    private static final Collection onCommandRegistration$lambda$30$lambda$2$lambda$0() {
        return INSTANCE.getRouteNames();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCommandRegistration$lambda$30$lambda$2(BaseBrigadierBuilder $this_registerBrigadier, BrigadierBuilder $this$literal) {
        void suggestions$iv;
        void argument$iv;
        void this_$iv;
        void name$iv;
        Intrinsics.checkNotNullParameter($this_registerBrigadier, "$this_registerBrigadier");
        Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
        $this_registerBrigadier.setDescription("Loads ordered waypoints from your clipboard or config.");
        BrigadierBuilder brigadierBuilder = $this$literal;
        String string = "name";
        ArgumentType argumentType = BrigadierArguments.INSTANCE.string();
        SuggestionProvider<Object> suggestionProvider = BrigadierUtils.INSTANCE.dynamicSuggestionProvider(OrderedWaypoints::onCommandRegistration$lambda$30$lambda$2$lambda$0);
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            this_$iv.internalArg((String)name$iv, argument$iv, (SuggestionProvider<Object>)suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                    void name2;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$onCommandRegistration_u24lambda_u2430_u24lambda_u242_u24lambda_u241 = $this$internalArg;
                    boolean bl = false;
                    $this$onCommandRegistration_u24lambda_u2430_u24lambda_u242_u24lambda_u241.coroutineSimpleCallback((Function2<ArgContext, Continuation<Unit>, Object>)new Function2<ArgContext, Continuation<? super Unit>, Object>((BrigadierArgument<String>)name2, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ BrigadierArgument<String> $name;
                        {
                            this.$name = $name;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(object);
                                    ArgContext $this$coroutineSimpleCallback = (ArgContext)this.L$0;
                                    String string = $this$coroutineSimpleCallback.getArg(this.$name);
                                    Intrinsics.checkNotNullExpressionValue(string, "getArg(...)");
                                    this.label = 1;
                                    Object object3 = OrderedWaypoints.access$load(OrderedWaypoints.INSTANCE, string, this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure($result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            Function2<ArgContext, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                            function2.L$0 = value;
                            return (Continuation)((Object)function2);
                        }

                        public final Object invoke(ArgContext p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = pair.component1();
            String argName$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            this_$iv.literal(stringArray, (Function1<? super BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, (ArgumentType)argument$iv, (SuggestionProvider)suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                            void name2;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$onCommandRegistration_u24lambda_u2430_u24lambda_u242_u24lambda_u241 = $this$internalArg;
                            boolean bl = false;
                            $this$onCommandRegistration_u24lambda_u2430_u24lambda_u242_u24lambda_u241.coroutineSimpleCallback((Function2<ArgContext, Continuation<Unit>, Object>)new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            });
        }
        $this$literal.coroutineSimpleCallback((Function2<ArgContext, Continuation<Unit>, Object>)new Function2<ArgContext, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.label = 1;
                        Object object3 = OrderedWaypoints.access$load(OrderedWaypoints.INSTANCE, "", this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(ArgContext p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$30$lambda$4$lambda$3() {
        INSTANCE.unload();
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$30$lambda$4(BaseBrigadierBuilder $this_registerBrigadier, BrigadierBuilder $this$literal) {
        Intrinsics.checkNotNullParameter($this_registerBrigadier, "$this_registerBrigadier");
        Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
        $this_registerBrigadier.setDescription("Unloads the current ordered waypoints.");
        $this$literal.simpleCallback(OrderedWaypoints::onCommandRegistration$lambda$30$lambda$4$lambda$3);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$30$lambda$7$lambda$6() {
        INSTANCE.skip(1);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCommandRegistration$lambda$30$lambda$7(BaseBrigadierBuilder $this_registerBrigadier, BrigadierBuilder $this$literal) {
        void name$iv;
        Intrinsics.checkNotNullParameter($this_registerBrigadier, "$this_registerBrigadier");
        Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
        $this_registerBrigadier.setDescription("Skips the next waypoint.");
        String string = "amount";
        ArgumentType argument$iv = BrigadierArguments.integer$default(BrigadierArguments.INSTANCE, 0, 0, 3, null);
        SuggestionProvider<Object> suggestions$iv = null;
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            $this$literal.internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$internalArg) {
                    void amount;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<Integer> brigadierArgument = new BrigadierArgument<Integer>(argumentName$iv, Integer.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$onCommandRegistration_u24lambda_u2430_u24lambda_u247_u24lambda_u245 = $this$internalArg;
                    boolean bl = false;
                    $this$onCommandRegistration_u24lambda_u2430_u24lambda_u247_u24lambda_u245.callback(new Function1<ArgContext, Unit>((BrigadierArgument<Integer>)amount){
                        final /* synthetic */ BrigadierArgument<Integer> $amount;
                        {
                            this.$amount = $amount;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                            Integer n = $this$callback.getArg(this.$amount);
                            Intrinsics.checkNotNullExpressionValue(n, "getArg(...)");
                            OrderedWaypoints.access$skip(OrderedWaypoints.INSTANCE, ((Number)n).intValue());
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = pair.component1();
            String argName$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            $this$literal.literal(stringArray, (Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$internalArg) {
                            void amount;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<Integer> brigadierArgument = new BrigadierArgument<Integer>(argumentName$iv, Integer.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$onCommandRegistration_u24lambda_u2430_u24lambda_u247_u24lambda_u245 = $this$internalArg;
                            boolean bl = false;
                            $this$onCommandRegistration_u24lambda_u2430_u24lambda_u247_u24lambda_u245.callback(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            });
        }
        $this$literal.simpleCallback(OrderedWaypoints::onCommandRegistration$lambda$30$lambda$7$lambda$6);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$30$lambda$10$lambda$9() {
        INSTANCE.skipto(1);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCommandRegistration$lambda$30$lambda$10(BaseBrigadierBuilder $this_registerBrigadier, BrigadierBuilder $this$literal) {
        void name$iv;
        Intrinsics.checkNotNullParameter($this_registerBrigadier, "$this_registerBrigadier");
        Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
        $this_registerBrigadier.setDescription("Skips to the waypoint with the inputted number.");
        String string = "number";
        ArgumentType argument$iv = BrigadierArguments.integer$default(BrigadierArguments.INSTANCE, 0, 0, 3, null);
        SuggestionProvider<Object> suggestions$iv = null;
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            $this$literal.internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$internalArg) {
                    void number;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<Integer> brigadierArgument = new BrigadierArgument<Integer>(argumentName$iv, Integer.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2410_u24lambda_u248 = $this$internalArg;
                    boolean bl = false;
                    $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2410_u24lambda_u248.callback(new Function1<ArgContext, Unit>((BrigadierArgument<Integer>)number){
                        final /* synthetic */ BrigadierArgument<Integer> $number;
                        {
                            this.$number = $number;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                            Integer n = $this$callback.getArg(this.$number);
                            Intrinsics.checkNotNullExpressionValue(n, "getArg(...)");
                            OrderedWaypoints.access$skipto(OrderedWaypoints.INSTANCE, ((Number)n).intValue());
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = pair.component1();
            String argName$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            $this$literal.literal(stringArray, (Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$internalArg) {
                            void number;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<Integer> brigadierArgument = new BrigadierArgument<Integer>(argumentName$iv, Integer.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2410_u24lambda_u248 = $this$internalArg;
                            boolean bl = false;
                            $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2410_u24lambda_u248.callback(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            });
        }
        $this$literal.simpleCallback(OrderedWaypoints::onCommandRegistration$lambda$30$lambda$10$lambda$9);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$30$lambda$13$lambda$12() {
        INSTANCE.unskip(1);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCommandRegistration$lambda$30$lambda$13(BaseBrigadierBuilder $this_registerBrigadier, BrigadierBuilder $this$literal) {
        void name$iv;
        Intrinsics.checkNotNullParameter($this_registerBrigadier, "$this_registerBrigadier");
        Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
        $this_registerBrigadier.setDescription("Goes back by the number inputted many waypoints.");
        String string = "amount";
        ArgumentType argument$iv = BrigadierArguments.integer$default(BrigadierArguments.INSTANCE, 0, 0, 3, null);
        SuggestionProvider<Object> suggestions$iv = null;
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            $this$literal.internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$internalArg) {
                    void amount;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<Integer> brigadierArgument = new BrigadierArgument<Integer>(argumentName$iv, Integer.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2413_u24lambda_u2411 = $this$internalArg;
                    boolean bl = false;
                    $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2413_u24lambda_u2411.callback(new Function1<ArgContext, Unit>((BrigadierArgument<Integer>)amount){
                        final /* synthetic */ BrigadierArgument<Integer> $amount;
                        {
                            this.$amount = $amount;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                            Integer n = $this$callback.getArg(this.$amount);
                            Intrinsics.checkNotNullExpressionValue(n, "getArg(...)");
                            OrderedWaypoints.access$unskip(OrderedWaypoints.INSTANCE, ((Number)n).intValue());
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = pair.component1();
            String argName$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            $this$literal.literal(stringArray, (Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$internalArg) {
                            void amount;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<Integer> brigadierArgument = new BrigadierArgument<Integer>(argumentName$iv, Integer.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2413_u24lambda_u2411 = $this$internalArg;
                            boolean bl = false;
                            $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2413_u24lambda_u2411.callback(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            });
        }
        $this$literal.simpleCallback(OrderedWaypoints::onCommandRegistration$lambda$30$lambda$13$lambda$12);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCommandRegistration$lambda$30$lambda$15(BaseBrigadierBuilder $this_registerBrigadier, BrigadierBuilder $this$literal) {
        void name$iv;
        Intrinsics.checkNotNullParameter($this_registerBrigadier, "$this_registerBrigadier");
        Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
        $this_registerBrigadier.setDescription("Deletes the waypoint with the inputted number.");
        String string = "number";
        ArgumentType argument$iv = BrigadierArguments.integer$default(BrigadierArguments.INSTANCE, 0, 0, 3, null);
        SuggestionProvider<Object> suggestions$iv = null;
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            $this$literal.internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$internalArg) {
                    void number;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<Integer> brigadierArgument = new BrigadierArgument<Integer>(argumentName$iv, Integer.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2415_u24lambda_u2414 = $this$internalArg;
                    boolean bl = false;
                    $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2415_u24lambda_u2414.callback(new Function1<ArgContext, Unit>((BrigadierArgument<Integer>)number){
                        final /* synthetic */ BrigadierArgument<Integer> $number;
                        {
                            this.$number = $number;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                            Integer n = $this$callback.getArg(this.$number);
                            Intrinsics.checkNotNullExpressionValue(n, "getArg(...)");
                            OrderedWaypoints.access$delete(OrderedWaypoints.INSTANCE, ((Number)n).intValue());
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = pair.component1();
            String argName$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            $this$literal.literal(stringArray, (Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$internalArg) {
                            void number;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<Integer> brigadierArgument = new BrigadierArgument<Integer>(argumentName$iv, Integer.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2415_u24lambda_u2414 = $this$internalArg;
                            boolean bl = false;
                            $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2415_u24lambda_u2414.callback(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            });
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCommandRegistration$lambda$30$lambda$17(BaseBrigadierBuilder $this_registerBrigadier, BrigadierBuilder $this$literal) {
        void name$iv;
        Intrinsics.checkNotNullParameter($this_registerBrigadier, "$this_registerBrigadier");
        Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
        $this_registerBrigadier.setDescription("Inserts a waypoint with the specified numbering below the player.");
        String string = "number";
        ArgumentType argument$iv = BrigadierArguments.integer$default(BrigadierArguments.INSTANCE, 0, 0, 3, null);
        SuggestionProvider<Object> suggestions$iv = null;
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            $this$literal.internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$internalArg) {
                    void number;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<Integer> brigadierArgument = new BrigadierArgument<Integer>(argumentName$iv, Integer.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2417_u24lambda_u2416 = $this$internalArg;
                    boolean bl = false;
                    $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2417_u24lambda_u2416.callback(new Function1<ArgContext, Unit>((BrigadierArgument<Integer>)number){
                        final /* synthetic */ BrigadierArgument<Integer> $number;
                        {
                            this.$number = $number;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                            Integer n = $this$callback.getArg(this.$number);
                            Intrinsics.checkNotNullExpressionValue(n, "getArg(...)");
                            OrderedWaypoints.access$add(OrderedWaypoints.INSTANCE, ((Number)n).intValue());
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = pair.component1();
            String argName$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            $this$literal.literal(stringArray, (Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$internalArg) {
                            void number;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<Integer> brigadierArgument = new BrigadierArgument<Integer>(argumentName$iv, Integer.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, Integer>> $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2417_u24lambda_u2416 = $this$internalArg;
                            boolean bl = false;
                            $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2417_u24lambda_u2416.callback(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            });
        }
        return Unit.INSTANCE;
    }

    private static final Collection onCommandRegistration$lambda$30$lambda$21$lambda$18() {
        return INSTANCE.getWaypointFormats();
    }

    private static final Unit onCommandRegistration$lambda$30$lambda$21$lambda$20() {
        INSTANCE.export("coleweight");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCommandRegistration$lambda$30$lambda$21(BaseBrigadierBuilder $this_registerBrigadier, BrigadierBuilder $this$literal) {
        void argument$iv;
        void this_$iv;
        void name$iv;
        Intrinsics.checkNotNullParameter($this_registerBrigadier, "$this_registerBrigadier");
        Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
        $this_registerBrigadier.setDescription("Exports the loaded ordered waypoints to clipboard.");
        BrigadierBuilder brigadierBuilder = $this$literal;
        String string = "format";
        ArgumentType argumentType = BrigadierArguments.INSTANCE.string();
        SuggestionProvider<Object> suggestions$iv = BrigadierUtils.INSTANCE.dynamicSuggestionProvider(OrderedWaypoints::onCommandRegistration$lambda$30$lambda$21$lambda$18);
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            this_$iv.internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                    void format;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2421_u24lambda_u2419 = $this$internalArg;
                    boolean bl = false;
                    $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2421_u24lambda_u2419.callback(new Function1<ArgContext, Unit>((BrigadierArgument<String>)format){
                        final /* synthetic */ BrigadierArgument<String> $format;
                        {
                            this.$format = $format;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                            String string = $this$callback.getArg(this.$format);
                            Intrinsics.checkNotNullExpressionValue(string, "getArg(...)");
                            OrderedWaypoints.access$export(OrderedWaypoints.INSTANCE, string);
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = pair.component1();
            String argName$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            this_$iv.literal(stringArray, (Function1<? super BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, (ArgumentType)argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                            void format;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2421_u24lambda_u2419 = $this$internalArg;
                            boolean bl = false;
                            $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2421_u24lambda_u2419.callback(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            });
        }
        $this$literal.simpleCallback(OrderedWaypoints::onCommandRegistration$lambda$30$lambda$21$lambda$20);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCommandRegistration$lambda$30$lambda$23(BaseBrigadierBuilder $this_registerBrigadier, BrigadierBuilder $this$literal) {
        void name$iv;
        Intrinsics.checkNotNullParameter($this_registerBrigadier, "$this_registerBrigadier");
        Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
        $this_registerBrigadier.setDescription("Saves the loaded ordered waypoints to your config.");
        String string = "name";
        ArgumentType argument$iv = BrigadierArguments.INSTANCE.string();
        SuggestionProvider<Object> suggestions$iv = null;
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            $this$literal.internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                    void name2;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2423_u24lambda_u2422 = $this$internalArg;
                    boolean bl = false;
                    $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2423_u24lambda_u2422.callback(new Function1<ArgContext, Unit>((BrigadierArgument<String>)name2){
                        final /* synthetic */ BrigadierArgument<String> $name;
                        {
                            this.$name = $name;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                            String string = $this$callback.getArg(this.$name);
                            Intrinsics.checkNotNullExpressionValue(string, "getArg(...)");
                            OrderedWaypoints.access$save(OrderedWaypoints.INSTANCE, string);
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = pair.component1();
            String argName$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            $this$literal.literal(stringArray, (Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                            void name2;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2423_u24lambda_u2422 = $this$internalArg;
                            boolean bl = false;
                            $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2423_u24lambda_u2422.callback(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            });
        }
        return Unit.INSTANCE;
    }

    private static final Collection onCommandRegistration$lambda$30$lambda$26$lambda$24() {
        return INSTANCE.getRouteNames();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCommandRegistration$lambda$30$lambda$26(BaseBrigadierBuilder $this_registerBrigadier, BrigadierBuilder $this$literal) {
        void argument$iv;
        void this_$iv;
        void name$iv;
        Intrinsics.checkNotNullParameter($this_registerBrigadier, "$this_registerBrigadier");
        Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
        $this_registerBrigadier.setDescription("Erases the route with the specified name.");
        BrigadierBuilder brigadierBuilder = $this$literal;
        String string = "name";
        ArgumentType argumentType = BrigadierArguments.INSTANCE.string();
        SuggestionProvider<Object> suggestions$iv = BrigadierUtils.INSTANCE.dynamicSuggestionProvider(OrderedWaypoints::onCommandRegistration$lambda$30$lambda$26$lambda$24);
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            this_$iv.internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                    void name2;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2426_u24lambda_u2425 = $this$internalArg;
                    boolean bl = false;
                    $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2426_u24lambda_u2425.callback(new Function1<ArgContext, Unit>((BrigadierArgument<String>)name2){
                        final /* synthetic */ BrigadierArgument<String> $name;
                        {
                            this.$name = $name;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                            String string = $this$callback.getArg(this.$name);
                            Intrinsics.checkNotNullExpressionValue(string, "getArg(...)");
                            OrderedWaypoints.access$erase(OrderedWaypoints.INSTANCE, string);
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = pair.component1();
            String argName$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            this_$iv.literal(stringArray, (Function1<? super BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, (ArgumentType)argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                            void name2;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2426_u24lambda_u2425 = $this$internalArg;
                            boolean bl = false;
                            $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2426_u24lambda_u2425.callback(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            });
        }
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$30$lambda$29$lambda$28() {
        INSTANCE.toggleSetupMode(!INSTANCE.getConfig().getSetupMode());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCommandRegistration$lambda$30$lambda$29(BaseBrigadierBuilder $this_registerBrigadier, BrigadierBuilder $this$literal) {
        void name$iv;
        Intrinsics.checkNotNullParameter($this_registerBrigadier, "$this_registerBrigadier");
        Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
        $this_registerBrigadier.setDescription("Toggles setup mode.");
        String string = "enable";
        ArgumentType argument$iv = BrigadierArguments.INSTANCE.bool();
        SuggestionProvider<Object> suggestions$iv = null;
        boolean $i$f$argCallback = false;
        BrigadierBuilder this_$iv$iv = $this$literal;
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            this_$iv$iv.internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, Boolean>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, Boolean>> $this$internalArg) {
                    void it;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<Boolean> brigadierArgument = new BrigadierArgument<Boolean>(argumentName$iv, Boolean.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, Boolean>> $this$argCallback_u24lambda_u2412 = $this$internalArg;
                    boolean bl = false;
                    $this$argCallback_u24lambda_u2412.callback(new Function1<ArgContext, Unit>((BrigadierArgument)it){
                        final /* synthetic */ BrigadierArgument $it;
                        {
                            this.$it = $it;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                            Boolean enableSetupMode = (Boolean)$this$callback.getArg(this.$it);
                            ArgContext $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2429_u24lambda_u2427 = $this$callback;
                            boolean bl = false;
                            Intrinsics.checkNotNull(enableSetupMode);
                            OrderedWaypoints.access$toggleSetupMode(OrderedWaypoints.INSTANCE, enableSetupMode);
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv$iv = pair.component1();
            String argName$iv$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv$iv};
            this_$iv$iv.literal(stringArray, (Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv$iv, argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, Boolean>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, Boolean>> $this$internalArg) {
                            void it;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<Boolean> brigadierArgument = new BrigadierArgument<Boolean>(argumentName$iv, Boolean.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, Boolean>> $this$argCallback_u24lambda_u2412 = $this$internalArg;
                            boolean bl = false;
                            $this$argCallback_u24lambda_u2412.callback(new Function1<ArgContext, Unit>((BrigadierArgument)it){
                                final /* synthetic */ BrigadierArgument $it;
                                {
                                    this.$it = $it;
                                }

                                public final void invoke(ArgContext $this$callback) {
                                    Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                                    Boolean enableSetupMode = (Boolean)$this$callback.getArg(this.$it);
                                    ArgContext $this$onCommandRegistration_u24lambda_u2430_u24lambda_u2429_u24lambda_u2427 = $this$callback;
                                    boolean bl = false;
                                    Intrinsics.checkNotNull(enableSetupMode);
                                    OrderedWaypoints.access$toggleSetupMode(OrderedWaypoints.INSTANCE, enableSetupMode);
                                }
                            });
                        }
                    });
                }
            });
        }
        $this$literal.simpleCallback(OrderedWaypoints::onCommandRegistration$lambda$30$lambda$29$lambda$28);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$30(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter($this$registerBrigadier, "$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Ordered Waypoints commands.");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_ACTIVE);
        $this$registerBrigadier.setAliases(CollectionsKt.listOf("sho"));
        String[] stringArray = new String[]{"load", "import"};
        $this$registerBrigadier.literal(stringArray, arg_0 -> OrderedWaypoints.onCommandRegistration$lambda$30$lambda$2($this$registerBrigadier, arg_0));
        stringArray = new String[]{"unload", "clear"};
        $this$registerBrigadier.literal(stringArray, arg_0 -> OrderedWaypoints.onCommandRegistration$lambda$30$lambda$4($this$registerBrigadier, arg_0));
        stringArray = new String[]{"skip"};
        $this$registerBrigadier.literal(stringArray, arg_0 -> OrderedWaypoints.onCommandRegistration$lambda$30$lambda$7($this$registerBrigadier, arg_0));
        stringArray = new String[]{"skipto"};
        $this$registerBrigadier.literal(stringArray, arg_0 -> OrderedWaypoints.onCommandRegistration$lambda$30$lambda$10($this$registerBrigadier, arg_0));
        stringArray = new String[]{"unskip"};
        $this$registerBrigadier.literal(stringArray, arg_0 -> OrderedWaypoints.onCommandRegistration$lambda$30$lambda$13($this$registerBrigadier, arg_0));
        stringArray = new String[]{"delete", "remove"};
        $this$registerBrigadier.literal(stringArray, arg_0 -> OrderedWaypoints.onCommandRegistration$lambda$30$lambda$15($this$registerBrigadier, arg_0));
        stringArray = new String[]{"add", "insert"};
        $this$registerBrigadier.literal(stringArray, arg_0 -> OrderedWaypoints.onCommandRegistration$lambda$30$lambda$17($this$registerBrigadier, arg_0));
        stringArray = new String[]{"export"};
        $this$registerBrigadier.literal(stringArray, arg_0 -> OrderedWaypoints.onCommandRegistration$lambda$30$lambda$21($this$registerBrigadier, arg_0));
        stringArray = new String[]{"save"};
        $this$registerBrigadier.literal(stringArray, arg_0 -> OrderedWaypoints.onCommandRegistration$lambda$30$lambda$23($this$registerBrigadier, arg_0));
        stringArray = new String[]{"erase", "delete-route"};
        $this$registerBrigadier.literal(stringArray, arg_0 -> OrderedWaypoints.onCommandRegistration$lambda$30$lambda$26($this$registerBrigadier, arg_0));
        stringArray = new String[]{"setupmode"};
        $this$registerBrigadier.literal(stringArray, arg_0 -> OrderedWaypoints.onCommandRegistration$lambda$30$lambda$29($this$registerBrigadier, arg_0));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$load(OrderedWaypoints $this, String name2, Continuation $completion) {
        return $this.load(name2, $completion);
    }

    public static final /* synthetic */ Waypoints access$loadWaypoints(OrderedWaypoints $this, String data2) {
        return $this.loadWaypoints(data2);
    }

    public static final /* synthetic */ OrderedWaypointsRoutes access$getStorage(OrderedWaypoints $this) {
        return $this.getStorage();
    }

    public static final /* synthetic */ List access$getWaypointFormats(OrderedWaypoints $this) {
        return $this.getWaypointFormats();
    }

    public static final /* synthetic */ void access$setOrderedWaypointsList$p(Waypoints waypoints) {
        orderedWaypointsList = waypoints;
    }

    public static final /* synthetic */ void access$setCurrentOrderedWaypointIndex$p(int n) {
        currentOrderedWaypointIndex = n;
    }

    public static final /* synthetic */ Waypoints access$getOrderedWaypointsList$p() {
        return orderedWaypointsList;
    }

    public static final /* synthetic */ List access$getRenderWaypoints$p() {
        return renderWaypoints;
    }

    public static final /* synthetic */ String access$exportWaypoints(OrderedWaypoints $this, Waypoints waypoints, String name2) {
        return $this.exportWaypoints(waypoints, name2);
    }

    public static final /* synthetic */ void access$skip(OrderedWaypoints $this, int amount) {
        $this.skip(amount);
    }

    public static final /* synthetic */ void access$skipto(OrderedWaypoints $this, int number) {
        $this.skipto(number);
    }

    public static final /* synthetic */ void access$unskip(OrderedWaypoints $this, int amount) {
        $this.unskip(amount);
    }

    public static final /* synthetic */ void access$delete(OrderedWaypoints $this, int number) {
        $this.delete(number);
    }

    public static final /* synthetic */ void access$add(OrderedWaypoints $this, int number) {
        $this.add(number);
    }

    public static final /* synthetic */ void access$export(OrderedWaypoints $this, String format) {
        $this.export(format);
    }

    public static final /* synthetic */ void access$save(OrderedWaypoints $this, String name2) {
        $this.save(name2);
    }

    public static final /* synthetic */ void access$erase(OrderedWaypoints $this, String name2) {
        $this.erase(name2);
    }

    public static final /* synthetic */ void access$toggleSetupMode(OrderedWaypoints $this, boolean value) {
        $this.toggleSetupMode(value);
    }
}

