/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.pathfind;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.misc.PathfindConfig;
import at.hannibal2.skyhanni.data.IslandGraphs;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.RenderDisplayHelper;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.chat.TextHelper;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.primitives.TextRenderableKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u0003J\u0015\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\f\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0016\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010\u001f\u00a8\u0006#"}, d2={"Lat/hannibal2/skyhanni/features/misc/pathfind/NavigationFeedback;", "", "<init>", "()V", "", "onConfigLoad", "", "isActive", "()Z", "setNavInactive", "", "message", "sendPathFindMessage", "(Ljava/lang/String;)Z", "Lnet/minecraft/util/ChatComponentText;", "component", "(Lnet/minecraft/util/ChatComponentText;)Z", "sendChatFeedback", "sendGuiFeedback", "Lat/hannibal2/skyhanni/config/features/misc/PathfindConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/misc/PathfindConfig;", "config", "", "pathFindMessageId", "I", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "guiRenderable", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastChatMessageSent", "J", "navActive", "Z", "navLastActive", "1.8.9"})
public final class NavigationFeedback {
    @NotNull
    public static final NavigationFeedback INSTANCE = new NavigationFeedback();
    private static final int pathFindMessageId = ChatUtils.INSTANCE.getUniqueMessageId();
    @Nullable
    private static Renderable guiRenderable;
    private static long lastChatMessageSent;
    private static boolean navActive;
    private static long navLastActive;

    private NavigationFeedback() {
    }

    private final PathfindConfig getConfig() {
        return SkyHanniMod.feature.misc.getPathfinding();
    }

    @HandleEvent
    public final void onConfigLoad() {
        Property[] propertyArray = new Property[]{this.getConfig().getFeedbackMode()};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, NavigationFeedback::onConfigLoad$lambda$0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isActive() {
        if (navActive) return true;
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(navLastActive), DurationKt.toDuration(3, DurationUnit.SECONDS)) >= 0) return false;
        return true;
    }

    public final void setNavInactive() {
        navActive = false;
    }

    public final boolean sendPathFindMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        return this.sendPathFindMessage(TextHelper.asComponent$default(TextHelper.INSTANCE, message, null, 1, null));
    }

    public final boolean sendPathFindMessage(@NotNull ChatComponentText component) {
        boolean bl;
        Intrinsics.checkNotNullParameter(component, "component");
        navActive = true;
        navLastActive = SimpleTimeMark.Companion.now-uFjCsEo();
        PathfindConfig.FeedbackMode feedbackMode = (PathfindConfig.FeedbackMode)((Object)this.getConfig().getFeedbackMode().get());
        switch (feedbackMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[feedbackMode.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = this.sendChatFeedback(component);
                break;
            }
            case 3: {
                bl = this.sendGuiFeedback(component);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean sendChatFeedback(ChatComponentText component) {
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastChatMessageSent), this.getConfig().getChatUpdateInterval().getDuration-UwyO8pc()) < 0) {
            return false;
        }
        TextHelper.INSTANCE.send((IChatComponent)component, pathFindMessageId);
        lastChatMessageSent = SimpleTimeMark.Companion.now-uFjCsEo();
        return true;
    }

    private final boolean sendGuiFeedback(ChatComponentText component) {
        String string = component.func_150254_d();
        Intrinsics.checkNotNullExpressionValue(string, "getFormattedText(...)");
        String guiFormattedText = StringsKt.replace$default(string, "\u00a7e[SkyHanni] ", "\u00a7e", false, 4, null);
        guiRenderable = Renderable.Companion.clickable$default(Renderable.Companion, (Renderable)TextRenderableKt.text$default(Renderable.Companion, guiFormattedText, 0.0, null, null, null, 30, null), (Function0)new Function0<Unit>((Object)IslandGraphs.INSTANCE){

            public final void invoke() {
                ((IslandGraphs)this.receiver).cancelClick();
            }
        }, false, null, CollectionsKt.listOf("\u00a7eClick to stop navigating!"), null, 44, null);
        return true;
    }

    private static final void onConfigLoad$lambda$0() {
        guiRenderable = null;
    }

    private static final boolean _init_$lambda$1() {
        return INSTANCE.isActive() && INSTANCE.getConfig().getFeedbackMode().get() == PathfindConfig.FeedbackMode.GUI;
    }

    private static final Unit _init_$lambda$3() {
        block0: {
            Renderable renderable2 = guiRenderable;
            if (renderable2 == null) break block0;
            Renderable it = renderable2;
            boolean bl = false;
            RenderUtils.renderRenderable$default(RenderUtils.INSTANCE, INSTANCE.getConfig().getPosition(), it, "Pathfind Feedback", false, 4, null);
        }
        return Unit.INSTANCE;
    }

    static {
        lastChatMessageSent = SimpleTimeMark.Companion.farPast();
        navLastActive = SimpleTimeMark.Companion.farPast();
        new RenderDisplayHelper(null, true, true, NavigationFeedback::_init_$lambda$1, null, NavigationFeedback::_init_$lambda$3, 17, null);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathfindConfig.FeedbackMode.values().length];
            try {
                nArray[PathfindConfig.FeedbackMode.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathfindConfig.FeedbackMode.CHAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathfindConfig.FeedbackMode.GUI.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

